# Copyright (C) 2013-2015, 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

shopt -s extglob

# bats test_tags=locale-es
@test "librestage follows cli conventions" {
	assert_follows_cli_conventions librestage
}

@test "librestage fails with 0 args if there is no PKGBUILD" {
	librestage >$tmpdir/stdout 2>$tmpdir/stderr || status=$?

	[[ $status != 0 ]]
	assert_file_empty "$tmpdir/stdout"
	assert_file_not_empty "$tmpdir/stderr"
}

# bats test_tags=network,sudo
@test "librestage guesses the repo" {
	mkdir -p -- "$tmpdir/reponame/libretools-hello"
	cp fixtures/librestage/PKGBUILD-hello "$tmpdir/reponame/libretools-hello/PKGBUILD"
	cd "$tmpdir/reponame/libretools-hello"

	testsudo libremakepkg -l "$BATS_TEST_NAME"
	librestage

	find "$tmpdir" -not -type d -exec ls -ld -- {} +
	globfile $tmpdir/workdir/staging/reponame/libretools-hello-1.0-1-any.pkg.tar?(.!(sig|*.*))
	globfile $tmpdir/workdir/staging/sources/parabola/libretools-hello-1.0-1-any.src.tar?(.!(sig|*.*))
}

# bats test_tags=network,sudo
@test "librestage stages packages without PKGDEST" {
	cat >>"$XDG_CONFIG_HOME/pacman/makepkg.conf" <<-eot
		PKGDEST=''
		SRCPKGDEST=''
	eot

	cp fixtures/librestage/PKGBUILD-hello "$tmpdir/PKGBUILD"
	cd "$tmpdir"

	testsudo libremakepkg -l "$BATS_TEST_NAME"
	librestage repo1

	find "$tmpdir" -not -type d -exec ls -ld -- {} +
	globfile $tmpdir/workdir/staging/repo1/libretools-hello-1.0-1-any.pkg.tar?(.!(sig|*.*))
	globfile $tmpdir/workdir/staging/sources/parabola/libretools-hello-1.0-1-any.src.tar?(.!(sig|*.*))
}
