# Copyright (C) 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

# bats test_tags=locale-es
@test "librexgettext follows cli conventions and fails with 0 args" {
	assert_follows_cli_conventions librexgettext
	assert_fails_with_errusage librexgettext
}

passcase() {
	librexgettext fixtures/librexgettext/$BATS_TEST_NAME.sh >$tmpdir/actual.pot 2>$tmpdir/stderr
	assert_file_empty $tmpdir/stderr
	diff -u fixtures/librexgettext/$BATS_TEST_NAME.pot $tmpdir/actual.pot
}

@test "librexgettext handles multiple skipped flags" { passcase; }
@test "librexgettext handles zero flags" { passcase; }
@test "librexgettext handles librefetch flags" { passcase; }

@test "librexgettext fails on missing final flag description" {
	librexgettext fixtures/librexgettext/$BATS_TEST_NAME.sh >/dev/null 2>$tmpdir/stderr || status=$?

	[[ $status != 0 ]]
	[[ "$(sed 1q $tmpdir/stderr)" == "fixtures/librexgettext/$BATS_TEST_NAME.sh:5:"* ]]
}

@test "librexgettext fails on subshell flag descriptions" {
	librexgettext fixtures/librexgettext/$BATS_TEST_NAME.sh >/dev/null 2>$tmpdir/stderr || status=$?

	[[ $status != 0 ]]
	[[ "$(sed 1q $tmpdir/stderr)" == "fixtures/librexgettext/$BATS_TEST_NAME.sh:5-6:"* ]]
}

@test "librexgettext doesnt keep failing" {
	librexgettext some_file_that_doesnt_exist >$tmpdir/stdout 2>$tmpdir/stderr || status=$?

	[[ $status != 0 ]]
	assert_file_empty $tmpdir/stdout
	[[ "$(wc -l <$tmpdir/stderr)" == 1 ]]
}

@test "librexgettext handles multiple files" {
	librexgettext fixtures/librexgettext/combine1.sh fixtures/librexgettext/combine2.sh >$tmpdir/actual.pot 2>$tmpdir/stderr
	assert_file_empty $tmpdir/stderr
	diff -u fixtures/librexgettext/combine.pot $tmpdir/actual.pot
}
