# Copyright (C) 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

# bats test_tags=locale-es
@test "toru-path follows cli conventions" {
	assert_follows_cli_conventions toru-path
}

@test "toru-path runs" {
	cat >>"$XDG_CONFIG_HOME/libretools/libretools.conf" <<-eot
		TORUPATH=${tmpdir@Q}
		REPOS=(libre)
	eot
	cat >>"$HOME/.abs.conf" <<-eot
		ABSROOT=${PWD@Q}/fixtures/toru
	eot

	toru-path

	tcamgr list "$tmpdir/paths.tch" |
		LC_COLLATE=C sort |
		while read -r key; do
			val="$(tcamgr get "$tmpdir/paths.tch" "$key")"
			printf '«%q» -> «%q»\n' "$key" "$val"
		done >"$tmpdir/paths-actual.txt"

	printf '«%q» -> «%q»\n' \
		BAR "$PWD/fixtures/toru/libre/split-base" \
		BAZ "$PWD/fixtures/toru/libre/split-base" \
		FOO "$PWD/fixtures/toru/libre/split-base" \
		bar "$PWD/fixtures/toru/libre/split" \
		baz "$PWD/fixtures/toru/libre/split" \
		foo "$PWD/fixtures/toru/libre/split" \
		simple "$PWD/fixtures/toru/libre/simple" \
		split-base "$PWD/fixtures/toru/libre/split-base" \
		>"$tmpdir/paths-expected.txt"

	diff "$tmpdir/paths-expected.txt" "$tmpdir/paths-actual.txt"
}

@test "toru-path sets torupath" {
	cat >>"$XDG_CONFIG_HOME/libretools/libretools.conf" <<-eot
		TORUPATH=${tmpdir@Q}
		REPOS=(libre)
	eot
	cat >>"$HOME/.abs.conf" <<-eot
		ABSROOT=${PWD@Q}/fixtures/toru
	eot

	mkdir -p "$tmpdir/x"
	T="$tmpdir/x" toru-path
	test -f "$tmpdir/x/paths.tch"
	refute test -e "$tmpdir/paths.tch"
}
