/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.javasupport.Java;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyReflectionObject
extends RubyObject {
    public JavaProxyReflectionObject(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass, false);
    }

    protected static void registerRubyMethods(ThreadContext context, RubyClass klass) {
        klass.defineMethods(context, JavaProxyReflectionObject.class);
        klass.getMetaClass().defineAlias(context, "__j_allocate", "allocate");
    }

    @Deprecated
    public IRubyObject op_equal(IRubyObject other) {
        return this.op_eqq(this.getCurrentContext(), other);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        if (!(obj instanceof JavaProxyReflectionObject)) {
            Object wrappedObj = obj.dataGetStruct();
            if (!(wrappedObj instanceof RubyObject)) {
                return context.fals;
            }
            obj = (IRubyObject)wrappedObj;
        }
        return Convert.asBoolean(context, this.equals(obj));
    }

    @Deprecated
    public IRubyObject same(IRubyObject other) {
        return this.op_equal(this.getCurrentContext(), other);
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return context.tru;
        }
        if (!(obj instanceof JavaProxyReflectionObject)) {
            Object wrappedObj = obj.dataGetStruct();
            if (!(wrappedObj instanceof RubyObject)) {
                return context.fals;
            }
            obj = (IRubyObject)wrappedObj;
        }
        return Convert.asBoolean(context, this == obj);
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Override
    public int hashCode() {
        return 11 * this.getJavaClass().hashCode();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return Create.newString(context, this.toString());
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Deprecated(since="10.0")
    public RubyString java_type() {
        return this.java_type(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyString java_type(ThreadContext context) {
        return Create.newString(context, this.getJavaClass().getName());
    }

    @Deprecated(since="10.0")
    public IRubyObject java_class() {
        return this.java_class(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject java_class(ThreadContext context) {
        return Java.getInstance(context.runtime, this.getJavaClass());
    }

    @Deprecated(since="10.0")
    public RubyFixnum length() {
        return this.length(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyFixnum length(ThreadContext context) {
        throw Error.typeError(context, "not a java array");
    }

    @Deprecated(since="10.0")
    public IRubyObject aref(IRubyObject index2) {
        return this.aref(this.getCurrentContext(), index2);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(ThreadContext context, IRubyObject index2) {
        throw Error.typeError(context, "not a java array");
    }

    @Deprecated(since="10.0")
    public IRubyObject aset(IRubyObject index2, IRubyObject someValue) {
        return this.aset(this.getCurrentContext(), index2, someValue);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(ThreadContext context, IRubyObject index2, IRubyObject someValue) {
        throw Error.typeError(context, "not a java array");
    }

    @Deprecated(since="10.0")
    public IRubyObject is_java_proxy() {
        return this.is_java_proxy(this.getCurrentContext());
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy(ThreadContext context) {
        return context.fals;
    }

    final RubyArray toRubyArray(ThreadContext context, IRubyObject[] elements) {
        return RubyArray.newArrayMayCopy(context.runtime, elements);
    }

    static RubyArray toClassArray(ThreadContext context, Class<?>[] classes) {
        IRubyObject[] javaClasses = new IRubyObject[classes.length];
        int i2 = classes.length;
        while (--i2 >= 0) {
            javaClasses[i2] = Java.getProxyClass(context, classes[i2]);
        }
        return RubyArray.newArrayMayCopy(context.runtime, javaClasses);
    }
}

