/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.util.function.Consumer;
import java.util.function.Function;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.logging.LoggerFactory;

public interface DeferredAction {
    public void processResponse(Response var1);

    default public void onException(Exception exception) {
        LoggerFactory.getLogger(this.getClass()).debug("Exception in processDeferredActions", exception);
    }

    public WarningMessageCallback getWarningMessageCallback();

    public static <T> DeferredAction wrapDeferredResponse(final DeferredResponse<T> deferredResponse, final Function<Response, T> responseMapper, final WarningMessageCallback warningMessageCallback, final Consumer<Exception> exceptionConsumer) {
        return new DeferredAction(){

            @Override
            public void processResponse(Response response) {
                deferredResponse.onResponse(responseMapper.apply(response));
            }

            @Override
            public void onException(Exception exception) {
                try {
                    deferredResponse.onException(exception);
                }
                finally {
                    exceptionConsumer.accept(exception);
                }
            }

            @Override
            public WarningMessageCallback getWarningMessageCallback() {
                return warningMessageCallback;
            }
        };
    }
}

