/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
final class NIOMarkerPacket
extends NIOPacket {
    private boolean isReset;
    private boolean isBreak;
    private ByteBuffer markerBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    NIOMarkerPacket(SessionAtts session) {
        super(session);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$4, null, session);
            }
            this.header.type = 12;
            this.markerBuffer = ByteBuffer.allocate(11);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    NIOMarkerPacket(NIOHeader header, SessionAtts session) throws IOException {
        super(header, session);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$5, null, header, session);
            }
            header.type = 12;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeToSocketChannel(int n2, byte by) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void markerData;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$0, this, n2, by);
            }
            this.markerBuffer.clear();
            if (this.session.isLargeSDU) {
                this.markerBuffer.putInt(this.markerBuffer.capacity());
            } else {
                this.markerBuffer.putShort((short)this.markerBuffer.capacity());
                this.markerBuffer.putShort((short)0);
            }
            this.markerBuffer.put((byte)this.header.type);
            this.markerBuffer.put((byte)this.header.flags);
            this.markerBuffer.putShort((short)0);
            this.markerBuffer.put((byte)type);
            this.markerBuffer.put((byte)0);
            this.markerBuffer.put((byte)markerData);
            this.markerBuffer.limit(this.markerBuffer.position());
            this.markerBuffer.rewind();
            if (bl) {
                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "type=" + this.header.type + ", length=" + this.header.length + ", flags=" + this.header.flags + "\n" + this.dumpBytes(this.markerBuffer, 0, this.header.length) + ", sessionTraceId=" + this.session.traceId);
            }
            if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.markerBuffer, false);
            } else {
                while (this.markerBuffer.hasRemaining()) {
                    this.session.socketChannel.write(this.markerBuffer);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$1, this, new Object[0]);
            }
            byte mktype = this.session.payloadBufferForRead.get();
            byte mkodt = this.session.payloadBufferForRead.get();
            switch (mktype) {
                case 0: {
                    this.isBreak = true;
                    break;
                }
                case 1: {
                    byte mkdat = this.session.payloadBufferForRead.get();
                    if (mkdat == 2) {
                        this.isBreak = false;
                        this.isReset = true;
                        break;
                    }
                    this.isReset = false;
                    this.isBreak = true;
                    break;
                }
                default: {
                    NetException netException = new NetException(205);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$1, this, netException);
                    }
                    throw netException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isBreakPkt() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = this.isBreak;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$2, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isResetPkt() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$3, this, new Object[0]);
            }
            boolean bl2 = this.isReset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOMarkerPacket.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = NIOMarkerPacket.class.getDeclaredConstructor(NIOHeader.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NIOMarkerPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NIOMarkerPacket.class.getDeclaredMethod("isResetPkt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NIOMarkerPacket.class.getDeclaredMethod("isBreakPkt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIOMarkerPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIOMarkerPacket.class.getDeclaredMethod("writeToSocketChannel", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

