/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.HttpExecutingContext;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;

@SnowflakeJdbcInternalApi
public class HttpExecutingContextBuilder {
    private final String requestId;
    private final String requestInfoScrubbed;
    private long retryTimeout;
    private long authTimeout;
    private int origSocketTimeout;
    private int maxRetries;
    private int injectSocketTimeout;
    private AtomicBoolean canceling;
    private boolean withoutCookies;
    private boolean includeRetryParameters;
    private boolean includeSnowflakeHeaders;
    private boolean retryHTTP403;
    private boolean noRetry;
    private boolean unpackResponse;
    private boolean isLoginRequest;
    private SFBaseSession sfSession;

    public HttpExecutingContextBuilder(String requestId, String requestInfoScrubbed) {
        this.requestId = requestId;
        this.requestInfoScrubbed = requestInfoScrubbed;
    }

    public HttpExecutingContextBuilder(HttpExecutingContext context) {
        this.requestId = context.getRequestId();
        this.requestInfoScrubbed = context.getRequestInfoScrubbed();
        this.retryTimeout = context.getRetryTimeout();
        this.authTimeout = context.getAuthTimeout();
        this.origSocketTimeout = context.getOrigSocketTimeout();
        this.maxRetries = context.getMaxRetries();
        this.injectSocketTimeout = context.getInjectSocketTimeout();
        this.canceling = context.getCanceling();
        this.withoutCookies = context.isWithoutCookies();
        this.includeRetryParameters = context.isIncludeRetryParameters();
        this.includeSnowflakeHeaders = context.isIncludeSnowflakeHeaders();
        this.retryHTTP403 = context.isRetryHTTP403();
        this.noRetry = context.isNoRetry();
        this.unpackResponse = context.isUnpackResponse();
        this.isLoginRequest = context.isLoginRequest();
    }

    public static HttpExecutingContextBuilder forLogin(String requestId, String requestInfoScrubbed) {
        return new HttpExecutingContextBuilder(requestId, requestInfoScrubbed).loginRequest(true).includeSnowflakeHeaders(true).retryHTTP403(true);
    }

    public static HttpExecutingContextBuilder forQuery(String requestId, String requestInfoScrubbed) {
        return new HttpExecutingContextBuilder(requestId, requestInfoScrubbed).includeRetryParameters(true).includeSnowflakeHeaders(true).unpackResponse(true);
    }

    public static HttpExecutingContextBuilder forSimpleRequest(String requestId, String requestInfoScrubbed) {
        return new HttpExecutingContextBuilder(requestId, requestInfoScrubbed).noRetry(true).includeSnowflakeHeaders(true);
    }

    public static HttpExecutingContextBuilder withRequest(String requestId, String requestInfoScrubbed) {
        return new HttpExecutingContextBuilder(requestId, requestInfoScrubbed);
    }

    public HttpExecutingContextBuilder retryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public HttpExecutingContextBuilder authTimeout(long authTimeout) {
        this.authTimeout = authTimeout;
        return this;
    }

    public HttpExecutingContextBuilder origSocketTimeout(int origSocketTimeout) {
        this.origSocketTimeout = origSocketTimeout;
        return this;
    }

    public HttpExecutingContextBuilder maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public HttpExecutingContextBuilder injectSocketTimeout(int injectSocketTimeout) {
        this.injectSocketTimeout = injectSocketTimeout;
        return this;
    }

    public HttpExecutingContextBuilder canceling(AtomicBoolean canceling) {
        this.canceling = canceling;
        return this;
    }

    public HttpExecutingContextBuilder withoutCookies(boolean withoutCookies) {
        this.withoutCookies = withoutCookies;
        return this;
    }

    public HttpExecutingContextBuilder includeRetryParameters(boolean includeRetryParameters) {
        this.includeRetryParameters = includeRetryParameters;
        return this;
    }

    public HttpExecutingContextBuilder includeSnowflakeHeaders(boolean includeSnowflakeHeaders) {
        this.includeSnowflakeHeaders = includeSnowflakeHeaders;
        return this;
    }

    public HttpExecutingContextBuilder retryHTTP403(boolean retryHTTP403) {
        this.retryHTTP403 = retryHTTP403;
        return this;
    }

    public HttpExecutingContextBuilder noRetry(boolean noRetry) {
        this.noRetry = noRetry;
        return this;
    }

    public HttpExecutingContextBuilder unpackResponse(boolean unpackResponse) {
        this.unpackResponse = unpackResponse;
        return this;
    }

    public HttpExecutingContextBuilder loginRequest(boolean isLoginRequest) {
        this.isLoginRequest = isLoginRequest;
        return this;
    }

    public HttpExecutingContextBuilder withSfSession(SFBaseSession sfSession) {
        this.sfSession = sfSession;
        return this;
    }

    public HttpExecutingContext build() {
        HttpExecutingContext context = new HttpExecutingContext(this.requestId, this.requestInfoScrubbed);
        context.setRetryTimeout(this.retryTimeout);
        context.setAuthTimeout(this.authTimeout);
        context.setOrigSocketTimeout(this.origSocketTimeout);
        context.setMaxRetries(this.maxRetries);
        context.setInjectSocketTimeout(this.injectSocketTimeout);
        context.setCanceling(this.canceling);
        context.setWithoutCookies(this.withoutCookies);
        context.setIncludeRetryParameters(this.includeRetryParameters);
        context.setIncludeSnowflakeHeaders(this.includeSnowflakeHeaders);
        context.setRetryHTTP403(this.retryHTTP403);
        context.setNoRetry(this.noRetry);
        context.setUnpackResponse(this.unpackResponse);
        context.setLoginRequest(this.isLoginRequest);
        context.setSfSession(this.sfSession);
        return context;
    }
}

