/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SecureStorageAppleManager
implements SecureStorageManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SecureStorageAppleManager.class);
    private final SecurityLib securityLib = SecurityLibManager.getInstance();

    private SecureStorageAppleManager() {
    }

    public static SecureStorageAppleManager builder() {
        logger.debug("Using Apple Keychain as a token cache storage", new Object[0]);
        return new SecureStorageAppleManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureStorageManager.SecureStorageStatus setCredential(String host, String user, String type, String cred) {
        if (SnowflakeUtil.isNullOrEmpty(cred)) {
            logger.debug("No credential provided", false);
            return SecureStorageManager.SecureStorageStatus.SUCCESS;
        }
        String target = SecureStorageManager.buildCredentialsKey(host, user, type);
        byte[] targetBytes = target.getBytes(StandardCharsets.UTF_8);
        byte[] userBytes = user.toUpperCase().getBytes(StandardCharsets.UTF_8);
        byte[] credBytes = cred.getBytes(StandardCharsets.UTF_8);
        Pointer[] itemRef = new Pointer[1];
        int errCode = 0;
        SecurityLib securityLib = this.securityLib;
        synchronized (securityLib) {
            errCode = this.securityLib.SecKeychainFindGenericPassword(null, targetBytes.length, targetBytes, userBytes.length, userBytes, null, null, itemRef);
        }
        if (errCode != 0 && errCode != -25300) {
            logger.warn(String.format("Failed to check the existence of the item in keychain. Error code = %d", Native.getLastError()), new Object[0]);
            return SecureStorageManager.SecureStorageStatus.FAILURE;
        }
        if (itemRef[0] != null) {
            securityLib = this.securityLib;
            synchronized (securityLib) {
                errCode = this.securityLib.SecKeychainItemModifyContent(itemRef[0], null, credBytes.length, credBytes);
            }
        }
        securityLib = this.securityLib;
        synchronized (securityLib) {
            errCode = this.securityLib.SecKeychainAddGenericPassword(Pointer.NULL, targetBytes.length, targetBytes, userBytes.length, userBytes, credBytes.length, credBytes, null);
        }
        if (errCode != 0) {
            logger.warn(String.format("Failed to set/modify the item in keychain. Error code = %d", Native.getLastError()), new Object[0]);
            return SecureStorageManager.SecureStorageStatus.FAILURE;
        }
        logger.debug("Set the item in keychain successfully", new Object[0]);
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCredential(String host, String user, String type) {
        String target = SecureStorageManager.buildCredentialsKey(host, user, type);
        byte[] targetBytes = target.getBytes(StandardCharsets.UTF_8);
        byte[] userBytes = user.toUpperCase().getBytes(StandardCharsets.UTF_8);
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        try {
            int errCode = 0;
            SecurityLib securityLib = this.securityLib;
            synchronized (securityLib) {
                errCode = this.securityLib.SecKeychainFindGenericPassword(null, targetBytes.length, targetBytes, userBytes.length, userBytes, dataLength, data, null);
            }
            if (errCode != 0) {
                logger.warn(String.format("Failed to find the item in keychain or item not exists. Error code = %d", Native.getLastError()), new Object[0]);
                securityLib = null;
                return securityLib;
            }
            if (dataLength[0] == 0 || data[0] == null) {
                logger.warn("Found empty item or no item is found", false);
                securityLib = null;
                return securityLib;
            }
            byte[] credBytes = data[0].getByteArray(0L, dataLength[0]);
            String res = new String(credBytes, StandardCharsets.UTF_8);
            logger.debug("Successfully read the credential. Will return it as String now", new Object[0]);
            String string = res;
            return string;
        }
        finally {
            if (data[0] != null) {
                SecurityLib securityLib = this.securityLib;
                synchronized (securityLib) {
                    this.securityLib.SecKeychainItemFreeContent(null, data[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureStorageManager.SecureStorageStatus deleteCredential(String host, String user, String type) {
        String target = SecureStorageManager.buildCredentialsKey(host, user, type);
        byte[] targetBytes = target.getBytes(StandardCharsets.UTF_8);
        byte[] userBytes = user.toUpperCase().getBytes(StandardCharsets.UTF_8);
        Pointer[] itemRef = new Pointer[1];
        int errCode = 0;
        SecurityLib securityLib = this.securityLib;
        synchronized (securityLib) {
            errCode = this.securityLib.SecKeychainFindGenericPassword(null, targetBytes.length, targetBytes, userBytes.length, userBytes, null, null, itemRef);
        }
        if (errCode != 0 && errCode != -25300) {
            logger.warn(String.format("Failed to delete the item in keychain. Error code = %d", Native.getLastError()), new Object[0]);
            return SecureStorageManager.SecureStorageStatus.FAILURE;
        }
        if (itemRef[0] != null) {
            securityLib = this.securityLib;
            synchronized (securityLib) {
                errCode = this.securityLib.SecKeychainItemDelete(itemRef[0]);
            }
            if (errCode != 0) {
                logger.warn(String.format("Failed to delete the item in keychain. Error code = %d", Native.getLastError()), new Object[0]);
                return SecureStorageManager.SecureStorageStatus.FAILURE;
            }
        }
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    static interface SecurityLib
    extends Library {
        public static final int ERR_SEC_SUCCESS = 0;
        public static final int ERR_SEC_ITEM_NOT_FOUND = -25300;

        public int SecKeychainFindGenericPassword(Pointer var1, int var2, byte[] var3, int var4, byte[] var5, int[] var6, Pointer[] var7, Pointer[] var8);

        public int SecKeychainAddGenericPassword(Pointer var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, Pointer[] var8);

        public int SecKeychainItemModifyContent(Pointer var1, Pointer var2, int var3, byte[] var4);

        public int SecKeychainItemDelete(Pointer var1);

        public int SecKeychainItemFreeContent(Pointer[] var1, Pointer var2);
    }

    static class SecurityLibManager {
        private static SecurityLib INSTANCE = null;

        SecurityLibManager() {
        }

        public static SecurityLib getInstance() {
            if (INSTANCE == null) {
                INSTANCE = ResourceHolder.INSTANCE;
            }
            return INSTANCE;
        }

        public static void setInstance(SecurityLib instance) {
            INSTANCE = instance;
        }

        public static void resetInstance() {
            if (Constants.getOS() == Constants.OS.MAC) {
                INSTANCE = ResourceHolder.INSTANCE;
            }
        }

        private static class ResourceHolder {
            private static final SecurityLib INSTANCE = (SecurityLib)Native.loadLibrary((String)"Security", SecurityLib.class);

            private ResourceHolder() {
            }
        }
    }
}

