/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.storage.v2.ReadObjectRequest;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
@ThreadSafe
abstract class ByteRangeSpec
implements Serializable {
    public static final long EFFECTIVE_INFINITY = Long.MAX_VALUE;
    private volatile @Nullable String httpRangeHeader;

    private ByteRangeSpec() {
    }

    abstract long beginOffset();

    abstract long endOffset() throws ArithmeticException;

    abstract long endOffsetInclusive() throws ArithmeticException;

    abstract long length() throws ArithmeticException;

    abstract ByteRangeSpec withNewBeginOffset(long var1);

    abstract ByteRangeSpec withShiftBeginOffset(long var1) throws ArithmeticException;

    abstract ByteRangeSpec withNewEndOffset(long var1);

    abstract ByteRangeSpec withNewEndOffsetClosed(long var1);

    abstract ByteRangeSpec withNewRelativeLength(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final @Nullable String getHttpRangeHeader() throws ArithmeticException {
        if (this.httpRangeHeader == null) {
            ByteRangeSpec byteRangeSpec = this;
            synchronized (byteRangeSpec) {
                if (this.httpRangeHeader == null) {
                    this.httpRangeHeader = this.fmtAsHttpRangeHeader();
                }
            }
        }
        return this.httpRangeHeader;
    }

    abstract ReadObjectRequest.Builder seekReadObjectRequest(ReadObjectRequest.Builder var1);

    protected abstract @Nullable String fmtAsHttpRangeHeader() throws ArithmeticException;

    public int hashCode() {
        return Objects.hash(this.getHttpRangeHeader());
    }

    public boolean equals(Object o) {
        if (o instanceof ByteRangeSpec) {
            ByteRangeSpec that = (ByteRangeSpec)o;
            return Objects.equals(this.getHttpRangeHeader(), that.getHttpRangeHeader());
        }
        return false;
    }

    public String toString() {
        return this.append(MoreObjects.toStringHelper("ByteRangeSpec")).toString();
    }

    protected abstract MoreObjects.ToStringHelper append(MoreObjects.ToStringHelper var1);

    static ByteRangeSpec nullRange() {
        return NullByteRangeSpec.INSTANCE;
    }

    static ByteRangeSpec relativeLength(@Nullable Long beginOffset, @Nullable Long length) {
        return ByteRangeSpec.create(beginOffset, length, (x$0, x$1) -> new RelativeByteRangeSpec((long)x$0, (long)x$1));
    }

    static ByteRangeSpec explicit(@Nullable Long beginOffset, @Nullable Long endOffsetExclusive) {
        return ByteRangeSpec.create(beginOffset, endOffsetExclusive, (x$0, x$1) -> new LeftClosedRightOpenByteRangeSpec((long)x$0, (long)x$1));
    }

    static ByteRangeSpec explicitClosed(@Nullable Long beginOffset, @Nullable Long endOffsetInclusive) {
        return ByteRangeSpec.create(beginOffset, endOffsetInclusive, (x$0, x$1) -> new LeftClosedRightClosedByteRangeSpec((long)x$0, (long)x$1));
    }

    static ByteRangeSpec parse(String string) {
        net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions.checkNotNull(string, "Range header is null");
        Preconditions.checkArgument(string.startsWith("bytes="), "malformed Range header value: %s", (Object)string);
        int i = string.indexOf(45);
        String minS = string.substring(6, i);
        String maxS = string.substring(i + 1);
        long min2 = Long.parseLong(minS);
        long max = Long.parseLong(maxS);
        return ByteRangeSpec.explicitClosed(min2, max);
    }

    private static ByteRangeSpec create(@Nullable Long beginOffset, @Nullable Long length, BiFunction<@NonNull Long, @NonNull Long, ByteRangeSpec> f) {
        if (beginOffset == null && length == null) {
            return ByteRangeSpec.nullRange();
        }
        if (beginOffset != null && length != null) {
            if (beginOffset == 0L && length == Long.MAX_VALUE) {
                return ByteRangeSpec.nullRange();
            }
            if (length == Long.MAX_VALUE) {
                return new LeftClosedByteRangeSpec(beginOffset);
            }
            return f.apply(beginOffset, length);
        }
        if (beginOffset == null) {
            if (length == Long.MAX_VALUE) {
                return ByteRangeSpec.nullRange();
            }
            return f.apply(0L, length);
        }
        return new LeftClosedByteRangeSpec(beginOffset);
    }

    @Immutable
    private static final class NullByteRangeSpec
    extends ByteRangeSpec {
        private static final NullByteRangeSpec INSTANCE = new NullByteRangeSpec();
        private static final long serialVersionUID = 9110512497431639881L;

        private NullByteRangeSpec() {
        }

        @Override
        long beginOffset() {
            return 0L;
        }

        @Override
        long endOffset() throws ArithmeticException {
            return Long.MAX_VALUE;
        }

        @Override
        long endOffsetInclusive() throws ArithmeticException {
            return Long.MAX_VALUE;
        }

        @Override
        long length() throws ArithmeticException {
            return Long.MAX_VALUE;
        }

        @Override
        ByteRangeSpec withNewBeginOffset(long beginOffset) {
            if (beginOffset != 0L) {
                return new LeftClosedByteRangeSpec(beginOffset);
            }
            return this;
        }

        @Override
        ByteRangeSpec withShiftBeginOffset(long beginOffsetIncrement) throws ArithmeticException {
            if (beginOffsetIncrement != 0L) {
                return new LeftClosedByteRangeSpec(beginOffsetIncrement);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffset(long endOffsetExclusive) {
            if (endOffsetExclusive != Long.MAX_VALUE) {
                return new LeftClosedRightOpenByteRangeSpec(0L, endOffsetExclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffsetClosed(long endOffsetInclusive) {
            if (endOffsetInclusive != Long.MAX_VALUE) {
                return new LeftClosedRightClosedByteRangeSpec(0L, endOffsetInclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewRelativeLength(long relativeLength) {
            if (relativeLength != Long.MAX_VALUE) {
                return new RelativeByteRangeSpec(0L, relativeLength);
            }
            return this;
        }

        @Override
        public ReadObjectRequest.Builder seekReadObjectRequest(ReadObjectRequest.Builder b) {
            return b;
        }

        @Override
        protected String fmtAsHttpRangeHeader() throws ArithmeticException {
            return null;
        }

        @Override
        protected MoreObjects.ToStringHelper append(MoreObjects.ToStringHelper tsh) {
            return tsh.addValue("[0, INF]");
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Immutable
    private static final class LeftClosedByteRangeSpec
    extends ByteRangeSpec {
        private static final long serialVersionUID = 4732278479149027012L;
        private final long beginOffset;

        private LeftClosedByteRangeSpec(long beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        long beginOffset() {
            return this.beginOffset;
        }

        @Override
        long endOffset() throws ArithmeticException {
            return Long.MAX_VALUE;
        }

        @Override
        long endOffsetInclusive() throws ArithmeticException {
            return Long.MAX_VALUE;
        }

        @Override
        long length() throws ArithmeticException {
            return Long.MAX_VALUE;
        }

        @Override
        ByteRangeSpec withNewBeginOffset(long beginOffset) {
            if (beginOffset != this.beginOffset) {
                return new LeftClosedByteRangeSpec(beginOffset);
            }
            return this;
        }

        @Override
        ByteRangeSpec withShiftBeginOffset(long beginOffsetIncrement) throws ArithmeticException {
            if (beginOffsetIncrement != 0L) {
                return new LeftClosedByteRangeSpec(Math.addExact(this.beginOffset, beginOffsetIncrement));
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffset(long endOffsetExclusive) {
            return new LeftClosedRightOpenByteRangeSpec(this.beginOffset, endOffsetExclusive);
        }

        @Override
        ByteRangeSpec withNewEndOffsetClosed(long endOffsetInclusive) {
            return new LeftClosedRightClosedByteRangeSpec(this.beginOffset, endOffsetInclusive);
        }

        @Override
        ByteRangeSpec withNewRelativeLength(long relativeLength) {
            return new RelativeByteRangeSpec(this.beginOffset, relativeLength);
        }

        @Override
        public ReadObjectRequest.Builder seekReadObjectRequest(ReadObjectRequest.Builder b) {
            return b.setReadOffset(this.beginOffset());
        }

        @Override
        protected String fmtAsHttpRangeHeader() throws ArithmeticException {
            if (this.beginOffset > 0L) {
                return String.format("bytes=%d-", this.beginOffset);
            }
            if (this.beginOffset < 0L) {
                return String.format("bytes=%d", this.beginOffset);
            }
            return null;
        }

        @Override
        protected MoreObjects.ToStringHelper append(MoreObjects.ToStringHelper tsh) {
            return tsh.addValue(String.format("[%d, +INF)", this.beginOffset));
        }
    }

    @Immutable
    private static final class LeftClosedRightClosedByteRangeSpec
    extends ByteRangeSpec {
        private static final long serialVersionUID = -2706235472358072141L;
        private final long beginOffset;
        private final long endOffsetInclusive;

        private LeftClosedRightClosedByteRangeSpec(long beginOffset, long endOffsetInclusive) {
            this.beginOffset = beginOffset;
            this.endOffsetInclusive = endOffsetInclusive;
        }

        @Override
        long beginOffset() {
            return this.beginOffset;
        }

        @Override
        long endOffset() throws ArithmeticException {
            return Math.addExact(this.endOffsetInclusive, 1L);
        }

        @Override
        long endOffsetInclusive() throws ArithmeticException {
            return this.endOffsetInclusive;
        }

        @Override
        long length() throws ArithmeticException {
            return Math.addExact(Math.subtractExact(this.endOffsetInclusive, this.beginOffset), 1L);
        }

        @Override
        ByteRangeSpec withNewBeginOffset(long beginOffset) {
            if (beginOffset != this.beginOffset) {
                return new LeftClosedRightClosedByteRangeSpec(beginOffset, this.endOffsetInclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withShiftBeginOffset(long beginOffsetIncrement) throws ArithmeticException {
            if (beginOffsetIncrement != 0L) {
                return new LeftClosedRightClosedByteRangeSpec(Math.addExact(this.beginOffset, beginOffsetIncrement), this.endOffsetInclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffset(long endOffsetExclusive) {
            return new LeftClosedRightOpenByteRangeSpec(this.beginOffset, endOffsetExclusive);
        }

        @Override
        ByteRangeSpec withNewEndOffsetClosed(long endOffsetInclusive) {
            if (endOffsetInclusive != this.endOffsetInclusive) {
                return new LeftClosedRightClosedByteRangeSpec(this.beginOffset, endOffsetInclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewRelativeLength(long relativeLength) {
            return new RelativeByteRangeSpec(this.beginOffset, relativeLength);
        }

        @Override
        public ReadObjectRequest.Builder seekReadObjectRequest(ReadObjectRequest.Builder b) {
            return b.setReadOffset(this.beginOffset()).setReadLimit(this.length());
        }

        @Override
        protected String fmtAsHttpRangeHeader() throws ArithmeticException {
            return String.format("bytes=%d-%d", this.beginOffset, this.endOffsetInclusive);
        }

        @Override
        protected MoreObjects.ToStringHelper append(MoreObjects.ToStringHelper tsh) {
            return tsh.addValue(String.format("[%d, %d]", this.beginOffset, this.endOffsetInclusive));
        }
    }

    @Immutable
    private static final class LeftClosedRightOpenByteRangeSpec
    extends ByteRangeSpec {
        private static final long serialVersionUID = -2706235472358072141L;
        private final long beginOffset;
        private final long endOffsetExclusive;

        private LeftClosedRightOpenByteRangeSpec(long beginOffset, long endOffsetExclusive) {
            this.beginOffset = beginOffset;
            this.endOffsetExclusive = endOffsetExclusive;
        }

        @Override
        long beginOffset() {
            return this.beginOffset;
        }

        @Override
        long endOffset() throws ArithmeticException {
            return this.endOffsetExclusive;
        }

        @Override
        long endOffsetInclusive() throws ArithmeticException {
            return Math.subtractExact(this.endOffsetExclusive, 1L);
        }

        @Override
        long length() throws ArithmeticException {
            return Math.subtractExact(this.endOffsetExclusive, this.beginOffset);
        }

        @Override
        ByteRangeSpec withNewBeginOffset(long beginOffset) {
            if (beginOffset != this.beginOffset) {
                return new LeftClosedRightOpenByteRangeSpec(beginOffset, this.endOffsetExclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withShiftBeginOffset(long beginOffsetIncrement) throws ArithmeticException {
            if (beginOffsetIncrement != 0L) {
                return new LeftClosedRightOpenByteRangeSpec(Math.addExact(this.beginOffset, beginOffsetIncrement), this.endOffsetExclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffset(long endOffsetExclusive) {
            if (endOffsetExclusive != this.endOffsetExclusive) {
                return new LeftClosedRightOpenByteRangeSpec(this.beginOffset, endOffsetExclusive);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffsetClosed(long endOffsetInclusive) {
            return new LeftClosedRightClosedByteRangeSpec(this.beginOffset, endOffsetInclusive);
        }

        @Override
        ByteRangeSpec withNewRelativeLength(long relativeLength) {
            return new RelativeByteRangeSpec(this.beginOffset, relativeLength);
        }

        @Override
        public ReadObjectRequest.Builder seekReadObjectRequest(ReadObjectRequest.Builder b) {
            return b.setReadOffset(this.beginOffset()).setReadLimit(this.length());
        }

        @Override
        protected String fmtAsHttpRangeHeader() throws ArithmeticException {
            return String.format("bytes=%d-%d", this.beginOffset, this.endOffsetInclusive());
        }

        @Override
        protected MoreObjects.ToStringHelper append(MoreObjects.ToStringHelper tsh) {
            return tsh.addValue(String.format("[%d, %d)", this.beginOffset, this.endOffsetExclusive));
        }
    }

    @Immutable
    private static final class RelativeByteRangeSpec
    extends ByteRangeSpec {
        private static final long serialVersionUID = -3910856417374881377L;
        private final long beginOffset;
        private final long length;

        private RelativeByteRangeSpec(long beginOffset, long length) {
            this.beginOffset = beginOffset;
            this.length = length;
        }

        @Override
        long beginOffset() {
            return this.beginOffset;
        }

        @Override
        long endOffset() throws ArithmeticException {
            return Math.addExact(this.beginOffset, this.length);
        }

        @Override
        long endOffsetInclusive() throws ArithmeticException {
            return Math.addExact(this.beginOffset, this.length) - 1L;
        }

        @Override
        long length() throws ArithmeticException {
            return this.length;
        }

        @Override
        ByteRangeSpec withNewBeginOffset(long beginOffset) {
            if (beginOffset != this.beginOffset) {
                return new RelativeByteRangeSpec(beginOffset, this.length);
            }
            return this;
        }

        @Override
        ByteRangeSpec withShiftBeginOffset(long beginOffsetIncrement) throws ArithmeticException {
            if (beginOffsetIncrement != 0L) {
                return new RelativeByteRangeSpec(Math.addExact(this.beginOffset, beginOffsetIncrement), this.length);
            }
            return this;
        }

        @Override
        ByteRangeSpec withNewEndOffset(long endOffsetExclusive) {
            return new LeftClosedRightOpenByteRangeSpec(this.beginOffset, endOffsetExclusive);
        }

        @Override
        ByteRangeSpec withNewEndOffsetClosed(long endOffsetInclusive) {
            return new LeftClosedRightClosedByteRangeSpec(this.beginOffset, endOffsetInclusive);
        }

        @Override
        ByteRangeSpec withNewRelativeLength(long relativeLength) {
            if (relativeLength != this.length) {
                return new RelativeByteRangeSpec(this.beginOffset, relativeLength);
            }
            return this;
        }

        @Override
        public ReadObjectRequest.Builder seekReadObjectRequest(ReadObjectRequest.Builder b) {
            return b.setReadOffset(this.beginOffset()).setReadLimit(this.length());
        }

        @Override
        protected String fmtAsHttpRangeHeader() throws ArithmeticException {
            return String.format("bytes=%d-%d", this.beginOffset, this.endOffsetInclusive());
        }

        @Override
        protected MoreObjects.ToStringHelper append(MoreObjects.ToStringHelper tsh) {
            return tsh.addValue(String.format("%d + %d", this.beginOffset, this.length));
        }
    }
}

