/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc;

import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Attributes;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.StreamTracer;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
@ThreadSafe
public abstract class ClientStreamTracer
extends StreamTracer {
    public static final CallOptions.Key<Long> NAME_RESOLUTION_DELAYED = CallOptions.Key.create("net.snowflake.client.jdbc.internal.grpc.ClientStreamTracer.NAME_RESOLUTION_DELAYED");

    public void streamCreated(Attributes transportAttrs, Metadata headers) {
    }

    public void createPendingStream() {
    }

    public void outboundHeaders() {
    }

    public void inboundHeaders() {
    }

    public void inboundHeaders(Metadata headers) {
        this.inboundHeaders();
    }

    public void inboundTrailers(Metadata trailers) {
    }

    @Internal
    public void addOptionalLabel(String key, String value) {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public static final class StreamInfo {
        private final CallOptions callOptions;
        private final int previousAttempts;
        private final boolean isTransparentRetry;
        private final boolean isHedging;

        StreamInfo(CallOptions callOptions, int previousAttempts, boolean isTransparentRetry, boolean isHedging) {
            this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
            this.previousAttempts = previousAttempts;
            this.isTransparentRetry = isTransparentRetry;
            this.isHedging = isHedging;
        }

        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        public int getPreviousAttempts() {
            return this.previousAttempts;
        }

        public boolean isTransparentRetry() {
            return this.isTransparentRetry;
        }

        public boolean isHedging() {
            return this.isHedging;
        }

        public Builder toBuilder() {
            return new Builder().setCallOptions(this.callOptions).setPreviousAttempts(this.previousAttempts).setIsTransparentRetry(this.isTransparentRetry).setIsHedging(this.isHedging);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("callOptions", this.callOptions).add("previousAttempts", this.previousAttempts).add("isTransparentRetry", this.isTransparentRetry).add("isHedging", this.isHedging).toString();
        }

        public static final class Builder {
            private CallOptions callOptions = CallOptions.DEFAULT;
            private int previousAttempts;
            private boolean isTransparentRetry;
            private boolean isHedging;

            Builder() {
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions cannot be null");
                return this;
            }

            public Builder setPreviousAttempts(int previousAttempts) {
                this.previousAttempts = previousAttempts;
                return this;
            }

            public Builder setIsTransparentRetry(boolean isTransparentRetry) {
                this.isTransparentRetry = isTransparentRetry;
                return this;
            }

            public Builder setIsHedging(boolean isHedging) {
                this.isHedging = isHedging;
                return this;
            }

            public StreamInfo build() {
                return new StreamInfo(this.callOptions, this.previousAttempts, this.isTransparentRetry, this.isHedging);
            }
        }
    }

    public static abstract class Factory {
        public ClientStreamTracer newClientStreamTracer(StreamInfo info, Metadata headers) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

