/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.NameResolverProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsNameResolver;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsClient;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public final class XdsNameResolverProvider
extends NameResolverProvider {
    public static final NameResolver.Args.Key<Supplier<XdsClient>> XDS_CLIENT_SUPPLIER = NameResolver.Args.Key.create("net.snowflake.client.jdbc.internal.grpc.xds.XdsNameResolverProvider.XDS_CLIENT_SUPPLIER");
    private static final String SCHEME = "xds";
    private final String scheme;
    private final Map<String, ?> bootstrapOverride;

    public XdsNameResolverProvider() {
        this(SCHEME, null);
    }

    private XdsNameResolverProvider(String scheme, @Nullable Map<String, ?> bootstrapOverride) {
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
        this.bootstrapOverride = bootstrapOverride;
    }

    public static XdsNameResolverProvider createForTest(String scheme, @Nullable Map<String, ?> bootstrapOverride) {
        return new XdsNameResolverProvider(scheme, bootstrapOverride);
    }

    @Override
    public XdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (this.scheme.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new XdsNameResolver(targetUri, name, args.getOverrideAuthority(), args.getServiceConfigParser(), args.getSynchronizationContext(), args.getScheduledExecutorService(), this.bootstrapOverride, args.getMetricRecorder(), args);
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return this.scheme;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 4;
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    static interface CallCounterProvider {
        public AtomicLong getOrCreate(String var1, @Nullable String var2);
    }
}

