/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.common;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.KeyValue;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.KeyValueList;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueArray;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueBoolean;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueBytes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueDouble;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueLong;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueString;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueType;

public interface Value<T> {
    public static Value<String> of(String value) {
        return ValueString.create(value);
    }

    public static Value<Boolean> of(boolean value) {
        return ValueBoolean.create(value);
    }

    public static Value<Long> of(long value) {
        return ValueLong.create(value);
    }

    public static Value<Double> of(double value) {
        return ValueDouble.create(value);
    }

    public static Value<ByteBuffer> of(byte[] value) {
        return ValueBytes.create(value);
    }

    public static Value<List<Value<?>>> of(Value<?> ... value) {
        return ValueArray.create(value);
    }

    public static Value<List<Value<?>>> of(List<Value<?>> value) {
        return ValueArray.create(value);
    }

    public static Value<List<KeyValue>> of(KeyValue ... value) {
        return KeyValueList.create(value);
    }

    public static Value<List<KeyValue>> of(Map<String, Value<?>> value) {
        return KeyValueList.createFromMap(value);
    }

    public ValueType getType();

    public T getValue();

    public String asString();
}

