/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.ciphers;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.openssl.OpenSSLStatus;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.Encryption;
import org.apache.tomcat.util.net.openssl.ciphers.EncryptionLevel;
import org.apache.tomcat.util.net.openssl.ciphers.KeyExchange;
import org.apache.tomcat.util.net.openssl.ciphers.MessageDigest;
import org.apache.tomcat.util.net.openssl.ciphers.Protocol;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLCipherConfigurationParser {
    private static final Log log = LogFactory.getLog(OpenSSLCipherConfigurationParser.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLCipherConfigurationParser.class);
    private static boolean initialized = false;
    private static final String SEPARATOR = ":|,| ";
    private static final String EXCLUDE = "!";
    private static final String DELETE = "-";
    private static final String TO_END = "+";
    private static final String AND = "+";
    private static final Map<String, List<Cipher>> aliases = new LinkedHashMap<String, List<Cipher>>();
    private static final String eNULL = "eNULL";
    private static final String aNULL = "aNULL";
    private static final String HIGH = "HIGH";
    private static final String MEDIUM = "MEDIUM";
    private static final String LOW = "LOW";
    private static final String EXPORT = "EXPORT";
    private static final String EXPORT40 = "EXPORT40";
    private static final String EXPORT56 = "EXPORT56";
    private static final String kRSA = "kRSA";
    private static final String aRSA = "aRSA";
    private static final String RSA = "RSA";
    private static final String kEDH = "kEDH";
    private static final String kDHE = "kDHE";
    private static final String EDH = "EDH";
    private static final String DHE = "DHE";
    private static final String kDHr = "kDHr";
    private static final String kDHd = "kDHd";
    private static final String kDH = "kDH";
    private static final String kECDHr = "kECDHr";
    private static final String kECDHe = "kECDHe";
    private static final String kECDH = "kECDH";
    private static final String kEECDH = "kEECDH";
    private static final String EECDH = "EECDH";
    private static final String ECDH = "ECDH";
    private static final String kECDHE = "kECDHE";
    private static final String ECDHE = "ECDHE";
    private static final String AECDH = "AECDH";
    private static final String DSS = "DSS";
    private static final String aDSS = "aDSS";
    private static final String aDH = "aDH";
    private static final String aECDH = "aECDH";
    private static final String aECDSA = "aECDSA";
    private static final String ECDSA = "ECDSA";
    private static final String kFZA = "kFZA";
    private static final String aFZA = "aFZA";
    private static final String eFZA = "eFZA";
    private static final String FZA = "FZA";
    private static final String DH = "DH";
    private static final String ADH = "ADH";
    private static final String AES128 = "AES128";
    private static final String AES256 = "AES256";
    private static final String AES = "AES";
    private static final String AESGCM = "AESGCM";
    private static final String AESCCM = "AESCCM";
    private static final String AESCCM8 = "AESCCM8";
    private static final String ARIA128 = "ARIA128";
    private static final String ARIA256 = "ARIA256";
    private static final String ARIA = "ARIA";
    private static final String CAMELLIA128 = "CAMELLIA128";
    private static final String CAMELLIA256 = "CAMELLIA256";
    private static final String CAMELLIA = "CAMELLIA";
    private static final String CHACHA20 = "CHACHA20";
    private static final String TRIPLE_DES = "3DES";
    private static final String DES = "DES";
    private static final String RC4 = "RC4";
    private static final String RC2 = "RC2";
    private static final String IDEA = "IDEA";
    private static final String SEED = "SEED";
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA = "SHA";
    private static final String SHA256 = "SHA256";
    private static final String SHA384 = "SHA384";
    private static final String KRB5 = "KRB5";
    private static final String aGOST = "aGOST";
    private static final String aGOST01 = "aGOST01";
    private static final String aGOST94 = "aGOST94";
    private static final String kGOST = "kGOST";
    private static final String GOST94 = "GOST94";
    private static final String GOST89MAC = "GOST89MAC";
    private static final String aSRP = "aSRP";
    private static final String kSRP = "kSRP";
    private static final String SRP = "SRP";
    private static final String PSK = "PSK";
    private static final String aPSK = "aPSK";
    private static final String kPSK = "kPSK";
    private static final String kRSAPSK = "kRSAPSK";
    private static final String kECDHEPSK = "kECDHEPSK";
    private static final String kDHEPSK = "kDHEPSK";
    private static final String DEFAULT = "DEFAULT";
    private static final String COMPLEMENTOFDEFAULT = "COMPLEMENTOFDEFAULT";
    private static final String ALL = "ALL";
    private static final String COMPLEMENTOFALL = "COMPLEMENTOFALL";
    private static final Map<String, String> jsseToOpenSSL = new HashMap<String, String>();

    private static void init() {
        LinkedHashSet<Cipher> linkedHashSet2;
        Set<String> set;
        Object object;
        Object object22;
        for (Object object22 : Cipher.values()) {
            object = object22.getOpenSSLAlias();
            if (aliases.containsKey(object)) {
                aliases.get(object).add((Cipher)((Object)object22));
            } else {
                set = new ArrayList<Cipher>();
                set.add((String)object22);
                aliases.put((String)object, (List<Cipher>)((Object)set));
            }
            aliases.put(object22.name(), Collections.singletonList(object22));
            for (String string : object22.getOpenSSLAltNames()) {
                if (aliases.containsKey(string)) {
                    aliases.get(string).add((Cipher)((Object)object22));
                    continue;
                }
                linkedHashSet2 = new ArrayList<Cipher>();
                linkedHashSet2.add((Cipher)((Object)object22));
                aliases.put(string, (List<Cipher>)((Object)linkedHashSet2));
            }
            jsseToOpenSSL.put(object22.name(), object22.getOpenSSLAlias());
            set = object22.getJsseNames();
            for (LinkedHashSet<Cipher> linkedHashSet2 : set) {
                jsseToOpenSSL.put((String)((Object)linkedHashSet2), object22.getOpenSSLAlias());
            }
        }
        List<Cipher> list = Arrays.asList(Cipher.values());
        Collections.reverse(list);
        LinkedHashSet<Cipher> linkedHashSet3 = OpenSSLCipherConfigurationParser.defaultSort(new LinkedHashSet<Cipher>(list));
        OpenSSLCipherConfigurationParser.addListAlias(eNULL, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.eNULL)));
        LinkedHashSet<Cipher> linkedHashSet4 = new LinkedHashSet<Cipher>(linkedHashSet3);
        OpenSSLCipherConfigurationParser.remove(linkedHashSet4, eNULL);
        OpenSSLCipherConfigurationParser.addListAlias(ALL, linkedHashSet4);
        OpenSSLCipherConfigurationParser.addListAlias(HIGH, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(linkedHashSet3, Collections.singleton(EncryptionLevel.HIGH)));
        OpenSSLCipherConfigurationParser.addListAlias(MEDIUM, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(linkedHashSet3, Collections.singleton(EncryptionLevel.MEDIUM)));
        OpenSSLCipherConfigurationParser.addListAlias(LOW, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(linkedHashSet3, Collections.singleton(EncryptionLevel.LOW)));
        OpenSSLCipherConfigurationParser.addListAlias(EXPORT, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(linkedHashSet3, new HashSet<EncryptionLevel>(Arrays.asList(EncryptionLevel.EXP40, EncryptionLevel.EXP56))));
        aliases.put("EXP", aliases.get(EXPORT));
        OpenSSLCipherConfigurationParser.addListAlias(EXPORT40, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(linkedHashSet3, Collections.singleton(EncryptionLevel.EXP40)));
        OpenSSLCipherConfigurationParser.addListAlias(EXPORT56, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(linkedHashSet3, Collections.singleton(EncryptionLevel.EXP56)));
        aliases.put("NULL", aliases.get(eNULL));
        aliases.put(COMPLEMENTOFALL, aliases.get(eNULL));
        OpenSSLCipherConfigurationParser.addListAlias(aNULL, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(kRSA, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.RSA)));
        OpenSSLCipherConfigurationParser.addListAlias(aRSA, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.RSA)));
        aliases.put(RSA, aliases.get(kRSA));
        OpenSSLCipherConfigurationParser.addListAlias(kEDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EDH)));
        OpenSSLCipherConfigurationParser.addListAlias(kDHE, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EDH)));
        object22 = OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EDH));
        object22.removeAll(OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(EDH, (Set<Cipher>)object22);
        OpenSSLCipherConfigurationParser.addListAlias(DHE, (Set<Cipher>)object22);
        OpenSSLCipherConfigurationParser.addListAlias(kDHr, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.DHr)));
        OpenSSLCipherConfigurationParser.addListAlias(kDHd, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.DHd)));
        OpenSSLCipherConfigurationParser.addListAlias(kDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.DHr, KeyExchange.DHd))));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHr, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.ECDHr)));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHe, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.ECDHe)));
        OpenSSLCipherConfigurationParser.addListAlias(kECDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.ECDHe, KeyExchange.ECDHr))));
        OpenSSLCipherConfigurationParser.addListAlias(ECDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.ECDHe, KeyExchange.ECDHr, KeyExchange.EECDH))));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHE, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EECDH)));
        object = OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EECDH));
        OpenSSLCipherConfigurationParser.remove((Set<Cipher>)object, aNULL);
        OpenSSLCipherConfigurationParser.addListAlias(ECDHE, (Set<Cipher>)object);
        OpenSSLCipherConfigurationParser.addListAlias(kEECDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EECDH)));
        set = OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EECDH));
        set.removeAll(OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(EECDH, set);
        OpenSSLCipherConfigurationParser.addListAlias(aDSS, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.DSS)));
        aliases.put(DSS, aliases.get(aDSS));
        OpenSSLCipherConfigurationParser.addListAlias(aDH, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.DH)));
        LinkedHashSet<Cipher> linkedHashSet5 = OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EECDH));
        OpenSSLCipherConfigurationParser.addListAlias(AECDH, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet5, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(aECDH, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.ECDH)));
        OpenSSLCipherConfigurationParser.addListAlias(ECDSA, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.ECDSA)));
        aliases.put(aECDSA, aliases.get(ECDSA));
        OpenSSLCipherConfigurationParser.addListAlias(kFZA, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.FZA)));
        OpenSSLCipherConfigurationParser.addListAlias(aFZA, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.FZA)));
        OpenSSLCipherConfigurationParser.addListAlias(eFZA, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.FZA)));
        OpenSSLCipherConfigurationParser.addListAlias(FZA, OpenSSLCipherConfigurationParser.filter(linkedHashSet3, null, Collections.singleton(KeyExchange.FZA), Collections.singleton(Authentication.FZA), Collections.singleton(Encryption.FZA), null, null));
        OpenSSLCipherConfigurationParser.addListAlias("TLSv1.2", OpenSSLCipherConfigurationParser.filterByProtocol(linkedHashSet3, Collections.singleton(Protocol.TLSv1_2)));
        OpenSSLCipherConfigurationParser.addListAlias("TLSv1.0", OpenSSLCipherConfigurationParser.filterByProtocol(linkedHashSet3, Collections.singleton(Protocol.TLSv1)));
        OpenSSLCipherConfigurationParser.addListAlias("SSLv3", OpenSSLCipherConfigurationParser.filterByProtocol(linkedHashSet3, Collections.singleton(Protocol.SSLv3)));
        aliases.put("TLSv1", aliases.get("TLSv1.0"));
        OpenSSLCipherConfigurationParser.addListAlias("SSLv2", OpenSSLCipherConfigurationParser.filterByProtocol(linkedHashSet3, Collections.singleton(Protocol.SSLv2)));
        OpenSSLCipherConfigurationParser.addListAlias(DH, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.DHr, KeyExchange.DHd, KeyExchange.EDH))));
        linkedHashSet2 = OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.EDH));
        linkedHashSet2.retainAll(OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(ADH, linkedHashSet2);
        OpenSSLCipherConfigurationParser.addListAlias(AES128, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.AES128, Encryption.AES128CCM, Encryption.AES128CCM8, Encryption.AES128GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AES256, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.AES256, Encryption.AES256CCM, Encryption.AES256CCM8, Encryption.AES256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AES, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.AES128, Encryption.AES128CCM, Encryption.AES128CCM8, Encryption.AES128GCM, Encryption.AES256, Encryption.AES256CCM, Encryption.AES256CCM8, Encryption.AES256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(ARIA128, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.ARIA128GCM)));
        OpenSSLCipherConfigurationParser.addListAlias(ARIA256, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.ARIA256GCM)));
        OpenSSLCipherConfigurationParser.addListAlias(ARIA, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.ARIA128GCM, Encryption.ARIA256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AESGCM, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.AES128GCM, Encryption.AES256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AESCCM, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.AES128CCM, Encryption.AES128CCM8, Encryption.AES256CCM, Encryption.AES256CCM8))));
        OpenSSLCipherConfigurationParser.addListAlias(AESCCM8, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.AES128CCM8, Encryption.AES256CCM8))));
        OpenSSLCipherConfigurationParser.addListAlias(CAMELLIA, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, new HashSet<Encryption>(Arrays.asList(Encryption.CAMELLIA128, Encryption.CAMELLIA256))));
        OpenSSLCipherConfigurationParser.addListAlias(CAMELLIA128, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.CAMELLIA128)));
        OpenSSLCipherConfigurationParser.addListAlias(CAMELLIA256, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.CAMELLIA256)));
        OpenSSLCipherConfigurationParser.addListAlias(CHACHA20, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.CHACHA20POLY1305)));
        OpenSSLCipherConfigurationParser.addListAlias(TRIPLE_DES, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.TRIPLE_DES)));
        OpenSSLCipherConfigurationParser.addListAlias(DES, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.DES)));
        OpenSSLCipherConfigurationParser.addListAlias(RC4, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.RC4)));
        OpenSSLCipherConfigurationParser.addListAlias(RC2, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.RC2)));
        OpenSSLCipherConfigurationParser.addListAlias(IDEA, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.IDEA)));
        OpenSSLCipherConfigurationParser.addListAlias(SEED, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, Collections.singleton(Encryption.SEED)));
        OpenSSLCipherConfigurationParser.addListAlias(MD5, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet3, Collections.singleton(MessageDigest.MD5)));
        OpenSSLCipherConfigurationParser.addListAlias(SHA1, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet3, Collections.singleton(MessageDigest.SHA1)));
        aliases.put(SHA, aliases.get(SHA1));
        OpenSSLCipherConfigurationParser.addListAlias(SHA256, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet3, Collections.singleton(MessageDigest.SHA256)));
        OpenSSLCipherConfigurationParser.addListAlias(SHA384, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet3, Collections.singleton(MessageDigest.SHA384)));
        OpenSSLCipherConfigurationParser.addListAlias(aGOST, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, new HashSet<Authentication>(Arrays.asList(Authentication.GOST01, Authentication.GOST94))));
        OpenSSLCipherConfigurationParser.addListAlias(aGOST01, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.GOST01)));
        OpenSSLCipherConfigurationParser.addListAlias(aGOST94, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.GOST94)));
        OpenSSLCipherConfigurationParser.addListAlias(kGOST, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.GOST)));
        OpenSSLCipherConfigurationParser.addListAlias(GOST94, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet3, Collections.singleton(MessageDigest.GOST94)));
        OpenSSLCipherConfigurationParser.addListAlias(GOST89MAC, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet3, Collections.singleton(MessageDigest.GOST89MAC)));
        OpenSSLCipherConfigurationParser.addListAlias(PSK, OpenSSLCipherConfigurationParser.filter(linkedHashSet3, null, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.PSK, KeyExchange.RSAPSK, KeyExchange.DHEPSK, KeyExchange.ECDHEPSK)), Collections.singleton(Authentication.PSK), null, null, null));
        OpenSSLCipherConfigurationParser.addListAlias(aPSK, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.PSK)));
        OpenSSLCipherConfigurationParser.addListAlias(kPSK, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.PSK)));
        OpenSSLCipherConfigurationParser.addListAlias(kRSAPSK, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.RSAPSK)));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHEPSK, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.ECDHEPSK)));
        OpenSSLCipherConfigurationParser.addListAlias(kDHEPSK, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.DHEPSK)));
        OpenSSLCipherConfigurationParser.addListAlias(KRB5, OpenSSLCipherConfigurationParser.filter(linkedHashSet3, null, Collections.singleton(KeyExchange.KRB5), Collections.singleton(Authentication.KRB5), null, null, null));
        OpenSSLCipherConfigurationParser.addListAlias(aSRP, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet3, Collections.singleton(Authentication.SRP)));
        OpenSSLCipherConfigurationParser.addListAlias(kSRP, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.SRP)));
        OpenSSLCipherConfigurationParser.addListAlias(SRP, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet3, Collections.singleton(KeyExchange.SRP)));
        initialized = true;
        OpenSSLCipherConfigurationParser.addListAlias(DEFAULT, OpenSSLCipherConfigurationParser.parse("ALL:!EXPORT:!eNULL:!aNULL:!SSLv2:!DES:!RC2:!RC4:!DSS:!SEED:!IDEA:!CAMELLIA:!AESCCM:!3DES:!ARIA"));
        LinkedHashSet<Cipher> linkedHashSet6 = OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet4, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.EDH, KeyExchange.EECDH)));
        linkedHashSet6 = OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet6, Collections.singleton(Authentication.aNULL));
        aliases.get(eNULL).forEach(linkedHashSet6::remove);
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get("SSLv2"));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(EXPORT));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(DES));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(TRIPLE_DES));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(RC2));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(RC4));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(aDSS));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(SEED));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(IDEA));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(CAMELLIA));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(AESCCM));
        linkedHashSet6.addAll((Collection<Cipher>)aliases.get(ARIA));
        OpenSSLCipherConfigurationParser.defaultSort(linkedHashSet6);
        OpenSSLCipherConfigurationParser.addListAlias(COMPLEMENTOFDEFAULT, linkedHashSet6);
    }

    static void addListAlias(String string, Set<Cipher> set) {
        aliases.put(string, new ArrayList<Cipher>(set));
    }

    static void moveToEnd(LinkedHashSet<Cipher> linkedHashSet, String string) {
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet, (Collection<Cipher>)aliases.get(string));
    }

    static void moveToEnd(LinkedHashSet<Cipher> linkedHashSet, Collection<Cipher> collection) {
        ArrayList<Cipher> arrayList = new ArrayList<Cipher>(collection);
        arrayList.retainAll(linkedHashSet);
        arrayList.forEach(linkedHashSet::remove);
        linkedHashSet.addAll(arrayList);
    }

    static void moveToStart(LinkedHashSet<Cipher> linkedHashSet, Collection<Cipher> collection) {
        ArrayList<Cipher> arrayList = new ArrayList<Cipher>(collection);
        ArrayList<Cipher> arrayList2 = new ArrayList<Cipher>(linkedHashSet);
        arrayList.retainAll(linkedHashSet);
        linkedHashSet.clear();
        linkedHashSet.addAll(arrayList);
        linkedHashSet.addAll(arrayList2);
    }

    static void add(LinkedHashSet<Cipher> linkedHashSet, String string) {
        linkedHashSet.addAll((Collection<Cipher>)aliases.get(string));
    }

    static void remove(Set<Cipher> set, String string) {
        aliases.get(string).forEach(set::remove);
    }

    static LinkedHashSet<Cipher> strengthSort(LinkedHashSet<Cipher> linkedHashSet) {
        Object object2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Object object2 : linkedHashSet) {
            hashSet.add(object2.getStrength_bits());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        object2 = new LinkedHashSet<Cipher>(linkedHashSet);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            OpenSSLCipherConfigurationParser.moveToEnd((LinkedHashSet<Cipher>)object2, OpenSSLCipherConfigurationParser.filterByStrengthBits(linkedHashSet, n));
        }
        return object2;
    }

    static LinkedHashSet<Cipher> defaultSort(LinkedHashSet<Cipher> linkedHashSet) {
        LinkedHashSet<Cipher> linkedHashSet2 = new LinkedHashSet<Cipher>(linkedHashSet.size());
        LinkedHashSet<Cipher> linkedHashSet3 = new LinkedHashSet<Cipher>(linkedHashSet.size());
        linkedHashSet3.addAll(OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet, Collections.singleton(KeyExchange.EECDH)));
        HashSet<Encryption> hashSet = new HashSet<Encryption>(Arrays.asList(Encryption.AES128, Encryption.AES128CCM, Encryption.AES128CCM8, Encryption.AES128GCM, Encryption.AES256, Encryption.AES256CCM, Encryption.AES256CCM8, Encryption.AES256GCM));
        linkedHashSet2.addAll(OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet3, hashSet));
        linkedHashSet2.addAll(OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet, hashSet));
        linkedHashSet2.addAll(linkedHashSet3);
        linkedHashSet2.addAll(linkedHashSet);
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet2, OpenSSLCipherConfigurationParser.filterByMessageDigest(linkedHashSet2, Collections.singleton(MessageDigest.MD5)));
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet2, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet2, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet2, OpenSSLCipherConfigurationParser.filterByAuthentication(linkedHashSet2, Collections.singleton(Authentication.ECDH)));
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet2, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet2, Collections.singleton(KeyExchange.RSA)));
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet2, OpenSSLCipherConfigurationParser.filterByKeyExchange(linkedHashSet2, Collections.singleton(KeyExchange.PSK)));
        OpenSSLCipherConfigurationParser.moveToEnd(linkedHashSet2, OpenSSLCipherConfigurationParser.filterByEncryption(linkedHashSet2, Collections.singleton(Encryption.RC4)));
        return OpenSSLCipherConfigurationParser.strengthSort(linkedHashSet2);
    }

    static Set<Cipher> filterByStrengthBits(Set<Cipher> set, int n) {
        LinkedHashSet<Cipher> linkedHashSet = new LinkedHashSet<Cipher>(set.size());
        for (Cipher cipher : set) {
            if (cipher.getStrength_bits() != n) continue;
            linkedHashSet.add(cipher);
        }
        return linkedHashSet;
    }

    static Set<Cipher> filterByProtocol(Set<Cipher> set, Set<Protocol> set2) {
        return OpenSSLCipherConfigurationParser.filter(set, set2, null, null, null, null, null);
    }

    static LinkedHashSet<Cipher> filterByKeyExchange(Set<Cipher> set, Set<KeyExchange> set2) {
        return OpenSSLCipherConfigurationParser.filter(set, null, set2, null, null, null, null);
    }

    static LinkedHashSet<Cipher> filterByAuthentication(Set<Cipher> set, Set<Authentication> set2) {
        return OpenSSLCipherConfigurationParser.filter(set, null, null, set2, null, null, null);
    }

    static Set<Cipher> filterByEncryption(Set<Cipher> set, Set<Encryption> set2) {
        return OpenSSLCipherConfigurationParser.filter(set, null, null, null, set2, null, null);
    }

    static Set<Cipher> filterByEncryptionLevel(Set<Cipher> set, Set<EncryptionLevel> set2) {
        return OpenSSLCipherConfigurationParser.filter(set, null, null, null, null, set2, null);
    }

    static Set<Cipher> filterByMessageDigest(Set<Cipher> set, Set<MessageDigest> set2) {
        return OpenSSLCipherConfigurationParser.filter(set, null, null, null, null, null, set2);
    }

    static LinkedHashSet<Cipher> filter(Set<Cipher> set, Set<Protocol> set2, Set<KeyExchange> set3, Set<Authentication> set4, Set<Encryption> set5, Set<EncryptionLevel> set6, Set<MessageDigest> set7) {
        LinkedHashSet<Cipher> linkedHashSet = new LinkedHashSet<Cipher>(set.size());
        for (Cipher cipher : set) {
            if (set2 != null && set2.contains((Object)cipher.getProtocol())) {
                linkedHashSet.add(cipher);
            }
            if (set3 != null && set3.contains((Object)cipher.getKx())) {
                linkedHashSet.add(cipher);
            }
            if (set4 != null && set4.contains((Object)cipher.getAu())) {
                linkedHashSet.add(cipher);
            }
            if (set5 != null && set5.contains((Object)cipher.getEnc())) {
                linkedHashSet.add(cipher);
            }
            if (set6 != null && set6.contains((Object)cipher.getLevel())) {
                linkedHashSet.add(cipher);
            }
            if (set7 == null || !set7.contains((Object)cipher.getMac())) continue;
            linkedHashSet.add(cipher);
        }
        return linkedHashSet;
    }

    public static LinkedHashSet<Cipher> parse(String string) {
        Object object;
        Serializable serializable;
        String[] stringArray;
        if (!initialized) {
            OpenSSLCipherConfigurationParser.init();
        }
        if ((stringArray = string.split(SEPARATOR)).length == 1 && stringArray[0].startsWith("PROFILE=")) {
            if (JreCompat.isJre22Available()) {
                if (OpenSSLStatus.isLibraryInitialized()) {
                    try {
                        serializable = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                        object = (List)((Class)serializable).getMethod("findCiphers", String.class).invoke(null, stringArray[0]);
                        stringArray = object.toArray(new String[0]);
                    }
                    catch (Throwable throwable) {
                        object = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                        ExceptionUtils.handleThrowable(object);
                        log.error((Object)sm.getString("opensslCipherConfigurationParser.unknownProfile", new Object[]{stringArray[0]}), object);
                    }
                } else {
                    log.error((Object)sm.getString("opensslCipherConfigurationParser.unknownProfile", new Object[]{stringArray[0]}));
                }
            } else {
                log.info((Object)sm.getString("opensslCipherConfigurationParser.unknownProfile", new Object[]{stringArray[0]}));
            }
        }
        serializable = new LinkedHashSet();
        object = new HashSet();
        for (String string2 : stringArray) {
            Object object2;
            if (string2.startsWith(DELETE)) {
                object2 = string2.substring(1);
                if (!aliases.containsKey(object2)) continue;
                OpenSSLCipherConfigurationParser.remove((Set<Cipher>)((Object)serializable), (String)object2);
                continue;
            }
            if (string2.startsWith(EXCLUDE)) {
                object2 = string2.substring(1);
                if (aliases.containsKey(object2)) {
                    object.addAll((Collection)aliases.get(object2));
                    continue;
                }
                log.warn((Object)sm.getString("opensslCipherConfigurationParser.unknownElement", new Object[]{object2}));
                continue;
            }
            if (string2.startsWith("+")) {
                object2 = string2.substring(1);
                if (!aliases.containsKey(object2)) continue;
                OpenSSLCipherConfigurationParser.moveToEnd((LinkedHashSet<Cipher>)serializable, (String)object2);
                continue;
            }
            if ("@STRENGTH".equals(string2)) {
                OpenSSLCipherConfigurationParser.strengthSort((LinkedHashSet<Cipher>)serializable);
                break;
            }
            if (aliases.containsKey(string2)) {
                OpenSSLCipherConfigurationParser.add((LinkedHashSet<Cipher>)serializable, string2);
                continue;
            }
            if (!string2.contains("+") || ((String[])(object2 = string2.split("\\+"))).length <= 0 || !aliases.containsKey(object2[0])) continue;
            ArrayList arrayList = new ArrayList(aliases.get(object2[0]));
            for (int i = 1; i < ((String[])object2).length; ++i) {
                if (!aliases.containsKey(object2[i])) continue;
                arrayList.retainAll((Collection)aliases.get(object2[i]));
            }
            ((AbstractCollection)((Object)serializable)).addAll(arrayList);
        }
        ((AbstractSet)((Object)serializable)).removeAll((Collection<?>)object);
        return serializable;
    }

    public static List<String> convertForJSSE(Collection<Cipher> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (Cipher cipher : collection) {
            arrayList.addAll(cipher.getJsseNames());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("opensslCipherConfigurationParser.effectiveCiphers", new Object[]{OpenSSLCipherConfigurationParser.displayResult(collection, true, ",")}));
        }
        return arrayList;
    }

    public static List<String> parseExpression(String string) {
        return OpenSSLCipherConfigurationParser.convertForJSSE(OpenSSLCipherConfigurationParser.parse(string));
    }

    public static String jsseToOpenSSL(String string) {
        if (!initialized) {
            OpenSSLCipherConfigurationParser.init();
        }
        return jsseToOpenSSL.get(string);
    }

    public static String openSSLToJsse(String string) {
        List<Cipher> list;
        if (!initialized) {
            OpenSSLCipherConfigurationParser.init();
        }
        if ((list = aliases.get(string)) == null || list.size() != 1) {
            return null;
        }
        Cipher cipher = list.get(0);
        return cipher.getJsseNames().iterator().next();
    }

    static String displayResult(Collection<Cipher> collection, boolean bl, String string) {
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 16);
        for (Cipher cipher : collection) {
            if (bl) {
                for (String string2 : cipher.getJsseNames()) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string);
                }
            } else {
                stringBuilder.append(cipher.getOpenSSLAlias());
            }
            stringBuilder.append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static void usage() {
        System.out.println("Usage: java " + OpenSSLCipherConfigurationParser.class.getName() + " [options] cipher spec");
        System.out.println();
        System.out.println("Displays the TLS cipher suites matching the cipher spec.");
        System.out.println();
        System.out.println(" --help,");
        System.out.println(" -h          Print this help message");
        System.out.println(" --openssl   Show OpenSSL cipher suite names instead of IANA cipher suite names.");
        System.out.println(" --verbose,");
        System.out.println(" -v          Provide detailed cipher listing");
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if ("--verbose".equals(string) || "-v".equals(string)) {
                bl = true;
                continue;
            }
            if ("--openssl".equals(string)) {
                bl2 = true;
                continue;
            }
            if ("--help".equals(string) || "-h".equals(string)) {
                OpenSSLCipherConfigurationParser.usage();
                System.exit(0);
                continue;
            }
            if ("--".equals(string)) {
                ++n;
                break;
            }
            if (!string.startsWith(DELETE)) break;
            System.out.println("Unknown option: " + string);
            OpenSSLCipherConfigurationParser.usage();
            System.exit(1);
        }
        string = n < stringArray.length ? stringArray[n] : DEFAULT;
        LinkedHashSet<Cipher> linkedHashSet = OpenSSLCipherConfigurationParser.parse(string);
        boolean bl3 = true;
        if (!linkedHashSet.isEmpty()) {
            for (Cipher cipher : linkedHashSet) {
                if (bl3) {
                    bl3 = false;
                } else if (!bl) {
                    System.out.print(',');
                }
                if (bl2) {
                    System.out.print(cipher.getOpenSSLAlias());
                } else {
                    System.out.print(cipher.name());
                }
                if (!bl) continue;
                System.out.println("\t" + (Object)((Object)cipher.getProtocol()) + "\tKx=" + (Object)((Object)cipher.getKx()) + "\tAu=" + (Object)((Object)cipher.getAu()) + "\tEnc=" + (Object)((Object)cipher.getEnc()) + "\tMac=" + (Object)((Object)cipher.getMac()));
            }
            System.out.println();
        } else {
            System.out.println("No ciphers match '" + string + "'");
        }
    }
}

