/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.ClassMethodMap;
import org.testng.DataProviderHolder;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.IDynamicGraph;
import org.testng.IExecutionListener;
import org.testng.IExecutionVisualiser;
import org.testng.IHookable;
import org.testng.IInjectorFactory;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteRunnerListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.InstanceOrderingMethodInterceptor;
import org.testng.ListenerComparator;
import org.testng.PreserveOrderMethodInterceptor;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.TestTaskExecutor;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.Attributes;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ClassBasedWrapper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.DefaultListenerFactory;
import org.testng.internal.DynamicGraph;
import org.testng.internal.DynamicGraphHelper;
import org.testng.internal.GroupsHelper;
import org.testng.internal.IConfigEavesdropper;
import org.testng.internal.IConfiguration;
import org.testng.internal.IContainer;
import org.testng.internal.ITestClassConfigInfo;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.ListenerOrderDeterminer;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodSorting;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestMethodComparator;
import org.testng.internal.TestMethodContainer;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGDeadLockException;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.AbstractParallelWorker;
import org.testng.internal.invokers.ConfigMethodArguments;
import org.testng.internal.invokers.IInvoker;
import org.testng.internal.invokers.Invoker;
import org.testng.thread.IThreadWorkerFactory;
import org.testng.thread.IWorker;
import org.testng.util.Strings;
import org.testng.util.TimeUtils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestRunner
implements ITestContext,
ITestResultNotifier,
IThreadWorkerFactory<ITestNGMethod>,
IConfigEavesdropper {
    private static final String DEFAULT_PROP_OUTPUT_DIR = "test-output";
    private final Comparator<ITestNGMethod> comparator;
    private ISuite m_suite;
    private XmlTest m_xmlTest;
    private String m_testName;
    private IInjectorFactory m_injectorFactory;
    private ITestObjectFactory m_objectFactory;
    private List<XmlClass> m_testClassesFromXml = null;
    private IInvoker m_invoker = null;
    private IAnnotationFinder m_annotationFinder = null;
    private final List<ITestListener> m_testListeners = Lists.newArrayList();
    private final Set<IConfigurationListener> m_configurationListeners = Sets.newLinkedHashSet();
    private final Set<IExecutionVisualiser> visualisers = Sets.newHashSet();
    private final IConfigurationListener m_confListener = new ConfigurationListener();
    private final Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newLinkedHashMap();
    private final DataProviderHolder holder;
    private Date m_startDate = new Date();
    private Date m_endDate = null;
    private final IContainer<ITestNGMethod> testMethodsContainer = new TestMethodContainer(this::computeAndGetAllTestMethods);
    private final Map<Class<?>, ITestClass> m_classMap = Maps.newLinkedHashMap();
    private String m_outputDirectory = "test-output";
    private final XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private ITestListener exitCodeListener;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private final List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private final Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private final IResultMap m_passedTests = new ResultMap();
    private final IResultMap m_failedTests = new ResultMap();
    private final IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private final IResultMap m_skippedTests = new ResultMap();
    private final RunInfo m_runInfo = new RunInfo(this::getCurrentXmlTest);
    private String m_host;
    private List<IMethodInterceptor> m_methodInterceptors;
    private ClassMethodMap m_classMethodMap;
    private TestNGClassFinder m_testClassFinder;
    private IConfiguration m_configuration;
    private final IResultMap m_passedConfigurations = new ResultMap();
    private final IResultMap m_skippedConfigurations = new ResultMap();
    private final IResultMap m_failedConfigurations = new ResultMap();
    private final IResultMap m_configsToBeInvoked = new ResultMap();
    private final IAttributes m_attributes = new Attributes();

    protected TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners, Comparator<ITestNGMethod> comparator, DataProviderHolder otherHolder, ISuiteRunnerListener suiteRunner) {
        this.comparator = comparator;
        this.holder = otherHolder;
        this.init(configuration, suite, test, outputDirectory, finder, skipFailedInvocationCounts, invokedMethodListeners, classListeners, suiteRunner);
    }

    public TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners, Comparator<ITestNGMethod> comparator, ISuiteRunnerListener suiteRunner) {
        this.comparator = comparator;
        this.holder = new DataProviderHolder(configuration);
        this.init(configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(), skipFailedInvocationCounts, invokedMethodListeners, classListeners, suiteRunner);
    }

    public TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners, ISuiteRunnerListener suiteRunner) {
        this.comparator = MethodSorting.basedOn();
        this.holder = new DataProviderHolder(configuration);
        this.init(configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(), skipFailedInvocationCounts, invokedMethodListeners, classListeners, suiteRunner);
    }

    private void init(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder annotationFinder, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners, ISuiteRunnerListener suiteRunner) {
        boolean preserveOrder;
        this.m_configuration = configuration;
        this.m_xmlTest = test;
        this.m_suite = suite;
        this.m_testName = test.getName();
        this.m_host = suite.getHost();
        this.m_testClassesFromXml = test.getXmlClasses();
        this.m_injectorFactory = this.m_configuration.getInjectorFactory();
        this.m_objectFactory = suite.getObjectFactory();
        this.setVerbose(test.getVerbose());
        if (suiteRunner == null) {
            if (suite instanceof ISuiteRunnerListener) {
                this.setExitCodeListener(((ISuiteRunnerListener)((Object)suite)).getExitCodeListener());
            }
        } else {
            this.setExitCodeListener(suiteRunner.getExitCodeListener());
        }
        IMethodInterceptor builtinInterceptor = (preserveOrder = test.getPreserveOrder().booleanValue()) ? new PreserveOrderMethodInterceptor() : new InstanceOrderingMethodInterceptor();
        this.m_methodInterceptors = new ArrayList<IMethodInterceptor>();
        this.m_methodInterceptors.add(builtinInterceptor);
        List<XmlPackage> m_packageNamesFromXml = this.getAllPackages();
        for (XmlPackage xp : m_packageNamesFromXml) {
            this.m_testClassesFromXml.addAll(xp.getXmlClasses());
        }
        this.m_annotationFinder = annotationFinder;
        this.m_classListeners.clear();
        for (IClassListener classListener : classListeners) {
            this.m_classListeners.put(classListener.getClass(), classListener);
        }
        this.m_invoker = new Invoker(this.m_configuration, this, this, this.m_suite.getSuiteState(), skipFailedInvocationCounts, invokedMethodListeners, classListeners, this.holder, this.m_confListener, suiteRunner);
        if (test.getParallel() != null) {
            TestRunner.log("Running the tests in '" + test.getName() + "' with parallel mode:" + String.valueOf((Object)test.getParallel()));
        }
        this.setOutputDirectory(outputDirectory);
        this.init();
    }

    private List<XmlPackage> getAllPackages() {
        List<XmlPackage> testPackages;
        List<XmlPackage> allPackages = Lists.newArrayList();
        List<XmlPackage> suitePackages = this.m_xmlTest.getSuite().getPackages();
        if (suitePackages != null) {
            allPackages.addAll(suitePackages);
        }
        if ((testPackages = this.m_xmlTest.getPackages()) != null) {
            allPackages.addAll(testPackages);
        }
        return allPackages;
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        this.initMethods();
        this.initListeners();
        for (IConfigurationListener cl : this.m_configuration.getConfigurationListeners()) {
            this.addConfigurationListener(cl);
        }
    }

    private void initListeners() {
        Set<Class> listenerClasses = Sets.newLinkedHashSet();
        Class listenerFactoryClass = null;
        for (IClass iClass : this.getTestClasses()) {
            Class<?> realClass = iClass.getRealClass();
            TestListenerHelper.ListenerHolder listenerHolder = TestListenerHelper.findAllListeners(realClass, this.m_annotationFinder);
            if (listenerFactoryClass == null) {
                listenerFactoryClass = listenerHolder.getListenerFactoryClass();
            }
            listenerClasses.addAll(listenerHolder.getListenerClasses());
        }
        if (listenerFactoryClass == null) {
            listenerFactoryClass = DefaultListenerFactory.class;
        }
        ITestNGListenerFactory factory = Optional.ofNullable(this.m_configuration.getListenerFactory()).orElse(new DefaultListenerFactory(this.m_objectFactory, this));
        for (Class c : listenerClasses) {
            ITestNGListener listener = factory.createListener(c);
            this.addListener(listener);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> metaGroups = xmlTest.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : metaGroups.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setScript(this.m_xmlTest.getScript());
        this.m_xmlMethodSelector.setOverrideIncludedMethods(this.m_configuration.getOverrideIncludedMethods());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector selector : xmlTest.getMethodSelectors()) {
                IMethodSelector s;
                if (selector.getClassName() == null) continue;
                try {
                    s = (IMethodSelector)this.m_objectFactory.newInstance(selector.getClassName(), new Object[0]);
                }
                catch (Exception ex) {
                    throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
                }
                this.m_runInfo.addMethodSelector(s, selector.getPriority());
            }
        }
    }

    private void initMethods() {
        IClass[] classes;
        List<ITestNGMethod> beforeClassMethods = Lists.newArrayList();
        List<ITestNGMethod> testMethods = Lists.newArrayList();
        List<ITestNGMethod> afterClassMethods = Lists.newArrayList();
        List<ITestNGMethod> beforeSuiteMethods = Lists.newArrayList();
        List<ITestNGMethod> afterSuiteMethods = Lists.newArrayList();
        List<ITestNGMethod> beforeXmlTestMethods = Lists.newArrayList();
        List<ITestNGMethod> afterXmlTestMethods = Lists.newArrayList();
        ClassInfoMap classMap = new ClassInfoMap(this.m_testClassesFromXml);
        this.m_testClassFinder = new TestNGClassFinder(classMap, Maps.newHashMap(), this.m_configuration, this, this.holder);
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(this.m_objectFactory, this.m_runInfo, this.m_annotationFinder, this.comparator);
        this.m_runInfo.setTestMethods(testMethods);
        for (IClass ic : classes = this.m_testClassFinder.findTestClasses()) {
            TestClass tc = new TestClass(this.m_objectFactory, ic, testMethodFinder, this.m_annotationFinder, this.m_xmlTest, classMap.getXmlClass(ic.getRealClass()), this.m_testClassFinder.getFactoryCreationFailedMessage());
            this.m_classMap.put(ic.getRealClass(), tc);
        }
        Map<String, List<ITestNGMethod>> beforeGroupMethods = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> afterGroupMethods = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass tc : this.m_classMap.values()) {
            MethodHelper.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
            MethodHelper.fixMethodsWithClass(TestRunner.beforeClassConfigMethods(tc), tc, beforeClassMethods);
            MethodHelper.fixMethodsWithClass(tc.getBeforeTestMethods(), tc, null);
            MethodHelper.fixMethodsWithClass(tc.getAfterTestMethods(), tc, null);
            MethodHelper.fixMethodsWithClass(TestRunner.afterClassConfigMethods(tc), tc, afterClassMethods);
            MethodHelper.fixMethodsWithClass(tc.getBeforeSuiteMethods(), tc, beforeSuiteMethods);
            MethodHelper.fixMethodsWithClass(tc.getAfterSuiteMethods(), tc, afterSuiteMethods);
            MethodHelper.fixMethodsWithClass(tc.getBeforeTestConfigurationMethods(), tc, beforeXmlTestMethods);
            MethodHelper.fixMethodsWithClass(tc.getAfterTestConfigurationMethods(), tc, afterXmlTestMethods);
            MethodHelper.fixMethodsWithClass(tc.getBeforeGroupsMethods(), tc, MethodHelper.uniqueMethodList(beforeGroupMethods.values()));
            MethodHelper.fixMethodsWithClass(tc.getAfterGroupsMethods(), tc, MethodHelper.uniqueMethodList(afterGroupMethods.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(beforeSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(beforeXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_classMethodMap = new ClassMethodMap(Arrays.asList(this.testMethodsContainer.getItems()), this.m_xmlMethodSelector);
        this.m_groupMethods = new ConfigurationGroupMethods(this.testMethodsContainer, beforeGroupMethods, afterGroupMethods);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(afterXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(afterSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
    }

    private static ITestNGMethod[] beforeClassConfigMethods(ITestClass tc) {
        return (ITestNGMethod[])ITestClassConfigInfo.allBeforeClassMethods(tc).toArray(ITestNGMethod[]::new);
    }

    private static ITestNGMethod[] afterClassConfigMethods(ITestClass tc) {
        return (ITestNGMethod[])ITestClassConfigInfo.allAfterClassMethods(tc).toArray(ITestNGMethod[]::new);
    }

    private ITestNGMethod[] computeAndGetAllTestMethods() {
        List<ITestNGMethod> testMethods = Lists.newArrayList();
        for (ITestClass tc : this.m_classMap.values()) {
            MethodHelper.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
        }
        return MethodHelper.collectAndOrderMethods(testMethods, true, this.m_runInfo, this.m_annotationFinder, false, this.m_excludedMethods, this.comparator);
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String name) {
        this.m_testName = name;
    }

    public void setOutputDirectory(String od) {
        this.m_outputDirectory = od;
    }

    private void addMetaGroup(String name, List<String> groupNames) {
        this.m_metaGroups.put(name, groupNames);
    }

    private Map<String, String> createGroups(List<String> groups) {
        return GroupsHelper.createGroups(this.m_metaGroups, groups);
    }

    public void run() {
        this.beforeRun();
        try {
            XmlTest test = this.getTest();
            this.privateRun(test);
        }
        finally {
            this.afterRun();
            this.forgetHeavyReferencesIfNeeded();
        }
    }

    private void forgetHeavyReferencesIfNeeded() {
        if (RuntimeBehavior.isMemoryFriendlyMode()) {
            this.testMethodsContainer.clearItems();
            this.m_groupMethods = null;
            this.m_classMethodMap = null;
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] testConfigurationMethods = this.getBeforeTestConfigurationMethods();
        this.invokeTestConfigurations(testConfigurationMethods);
    }

    private void invokeTestConfigurations(ITestNGMethod[] testConfigurationMethods) {
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            ConfigMethodArguments arguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(testConfigurationMethods).forSuite(this.m_xmlTest.getSuite()).usingParameters(this.m_xmlTest.getAllParameters()).build();
            this.m_invoker.getConfigInvoker().invokeConfigurations(arguments);
        }
    }

    private static Comparator<ITestNGMethod> newComparator(boolean needPrioritySort) {
        return needPrioritySort ? new TestMethodComparator() : null;
    }

    private boolean sortOnPriority(ITestNGMethod[] interceptedOrder) {
        return this.m_methodInterceptors.size() > 1 || Arrays.stream(interceptedOrder).anyMatch(m -> m.getPriority() != 0);
    }

    private static BlockingQueue<Runnable> newQueue(boolean needPrioritySort) {
        return needPrioritySort ? new PriorityBlockingQueue() : new LinkedBlockingQueue();
    }

    private void privateRun(XmlTest xmlTest) {
        boolean parallel = xmlTest.getParallel().isParallel();
        ITestNGMethod[] interceptedOrder = this.intercept(this.getAllTestMethods());
        AtomicReference reference = new AtomicReference();
        TimeUtils.computeAndShowTime("DynamicGraphHelper.createDynamicGraph()", () -> {
            DynamicGraph<ITestNGMethod> ref = DynamicGraphHelper.createDynamicGraph(interceptedOrder, this.getCurrentXmlTest());
            reference.set(ref);
        });
        IDynamicGraph graph = (IDynamicGraph)reference.get();
        for (ITestNGMethod each : interceptedOrder) {
            if (!(each instanceof BaseTestMethod)) continue;
            Set<ITestNGMethod> downstream = Sets.newHashSet(graph.getDependenciesFor(each));
            ((BaseTestMethod)each).setDownstreamDependencies(downstream);
            Set<ITestNGMethod> upstream = Sets.newHashSet(graph.getUpstreamDependenciesFor(each));
            ((BaseTestMethod)each).setUpstreamDependencies(upstream);
        }
        Collection<IExecutionVisualiser> original = ListenerComparator.sort(this.visualisers, this.m_configuration.getListenerComparator());
        graph.setVisualisers(Sets.newLinkedHashSet(original));
        boolean needPrioritySort = this.sortOnPriority(interceptedOrder);
        Comparator<ITestNGMethod> methodComparator = TestRunner.newComparator(needPrioritySort);
        if (parallel) {
            if (graph.getNodeCount() <= 0) {
                return;
            }
            TestTaskExecutor taskExecutor = new TestTaskExecutor(this.m_configuration, xmlTest, this, TestRunner.newQueue(needPrioritySort), graph, methodComparator);
            taskExecutor.execute();
            taskExecutor.awaitCompletion();
            return;
        }
        List<ITestNGMethod> freeNodes = graph.getFreeNodes();
        if (graph.getNodeCount() > 0 && freeNodes.isEmpty()) {
            throw new TestNGException("No free nodes found in:" + String.valueOf(graph));
        }
        while (!freeNodes.isEmpty()) {
            if (needPrioritySort) {
                freeNodes.sort(methodComparator);
                freeNodes = freeNodes.subList(0, 1);
            }
            this.createWorkers(freeNodes).forEach(Runnable::run);
            graph.setStatus(freeNodes, IDynamicGraph.Status.FINISHED);
            freeNodes = graph.getFreeNodes();
        }
    }

    private ITestNGMethod[] intercept(ITestNGMethod[] methods) {
        List<IMethodInstance> methodInstances = MethodHelper.methodsToMethodInstances(Arrays.asList(methods));
        List<IMethodInterceptor> original = ListenerComparator.sort(this.m_methodInterceptors, this.m_configuration.getListenerComparator());
        for (IMethodInterceptor m_methodInterceptor : original) {
            methodInstances = m_methodInterceptor.intercept(methodInstances, this);
        }
        List<ITestNGMethod> result = MethodHelper.methodInstancesToMethods(methodInstances);
        this.m_classMethodMap = new ClassMethodMap(result, null);
        ITestNGMethod[] resultArray = result.toArray(new ITestNGMethod[0]);
        if (resultArray.length != this.testMethodsContainer.getItems().length) {
            this.m_groupMethods = new ConfigurationGroupMethods(new TestMethodContainer(() -> resultArray), this.m_groupMethods.getBeforeGroupsMethods(), this.m_groupMethods.getAfterGroupsMethods());
        }
        if (this.m_methodInterceptors.size() > 1) {
            for (int i = 0; i < resultArray.length; ++i) {
                resultArray[i].setInterceptedPriority(i);
            }
        }
        return resultArray;
    }

    @Override
    public List<IWorker<ITestNGMethod>> createWorkers(List<ITestNGMethod> methods) {
        AbstractParallelWorker.Arguments args = new AbstractParallelWorker.Arguments.Builder().classMethodMap(this.m_classMethodMap).configMethods(this.m_groupMethods).finder(this.m_annotationFinder).invoker(this.m_invoker).methods(methods).testContext(this).listeners(this.m_classListeners.values()).build();
        List<IWorker<ITestNGMethod>> result = AbstractParallelWorker.newWorker(this.m_xmlTest.getParallel(), this.m_xmlTest.getGroupByInstances()).createWorkers(args);
        long dataDrivenTestCount = result.stream().flatMap(it -> it.getTasks().stream()).filter(ITestNGMethod::isDataDriven).count();
        int threads = this.getCurrentXmlTest().getThreadCount();
        XmlSuite.ParallelMode parallelMode = this.getCurrentXmlTest().getParallel();
        XmlSuite suite = this.getSuite().getXmlSuite();
        if (suite.useGlobalThreadPool() && parallelMode.isParallel() && dataDrivenTestCount >= (long)threads) {
            String msg = "[Deadlock condition detected] Cannot run " + dataDrivenTestCount + " data driven tests on just " + threads + " threads when using common thread pool. Please increase the number of threads to at-least " + (dataDrivenTestCount + 1L) + ".";
            throw new TestNGDeadLockException(msg);
        }
        return result;
    }

    private void afterRun() {
        ITestNGMethod[] testConfigurationMethods = this.getAfterTestConfigurationMethods();
        this.invokeTestConfigurations(testConfigurationMethods);
        this.m_endDate = new Date(System.currentTimeMillis());
        this.dumpInvokedMethods();
        this.fireEvent(false);
        this.removeAttribute("testng.guice-helper");
    }

    private void logStart() {
        TestRunner.log("Running test " + this.m_testName + " on " + this.m_classMap.size() + "  classes,  included groups:[" + Strings.valueOf(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + Strings.valueOf(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass tc : this.m_classMap.values()) {
                ((TestClass)tc).dump();
            }
        }
    }

    private void fireEvent(boolean isStart) {
        if (isStart) {
            for (ITestListener itl : ListenerOrderDeterminer.order(this.m_testListeners, this.m_configuration.getListenerComparator())) {
                itl.onStart(this);
            }
            this.exitCodeListener.onStart(this);
        } else {
            List<ITestListener> testListenersReversed = ListenerOrderDeterminer.reversedOrder(this.m_testListeners, this.m_configuration.getListenerComparator());
            for (ITestListener itl : testListenersReversed) {
                itl.onFinish(this);
            }
            this.exitCodeListener.onFinish(this);
        }
        if (!isStart) {
            MethodHelper.clear(TestRunner.methods(this.getPassedConfigurations()));
            MethodHelper.clear(TestRunner.methods(this.getFailedConfigurations()));
            MethodHelper.clear(TestRunner.methods(this.getSkippedConfigurations()));
            MethodHelper.clear(TestRunner.methods(Arrays.stream(this.getAllTestMethods())));
        }
    }

    private static Stream<Method> methods(IResultMap resultMap) {
        return TestRunner.methods(resultMap.getAllMethods().stream());
    }

    private static Stream<Method> methods(Stream<ITestNGMethod> methods) {
        return methods.map(each -> each.getConstructorOrMethod().getMethod());
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> ig = this.m_xmlMethodSelector.getIncludedGroups();
        return ig.values().toArray(new String[0]);
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> eg = this.m_xmlMethodSelector.getExcludedGroups();
        return eg.values().toArray(new String[0]);
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.testMethodsContainer.getItems();
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        Map<ITestNGMethod, ITestNGMethod> vResult = Maps.newHashMap();
        for (ITestNGMethod m : this.m_excludedMethods) {
            vResult.put(m, m);
        }
        return vResult.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getConfigurationsScheduledForInvocation() {
        return this.m_configsToBeInvoked;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    @Override
    public void addPassedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_passedTests.addResult(tr);
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod tm) {
        return this.m_passedTests.getResults(tm);
    }

    @Override
    public Set<ITestResult> getFailedTests(ITestNGMethod tm) {
        return this.m_failedTests.getResults(tm);
    }

    @Override
    public Set<ITestResult> getSkippedTests(ITestNGMethod tm) {
        return this.m_skippedTests.getResults(tm);
    }

    @Override
    public void addSkippedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_skippedTests.addResult(tr);
    }

    @Override
    public void addFailedTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(result, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(result, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return this.m_configurationListeners.stream().map(ClassBasedWrapper::wrap).distinct().map(ClassBasedWrapper::unWrap).collect(Collectors.toUnmodifiableList());
    }

    private void logFailedTest(ITestResult tr, boolean withinSuccessPercentage) {
        if (withinSuccessPercentage) {
            this.m_failedButWithinSuccessPercentageTests.addResult(tr);
        } else {
            this.m_failedTests.addResult(tr);
        }
    }

    private static void log(String s) {
        Utils.log("TestRunner", 3, s);
    }

    public static int getVerbose() {
        return Utils.getVerbose();
    }

    public void setVerbose(int n) {
        Utils.setVerbose(n);
    }

    void addTestListener(ITestListener listener) {
        boolean found = this.m_testListeners.stream().anyMatch(iTestListener -> iTestListener.getClass().equals(listener.getClass()));
        if (!found) {
            this.m_testListeners.add(listener);
        }
    }

    public void addListener(ITestNGListener listener) {
        IExecutionListener iel;
        if (listener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)listener);
        }
        if (listener instanceof ITestListener) {
            this.addTestListener((ITestListener)listener);
        }
        if (listener instanceof IClassListener) {
            IClassListener classListener = (IClassListener)listener;
            this.m_classListeners.putIfAbsent(classListener.getClass(), classListener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
        if (listener instanceof IConfigurable) {
            this.m_configuration.setConfigurable((IConfigurable)listener);
        }
        if (listener instanceof IHookable) {
            this.m_configuration.setHookable((IHookable)listener);
        }
        if (listener instanceof IExecutionListener && this.m_configuration.addExecutionListenerIfAbsent(iel = (IExecutionListener)listener)) {
            iel.onExecutionStart();
        }
        if (listener instanceof IDataProviderListener) {
            IDataProviderListener dataProviderListener = (IDataProviderListener)listener;
            this.holder.addListener(dataProviderListener);
        }
        if (listener instanceof IDataProviderInterceptor) {
            IDataProviderInterceptor interceptor = (IDataProviderInterceptor)listener;
            this.holder.addInterceptor(interceptor);
        }
        if (listener instanceof IExecutionVisualiser) {
            IExecutionVisualiser l = (IExecutionVisualiser)listener;
            this.visualisers.add(l);
        }
        this.m_suite.addListener(listener);
    }

    void addConfigurationListener(IConfigurationListener icl) {
        boolean alreadyAdded = this.m_configurationListeners.stream().anyMatch(each -> each.getClass().equals(icl.getClass()));
        if (!alreadyAdded) {
            this.m_configurationListeners.add(icl);
        }
    }

    private void setExitCodeListener(ITestListener exitCodeListener) {
        this.exitCodeListener = exitCodeListener;
    }

    @Override
    public ITestListener getExitCodeListener() {
        return Objects.requireNonNull(this.exitCodeListener, "ExitCodeListener cannot be null.");
    }

    private void dumpInvokedMethods() {
        MethodHelper.dumpInvokedMethodInfoToConsole(this.getAllTestMethods(), TestRunner.getVerbose());
    }

    void addMethodInterceptor(IMethodInterceptor methodInterceptor) {
        if (!this.m_methodInterceptors.contains(methodInterceptor)) {
            this.m_methodInterceptors.add(methodInterceptor);
        }
    }

    @Override
    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    @Override
    public IInjectorFactory getInjectorFactory() {
        return this.m_injectorFactory;
    }

    private class ConfigurationListener
    implements IConfigurationListener {
        private ConfigurationListener() {
        }

        @Override
        public void beforeConfiguration(ITestResult tr) {
            TestRunner.this.m_configsToBeInvoked.addResult(tr);
        }

        @Override
        public void onConfigurationFailure(ITestResult itr) {
            TestRunner.this.m_failedConfigurations.addResult(itr);
            this.removeConfigurationResultAfterExecution(itr);
        }

        @Override
        public void onConfigurationSkip(ITestResult itr) {
            TestRunner.this.m_skippedConfigurations.addResult(itr);
            this.removeConfigurationResultAfterExecution(itr);
        }

        @Override
        public void onConfigurationSuccess(ITestResult itr) {
            TestRunner.this.m_passedConfigurations.addResult(itr);
            this.removeConfigurationResultAfterExecution(itr);
        }

        private void removeConfigurationResultAfterExecution(ITestResult itr) {
            TestRunner.this.m_configsToBeInvoked.getAllResults().removeIf(tr -> tr.getMethod().equals(itr.getMethod()));
        }
    }

    public static enum PriorityWeight {
        groupByInstance,
        preserveOrder,
        priority,
        dependsOnGroups,
        dependsOnMethods;

    }
}

