/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.blacklist;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.Country;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.daten.ListeFilme;
import mediathek.daten.blacklist.ApplyBlacklistFilterPredicate;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.MessageBus;
import org.apache.commons.configuration2.Configuration;
import org.jetbrains.annotations.NotNull;

public class ListeBlacklist
extends ArrayList<BlacklistRule> {
    private final GeoblockingPredicate geoblockingPredicate = new GeoblockingPredicate();
    private long days_lower_boundary;
    private boolean doNotShowFutureFilms;
    private boolean doNotShowGeoBlockedFilms;
    private boolean blacklistIsActive;
    private long minimumFilmLength;
    private static final String[] EMPTY_STRING_ARRAY = new String[]{""};

    public synchronized void addWithoutNotification(BlacklistRule b) {
        super.add(b);
    }

    @Override
    public synchronized boolean add(BlacklistRule b) {
        boolean ret = super.add(b);
        this.filterListAndNotifyListeners();
        return ret;
    }

    @Override
    public synchronized boolean remove(Object b) {
        boolean ret = super.remove(b);
        this.filterListAndNotifyListeners();
        return ret;
    }

    public synchronized void remove(List<BlacklistRule> ruleList) {
        for (BlacklistRule rule : ruleList) {
            super.remove(rule);
        }
        this.filterListAndNotifyListeners();
    }

    @Override
    public synchronized BlacklistRule remove(int idx) {
        BlacklistRule ret = (BlacklistRule)super.remove(idx);
        this.filterListAndNotifyListeners();
        return ret;
    }

    @Override
    public synchronized BlacklistRule get(int idx) {
        return (BlacklistRule)super.get(idx);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.filterListAndNotifyListeners();
    }

    public synchronized void filterListe() {
        Daten daten = Daten.getInstance();
        ListeFilme completeFilmList = daten.getListeFilme();
        ListeFilme filteredList = daten.getListeFilmeNachBlackList();
        filteredList.clear();
        this.loadCurrentFilterSettings();
        if (completeFilmList != null && !completeFilmList.isEmpty()) {
            boolean filterBlacklistDuplicates;
            filteredList.setMetaData(completeFilmList.getMetaData());
            this.parallelStream().forEach((? super T entry) -> {
                entry.convertToLowerCase();
                entry.checkPatterns();
            });
            Stream<Object> stream = completeFilmList.parallelStream();
            Configuration config = ApplicationConfiguration.getConfiguration();
            boolean evaluateDuplicates = config.getBoolean("film.evaluate_duplicates", true);
            if (evaluateDuplicates && (filterBlacklistDuplicates = config.getBoolean("blacklist.filter_duplicates", false))) {
                stream = stream.filter(film -> !film.isDuplicate());
            }
            stream.filter(this.createPredicate()).forEachOrdered(filteredList::add);
        }
    }

    private Predicate<DatenFilm> createPredicate() {
        ArrayList<Predicate<DatenFilm>> filterList = new ArrayList<Predicate<DatenFilm>>();
        if (!(Daten.getInstance().getListeFilmeNachBlackList() instanceof IndexedFilmList) && this.days_lower_boundary != 0L) {
            filterList.add(this::checkDate);
        }
        if (this.blacklistIsActive) {
            if (this.doNotShowGeoBlockedFilms) {
                filterList.add(this.geoblockingPredicate);
            }
            if (this.doNotShowFutureFilms) {
                filterList.add(this::checkIfFilmIsInFuture);
            }
            if (this.minimumFilmLength != 0L) {
                filterList.add(this::checkFilmLength);
            }
            if (!this.isEmpty()) {
                ApplyBlacklistFilterPredicate predicate = new ApplyBlacklistFilterPredicate(this);
                filterList.add(predicate);
            }
        }
        Predicate<DatenFilm> pred = filterList.stream().reduce(Predicate::and).orElse(datenFilm -> true);
        filterList.clear();
        return pred;
    }

    public synchronized boolean checkBlackOkFilme_Downloads(DatenFilm film) {
        this.loadCurrentFilterSettings();
        this.days_lower_boundary = 0L;
        this.blacklistIsActive = true;
        return this.applyFiltersForAbos(film);
    }

    public synchronized void filterListAndNotifyListeners() {
        this.filterListe();
        MessageBus.getMessageBus().publishAsync((Object)new BlacklistChangedEvent());
    }

    private void calculateZeitraumBoundaries() {
        try {
            String strZeitraum = MediathekGui.ui().tabFilme.getFilterConfiguration().getZeitraum();
            if (strZeitraum.equalsIgnoreCase("\u221e")) {
                this.days_lower_boundary = 0L;
            } else {
                long days_ms = TimeUnit.MILLISECONDS.convert(Long.parseLong(strZeitraum), TimeUnit.DAYS);
                this.days_lower_boundary = System.currentTimeMillis() - days_ms;
            }
        }
        catch (Exception ex) {
            this.days_lower_boundary = 0L;
        }
    }

    private void calculateMinimumFilmLength() {
        try {
            long filmlength_minutes = Long.parseLong(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE));
            this.minimumFilmLength = filmlength_minutes * 60L;
        }
        catch (Exception ex) {
            this.minimumFilmLength = 0L;
        }
    }

    private void loadCurrentFilterSettings() {
        this.calculateZeitraumBoundaries();
        this.calculateMinimumFilmLength();
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.blacklistIsActive = config.getBoolean("blacklist.is_on", false);
        this.doNotShowFutureFilms = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN));
        this.doNotShowGeoBlockedFilms = ApplicationConfiguration.getInstance().getBlacklistDoNotShowGeoblockedFilms();
        this.geoblockingPredicate.updateLocation();
    }

    private boolean applyFiltersForAbos(DatenFilm film) {
        if (!this.checkDate(film)) {
            return false;
        }
        if (!this.blacklistIsActive) {
            return true;
        }
        if (this.doNotShowGeoBlockedFilms && !this.geoblockingPredicate.test(film)) {
            return false;
        }
        if (this.doNotShowFutureFilms && !this.checkIfFilmIsInFuture(film)) {
            return false;
        }
        if (this.minimumFilmLength != 0L && !this.checkFilmLength(film)) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean bl_is_whitelist = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
        for (BlacklistRule rule : this) {
            if (!Filter.filterAufFilmPruefenWithLength(rule.getSender(), rule.getThema(), this.makePattern(rule.getTitel()), this.makePattern(rule.getThema_titel()), EMPTY_STRING_ARRAY, 0, true, film, true)) continue;
            return bl_is_whitelist;
        }
        return !bl_is_whitelist;
    }

    private String[] makePattern(String input) {
        String[] stringArray;
        if (Filter.isPattern(input)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = input;
        } else {
            stringArray = input.toLowerCase().split(",");
        }
        return stringArray;
    }

    private boolean checkDate(@NotNull DatenFilm film) {
        if (film.isLivestream()) {
            return true;
        }
        if (this.days_lower_boundary != 0L) {
            long filmTime = film.getDatumFilm().getTime();
            return filmTime == 0L || filmTime >= this.days_lower_boundary;
        }
        return true;
    }

    private boolean checkIfFilmIsInFuture(@NotNull DatenFilm film) {
        return film.getDatumFilm().getTime() <= System.currentTimeMillis();
    }

    private boolean checkFilmLength(@NotNull DatenFilm film) {
        int filmLength = film.getFilmLength();
        return filmLength == 0 || this.minimumFilmLength <= (long)filmLength;
    }

    static class GeoblockingPredicate
    implements Predicate<DatenFilm> {
        private Country geoLocation;

        public GeoblockingPredicate() {
            this.updateLocationData();
        }

        public void updateLocation() {
            this.updateLocationData();
        }

        private void updateLocationData() {
            this.geoLocation = ApplicationConfiguration.getInstance().getGeographicLocation();
        }

        @Override
        public boolean test(DatenFilm film) {
            if (film.countrySet.isEmpty()) {
                return true;
            }
            return film.countrySet.contains((Object)this.geoLocation);
        }
    }
}

