/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.exception;

import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.exception.LdapTlsHandshakeFailCause;

public final class LdapTlsHandshakeExceptionClassifier {
    private LdapTlsHandshakeExceptionClassifier() {
    }

    public static LdapTlsHandshakeFailCause classify(Throwable cause) {
        return LdapTlsHandshakeExceptionClassifier.classify(cause, null);
    }

    public static LdapTlsHandshakeFailCause classify(Throwable cause, X509Certificate certificate) {
        LdapTlsHandshakeFailCause failCause = new LdapTlsHandshakeFailCause();
        failCause.setCause(cause);
        Throwable rootCause = ExceptionUtils.getRootCause(cause);
        failCause.setRootCause(rootCause);
        if (rootCause instanceof CertificateExpiredException) {
            failCause.setReason(CertPathValidatorException.BasicReason.EXPIRED);
            failCause.setReasonPhrase("Certificate expired");
        } else if (rootCause instanceof CertificateNotYetValidException) {
            failCause.setReason(CertPathValidatorException.BasicReason.NOT_YET_VALID);
            failCause.setReasonPhrase("Certificate not yet valid");
        } else if (rootCause instanceof CertPathBuilderException) {
            X500Principal subjectX500Principal;
            X500Principal issuerX500Principal;
            failCause.setReason(LdapTlsHandshakeFailCause.LdapApiReason.NO_VALID_CERTIFICATION_PATH);
            failCause.setReasonPhrase("Failed to build certification path");
            if (certificate != null && (issuerX500Principal = certificate.getIssuerX500Principal()).equals(subjectX500Principal = certificate.getSubjectX500Principal())) {
                failCause.setReason(LdapTlsHandshakeFailCause.LdapApiReason.SELF_SIGNED);
                failCause.setReasonPhrase("Self signed certificate");
            }
        } else if (rootCause instanceof CertPathValidatorException) {
            CertPathValidatorException cpve = (CertPathValidatorException)rootCause;
            failCause.setReason(cpve.getReason());
            failCause.setReasonPhrase("Failed to verify certification path");
        } else {
            failCause.setReason(CertPathValidatorException.BasicReason.UNSPECIFIED);
            String failMessage = "Undefined";
            if (cause != null) {
                failMessage = failMessage + ", " + cause.getClass().getSimpleName();
            }
            failCause.setReasonPhrase(failMessage);
        }
        return failCause;
    }
}

