/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleInstancePropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyType;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

final class RubyObjectProperties {
    RubyObjectProperties() {
    }

    public static class ReferencesProvider
    extends TruffleObjectPropertyProvider.References<RubyObject, RubyType, RubyHeapFragment, RubyLanguage> {
        public ReferencesProvider() {
            super(Bundle.RubyObjectProperties_References(), RubyLanguage.instance(), false);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("ruby_") && !viewID.endsWith("_fields");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            return node instanceof RubyNodes.RubyNode && !(node instanceof RubyNodes.RubyObjectFieldNode) && !(node instanceof RubyNodes.RubyObjectArrayItemNode);
        }

        @Override
        protected HeapViewerNode createObjectReferenceNode(RubyObject object, String type, FieldValue field) {
            return new RubyNodes.RubyObjectReferenceNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(RubyObject object) throws InterruptedException {
            HeapOperations.initializeReferences((Heap)object.getInstance().getJavaClass().getHeap());
            return object.getReferences();
        }
    }

    public static class ItemsProvider
    extends TruffleObjectPropertyProvider.Fields<RubyObject, RubyType, RubyHeapFragment, RubyLanguage> {
        public ItemsProvider() {
            super(Bundle.RubyObjectProperties_Items(), RubyLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("ruby_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            if (node instanceof RubyNodes.RubyNode && !(node instanceof RubyNodes.RubyObjectReferenceNode)) {
                RubyObject robject;
                TruffleObject object = (TruffleObject)HeapViewerNode.getValue((HeapViewerNode)node, TruffleObject.DATA_TYPE, (Heap)heap);
                RubyObject rubyObject = robject = object instanceof RubyObject ? (RubyObject)object : null;
                if (robject != null) {
                    return !this.getPropertyItems(robject).isEmpty();
                }
            }
            return false;
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(RubyObject object, String type, FieldValue field) {
            return new RubyNodes.RubyObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(RubyObject object) {
            return object.getItems();
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("org.truffleruby.core.rope.") || className.startsWith("com.oracle.truffle.api.strings.");
        }

        @Override
        protected String getMergedPropertiesKey() {
            return null;
        }
    }

    public static class ArrayItemsProvider
    extends TruffleInstancePropertyProvider.ArrayItems<RubyObject, RubyType, RubyHeapFragment, RubyLanguage> {
        public ArrayItemsProvider() {
            super(Bundle.RubyObjectProperties_Items(), RubyLanguage.instance(), false);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("ruby_");
        }

        @Override
        protected HeapViewerNode createObjectArrayItemNode(RubyObject object, String type, ArrayItemValue item) {
            return new RubyNodes.RubyObjectArrayItemNode(object, type, item);
        }
    }

    public static class FieldsProvider
    extends TruffleObjectPropertyProvider.Fields<RubyObject, RubyType, RubyHeapFragment, RubyLanguage> {
        public FieldsProvider() {
            super(Bundle.RubyObjectProperties_Properties(), RubyLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("ruby_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            return node instanceof RubyNodes.RubyNode && !(node instanceof RubyNodes.RubyObjectReferenceNode);
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(RubyObject object, String type, FieldValue field) {
            return new RubyNodes.RubyObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(RubyObject object) {
            ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
            fields.addAll(object.getFieldValues());
            fields.addAll(object.getStaticFieldValues());
            return fields;
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("org.truffleruby.core.rope.") || className.startsWith("com.oracle.truffle.api.strings.");
        }
    }
}

