/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetColumn;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.utils.CommonUtils;

public class StreamTransferResultSet
implements DBCResultSet {
    private static final Log log = Log.getLog(StreamTransferResultSet.class);
    private final DBCSession session;
    private final DBCStatement statement;
    private final StreamEntityMapping entityMapping;
    private final List<DBCAttributeMetaData> metaAttrs;
    private Object[] streamRow;
    private final List<StreamDataImporterColumnInfo> attributeMappings;
    private DateTimeFormatter dateTimeFormat;
    private ZoneId dateTimeZoneId;

    public StreamTransferResultSet(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull StreamEntityMapping entityMapping) {
        this.session = session;
        this.statement = statement;
        this.entityMapping = entityMapping;
        this.attributeMappings = this.entityMapping.getStreamColumns();
        this.metaAttrs = this.attributeMappings.stream().map(c -> new LocalResultSetColumn((DBCResultSet)this, c.getOrdinalPosition(), c.getName(), (DBSTypedObject)c)).collect(Collectors.toList());
    }

    public List<StreamDataImporterColumnInfo> getAttributeMappings() {
        return this.attributeMappings;
    }

    public void setStreamRow(Object[] streamRow) {
        this.streamRow = streamRow;
    }

    @NotNull
    public DBCSession getSession() {
        return this.session;
    }

    @NotNull
    public DBCStatement getSourceStatement() {
        return this.statement;
    }

    public Object getAttributeValue(int index) throws DBCException {
        StreamDataImporterColumnInfo attr = this.attributeMappings.get(index);
        Object value = this.streamRow[index];
        if (value != null && this.dateTimeFormat != null && attr.getDataKind() == DBPDataKind.DATETIME && !(value instanceof Date)) {
            try {
                String strValue = CommonUtils.toString((Object)value);
                if (CommonUtils.isEmptyTrimmed((String)strValue)) {
                    return null;
                }
                TemporalAccessor ta = this.dateTimeFormat.parse(strValue);
                try {
                    ZonedDateTime zdt = ZonedDateTime.from(ta);
                    value = Date.from(zdt.toInstant());
                }
                catch (Exception e) {
                    LocalDateTime localDT;
                    if (ta.isSupported(ChronoField.NANO_OF_SECOND)) {
                        localDT = LocalDateTime.from(ta);
                    } else {
                        localDT = LocalDate.from(ta).atStartOfDay();
                        log.debug((Object)"No time present in datetime string, defaulting to the start of the day");
                    }
                    if (this.dateTimeZoneId != null) {
                        localDT = localDT.atZone(ZoneId.systemDefault()).withZoneSameInstant(this.dateTimeZoneId).toLocalDateTime();
                    }
                    value = Timestamp.valueOf(localDT);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error parsing datetime string: " + e.getMessage()));
            }
        }
        return value;
    }

    public Object getAttributeValue(String name) throws DBCException {
        return null;
    }

    public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    public boolean nextRow() throws DBCException {
        return false;
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        return new LocalResultSetMeta(this.metaAttrs);
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
    }

    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(DateTimeFormatter dateTimeFormat, ZoneId dateTimeZoneId) {
        this.dateTimeFormat = dateTimeFormat;
        this.dateTimeZoneId = dateTimeZoneId;
        if (this.dateTimeFormat == null || this.dateTimeZoneId != null) {
            // empty if block
        }
    }
}

