/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.registry.ObjectManagerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorDescriptor;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorRegistry;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateNew;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ObjectPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.object";
    public static final String PROP_CAN_OPEN = "canOpen";
    public static final String PROP_CAN_CREATE_SINGLE = "canCreateSingle";
    public static final String PROP_CAN_CREATE_MULTI = "canCreateMulti";
    public static final String PROP_CAN_PASTE = "canPaste";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_CAN_RENAME = "canRename";
    public static final String PROP_CAN_MOVE_UP = "canMoveUp";
    public static final String PROP_CAN_MOVE_DOWN = "canMoveDown";
    public static final String PROP_CAN_FILTER = "canFilter";
    public static final String PROP_CAN_FILTER_OBJECT = "canFilterObject";
    public static final String PROP_HAS_FILTER = "hasFilter";
    public static final String PROP_HAS_TOOLS = "hasTools";
    public static final String PROP_SUPPORTS_CREATING_INDEX = "supportsIndexCreate";
    public static final String PROP_SUPPORTS_CREATING_CONSTRAINT = "supportsConstraintCreate";
    public static final String PROP_PROJECT_RESOURCE_EDITABLE = "projectResourceEditable";
    public static final String PROP_PROJECT_RESOURCE_VIEWABLE = "projectResourceViewable";
    public static final String PROP_SUPPORTS_NATIVE_EXECUTION = "supportsNativeExecution";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter((Object)receiver, DBNNode.class);
        if (node == null) {
            return false;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        switch (property) {
            case "canOpen": {
                return node.isPersisted();
            }
            case "canCreateSingle": {
                return ObjectPropertyTester.canCreateObject(node, true);
            }
            case "canCreateMulti": {
                return ObjectPropertyTester.canCreateObject(node, false);
            }
            case "canPaste": {
                if (node instanceof DBNResource || node instanceof DBNPath) {
                    return property.equals(PROP_CAN_PASTE);
                }
                return ObjectPropertyTester.canCreateObject(node, null);
            }
            case "supportsNativeExecution": {
                if (receiver instanceof DBNResource) {
                    DBNResource dbnResource = (DBNResource)receiver;
                    List associatedDataSources = (List)dbnResource.getAssociatedDataSources();
                    if (CommonUtils.isEmpty((Collection)associatedDataSources)) {
                        return false;
                    }
                    DBPDataSourceContainer dbpDataSourceContainer = (DBPDataSourceContainer)associatedDataSources.get(0);
                    SQLNativeExecutorDescriptor executorDescriptor = SQLNativeExecutorRegistry.getInstance().getExecutorDescriptor(dbpDataSourceContainer);
                    try {
                        return executorDescriptor != null && executorDescriptor.getNativeExecutor() != null;
                    }
                    catch (DBException e) {
                        return false;
                    }
                }
                return false;
            }
            case "canDelete": {
                if (node instanceof DBNDataSource || node instanceof DBNLocalFolder) {
                    return ObjectPropertyTester.nodeProjectHasPermission(node, "project-datasource-edit");
                }
                if (DBNUtils.isReadOnly((DBNNode)node)) {
                    return false;
                }
                if (ObjectPropertyTester.isResourceNode(node) && !ObjectPropertyTester.nodeProjectHasPermission(node, "project-resource-edit")) {
                    return false;
                }
                if (node instanceof DBSWrapper) {
                    DBSWrapper wrapper = (DBSWrapper)node;
                    DBSObject object = wrapper.getObject();
                    if (object == null || DBUtils.isReadOnly((DBSObject)object) || !(node.getParentNode() instanceof DBNContainer) || !DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor")) {
                        return false;
                    }
                    DBEObjectMaker objectMaker = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectMaker.class);
                    return objectMaker != null && objectMaker.canDeleteObject(object);
                }
                if (node instanceof DBNResource) {
                    DBNResource dbnResource = (DBNResource)node;
                    if ((dbnResource.getFeatures() & 2) == 0) break;
                    return true;
                }
                if (node instanceof DBNProject) {
                    DBNProject projectNode = (DBNProject)node;
                    DBPProject project = projectNode.getProject();
                    return project != project.getWorkspace().getActiveProject();
                }
                if (!ObjectPropertyTester.isResourceNode(node)) break;
                return true;
            }
            case "canRename": {
                if (node instanceof DBNDataSource || node instanceof DBNLocalFolder) {
                    return ObjectPropertyTester.nodeProjectHasPermission(node, "project-datasource-edit");
                }
                if (ObjectPropertyTester.isResourceNode(node) && !ObjectPropertyTester.nodeProjectHasPermission(node, "project-resource-edit")) {
                    return false;
                }
                if (node.supportsRename()) {
                    return true;
                }
                if (!(node instanceof DBNDatabaseNode)) break;
                if (DBNUtils.isReadOnly((DBNNode)node) || !DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor")) {
                    return false;
                }
                DBSObject object = ((DBNDatabaseNode)node).getObject();
                if (object == null) break;
                DBEObjectRenamer objectRenamer = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectRenamer.class);
                return !DBUtils.isReadOnly((DBSObject)object) && object.isPersisted() && node.getParentNode() instanceof DBNContainer && objectRenamer != null && objectRenamer.canRenameObject(object);
            }
            case "canMoveUp": 
            case "canMoveDown": {
                DBEObjectReorderer objectReorderer;
                if (!(node instanceof DBNDatabaseNode)) break;
                DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
                if (DBNUtils.isReadOnly((DBNNode)node)) {
                    return false;
                }
                DBSObject object = dbNode.getObject();
                if (!(object instanceof DBPOrderedObject) || (objectReorderer = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectReorderer.class)) == null) break;
                int position = ((DBPOrderedObject)object).getOrdinalPosition();
                if (property.equals(PROP_CAN_MOVE_UP)) {
                    return position > objectReorderer.getMinimumOrdinalPosition(object);
                }
                return position < objectReorderer.getMaximumOrdinalPosition(object);
            }
            case "canFilter": {
                DBNDatabaseNode dbNode;
                DBNDataSource ds;
                if (node instanceof DBNDataSource && (ds = (DBNDataSource)node).getDataSource() == null) {
                    return false;
                }
                if (node instanceof DBNDatabaseItem) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNDatabaseNode) || (dbNode = (DBNDatabaseNode)node).getItemsMeta() == null) break;
                return true;
            }
            case "canFilterObject": {
                DBNDatabaseNode dbNode;
                DBNNode object = node.getParentNode();
                if (!(object instanceof DBNDatabaseNode) || (dbNode = (DBNDatabaseNode)object).getItemsMeta() == null) break;
                return true;
            }
            case "hasFilter": {
                DBNDatabaseNode dbNode;
                if (node instanceof DBNDatabaseItem) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNDatabaseNode) || (dbNode = (DBNDatabaseNode)node).getItemsMeta() == null) break;
                DBSObjectFilter filter = dbNode.getNodeFilter(dbNode.getItemsMeta(), true);
                if ("defined".equals(expectedValue)) {
                    return filter != null && !filter.isEmpty();
                }
                return filter != null && !filter.isNotApplicable();
            }
            case "supportsIndexCreate": {
                return ObjectPropertyTester.supportsCreatingColumnObject(node, DBSTableIndex.class);
            }
            case "supportsConstraintCreate": {
                return ObjectPropertyTester.supportsCreatingColumnObject(node, DBSEntityConstraint.class);
            }
            case "projectResourceEditable": {
                return ObjectPropertyTester.nodeProjectHasPermission(node, "project-resource-edit");
            }
            case "projectResourceViewable": {
                return ObjectPropertyTester.nodeProjectHasPermission(node, "project-resource-view");
            }
        }
        return false;
    }

    private static boolean isResourceNode(DBNNode node) {
        return node.getAdapter(IResource.class) != null;
    }

    public static boolean nodeProjectHasPermission(@NotNull DBNNode node, @NotNull String permissionName) {
        DBPProject ownerProject = node.getOwnerProjectOrNull();
        return ownerProject != null && ownerProject.hasRealmPermission(permissionName);
    }

    public static boolean canCreateObject(DBNNode node, Boolean onlySingle) {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (node instanceof DBNProject && DBWorkbench.isDistributed()) {
            return false;
        }
        if (node instanceof DBNDatabaseNode) {
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            if (dbNode.isVirtual() || !workspace.hasRealmPermission("metadata-editor")) {
                return false;
            }
            DBPDataSource dataSource = dbNode.getDataSource();
            if (dataSource != null && dataSource.getInfo().isReadOnlyMetaData()) {
                return false;
            }
            if (!(node instanceof DBNDataSource) && ObjectPropertyTester.isMetadataChangeDisabled(dbNode)) {
                return false;
            }
        }
        if (onlySingle == null) {
            if (node instanceof DBNDataSource || node instanceof DBNLocalFolder) {
                return node.getOwnerProject().hasRealmPermission("project-datasource-edit");
            }
            if (!(node instanceof DBNContainer) && node.getParentNode() instanceof DBNContainer) {
                node = node.getParentNode();
            }
            if (!(node instanceof DBNContainer)) {
                return false;
            }
            Class objectType = ((DBNContainer)node).getChildrenClass();
            DBNContainer container = (DBNContainer)node;
            if (DBNUtils.isReadOnly((DBNNode)node) || !workspace.hasRealmPermission("metadata-editor")) {
                return false;
            }
            if (node instanceof DBSWrapper && DBUtils.isReadOnly((DBSObject)((DBSWrapper)node).getObject())) {
                return false;
            }
            if (objectType == null) {
                return false;
            }
            DBEObjectMaker objectMaker = ObjectPropertyTester.getObjectManager(objectType, DBEObjectMaker.class);
            if (objectMaker == null) {
                return false;
            }
            return objectMaker.canCreateObject(container.getValueObject());
        }
        if (DBNUtils.isReadOnly((DBNNode)node)) {
            return false;
        }
        List<IContributionItem> createItems = NavigatorHandlerObjectCreateNew.fillCreateMenuItems(null, node);
        if (onlySingle.booleanValue()) {
            return createItems.size() == 1;
        }
        return createItems.size() > 1;
    }

    public static boolean isMetadataChangeDisabled(DBNDatabaseNode node) {
        DBNBrowseSettings navSettings = node.getDataSourceContainer().getNavigatorSettings();
        return navSettings.isHideFolders() || navSettings.isShowOnlyEntities();
    }

    private static <T extends DBEObjectManager> T getObjectManager(Class<?> objectType, Class<T> managerType) {
        return (T)((DBEObjectManager)ObjectManagerRegistry.getInstance().getObjectManager(objectType, managerType));
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.object." + propName));
    }

    private static boolean supportsCreatingColumnObject(@Nullable DBNNode node, @NotNull Class<?> supertype) {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor")) {
            return false;
        }
        if (!(node instanceof DBNDatabaseItem)) {
            return false;
        }
        DBNDatabaseItem databaseItem = (DBNDatabaseItem)node;
        DBSObject attributeObject = databaseItem.getObject();
        if (!(attributeObject instanceof DBSEntityAttribute)) {
            return false;
        }
        DBSEntityAttribute entityAttribute = (DBSEntityAttribute)attributeObject;
        DBPDataSource dataSource = entityAttribute.getDataSource();
        if (dataSource == null || dataSource.getInfo().isReadOnlyMetaData()) {
            return false;
        }
        DBSEntity entityObject = entityAttribute.getParentObject();
        DBEStructEditor structEditor = (DBEStructEditor)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(entityObject.getClass(), DBEStructEditor.class);
        if (structEditor == null) {
            return false;
        }
        for (Class childType : structEditor.getChildTypes()) {
            DBEObjectMaker maker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(childType, DBEObjectMaker.class);
            if (maker == null || !maker.canCreateObject((Object)entityObject) || !supertype.isAssignableFrom(childType)) continue;
            return true;
        }
        return false;
    }
}

