/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.util.test;

import java.util.HashMap;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class FreeColTestUtils {
    private static ColonyBuilder colonyBuilder = null;

    public static ColonyBuilder getColonyBuilder() {
        Game game = FreeColTestCase.getGame();
        if (game == null) {
            throw new NullPointerException("Game not set");
        }
        colonyBuilder = colonyBuilder == null ? new ColonyBuilder(game) : colonyBuilder.reset().setGame(game);
        return colonyBuilder;
    }

    public static boolean setStudentSelection(boolean value) {
        boolean ret = FreeColTestCase.spec().getBoolean("model.option.allowStudentSelection");
        FreeColTestCase.spec().setBoolean("model.option.allowStudentSelection", value);
        return ret;
    }

    public static class ColonyBuilder {
        static final UnitType colonistType = FreeColTestCase.spec().getDefaultUnitType();
        private Game game;
        private HashMap<UnitType, Integer> colonists = new HashMap();
        private Player player;
        private String name;
        private int initialColonists;
        private final String defaultPlayer = "model.nation.dutch";
        private String defaultName = "New Amsterdam";
        private int initialDefaultColonists = 1;
        private Tile colonyTile;

        private ColonyBuilder(Game game) {
            this.game = game;
            this.setStartingParams();
        }

        private void setStartingParams() {
            this.player = null;
            this.colonyTile = null;
            this.name = this.defaultName;
            this.initialColonists = this.initialDefaultColonists;
            this.colonists.clear();
        }

        public ColonyBuilder player(Player player) {
            if (player == null || CollectionUtils.none(this.game.getPlayers(CollectionUtils.matchKey(player)))) {
                throw new IllegalArgumentException("Player not in game");
            }
            this.player = player;
            return this;
        }

        public ColonyBuilder initialColonists(int colonists) {
            if (colonists <= 0) {
                throw new IllegalArgumentException("Number of colonists must be positive");
            }
            this.initialColonists = colonists;
            return this;
        }

        public ColonyBuilder colonyTile(Tile tile) {
            Tile tileOnMap = this.game.getMap().getTile(tile.getX(), tile.getY());
            if (tile != tileOnMap) {
                throw new IllegalArgumentException("Given tile not on map");
            }
            this.colonyTile = tile;
            return this;
        }

        public ColonyBuilder colonyName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
            this.name = name;
            return this;
        }

        public ColonyBuilder addColonist(UnitType type) {
            if (!this.colonists.containsKey(type)) {
                this.colonists.put(type, 0);
            }
            Integer nCol = this.colonists.get(type);
            this.colonists.put(type, nCol + 1);
            return this;
        }

        public Colony build() {
            if (this.player == null) {
                this.player = this.game.getPlayerByNationId("model.nation.dutch");
                if (this.player == null) {
                    throw new IllegalArgumentException("Default Player model.nation.dutch not in game");
                }
            }
            if (this.colonyTile == null) {
                this.colonyTile = this.game.getMap().getTile(5, 8);
                if (this.colonyTile == null) {
                    throw new IllegalArgumentException("Default tile not in game");
                }
            }
            ServerColony colony = new ServerColony(this.game, this.player, this.name, this.colonyTile);
            this.player.addSettlement(colony);
            colony.placeSettlement(true);
            this.player.invalidateCanSeeTiles();
            CollectionUtils.forEachMapEntry(this.colonists, e -> {
                UnitType type = (UnitType)e.getKey();
                Integer n = (Integer)e.getValue();
                for (int i = 0; i < n; ++i) {
                    ServerUnit colonist = new ServerUnit(this.game, this.colonyTile, this.player, type);
                    colonist.setLocation(colony);
                }
            });
            for (int i = colony.getUnitCount(); i < this.initialColonists; ++i) {
                ServerUnit colonist = new ServerUnit(this.game, this.colonyTile, this.player, colonistType);
                colonist.setLocation(colony);
            }
            return colony;
        }

        public ColonyBuilder setGame(Game game) {
            this.game = game;
            return this.reset();
        }

        public ColonyBuilder reset() {
            this.setStartingParams();
            return this;
        }
    }
}

