#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-lib
version:              1.8.2
visibility:           public
id:                   clash-lib-1.8.2-INFo7IPstMnEdk3xxoKWaT
key:                  clash-lib-1.8.2-INFo7IPstMnEdk3xxoKWaT
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2023, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  0128adc1930f8b1f46252932abd9a998
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Backend.Verilog.Time Clash.Core.DataCon
    Clash.Core.EqSolver Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Data.UniqMap Clash.DataFiles Clash.Debug
    Clash.Driver Clash.Driver.Bool Clash.Driver.Manifest
    Clash.Driver.Types Clash.Edalize.Edam Clash.Netlist
    Clash.Netlist.BlackBox Clash.Netlist.BlackBox.Parser
    Clash.Netlist.BlackBox.Types Clash.Netlist.BlackBox.Util
    Clash.Netlist.Expr Clash.Netlist.Id Clash.Netlist.Id.Common
    Clash.Netlist.Id.Internal Clash.Netlist.Id.SystemVerilog
    Clash.Netlist.Id.VHDL Clash.Netlist.Id.Verilog Clash.Netlist.Types
    Clash.Netlist.Util Clash.Normalize
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Primitives
    Clash.Normalize.Strategy Clash.Normalize.Transformations
    Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty
    Clash.Primitives.Annotations.SynthesisAttributes
    Clash.Primitives.DSL Clash.Primitives.GHC.Int
    Clash.Primitives.GHC.Literal Clash.Primitives.GHC.Word
    Clash.Primitives.Intel.ClockGen Clash.Primitives.Magic
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Primitives.Xilinx.ClockGen Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Eq Clash.Util.Graph
    Clash.Util.Interpolate Clash.Util.Supply Clash.Verification.Pretty
    Data.Aeson.Extra Data.Text.Prettyprint.Doc.Extra
    GHC.BasicTypes.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.SrcLoc.Extra Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.6.6/site-local/clash-lib-1.8.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/clash-lib-1.8.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/clash-lib-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.8.2-INFo7IPstMnEdk3xxoKWaT
depends:
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    aeson-pretty-0.8.10-LSDchJgtnQ46sIK4bUu3co
    ansi-terminal-1.1-6H4MdlQ9LS5JB7dL181Y6t array-0.5.6.0
    async-2.2.5-BExe3HBSFHr8hii1cT1bvS
    attoparsec-0.14.4-FIfeiNzOKYm3sEc1QPF51Z
    attoparsec-aeson-2.2.0.0-KYduzFSMaTW7ukJHpbwuYU base-4.18.2.1
    base16-bytestring-1.0.2.0-4dU46p0HYXn6d3pnzwPlcc binary-0.8.9.1
    bytestring-0.11.5.3 clash-prelude-1.8.2-EKQAYifjjxuATYxUOJtwrU
    containers-0.6.7
    cryptohash-sha256-0.11.102.1-BO36oUcGTLo3lAT0W1U2yt
    data-binary-ieee754-0.4.4-4UW07Uhzyok6gyNDRTrrKK
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz deepseq-1.4.8.1
    directory-1.3.8.5 dlist-1.0-B7D1vsARFiIHVaGk5CGbYO
    exceptions-0.10.7 extra-1.7.16-6e0wBrlA2xu66mkOtGwbe0
    filepath-1.4.300.1 ghc-9.6.6 ghc-bignum-1.3 ghc-boot-th-9.6.6
    ghc-prim-0.10.0 hashable-1.4.7.0-LE3bCdm1Wgy6IgVYkRoAlQ
    haskell-src-meta-0.8.15-K6MW8Fmh6SH9wv6uJsUQoC
    hint-0.9.0.8-97bdZ4oGtBv1GKeSz1P4CK
    infinite-list-0.1.3-HZsbMQm6sMp4wFop3twbNd
    lens-5.3.3-Ag3JywAjDxJ2k98xBhf4hs mtl-2.3.1
    ordered-containers-0.2.4-8Jl0j7mIzomD5fmADOiqOg
    pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    prettyprinter-1.7.1-4PNEjQDcFkU8z4wKR8XxHs
    prettyprinter-interp-0.2.0.0-CM10VM4LhfF9zCJnTBRm3v
    primitive-0.9.1.0-3wcULVX324m4b7zw32DKNg
    string-interpolate-0.3.4.0-KKh3zQmiwYu18s1gHvbgP9
    template-haskell-2.20.0.0 temporary-1.3-7FXkQQKerYU7UfmRyKNwo9
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2 time-1.12.2
    transformers-0.6.1.0 trifecta-2.1.4-IoHJA7IaZdg46NOcBePxL3
    unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi
    vector-binary-instances-0.2.5.2-HZgfLZ0BeRq7aeVKAymBpS
    yaml-0.11.11.2-BS6mG9zOsXWGQgGFfufno4

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

