/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import oracle.net.ano.AnoComm;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

class AnoCommNIO
extends AnoComm {
    private static final boolean DEBUG = false;
    private boolean bytesReadyToGo = false;
    NIONSDataChannel nsDataChannel;
    SessionAtts sAtts;

    public AnoCommNIO(SessionAtts sAtts) {
        this.sAtts = sAtts;
        this.nsDataChannel = sAtts.dataChannel;
    }

    private void prepareForUnmarshall() throws IOException {
        if (this.bytesReadyToGo) {
            this.flush();
        }
        if (this.sAtts.payloadDataBufferForRead.hasRemaining()) {
            return;
        }
        this.nsDataChannel.readDataFromSocketChannel();
    }

    private void prepareForMarshall(int numberBytesToBeWritten) throws IOException {
        if (this.sAtts.payloadDataBufferForWrite.remaining() < numberBytesToBeWritten) {
            if (this.bytesReadyToGo) {
                this.flush();
            }
            this.sAtts.prepareWriteBuffer();
        }
    }

    @Override
    protected void flush() throws IOException {
        if (this.bytesReadyToGo) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        this.bytesReadyToGo = false;
    }

    @Override
    protected void sendUB1(short num) throws IOException {
        this.sendPktHeader(1, 2);
        this.prepareForMarshall(1);
        this.sAtts.payloadDataBufferForWrite.put((byte)num);
        this.bytesReadyToGo = true;
    }

    @Override
    protected void sendString(String str) throws IOException {
        this.sendPktHeader(str.length(), 0);
        this.prepareForMarshall(str.length());
        this.sAtts.payloadDataBufferForWrite.put(str.getBytes(StandardCharsets.US_ASCII));
        this.bytesReadyToGo = true;
    }

    @Override
    protected void sendRaw(byte[] rawdata) throws IOException {
        this.sendPktHeader(rawdata.length, 1);
        this.prepareForMarshall(rawdata.length);
        this.sAtts.payloadDataBufferForWrite.put(rawdata);
        this.bytesReadyToGo = true;
    }

    @Override
    protected void writeUB1(short num) throws IOException {
        this.prepareForMarshall(1);
        this.sAtts.payloadDataBufferForWrite.put((byte)num);
        this.bytesReadyToGo = true;
    }

    @Override
    protected void writeUB2(int value) throws IOException {
        byte[] tmpBuffer = new byte[2];
        byte bytes = this.value2Buffer((short)(0xFFFF & value), tmpBuffer);
        this.prepareForMarshall(tmpBuffer.length);
        this.sAtts.payloadDataBufferForWrite.put(tmpBuffer, 0, bytes);
        this.bytesReadyToGo = true;
    }

    @Override
    protected void writeUB4(long value) throws IOException {
        byte[] tmpBuffer = new byte[4];
        byte bytes = this.value2Buffer((int)(0xFFFFFFFFFFFFFFFFL & value), tmpBuffer);
        this.prepareForMarshall(tmpBuffer.length);
        this.sAtts.payloadDataBufferForWrite.put(tmpBuffer, 0, bytes);
        this.bytesReadyToGo = true;
    }

    @Override
    protected short readUB1() throws NetException, IOException {
        short value = 0;
        this.prepareForUnmarshall();
        value = (short)(this.sAtts.payloadDataBufferForRead.get() & 0xFF);
        return value;
    }

    @Override
    protected byte[] receiveByteArray(int n) throws NetException, IOException {
        byte[] tmpBuffer = new byte[n];
        this.prepareForUnmarshall();
        this.sAtts.payloadDataBufferForRead.get(tmpBuffer);
        return tmpBuffer;
    }

    protected int receiveByteArray(byte[] buf, int off, int len) throws NetException, IOException {
        int cnt = 0;
        this.sAtts.payloadDataBufferForRead.get(buf, off, len);
        return cnt;
    }

    @Override
    protected long buffer2Value(byte[] tmpBuffer) throws NetException, IOException {
        long value = 0L;
        this.prepareForUnmarshall();
        this.sAtts.payloadDataBufferForRead.get(tmpBuffer);
        for (int i = 0; i < tmpBuffer.length; ++i) {
            value |= (long)((tmpBuffer[i] & 0xFF) << 8 * (tmpBuffer.length - 1 - i));
        }
        return value &= 0xFFFFFFFFFFFFFFFFL;
    }
}

