/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.stats.upload;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geospatial.stats.upload.UploadMetric;
import org.opensearch.geospatial.stats.upload.UploadStats;

public final class TotalUploadStats
implements ToXContentObject {
    private final List<UploadStats> uploadStatsList;

    public TotalUploadStats(List<UploadStats> uploadStatsList) {
        this.uploadStatsList = Objects.requireNonNull(uploadStatsList, "Upload stats list cannot be null");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(FIELDS.TOTAL.toString());
        if (this.isUploadStatsEmpty()) {
            return builder.endObject();
        }
        long totalRequestCount = this.uploadStatsList.stream().mapToLong(UploadStats::getTotalAPICount).sum();
        builder.field(FIELDS.REQUEST_COUNT.toString(), totalRequestCount);
        long totalUpload = this.sumMetricField(this.uploadStatsList, UploadMetric::getUploadCount);
        builder.field(FIELDS.UPLOAD.toString(), totalUpload);
        long totalSuccess = this.sumMetricField(this.uploadStatsList, UploadMetric::getSuccessCount);
        builder.field(FIELDS.SUCCESS.toString(), totalSuccess);
        long totalFailed = this.sumMetricField(this.uploadStatsList, UploadMetric::getFailedCount);
        builder.field(FIELDS.FAILED.toString(), totalFailed);
        long totalDuration = this.sumMetricField(this.uploadStatsList, UploadMetric::getDuration);
        builder.field(FIELDS.DURATION.toString(), totalDuration);
        return builder.endObject();
    }

    private long sumMetricField(List<UploadStats> stats, Function<UploadMetric, Long> mapper) {
        return stats.stream().map(UploadStats::getMetrics).flatMap(Collection::stream).mapToLong(mapper::apply).sum();
    }

    public boolean isUploadStatsEmpty() {
        return this.uploadStatsList.isEmpty();
    }

    public static enum FIELDS {
        DURATION,
        FAILED,
        REQUEST_COUNT,
        SUCCESS,
        TOTAL,
        UPLOAD;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

