/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.stats.ShardRoutingState;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardRouting
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardRouting> {
    @Nonnull
    private final String node;
    private final boolean primary;
    @Nullable
    private final String relocatingNode;
    @Nonnull
    private final ShardRoutingState state;
    public static final JsonpDeserializer<ShardRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRouting::setupShardRoutingDeserializer);

    private ShardRouting(Builder builder) {
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, this, "primary");
        this.relocatingNode = builder.relocatingNode;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static ShardRouting of(Function<Builder, ObjectBuilder<ShardRouting>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String node() {
        return this.node;
    }

    public final boolean primary() {
        return this.primary;
    }

    @Nullable
    public final String relocatingNode() {
        return this.relocatingNode;
    }

    @Nonnull
    public final ShardRoutingState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.relocatingNode != null) {
            generator.writeKey("relocating_node");
            generator.write(this.relocatingNode);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardRoutingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::relocatingNode, JsonpDeserializer.stringDeserializer(), "relocating_node");
        op.add(Builder::state, ShardRoutingState._DESERIALIZER, "state");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.node.hashCode();
        result = 31 * result + Boolean.hashCode(this.primary);
        result = 31 * result + Objects.hashCode(this.relocatingNode);
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardRouting other = (ShardRouting)o;
        return this.node.equals(other.node) && this.primary == other.primary && Objects.equals(this.relocatingNode, other.relocatingNode) && this.state.equals(other.state);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardRouting> {
        private String node;
        private Boolean primary;
        @Nullable
        private String relocatingNode;
        private ShardRoutingState state;

        public Builder() {
        }

        private Builder(ShardRouting o) {
            this.node = o.node;
            this.primary = o.primary;
            this.relocatingNode = o.relocatingNode;
            this.state = o.state;
        }

        private Builder(Builder o) {
            this.node = o.node;
            this.primary = o.primary;
            this.relocatingNode = o.relocatingNode;
            this.state = o.state;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        @Nonnull
        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        @Nonnull
        public final Builder relocatingNode(@Nullable String value) {
            this.relocatingNode = value;
            return this;
        }

        @Nonnull
        public final Builder state(ShardRoutingState value) {
            this.state = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardRouting build() {
            this._checkSingleUse();
            return new ShardRouting(this);
        }
    }
}

