/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.CollapseResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.PersonalizeSearchRankingResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.RenameFieldResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.RerankResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessorVariant;
import org.opensearch.client.opensearch.search_pipeline.RetrievalAugmentedGenerationResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.SortResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.SplitResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.TruncateHitsResponseProcessor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class ResponseProcessor
implements TaggedUnion<Kind, ResponseProcessorVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final ResponseProcessorVariant _value;
    public static final JsonpDeserializer<ResponseProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResponseProcessor::setupResponseProcessorDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final ResponseProcessorVariant _get() {
        return this._value;
    }

    public ResponseProcessor(ResponseProcessorVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._responseProcessorKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private ResponseProcessor(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static ResponseProcessor of(Function<Builder, ObjectBuilder<ResponseProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCollapse() {
        return this._kind == Kind.Collapse;
    }

    public CollapseResponseProcessor collapse() {
        return (CollapseResponseProcessor)TaggedUnionUtils.get(this, Kind.Collapse);
    }

    public boolean isPersonalizeSearchRanking() {
        return this._kind == Kind.PersonalizeSearchRanking;
    }

    public PersonalizeSearchRankingResponseProcessor personalizeSearchRanking() {
        return (PersonalizeSearchRankingResponseProcessor)TaggedUnionUtils.get(this, Kind.PersonalizeSearchRanking);
    }

    public boolean isRenameField() {
        return this._kind == Kind.RenameField;
    }

    public RenameFieldResponseProcessor renameField() {
        return (RenameFieldResponseProcessor)TaggedUnionUtils.get(this, Kind.RenameField);
    }

    public boolean isRerank() {
        return this._kind == Kind.Rerank;
    }

    public RerankResponseProcessor rerank() {
        return (RerankResponseProcessor)TaggedUnionUtils.get(this, Kind.Rerank);
    }

    public boolean isRetrievalAugmentedGeneration() {
        return this._kind == Kind.RetrievalAugmentedGeneration;
    }

    public RetrievalAugmentedGenerationResponseProcessor retrievalAugmentedGeneration() {
        return (RetrievalAugmentedGenerationResponseProcessor)TaggedUnionUtils.get(this, Kind.RetrievalAugmentedGeneration);
    }

    public boolean isSort() {
        return this._kind == Kind.Sort;
    }

    public SortResponseProcessor sort() {
        return (SortResponseProcessor)TaggedUnionUtils.get(this, Kind.Sort);
    }

    public boolean isSplit() {
        return this._kind == Kind.Split;
    }

    public SplitResponseProcessor split() {
        return (SplitResponseProcessor)TaggedUnionUtils.get(this, Kind.Split);
    }

    public boolean isTruncateHits() {
        return this._kind == Kind.TruncateHits;
    }

    public TruncateHitsResponseProcessor truncateHits() {
        return (TruncateHitsResponseProcessor)TaggedUnionUtils.get(this, Kind.TruncateHits);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResponseProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collapse, CollapseResponseProcessor._DESERIALIZER, "collapse");
        op.add(Builder::personalizeSearchRanking, PersonalizeSearchRankingResponseProcessor._DESERIALIZER, "personalize_search_ranking");
        op.add(Builder::renameField, RenameFieldResponseProcessor._DESERIALIZER, "rename_field");
        op.add(Builder::rerank, RerankResponseProcessor._DESERIALIZER, "rerank");
        op.add(Builder::retrievalAugmentedGeneration, RetrievalAugmentedGenerationResponseProcessor._DESERIALIZER, "retrieval_augmented_generation");
        op.add(Builder::sort, SortResponseProcessor._DESERIALIZER, "sort");
        op.add(Builder::split, SplitResponseProcessor._DESERIALIZER, "split");
        op.add(Builder::truncateHits, TruncateHitsResponseProcessor._DESERIALIZER, "truncate_hits");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseProcessor other = (ResponseProcessor)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ResponseProcessor> {
        private Kind _kind;
        private ResponseProcessorVariant _value;

        public Builder() {
        }

        private Builder(ResponseProcessor o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<ResponseProcessor> collapse(CollapseResponseProcessor v) {
            this._kind = Kind.Collapse;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> collapse(Function<CollapseResponseProcessor.Builder, ObjectBuilder<CollapseResponseProcessor>> fn) {
            return this.collapse(fn.apply(new CollapseResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> personalizeSearchRanking(PersonalizeSearchRankingResponseProcessor v) {
            this._kind = Kind.PersonalizeSearchRanking;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> personalizeSearchRanking(Function<PersonalizeSearchRankingResponseProcessor.Builder, ObjectBuilder<PersonalizeSearchRankingResponseProcessor>> fn) {
            return this.personalizeSearchRanking(fn.apply(new PersonalizeSearchRankingResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> renameField(RenameFieldResponseProcessor v) {
            this._kind = Kind.RenameField;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> renameField(Function<RenameFieldResponseProcessor.Builder, ObjectBuilder<RenameFieldResponseProcessor>> fn) {
            return this.renameField(fn.apply(new RenameFieldResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> rerank(RerankResponseProcessor v) {
            this._kind = Kind.Rerank;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> rerank(Function<RerankResponseProcessor.Builder, ObjectBuilder<RerankResponseProcessor>> fn) {
            return this.rerank(fn.apply(new RerankResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> retrievalAugmentedGeneration(RetrievalAugmentedGenerationResponseProcessor v) {
            this._kind = Kind.RetrievalAugmentedGeneration;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> retrievalAugmentedGeneration(Function<RetrievalAugmentedGenerationResponseProcessor.Builder, ObjectBuilder<RetrievalAugmentedGenerationResponseProcessor>> fn) {
            return this.retrievalAugmentedGeneration(fn.apply(new RetrievalAugmentedGenerationResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> sort(SortResponseProcessor v) {
            this._kind = Kind.Sort;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> sort(Function<SortResponseProcessor.Builder, ObjectBuilder<SortResponseProcessor>> fn) {
            return this.sort(fn.apply(new SortResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> split(SplitResponseProcessor v) {
            this._kind = Kind.Split;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> split(Function<SplitResponseProcessor.Builder, ObjectBuilder<SplitResponseProcessor>> fn) {
            return this.split(fn.apply(new SplitResponseProcessor.Builder()).build());
        }

        public ObjectBuilder<ResponseProcessor> truncateHits(TruncateHitsResponseProcessor v) {
            this._kind = Kind.TruncateHits;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseProcessor> truncateHits(Function<TruncateHitsResponseProcessor.Builder, ObjectBuilder<TruncateHitsResponseProcessor>> fn) {
            return this.truncateHits(fn.apply(new TruncateHitsResponseProcessor.Builder()).build());
        }

        @Override
        public ResponseProcessor build() {
            this._checkSingleUse();
            return new ResponseProcessor(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Collapse("collapse"),
        PersonalizeSearchRanking("personalize_search_ranking"),
        RenameField("rename_field"),
        Rerank("rerank"),
        RetrievalAugmentedGeneration("retrieval_augmented_generation"),
        Sort("sort"),
        Split("split"),
        TruncateHits("truncate_hits");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

