/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import javax.swing.SizeRequirements;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class LogEditorKit
extends StyledEditorKit
implements ViewFactory {
    private static final long serialVersionUID = -6193302665953492671L;
    private boolean lineWrap_ = false;

    public boolean isLineWrap() {
        return this.lineWrap_;
    }

    public void setLineWrap(boolean wrap) {
        this.lineWrap_ = wrap;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new LabelView(elem);
            }
            if (kind.equals("paragraph")) {
                return new LogParagraphView(elem);
            }
            if (kind.equals("section")) {
                return new BoxView(elem, 1);
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new LabelView(elem);
    }

    private class LogParagraphView
    extends ParagraphView {
        public LogParagraphView(Element elem) {
            super(elem);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            if (LogEditorKit.this.lineWrap_) {
                return super.calculateMinorAxisRequirements(axis, r);
            }
            SizeRequirements req = super.calculateMinorAxisRequirements(axis, r);
            req.minimum = req.preferred;
            return req;
        }

        @Override
        public int getFlowSpan(int index) {
            if (LogEditorKit.this.lineWrap_) {
                return super.getFlowSpan(index);
            }
            return Integer.MAX_VALUE;
        }
    }
}

