/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public abstract class AbstractTextHandler {
    private BufferedReader reader;
    private String text;
    private String rawLine;
    private String currentLine;
    private int lineBegin = 0;
    private int lineEnd = -1;
    private int lineNumber = 0;

    public AbstractTextHandler(String text) {
        this.text = text;
    }

    public int getLineBegin() {
        return this.lineBegin;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getText() {
        return this.text;
    }

    protected final String currentLine() {
        return this.currentLine;
    }

    protected final void setCurrentLine(String currentLine) {
        this.currentLine = currentLine;
    }

    protected final String text() {
        return this.text;
    }

    protected final String rawLine() {
        return this.rawLine;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    protected void reset() {
        this.lineBegin = 0;
        this.lineEnd = -1;
        this.currentLine = null;
        this.rawLine = null;
        this.reader = new BufferedReader(new StringReader(this.text));
    }

    protected final String readLine() {
        try {
            if (this.lineEnd >= 0) {
                this.lineBegin = this.lineEnd + 1;
            }
            this.rawLine = this.reader.readLine();
            if (this.rawLine != null) {
                ++this.lineNumber;
                this.lineEnd = this.lineBegin + this.rawLine.length();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.rawLine;
    }

    protected final boolean ready() {
        try {
            return this.reader.ready();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected final void reset(int oldBegin, int oldEnd) {
        this.lineBegin = oldBegin;
        this.lineEnd = oldEnd;
    }
}

