/**
 * A list of most categories supported by the system integration.
 *
 * Some categories are intentionally missing because they are aliases of other categories
 * or are unlikely to be used in common web apps. This list should mostly be kept in sync
 * with lists in the system integration part of the native program.
 *
 * @type {string[]}
 */
export const knownCategories = [
  // XDG Main Categories
  'audio-video',
  'audio',
  'music',
  'video',
  'development',
  'education',
  'game',
  'design',
  'graphics',
  'network',
  'office',
  'settings',
  'system',
  'personalization',
  'utility',

  // XDG Additional Categories
  'debugger',
  'ide',
  'revision-control',
  'version-control',
  'translation',
  'calendar',
  'contact-management',
  'database',
  'dictionary',
  'chart',
  'email',
  'finance',
  'flowchart',
  'presentation',
  'spreadsheet',
  'word-processor',
  '2d-graphics',
  'vector-graphics',
  'raster-graphics',
  '3d-graphics',
  'scanning',
  'ocr',
  'photo',
  'photography',
  'publishing',
  'printing',
  'chat',
  'social',
  'irc-client',
  'file-transfer',
  'ham-radio',
  'magazines',
  'newspapers',
  'news',
  'p2p',
  'remote-access',
  'telephony',
  'video-conference',
  'browser',
  'web-browser',
  'web-development',
  'tv',
  'audio-editing',
  'video-editing',
  'audio-video-editing',
  'player',
  'recorder',
  'disc-burning',
  'action-game',
  'adventure-game',
  'arcade-game',
  'board-game',
  'blocks-game',
  'card-game',
  'kids-game',
  'logic-game',
  'role-playing-game',
  'simulation-game',
  'sports-game',
  'strategy-game',
  'art',
  'science',
  'astronomy',
  'biology',
  'chemistry',
  'computer-science',
  'data-visualization',
  'economy',
  'electricity',
  'geography',
  'geology',
  'geoscience',
  'history',
  'book',
  'literature',
  'math',
  'medical',
  'physics',
  'robotics',
  'fitness',
  'sport',
  'amusement',
  'entertainment',
  'electronics',
  'emulation',
  'engineering',
  'file-tools',
  'security',
  'accessibility',
  'documentation',

  // macOS Categories
  'business',
  'casino-game',
  'dice-game',
  'educational-game',
  'family-game',
  'music-game',
  'puzzle-game',
  'racing-game',
  'trivia-game',
  'word-game',
  'health',
  'lifestyle',
  'productivity',
  'reference',
  'travel',
  'weather'
]
