/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";
const {
  openIceCatViewTab,
  withIceCatView,
  init: IceCatViewTestUtilsInit,
} = ChromeUtils.importESModule(
  "resource://testing-common/IceCatViewTestUtils.sys.mjs"
);

/**
 * Bug 1856572 - This test is to ensure that fluent strings in IceCat View
 * can be updated after opening Customize Mode
 * **/
add_task(async function test_data_l10n_customize_mode() {
  IceCatViewTestUtilsInit(this);
  await withIceCatView({ win: window }, async function (browser) {
    /**
     * Bug 1856572, Bug 1857622: Without requesting two animation frames
     * the "missing Fluent strings" issue will not reproduce.
     *
     * Given the precondition that we open IceCat View, then open Customize Mode, then
     * navigate back to IceCat View in a quick succession, as long as Fluent
     * controlled strings can be updated by changing their Fluent IDs then this
     * test is valid.
     */
    await new Promise(r =>
      requestAnimationFrame(() => requestAnimationFrame(r))
    );
    await startCustomizing();
    await endCustomizing();
    await openIceCatViewTab(window);
    const { document } = browser.contentWindow;
    let secondPageNavButton = document.querySelectorAll(
      "moz-page-nav-button"
    )[0];
    document.l10n.setAttributes(
      secondPageNavButton,
      "icecatview-overview-header"
    );
    let previousText = await document.l10n.formatValue(
      "icecatview-opentabs-nav"
    );
    let translatedText = await window.content.document.l10n.formatValue(
      "icecatview-overview-header"
    );
    /**
     * This should be replaced with
     * BrowserTestUtils.waitForMutationCondition(secondPageNavButton, {characterData: true}, ...)
     * but apparently Fluent manipulation of textContent doesn't result
     * in a characterData mutation occurring.
     */
    await BrowserTestUtils.waitForCondition(() => {
      return (
        secondPageNavButton.textContent !== previousText &&
        secondPageNavButton.textContent === translatedText
      );
    }, "waiting for text content to change");

    Assert.equal(
      secondPageNavButton.getAttribute("data-l10n-id"),
      "icecatview-overview-header",
      "data-l10n-id should be updated"
    );
    Assert.notEqual(
      previousText,
      secondPageNavButton.textContent,
      "The second page-nav button text content should be updated"
    );

    Assert.equal(
      translatedText,
      secondPageNavButton.textContent,
      "The changed text should be the translated value of 'icecatview-overview-header"
    );
  });
});
