/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

add_task(async function test_removing_button_should_close_tab() {
  await withIceCatView({}, async browser => {
    let win = browser.ownerGlobal;
    let tab = browser.getTabBrowser().getTabForBrowser(browser);
    let button = win.document.getElementById("icecat-view-button");
    await win.gCustomizeMode.removeFromArea(button, "toolbar-context-menu");
    ok(!tab.isConnected, "Tab should have been removed.");
    isnot(win.gBrowser.selectedTab, tab, "A different tab should be selected.");
  });
  CustomizableUI.reset();
});

add_task(async function test_button_auto_readd() {
  await withIceCatView({}, async browser => {
    let { IceCatViewHandler } = browser.ownerGlobal;

    CustomizableUI.removeWidgetFromArea("icecat-view-button");
    ok(
      !CustomizableUI.getPlacementOfWidget("icecat-view-button"),
      "Button has no placement"
    );
    ok(!IceCatViewHandler.tab, "Shouldn't have tab reference");
    ok(!IceCatViewHandler.button, "Shouldn't have button reference");

    IceCatViewHandler.openTab();
    ok(IceCatViewHandler.tab, "Tab re-opened");
    ok(IceCatViewHandler.button, "Button re-added");
    let placement = CustomizableUI.getPlacementOfWidget("icecat-view-button");
    is(
      placement.area,
      CustomizableUI.AREA_TABSTRIP,
      "Button re-added to the tabs toolbar"
    );
    is(placement.position, 0, "Button re-added as the first toolbar element");
  });
  CustomizableUI.reset();
});

add_task(async function test_button_moved() {
  await withIceCatView({}, async browser => {
    let { IceCatViewHandler } = browser.ownerGlobal;
    CustomizableUI.addWidgetToArea(
      "icecat-view-button",
      CustomizableUI.AREA_NAVBAR,
      0
    );
    is(
      IceCatViewHandler.button.closest("toolbar").id,
      "nav-bar",
      "Button is in the navigation toolbar"
    );
  });
  await withIceCatView({}, async browser => {
    let { IceCatViewHandler } = browser.ownerGlobal;
    is(
      IceCatViewHandler.button.closest("toolbar").id,
      "nav-bar",
      "Button remains in the navigation toolbar"
    );
  });
  CustomizableUI.reset();
});
