// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package pdata // import "go.opentelemetry.io/collector/model/pdata"

import (
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// NewAttributeMapFromMap creates a Map with values from the given map[string]Value.
// Deprecated: [v0.48.0] Use pcommon.NewMapFromRaw instead.
func NewAttributeMapFromMap(rawMap map[string]pcommon.Value) pcommon.Map {
	m := pcommon.NewMap()
	for k, v := range rawMap {
		m.Insert(k, v)
	}
	return m
}
