#!/hint/bash -euE -o pipefail
# Copyright (C) 2013, 2017 Luke Shumaker <lukeshu@sbcglobal.net>
# Copyright (C) 2020 André Silva <emulatorman@hyperbola.info>
# Copyright (C) 2020 Márcio Silva <coadde@hyperbola.info>
#
# License: GNU GPLv2+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

hook_check_pkgbuild+=("check_pkgbuild_nonfree")
check_pkgbuild_nonfree() {
	local s=0
	if [ $(doas grep -qs 'permit nopass keepenv setenv { HOME='$LIBREHOME' } '$LIBREUSER /etc/doas.conf; echo $?) != 0 ]; then
		echo 'permit nopass keepenv setenv { HOME='$LIBREHOME' } '$LIBREUSER  >> "$copydir/etc/doas.conf"
	fi
	doas -u "$LIBREUSER" bash -c "DOAS_USER="$DOAS_USER" pkgbuild-check-nonfree -f || s=$?"
	sed -i '\|permit nopass keepenv setenv { HOME='$LIBREHOME' } '$LIBREUSER'|d' "$copydir/etc/doas.conf"
	pkgbuild-summarize-nonfree $s
}

#hook_check_pkgbuild+=("check_pkgbuild_namcap")
check_pkgbuild_namcap() {
	if [ $(doas grep -qs 'permit nopass keepenv setenv { HOME='$LIBREHOME' } '$LIBREUSER /etc/doas.conf; echo $?) != 0 ]; then
		echo 'permit nopass keepenv setenv { HOME='$LIBREHOME' } '$LIBREUSER  >> "$copydir/etc/doas.conf"
	fi
	doas -u "$LIBREUSER" bash -c "DOAS_USER="$DOAS_USER" namcap PKGBUILD"
	sed -i '\|permit nopass keepenv setenv { HOME='$LIBREHOME' } '$LIBREUSER'|d' "$copydir/etc/doas.conf"
}

#hook_check_pkg+=("check_pkg")
check_pkg() {
	# TODO
	:
}
