# Dave Gnukem
Dave Gnukem is a retro-style 2D scrolling platform shooter similar to, and inspired by, Duke Nukem 1 (~1991). The source code is cross-platform, free and libre. It runs on Windows, Linux, Mac OS X and more. (The original Duke Nukem 1 had 16-color EGA 320x200 graphics; the aim here is 'similar but different' gameplay and 'look and feel'. It is kind of a parody of the original. Please note it is not a 'clone', and not a 're-make'.)

**29 Nov 2022:** Version 1.0.3 released: First official stable SDL2-based version, with new 'formally maintained' Debian package files (both SDL2 support and Debian packages done by Matteo Bini)

**News Apr 2018: Version 1.0 released.** Apr 2019 OpenBSD port. (Apr 2020: Version 1.0.1 released.) (19 Nov 2022: 1.0.2 and 1.0.3 update to SDL2! Also adding OS/2 port)

**Release Downloads:** https://sourceforge.net/projects/gnukem/

**Direct Download Link:** https://sourceforge.net/projects/gnukem/files/latest/download?source=files

**Source code repository:** https://github.com/davidjoffe/dave_gnukem

**Repository for datasrc:** https://github.com/davidjoffe/gnukem_datasrc

**Repository for 'data' subfolder:** https://github.com/davidjoffe/gnukem_data

**Project page**: http://djoffe.com/gnukem/


![Dave Gnukem Screenshot](http://scorpioncity.com/dave_gnukem/gallery/Dave%20Gnukem%200.90%20%2813%20Jan%202018%29.png "Dave Gnukem Screenshot")

### Who is to blame for this?

Created by: David Joffe https://djoffe.com/ / https://www.liveedu.tv/david_joffe/ / https://minds.com/David_Joffe

The project was originally created and maintained by David Joffe (~1994 to 2004, and Oct 2016 to present). It was maintained by EMH (Evil Mr Henry http://www.emhsoft.com/) from 2004 to 2008. Additional contributions by: [T.O.G](http://www.nuke24.net/ "T.O.G."), [Vytautas Shaltenis](https://rtfb.lt/), Kent Mein, Steve Merrifield, Felix Richter, Kevin Joffe. See also 'Additional Credits' below.

As of 8 Oct 2016, this project is under 'properly' active development again, and **on 3 Apr 2018, 'version 1.0' has been released**. (Note - this game wasn't 'retro genre' when I started it - it just took so long to complete that it's now 'de facto' "retro"! - David)

### About Duke Nukem 1

Duke Nukem 1 was a famous original 16-color 320x200 'classic' game released by Apogee Software in 1991 that launched the Duke Nukem series: https://goo.gl/yP4PbS  The original Duke Nukem 1 was created by Todd Replogle (co-creator of the Duke Nukem series), John Carmack (of id Software), Scott Miller (founder of 3D Realms), Allen H. Blum III, George Broussard, and Jim Norwood.

### Help Wanted: Packages for major Linux distros, e.g. Debian, Ubuntu etc.

It would be really great if someone could create packages for all major Linux distros (perhaps dual packages, i.e. one for data, one for binary? as licenses differ a bit .. or just one?)

Dave Gnukem added to the Arch Linux AUR (Arch User Repository) 🙂 (Added May 2020 by https://github.com/caltlgin)

* https://aur.archlinux.org/packages/dave-gnukem
* https://aur.archlinux.org/packages/dave-gnukem-git (build from git master)

Spotted: openSUSE Leap packages :) (seemingly by Martin Hauke)

* https://software.opensuse.org/package/dave_gnukem
* https://opensuse.pkgs.org/15.2/games-x86_64/dave_gnukem-1.0.1-lp152.1.1.x86_64.rpm.html (the description here is perfect to me - dj)
* https://opensuse.pkgs.org/15.2/games-x86_64/dave_gnukem-data-1.0.1-lp152.1.1.noarch.rpm.html


### Notes

Note the aim of Dave Gnukem is not to be a 'clone', nor to try match DN1 gameplay precisely - the goal is to be 'similar but different', sort of a parody though not terribly funny. It's not the purpose or intention of this project to produce a 'clone', nor is it the intention to try load actual original level or sprite data into this 'engine'. The included levels have been created from scratch by users. The included sprites (apart from a few small exceptions mentioned at the bottom of this README) have been drawn by hand from scratch. The game is sort of a hat tip to the original. - David Joffe

## Gameplay Instructions

Try find the exit, while dodging or shooting monsters.

### Default Keys:

* Left/Right: Move left/right
* Ctrl: Jump
* Alt: Shoot
* Up Arrow: Action key (for e.g. opening doors, using teleporters or lifts, activating the exit, etc.)
* Escape: In-game menu

* 7/6: Increase/decrease volume
* Insert: Toggle sounds on/off
* Shift+F6/F7: Dec/Inc speed (framerate)
* Shift+F8/F9: Toggle map and sprite auto-shadows on/off, respectively
* F10 Save screenshot

To open doors, find the correct color key, and press the action key on the 'lock' nearby the door(s).

Power boots allow you to jump higher. The special molecule pickup gives you full health.

### Storyline/Plot:

The year is $CURRENTYEAR+8. An evil genius, Dr Proetton, has been hired by the CIA to infect the world's computers with a virus called SystemD, crippling them. Only you can stop him. You must find the floppy disk with the Devuan Antivirus on it, and install it on the main computer, which is hidden in Vault7.

*Any resemblance to actual persons or entities is purely coincidental*

TL;DR Shoot anything that moves

## Features

* Now with less crashes
* Game taking forever to complete, like Duke Nukem Forever
* Shootable bananas
* Integrated level editor
* Subliminal messages
* Puns
* Now with extra-retro simulated EGA/CGA settings, you'll feel like you're in the 90s again or your money back
* Evil SuperTux*
* SystemD integration
* Big rockets
* Software doesn't spy on you
* Cutting edge lighting effects you'd expect from 1990
* Family friendly
* Teleporters
* Fans that blow you ;)
* Something that sort of resembles a cannon on wheels
* Nostalgic references to technology nobody uses anymore
* Red balloons
* Arcane command-line parameters nobody will use
* Overweight hero to represent rise in obesity rates since original 1991 release
* A surprisingly bearable 18 frames per second
* A good time killer when baking
* Detects and corrects wrongthink
* Bugs older than your children
* Safe for use during pregnancy
* Floors
* Walls
* Doors
* Much much more!

\* "Evil SuperTux": Kindly note that no disrespect is intended here toward SuperTux: In this game the SuperTux's have only turned evil due to being infected by the SystemD virus. Save the world by finding the Devuan Antivirus, and they'll be cured.

# Ports

* OS/2 port by Andreas Peters (~2022/11 merge of ~2020 https://github.com/davidjoffe/dave_gnukem/pull/128)
* Debian (work in progress ~2022 - Matteo Bini; https://github.com/enigma9o7, https://github.com/bgermann; Craig Langman)
* Bodhi Linux Dec 2021 efforts: https://bodhilinux.boards.net/thread/892/packaged-dave-gnukem-silly-retro
* Open Pandora: http://repo.openpandora.org/?page=detail&app=davegnukem-magicsam - release thread: https://pyra-handheld.com/boards/threads/dave-gnukem.79533/ (by https://github.com/sviscapi and https://github.com/ptitseb)
* MorphOS [Mar 2018, by Bruno Peloille]: http://www.morphos-storage.net/?page=Games%2FShoot+2D&file=Davegnukem_1.00.lha
* Instructions for ClockworkPi GameShell: https://forum.clockworkpi.com/t/lets-play-dave-gnukem/1917 by: https://forum.clockworkpi.com/u/Oet
* OpenBSD [Apr 2019 by Dr. Brian Robert Callahan] Callahan https://twitter.com/__briancallahan https://github.com/jasperla/openbsd-wip/commit/e51e3a3b9386365cd0eb8317018463ff4682e0d3 http://cvsweb.openbsd.org/cgi-bin/cvsweb/ports/games/gnukem/
* HaikuOS (see discussion thread and instructions here https://discuss.haiku-os.org/t/gaming-on-haiku/3928/74) [22 June 2020]
* HaikuOS Instructions: (to check - confirm these instructions are right for SDL2?)

~> pkgman install libsdl2_devel

~> pkgman install sdl_mixer_devel

Then follow the same instructions as for Linux, e.g. git clone the src, cd into src folder, git clone the gnukem_data into 'data' folder, and 'make'
* Also in HaikuPorts: https://github.com/haikuports/haikuports/tree/master/games-action/dave_gnukem


# Awards and Reviews

* "a good time killer when I'm baking" - Alessia_Amelia (Jan 2019)

# FAQ (Frequently Asked Questions)

* Q: 'The scrolling is choppy' or 'framerate low'?
* A: The code can handle smoother scrolling and faster frame rates by tweaking settings and gameplay code, but is deliberately soft-limited to 18 frames per second (and the scrolling behaviour intended to mimic the original) because the original DN1 behaved close to this, and the point is to offer a nostalgic similar retro 'look and feel' (and thus also frame rate and scrolling behaviour) of the original Duke Nukem 1, which was designed to run on the much slower computers of that era (I used to play DN1 on an 80286 with 16-color EGA graphics in the '90s, and if you've ever had to code for EGA you'd also understand - dj) - so that anyone who also played the original should experience some nostalgic familiarity.

* Q: Why is the game resolution 320x200?
* A: The original Duke Nukem 1 had 320x200 16-color EGA-mode graphics ("Enhanced Graphics Adapter", an early video standard that supported 16 colors; many games of the time used 320x200). Since this game is intended as a sort of 'retro parody' it deliberately uses the same original resolution (and frame rate) in order to offer some retro nostalgic recognition and familiarity in look and feel and gameplay, especially for those who played the original. (David Joffe note: The first computer I did 'serious' programming on was an 80286 with EGA display adapter in the 1990s, and I spent quite a lot of time playing the original Duke Nukem 1 - I loved the game - and around ~1994 I started working on a very early x86 assembly language DOS/EGA version of what went on to become Dave Gnukem when in ~1995 I started this C++ version. So this wasn't a retro game when I started it - it just took so long to complete it that by the time version 1 was completed, I noticed everyone was calling it a "retro game", so it's now de facto "retro". I felt during development that if one deviates from 320x200 it feels much less like a 'retro parody of Duke Nukem 1'.) The game source code can support higher resolutions - these are controlled by config options - so the 'engine' could be used to make higher-resolution games, and with higher frame rates and smoother scrolling (with some tweaking).

* Q: What does the "Don't quit" menu option do?
* A: It does just what it says, it doesn't quit the game

* Q: Why does it say "Ordering info" in the menu?
* A: A small parody and retro recognition item, because the original shareware Duke Nukem 1 had that in the menu - but since this is open source, we add a "not" right after that is [also very 1990s](https://en.wikipedia.org/wiki/..._Not!)

# History / Changes

Recent:

2022/11/29 - Version 1.0.3 First official stable SDL2-based version, with new formally maintained Debian package files

* New improved Debian package files by Matteo Bini
* First official stable SDL2-based version with Matteo Bini's updates to SDL2
* New in-game fullscreen toggle

2022/11/19 - Version 1.0.3-dev

~2022 - Work on Debian support and Debian packaging - user contributions by Matteo Bini, https://github.com/enigma9o7, https://github.com/bgermann, Craig Langman

* [19 Nov 2022] Integrating Matteo Bini's implementation of updating the source from SDL1 to SDL2
* [19 Nov 2022] Integrating Andreas Peters OS/2 port!

Matteo Bini implemented SDL2 support (including also contributions for Debian support) https://github.com/davidjoffe/dave_gnukem/pull/135/commits/0f0022b9921982062eb7a93d2aef9a90459f3d33

2022/11/19 - Version 1.0.2 Final SDL1-based release, about to switch to SDL2

* [19 Nov 2022] Final offical SDL1-based release: https://github.com/davidjoffe/dave_gnukem/releases/tag/1.0.2 (https://github.com/davidjoffe/dave_gnukem/releases/tag/1.0.2 (final official SDL1-based source code - if an old downstream port needs to be on SDL1 for some reason we suggest using that 1.0.2 release)


2021 - User work for Bodhi Linux port: https://bodhilinux.boards.net/thread/892/packaged-dave-gnukem-silly-retro

2020/04/25 - Version 1.0.1

* [11 Jun 2019] New 'Retro Settings' menu option with 'extra retro' settings/effects for simulated EGA 16-color and CGA 4-color graphics options. You'll feel like you're back in the 90s or your money back. [NB: currently little-endian platforms only]
* [6 Jun 2019] Incorporate OpenBSD build fixes by Dr. Brian Robert Callahan https://twitter.com/__briancallahan https://github.com/jasperla/openbsd-wip/commit/e51e3a3b9386365cd0eb8317018463ff4682e0d3 http://cvsweb.openbsd.org/cgi-bin/cvsweb/ports/games/gnukem/
* [10 Apr 2018] Tentative fix for XP and ReactOS support (relating to SetProcessDPIAware stuff)
* [4 Apr 2018] Got it running on TrueOS (use make -f Makefile.bsd)

**2018/04/03 - Version 1.0**

* [3 Apr 2018] Change it so that you must first turn cheat/debugging stuff (Ctrl+Shift+G) on before using F4 or F5 for sprite/level editor
* [1 Apr 2018] Add Shift+F10 to start/stop auto-save screenshot-per-frame sequence (warning, eats disk space very fast)

2018/03/31 - Version 0.96

* [30 Mar 2018] Change volume control keys from PgUp/PgDn to 7/6 (as PgUp/PgDn conflict on some keyboards, e.g. Pandora, and also some laptops don't have 'actual' PgUp/PgDn etc.)
* [30 Mar 2018] Add 'About' page to main menu
* [30 Mar 2018] Add new F10 save screenshot function (saves on Windows under \Users\USERNAME\AppData\Roaming\DaveGnukem\screenshots and on Linux under $HOME/.gnukem/screenshots)
* [26 Mar 2018] Bugfixes and level improvements (also fixed a level bug where one of the levels was impossible to complete)
* [22 Mar 2018] Boot sprite; Improve Dr Proetton (Dr Proton) sprite and behavior
* [20 Mar 2018] Fix overly-large window if Windows DPI scaling settings are enabled (unfortunately the fix breaks Windows XP support - but you can enable djWINXP_SUPPORT in config.h if you want to generate a build that supports Windows XP)

2018/03/11 - Version 0.91

* [11 Mar 2018] Create a Windows installer
* [22 Jan 2018] Add 'easter egg' [arin_j stream viewer suggestion]
* [22 Jan 2018] Level editor highlights instances of selected sprite (yellow), and sprite selection mouse-over sprite (cyan) (F3 toggles this ON/OFF if/when it gets annoying)
* [13 Jan 2018] New slightly experimental map auto-shadows and sprite auto-drop-shadows
* [13 Jan 2018] New shortcut keys Shift+F8/F9: Toggle map and sprite auto-shadows on/off, respectively
* Overhauled shooting/bullets code
* Level Editor: New "Ctrl+F7" command shows overview of all levels, and some basic stats on 'important' gameplay items
* Ctrl+Shift+W Large gameplay viewport mode (currently classified as a 'cheat')
* All cheat keys (and debug/testing keys like H to inflict self-damage) must now first be enabled by pressing Ctrl+Shift+G to enable in-game debugging stuff
* New cheat Backspace+PgUp increases firepower by one (added for testing)
* Numerous bugfixes and gameplay tweaks

2017/08/12 - Version 0.81 [Linux/Mac source release, Windows source and binary]:

* Add water
* Add very basic Dr Proetton ('final boss') and basic foundations of game ending sequence when you beat Dr Proetton
* Add jump-monster
* Add rockets
* Level Editor: New "Ctrl+Alt+N" command to generate a new blank level (NB: Still needs to be added manually to default.gam!)
* Fix a couple of bugs relating to jump height and powerboots

2017/08/05 - Version 0.72 [Linux/Mac source release, Windows source and binary]:

* Add new 'sort of looks like a cannon on wheels' monster type
* Implemented new inventory pickup item 'antivirus disk' and corresponding 'main computer' (when we insert "AV" (anti-virus) disk into main computer we save the world) (should only be one of each of these, and in last level of a 'mission')
* Add new high-voltage "barrier" that must be shot multiple times to destroy before hero can pass through (touching it results in immediate death)
* Add new monster that constitutes the approximate equivalent of DN1 rabbits (for now, or maybe permanently, this is just a sort of 'evil Tux' - not sure yet if placeholder sprite, or part of plot)
* Add new floor type that auto-crumbles after hero walks or jumps twice on it (2nd spriteset, position 5x4 - place only 1 block per segment)
* Re-do instructions screens to display storyline/plot
* Basic more proper/correct implementation of the CAcme falling blocks
* Fixed: Bullets go through doors

2017/06/22 - Version 0.71 [Linux/Mac source, binary Windows only]:

* Add new 'flying robot' monster type
* Implemented access card and access card 'door' and door activator
* Added special molecule pickup that gives you full health
* Level Editor: Add unsaved-changes indication
* Level Editor: Add level statistics page (Ctrl+F6)
* Improve character control: Make vertical jumping/falling movement a bit smoother (more similar to the original DN1)
* Improve viewport vertical auto-scrolling
* New keyboard shortcuts: Shift+F6/F7: Dec/Inc speed (framerate)
* Fix soda can not animating

2017/06/22 - Version 0.70 [Linux/Mac source, binary Windows only]

* Add new basic 'Instructions' option to in-game menu
* Fix: Potential game 'freeze' in teleporter if exiting level editor (or holding in action key)
* Added "-scale N" command line option (1 = 320x200, 2=640x400, etc.) (if passed, this overrides the default behavior of attempting to "intelligently" select the scale factor based on e.g. desktop resolution etc.)
* Fix: "Key polling behavior is subtly incorrect" (this should slightly improve the character control, especially if trying to move left/right one block only)
* Minor sprite and level improvements
* Add hero jump/landing sounds (credit for the sounds: Juhani Junkala), key pick-up sound, and more
* Increase gameplay viewport width from 12 to 13 blocks

2016/10/29 - Version 0.66 [Linux/Mac source, binary Windows only]

* Add shortcut key to toggle sounds on/off (Insert)
* Fix: On Windows, game window often starts slightly off bottom of screen
* Fix: Restore Game from main menu doesn't work
* Fix: Save/Restore game doesn't save "mission" (i.e. selected "game")
* New proper exit sound (is "PowerUp13.mp3" by Eric Matyas http://soundimage.org/)
* Fixed: A monster could kill you in the moments after you entered the exit
* Better hero shooting sound

2016/10/22 - Version 0.63 / 0.64 / 0.65

* Add background music. So far, have only added music by Eric Matyas http://soundimage.org/
* Add game volume controls (use 7 and 6 keys to increase/decrease volume from menus or in-game)
* Level Editor: New feature: Hold in Ctrl+Alt and click with the mouse to automatically start level with hero 'dropped in' to the clicked position as starting position (to help with level editing / testing)

2016/10/16 - Version 0.62

* Get Dave Gnukem compiling and running on Mac OS X: https://www.livecoding.tv/david_joffe/videos/jbBvb-dave-gnukem-c-game-side-scrolling-shooter-9
* Miscellaneous minor aesthetic improvements

2016/10/10 - Version 0.61

* Fix: "Dying in the pungee sticks will often cause a crash" (thank you to porter who pointed that out)
* Fix a segfault in Linux (possibly VNC only?) when navigating in-game menus and other sub-menus
* Add semi-experimental 'big viewport mode' (Backspace + B in game to toggle) to make level creation/testing easier for level editors

2016/10/09 - Version 0.6 (0.60)

* Use last EMH release; create github project https://github.com/davidjoffe/dave_gnukem
* Fixed 'tiny game window'
* Fix some Linux compile issues, make a few other fixes/improvements (streamed on LiveCoding), call it v0.6 ('un-abandoning' project - DJ)

1994 - 2016 - See HISTORY.txt for 1994 - 2016 history

1994/02/22 [david]
 - Crude origins as a 16-bit x86 assembler implementation

# Developer Info / Build Info

**Dependencies: LibSDL2, LibSDL-Mixer 2**

## Windows Build Instructions

* Visual Studio 2010 project is included.
* **NB** You must set your Visual Studio 'Working Directory' to ../../ in order to run this (under Project / Properties / Configure Properties / Debugging) or it won't find the data files and just immediately exit on run
* If you get an error about not finding SDL DLL(s) when running, set 'Project / Properties / Configure Properties / Environment' to: PATH=c:\your\path\to\DLLs;%PATH%

## Linux Build Instructions

Either download the source code archive, or get the latest source code with git. Make sure the 'data' subfolder is also present.

The latest source code and data archives can be downloaded here (these should generally be stable and the best option to download):

https://github.com/davidjoffe/dave_gnukem/archive/master.zip
https://github.com/davidjoffe/gnukem_data/archive/master.zip (after extracting, rename this folder to just 'data' as that's what the game looks for)

GETTING THE LATEST SOURCE AND DATA FOLDER USING GIT:

To get the latest source with git, you need two repos, the source code, and the data, which must be exactly cloned into 'data' under the main folder:

$ git clone https://github.com/davidjoffe/dave_gnukem.git gnukem

$ cd gnukem

$ git clone https://github.com/davidjoffe/gnukem_data.git data

$ cd ..

BUILDING:

Type 'make'
(BSD variants: Try 'make -f Makefile.bsd' rather.)

Run with ./davegnukem if it built correctly (NB, it must find the 'data' folder)

NB: FIRST INSTALL DEPENDENCIES:

How to install dependencies on Debian, Ubuntu etc.:

$ sudo apt-get install libsdl2-dev

$ sudo apt-get install libsdl2-mixer-dev

(NOTE: If you don't have libsdl-mixer1.2 for whatever reason and you just want to get it compiling without sound, you can add -DNOSOUND to the CCFLAGS in the Makefile, and remove -lSDL_mixer from the Makefile LIBS setting.)

## SDL1.2 or SDL2?

On 19 November 2022 we made an official change from LibSDL1.2 (now very old) to LibSDL2 (thanks to Matteo Bini for that).

https://github.com/davidjoffe/dave_gnukem/releases/tag/1.0.2 (final official SDL1-based source code - if an old downstream port needs to be on SDL1 for some reason we suggest using that 1.0.2 release)

So for builds prior to this, the dependencies would be e.g. along the lines "sudo apt-get install libsdl1.2-dev" and "libsdl-mixer1.2-dev".

Henceforth, it should be e.g.: libsdl2-dev, libsdl2-mixer-dev

SDL2 brings various potential advantages.



## Mac OS X Build Instructions

Same as Linux - type 'make'. Run with ./davegnukem if it built correctly (and data subfolder present)

Installing Dependencies:

If using macports, you should be able to just do:

% sudo port install libsdl2

% sudo port install libsdl2_mixer

Then as with Linux, type 'make' and run with "./davegnukem" if it built correctly (and data subfolder present)

(Alternatively, you could install LibSDL2 and LibSDL-Mixer2 by downloading the source code and doing 'make' and 'make install' (as root) for each of these first).


## Windows Installer Build Instructions

To build a Windows installer, use Inno Setup 5.

Note: As of Apr 2020 it is still recommended to use the older 'version 5' of Inno Setup (and not versions 6 or higher) as Inno Setup version 6 appears to have dropped support for Windows XP, which we still support (this also indirectly allows ReactOS support)

The basic process of building a Windows installer is as follows (this process is still a little crude/unrefined and may require a bit of hackery if you're trying to do this):

* Build the source code so you have the game's .exe (updating version number and date in main.cpp if/as desired to change it)
* Set up a local folder, e.g. c:\src\gnukem\src\installer\ApplicationFolder\ which is basically a mirror of what the installed "\Program Files\Dave Gnukem" is going to look like, containing the data subfolder, .exe, DLLs, license files, README.md etc. Remember to codesign the exe and DLLs if you can.
* Open c:\src\gnukem\src\installer\gnukem.iss in Inno Setup
* Make any changes to reflect your own local build differences, e.g. if you're using a different folder location to the default c:\src\gnukem
* Update the version number
* Compile it in Inno Setup. It will generate something like Dave_Gnukem_Setup.exe ... rename to add the version number
* Code-sign the generated Setup .exe
* Test the generated Setup .exe


# Level Editor Instructions

(New 1 Jul 2017) Level Editor how-to video: https://youtu.be/xiznDqg2BHg

Note there is currently no 'undo', so be careful. If happy with a set of work, save your changes.

NB: All in-game cheat/debugging keys (eg level up) must first be turned on by pressing Ctrl+Shift+G

* NB: As of Apr 2018, you must first turn cheat/debugging stuff (Ctrl+Shift+G) on before using F4 or F5 for sprite/level editor
* F5 from within the game invokes the level editor
* F1: Save current changes (NB: there is currently no 'unsaved changes' warning, so remember to save your changes, if desired)
* Escape: Exit level editor and start playing current level
* Hold in Ctrl+Alt and click with the mouse to drop in hero and start playing/testing level at the clicked position
* X: Toggle display/editing of 'foreground layer' (there are two 'layers', the background layer primarily for solid stuff, e.g. walls, and the foreground layer generally for e.g. objects or monsters, or other semi-transparent objects)
* Z: Toggle display/editing of 'background layer'
* M,N: Previous/Next spriteset. There is a left-click and right-click "sprite palette"; clicking the left or right mouse button in the map preview area places an object from the left-click or right-click palette, respectively. Click in the spriteset with the left or mouse button to select that sprite object to either the left or right-click "sprite palette".
* To select the hero start position in the map, select and place either the 2nd-last or 3rd-last object in the first spriteset (it looks like a figure with a left or right arrow, which indicates the start direction). There should only be one of these per level.
* To place the exit position in the map, select and place the last object in the first spritset. There should only be one of these per level.
* 1-9: Macros: Float the mouse cursor in the map preview area and press one of these shortcuts to place from a few pre-defined complex objects, e.g. crates.
* F: Do a 'horizontal fill' of the current selected sprite (on the current layer)
* To choose the desired level, use the Up+L 'cheat' from within the game
* To choose the desired 'game' i.e. 'mission' (i.e. set of levels), use the main game menu 'Select mission'
* Ctrl+F6: Show level sprite instance statistics
* Ctrl+F7: Show overview of all levels, with some basic stats on 'important' gameplay items

Game Cheats Useful for Testing:

* Up+L - Next level
* Backspace+P - Get Powerboots
* Backspace+G - 'God Mode'
* Backspace+PgDn - Get all keys, access card, antivirus disk, and full firepower
* H - Damage Health

Note that for active animated objects that consist in the spriteset of multiple sprites (e.g. each conveyor belt piece has 4 sprites, for its animation), you *must* place the *first* of the four in the map for the object to work correctly.

Keep in mind that once the hero has the powerboots, he'll be able to jump higher. So there is a sort of logical progression if you place powerboots in a level, i.e. they should be placed once per 'mission' (i.e. set of levels), and levels prior to that should assume the default lower jump height, levels after that point might possibly assume the higher jump height.

To add a new 'mission' (i.e. set of levels), edit the missions.txt file and add a new line containing the name of your .gam file, e.g. "mygame/mygame.gam" (without quotes). (You should try keep all files associated with a particular game/mission in its own subfolder.) To add/remove levels for that game/mission, edit the .gam file (see the included .gam files to see the format).


# TODOs (To Sort - many done now):

* It would be really great to have packages for e.g. Debian, Ubuntu etc. (possibly two packages? one for the binary, one for the data)
* Videos?
* Check through code for possible buffer over-runs?
* 'Texture Manager':
	* Clean up of 'textures'
	* Actual hardware accel if available [todo: proper blending]
	* Restoring hardware surfaces on toggle fullscreen with DirectX (is this no longer an issue now we're on SDL? or still something one must do with SDL?) (low)
* Explosion sound doesn't always play (fixed 2016-10-22 but fix could use more testing, cf. channel -1 story)
* DEV
	* Update TargetName to DaveGnukem in VS2010
	* Set up working folders to work 'out the box', so to speak
	* Add a dev readme.txt to help devs get set up

* [med] Level Editor is hogging CPU [check sprite editor, does it also?]
* Check for all possible hardcoded keys that may be interfering with redefined keys (e.g. Ctrl, H, backspace+G etc.)
* Some better graphics
* Signed executables in binary release?
* [check] Dying seems to reset score to 0 - is that right? Cf. DN1 behavior
* Is the -640 flag now basically obsolete? Remove? Or change to do something else useful? E.g. to make window maximum size e.g. same as monitor could be useful for level editing.

## Sprite TODOs:

* Some of the background brick colors should be a bit darker
* Some smoothing on some of hard pixely 'lines' (e.g. on shadow edges)
* Un-EGA-ish sprites that still look a bit too EGA-ish (some of the especially ones look a bit too 16-color-ish perhaps, though the original DN1 was 16 colors)
* Red background pipes look a bit .. I dunno what .. chromatic? Maybe desaturate slightly .. or something



# Notes

The name is a pun on 'Duke Nukem' and 'Gnu' as a sort of 'hat-tip'/reference to the free software license/model.

The game took forever to complete to mimic the Duke Nukem Forever model of taking forever to be released.

The underlying 'engine' supports high frame rates and smooth scrolling etc.; the reason the frame rate is artificially capped to 18fps is that the earliest versions (~1994/1995-ish) were written for 16-bit 8086/80286, which used hardware timer interrupts that ran at around 18Hz. (Though it's possible to uncap the frame-rate, the CThing's are unfortunately currently hardcoded for 18Hz, so they just run silly-fast if one uncaps the frame rate ... if writing a new game or a 'version 2' it should be easy to use a higher frame rate and write new CThing's movement code to be based on time-passed-since-last-frame or some-such. Likewise the blocky viewport scrolling itself should be easy to replace with smooth viewport-scrolling.)

# License and Additional Credits

The source code itself (and most of the data/sprites) for Dave Gnukem are dual-licensed under MIT license or GPL.

With respect to particular **data items**, the following license conditions apply:

* 2018-03-22 Add boots sprite made by freepik.com, from flaticon.com, license Creative Commons BY 3.0
* 2017-08-04 Add font data/fonts/simple_6x8.tga by http://www.zingot.com/ from https://opengameart.org/content/bitmap-font-pack License https://creativecommons.org/licenses/by/3.0/ (small changes made to color, and convert from PNG to TGA)
* 2016-10-30 data/sounds/soft_explode.wav From same Juhani Junkala collection as per below
* 2016-10-30 data/sounds/key_pickup.wav http://opengameart.org/content/key-pickup author Vinrax, license 'CC BY 3.0' https://creativecommons.org/licenses/by/3.0/
* 2016-10-30 data/sounds/jump.wav and data/sounds/jump_landing.wav From same Juhani Junkala collection as per below
* 2016-10-23 data/sounds/shoot\_cg1_modified.wav Slightly modified version of cg1.wav from http://opengameart.org/content/chaingun-pistol-rifle-shotgun-shots by Michel Baradari http://michel-baradari.de/
	"Sounds (c) by Michel Baradari apollo-music.de
	Licensed under CC BY 3.0 http://creativecommons.org/licenses/by/3.0/
	Hosted on opengameart.org"
* 2016-10-23 data/sounds/sfx\_weapon_singleshot7.wav by Juhani Junkala (CC0 creative commons license) ("The Essential Retro Video Game Sound Effects Collection [512 sounds]")
* 2016-10 Thanks to daveywavey @ livecoding https://www.livecoding.tv/daveywavey/ for help with setting up github repo

Apart from the abovementioned, all other data included with 'version 1' is dual-licensed under MIT license or GPL.

Additional game data credits: Apart from the abovementioned, most the sprites were done by David Joffe (with some major contributions by Evil Mr Henry http://www.emhsoft.com/ including the main character sprites). Steve Merrifield made major level editing contributions. Apologies if anyone left out.

# Additional Development Credits

* ~2022 Matteo Bini entirely developed and contributed updates of the code from SDL1 to SDL2 (~2022 merging in progress) https://github.com/davidjoffe/dave_gnukem/pull/135

* ~2021/2022- [Ongoing] Some valuable contributions for Debian support (work in progress, see https://github.com/davidjoffe/dave_gnukem/pull/131 discussion) - amongst others:
	Matteo Bini
	https://github.com/enigma9o7
	https://github.com/bgermann
	Craig Langman
