# GNU Typist - improved typing tutor program for UNIX systems
# Copyright (C) 2011 GNU Typist Development Team
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series C
#------------------------------------------------------------------------------
G:_C_MENU
*:_C_NO_MENU

#------------------------------------------------------------------------------
# Lesson C1
#------------------------------------------------------------------------------
*:C1
*:_C_S_C1
B:                             Lesson C1

T:			Welcome to the Colemak Course
 :
 :This course is intended for beginners as well as experienced typists.  The
 :Colemak keyboard is an alternative to the QWERTY (Sholes) keyboard layout.
 :You will find it easier to learn than the QWERTY and Dvorak keyboard layouts.
 :
 :Like the Dvorak keyboard, this is because the Colemak keyboard layout has been
 :scientifically designed to minimise cumulative finger motion while typing
 :English.  The ten letters on the home row (A, R, S, T, D, H, N, E, I, and O)
 :make up about 70% of all keystrokes.  These ten letters alone can form over
 :3000 words.  Needless to say, having these keys in the home row facilitates
 :both speed and accuracy.
 :
 :Unlike the Dvorak keyboard layout, however, the Colemak keyboard layout has
 :also specifically been designed to be easy to learn for people who are already
 :familiar with using a QWERTY keyboard layout.  Despite this, it appears that
 :the Colemak keyboard is as fast as, if not faster than, the Dvorak keyboard.
 :
 :For information about the Colemak keyboard layout, see <http://colemak.com/>.

T:			General Instructions
 :
 :The fingers of the left hand should be placed over the A-key, the R-key,
 :the S-key, and the T-key.  Similarly, the fingers of the right hand should be
 :placed over the N-key, the E-key, the I-key, and the O-key.  This is called the
 :HOME position.  Only these fingers should be used to press the keys that they
 :are above.
 :
 :In addition to these keys, the SPACE bar should be pressed with the thumb of
 :the right hand.  At the end of every line, the RETURN key should be pressed
 :with the fourth finger of the right hand.

I:(1) S, T, N and E
*:_C_R_C1_1
D:sets tens ten tnt sestet tenet seen nene testee tenets essen sent senses
 :tenses teens stent sense tent nets tenseness net tense nests tennessee

I:(2)
*:_C_R_C1_2
D:teen nest tents net tens teen tenets senses nests nest nets tenet sent sense
 :tenses tennessee essen tnt tent teens tense nene stent seen

G:_C_E_C1

#------------------------------------------------------------------------------
# Lesson C2
#------------------------------------------------------------------------------
*:C2
*:_C_S_C2
B:                             Lesson C2

I:(1) R and I
*:_C_R_C2_1
D:trite stress sire it entire terse tit sir tire sinner retire rinse inn tree
 :insist tier rite teeter resin stir siren enter

I:(2)
*:_C_R_C2_2
D:sitter insert site sneer intern tie inner series steer tin riser its resent
 :sin rise rent rein iris stern in titter resist

I:(3)
*:_C_R_C2_3
D:eerie inert street is renter sit nine risen sister serene stint err snit
 :intent entree nit inter rest tennis re tint

G:_C_E_C2

#------------------------------------------------------------------------------
# Lesson C3
#------------------------------------------------------------------------------
*:C3
*:_C_S_C3
B:                             Lesson C3

I:(1) A and O
*:_C_R_C3_1
D:retain roe rant ratio toast sort stat tore earn noose teat eater oat trio tear
 :tone artist nor tattoo seat arise noise start toss tenant oasis

I:(2)
*:_C_R_C3_2
D:one aria no arson sonata soon rear to ass soot irate sane onset star root
 :state oar errant resort tartan sonnet notes eat rotten stain ration

I:(3)
*:_C_R_C3_3
D:arose reason noon sass retina iota torn stairs iron estate toe are season not
 :attire tenor innate torso tease arisen note tar snort tarot

G:_C_E_C3

#------------------------------------------------------------------------------
# Lesson C4
#------------------------------------------------------------------------------
*:C4
*:_C_S_C4
B:                             Lesson C4

T:			General Instructions
 :
 :When you need to press the D-key or the H-key, the first finger of the left or
 :right hand, respectively, should be used.  No other finger should be used.

I:(1) D and H
*:_C_R_C4_1
D:odds the hard tooth tide ether raid other rend hire dress has noted ash aide
 :ha rider hiss soda ninth aside ahead hate toad shirt shed dare hid

I:(2)
*:_C_R_C4_2
D:this dose horde ashen road shot shod idea hear hand read rash darts those
 :stand three stood shorn trend hint dote short darn ah staid her node had

I:(3)
*:_C_R_C4_3
D:heard horn third add these hot ode hers does heart hated did rhino sash door
 :teeth rid here sod hoe nerd head hose drier trash tread host date hat

G:_C_E_C4

#------------------------------------------------------------------------------
# Lesson C5
#------------------------------------------------------------------------------
*:C5
*:_C_S_C5
B:                             Lesson C5

I:(1) HOME row exercises
*:_C_R_C5_1
D:his hat is an aid in the hot heat
 :in his sad sod rest he sat on his hen

I:(2)
*:_C_R_C5_2
D:ron did not don his hoe and tin hat
 :dan did not see the dot on his tie as he hid his tan hat

I:(3)
*:_C_R_C5_3
D:i do as i do and the end is not as sad as the one sid had

I:(4)
*:_C_R_C5_4
D:add ado ads aha aid air and ani ant are art ash ass ate dad den
 :did die din dis doe don dos dot ear eat end eon era ere err eta
 :had hah has hat hen her hes hid hie his hit hod hoe hos hot ids

I:(5)
*:_C_R_C5_5
D:inn ins ion ire its net nit nod non nor not nth oar oat odd ode
 :oho ohs one ore ran rat red rho rid rod roe rot sad sat sea see
 :set she sin sir sis sit sod son sot tad tan tar tat tea tee ten
 :the tho tie tin tit toe ton too tor tot

I:(6)
*:_C_R_C5_6
D:adds aeon ahas aide aids airs ands anon ante anti ants area ares
 :dint dire dirt dish diss dodo doer does done dons door dose dote
 :hair hand hard hare hart hash hate hath hats head hear heat heed
 :inti into ions iota ired ires iris iron near neat need neon nerd

I:(7)
*:_C_R_C5_7
D:rash rate rats read rear redo reds reed rein rend rent rest rhea
 :sate sear seas seat seed seen seer sees send sent sera sere sets
 :soot sore sort sots star stir tads tans tare taro tars tart tats
 :toad toed toes tone tons toot tore torn tors tort toss tost

G:_C_E_C5

#------------------------------------------------------------------------------
# Lesson C6
#------------------------------------------------------------------------------
*:C6
*:_C_S_C6
B:                             Lesson C6

T:			General Instructions
 :
 :The P-key and the L-key should be pressed only by the first finger of the left
 :or right hand.

I:(1) P and L
*:_C_R_C6_1
D:toil dip lithe peer oiled spite less phase sold oops spiel slid patio slat
 :nope slit poet spelt leper hall plaid snoop spill

I:(2)
*:_C_R_C6_2
D:padre paint dial pin land splat plop pale lead lip pail pond lope else pan
 :peal stilt shop plot steal pain spool load peter solid

I:(3)
*:_C_R_C6_3
D:pilot sleep pep lone ale spend lilt past spit lots steep pool ideal pal snipe
 :slope apple old petal polar let paste slip heist

G:_C_E_C6

#------------------------------------------------------------------------------
# Lesson C7
#------------------------------------------------------------------------------
*:C7
*:_C_S_C7
B:                             Lesson C7

T:			General Instructions
 :
 :The F-key and the U-key should be pressed only by the second finger of the left
 :or right hand.

I:(1) F and U
*:_C_R_C7_1
D:urn file hound flora pupil feast upper fade spud fern spurn froth huh foal
 :dune sniff rerun furor tune fresh hush shaft lure left fuss usher

I:(2)
*:_C_R_C7_2
D:thief surf taut fold found sour fire stunt elf letup fell tout fun tuft puff
 :us foe run fatal flout usurp flap ford four sinus fated dual roof

I:(3)
*:_C_R_C7_3
D:proud final fur utter fool round furl flare rude flute self hut stiff foul
 :unit fraud pulp flood route feed pause fund fetid hurl tofu fear

G:_C_E_C7

#------------------------------------------------------------------------------
# Lesson C8
#------------------------------------------------------------------------------
*:C8
*:_C_S_C8
B:                             Lesson C8

T:			General Instructions
 :
 :The W-key and the Y-key should be pressed only by the third finger of the left
 :or right hand.

I:(1) W and Y
*:_C_R_C8_1
D:wasp way delay hewn fury twit newsy yet whir ray water hurry dawn holly widen
 :penny widow raspy yawn lily downy dwell

I:(2)
*:_C_R_C8_2
D:wiry sissy warp snowy furry swift windy hefty wish filly sweat hype sway prawn
 :day fowl noisy wail surly rowdy wily

I:(3)
*:_C_R_C8_3
D:sweet lowly synod went posy strew your swine yap whoa paddy weep artsy aware
 :stray wade style woof sunny stow pray

I:(4)
*:_C_R_C8_4
D:wife days frown wispy ply howl phony awe hyena endow handy whet yeast stew
 :type word dandy show duly weird tasty newly

G:_C_E_C8

#------------------------------------------------------------------------------
# Lesson C9
#------------------------------------------------------------------------------
*:C9
*:_C_S_C9
B:                             Lesson C9

T:			General Instructions
 :
 :The G-key and the J-key should be pressed only by the first finger of the left
 :or right hand.

I:(1) G and J
*:_C_R_C9_1
D:jaw gel jut gape jury night juror giant jade gut jug jaunt gofer jeer gash
 :just hog jot leg jog jet fight jilt guilt joy ghoul

I:(2)
*:_C_R_C9_2
D:jewel slog jeans gal jig jail dough jar pang jelly rang jowls gag jaws jiffy
 :deign junta go jetty grass jaded fang joint gull

I:(3)
*:_C_R_C9_3
D:ajar dig jest gaffe fjord along join glass jolt groan jolly sting jeans green
 :jiffy golly jot fig jilt sag jetty gruff jail

I:(4)
*:_C_R_C9_4
D:sung jaw gushy jeer gala just age jig jaded glee jut tongs jar god jet grate
 :jade genre sharp jelly tangy proof ajar pager

G:_C_E_C9

#------------------------------------------------------------------------------
# Lesson C10
#------------------------------------------------------------------------------
*:C10
*:_C_S_C10
B:                             Lesson C10

T:			General Instructions
 :
 :The M-key and the V-key should be pressed only by the first finger of the left
 :or right hand.

I:(1) M and V
*:_C_R_C10_1
D:envy mount vivid made motor navel moose lever madly levy muddy dive trump
 :raven harem vain nomad view month hover lemon naval imply valet

I:(2)
*:_C_R_C10_2
D:gnome oven mean move grove swim vote swamp levee germ vat melee novel frame
 :eve humid vile swarm verge med five limp haven ramp vet mitt

I:(3)
*:_C_R_C10_3
D:seven maple mover venom lava yum drive moat wove swam savor maim given dove
 :dome ivory stomp very tumor sever sham avert loom vigor moldy

I:(4)
*:_C_R_C10_4
D:movie voter foam vast media devil metal grave muggy jar salve madam jot vie
 :just saver dream jet foil vow him jumpy aloof shave

G:_C_E_C10

#------------------------------------------------------------------------------
# Lesson C11
#------------------------------------------------------------------------------
*:C11
*:_C_S_C11
B:                             Lesson C11

T:			General Instructions
 :
 :The B-key and the K-key should be pressed only by the first finger of the left
 :or right hand.

I:(1) B and K
*:_C_R_C11_1
D:make lamb disk boob smoke skim abort kin blush dorky buns fake snub pike fable
 :geeky beam eke brown waken butt nook bed oak buddy biker

I:(2)
*:_C_R_C11_2
D:stake bide dusk been risk belly joke bolt baker skull bore peek buyer awoke
 :bliss looks babe kiddo sheik debut sky web frisk brief mark

I:(3)
*:_C_R_C11_3
D:adobe woke jamb bike brisk nuke bulge kiss boa shook bayou okra tuba flask
 :maybe desk brash week bongo flake jab murky bogus duke rehab

I:(4)
*:_C_R_C11_4
D:stoke about trike birth maker book bird king ivory bond kiwi veto bill wok
 :vine point boost just jerky naive promo baggy speak stave tribe

G:_C_E_C11

#------------------------------------------------------------------------------
# Lesson C12
#------------------------------------------------------------------------------
*:C12
*:_C_S_C12
B:                             Lesson C12

T:			General Instructions
 :
 :The Q-key should be pressed only by fourth finger on the left hand.  The C-key
 :should only be pressed by the second finger on the left hand.

I:(1) Q and C
*:_C_R_C12_1
D:circa quote quip cult quail craft quiet cute quash pubic quilt cheap quirk
 :rice squad colt quay cleft quite music quit croon quits

I:(2)
*:_C_R_C12_2
D:cab equal curl quick quake manic quad reach quark chord quart pace quill sack
 :equip track squid sick quack squat poach quota eject

I:(3)
*:_C_R_C12_3
D:quark speck quail space quip chop quad comic quill squid clef quake close
 :quota color quash care quick squad each quart pouch

I:(4)
*:_C_R_C12_4
D:quack equip twice quite black quilt thick quirk sic quits curly quiet coach
 :quit quote gloss valor champ squat wares joy gasp vat

I:(5)
*:_C_R_C12_5
D:cross equal mown jest night vote coast quay tweak juicy lingo fit visa quilt
 :sob threw jar grit info valet clamp quits limbo

G:_C_E_C12

#------------------------------------------------------------------------------
# Lesson C13
#------------------------------------------------------------------------------
*:C13
*:_C_S_C13
B:                             Lesson C13

T:			General Instructions
 :
 :The Z-key and X-key should be pressed by fourth and third fingers on the left
 :hand, respectively.

I:(1) Z and X
*:_C_R_C13_1
D:exec fuzz boxer buxom glitz exam zeal toxic jeez lax hertz extol prize text
 :ozone pixie size pixel booze ex zoom crux gauze fax woozy ax tizzy flux

I:(2)
*:_C_R_C13_2
D:jinx zit oxide froze axle ooze extra dozen exit bozo waxy quiz tax ritzy ox
 :fizz index axes zinc apex zip exist buzz expo oxen fez tux dizzy proxy

I:(3)
*:_C_R_C13_3
D:detox zebra next doze max waltz affix zest sixty zone exact zoo excel frizz
 :fox sex blitz mixer gizmo foxy seize mix unzip flex fizzy six fixed

I:(4)
*:_C_R_C13_4
D:jerk valve whiz relax work equal fuzzy exert quark hoard evil mixed jolly
 :shook twang dove quota zero annex jibe key ranch regal wavy quick cozy

G:_C_E_C13

#------------------------------------------------------------------------------
# Lesson C14
#------------------------------------------------------------------------------
*:C14
*:_C_S_C14
B:                            Lesson C14

T:			Learning the SHIFT key
 :
 :To integrate the shift key rhythmically in your practice, a capital letter
 :should take three beats:
 :  1. press the shift key opposite the hand to press the letter key
 :  2. press the letter
 :  3. release the shift key

I:(1)
*:_C_R_C14_1
D:Ada Anne Ana Ann Dad Dan Don Ed Eta Rita
 :Dan Nan Nat Ned Sid Sire Tad Ted Tod Rene

I:(2)
*:_C_R_C14_2
D:The sad tot sat on a tan seat in his neat tent
 :He ate ten stones

I:(3)
*:_C_R_C14_3
D:On his date Otis has a thin suit
 :There is no tint on his shoes

I:(4)
*:_C_R_C14_4
D:Enos eats a thin hash diet in a dish as he sits on an odd seat
 :Dad does not eat desert
 :He had seen Ted dent his auto

I:(5)
*:_C_R_C14_5
D:Adna Anna Anne Dana Dead Edie Edna Enid Etta Heda
 :Nate Nina Neta Nona Odie Ohio Otto Stan Tess Thad Theo

G:_C_E_C14

#------------------------------------------------------------------------------
# Lesson C15
#------------------------------------------------------------------------------
*:C15
*:_C_S_C15
B:                            Lesson C15

T:			Learning punctuation
 :
 :The period/full stop is below the forth finger on the right hand.  Note that
 :the end of a sentence should be followed by two spaces; in abbreviations, it is
 :followed by one space.
 :
 :The comma is below the third finger on the right hand.
 :
 :The fourth finger of the right hand and the left SHIFT key should be used to
 :type a question point/mark.

I:(1)
*:_C_R_C15_1
D:e.  e.  e.  e.  a.  s.  o.  n.  e.  t.  r.  h.  i.  d.  a.  a.
 :h.  r.  a.  i.  o.  n.  s.  d.  t.  e.  h.  o.  r.  i.  s.  a.

I:(2)
*:_C_R_C15_2
D:Adana.  Andie.  Annie.  Aonia.  Ardie.  Denis.  Diana.  Dinah.

I:(3)
*:_C_R_C15_3
D:On the horse, Adana dined in haste on toast and dates.
 :Sated, as she had eaten she noted the sheen on the drones
 :and the shade in the sheds.  She hates to see an idiot
 :stand and shoot his tenth doe in the dense heath.

I:(4)
*:_C_R_C15_4
D:An onion heats, stunned, a stout nose.  As does she?  As do I?
 :Do I send hands to douse teeth?  Are their suedes hoisted ahead?

I:(5)
*:_C_R_C15_5
D:The shy ape put on a red hat and ran off with the lot.  Can pa
 :go aft and lie on our old cot?  For a top fee, her act is to hop
 :in, lie on the rug, pat her pet cat, fit a fur on her ear, get
 :her fan, and run off.

G:_C_E_C15

#------------------------------------------------------------------------------
# Lesson C16
#------------------------------------------------------------------------------
*:C16
*:_C_S_C16
B:                            Lesson C16

T:			Frequent words
 :
 :The following 135 words are so frequently used that they comprise 50% of all
 :words normally typed.  If you can type the next two exercises without errors,
 :half of all of your typed words will be correct!

I:(1)
*:_C_R_C16_1
D:a about after all also an and another any are as at back be because
 :been before being between both but by can could day did do down each
 :even first for from get good had has have he her here him his how I
 :if in into is it its just know last life like little long made make
 :many may me men more most Mr. Ms. much must my never new no not now

I:(2)
*:_C_R_C16_2
D:of or on one only or other our out over own people said same see she
 :should so some state still such than that the their them then there
 :these they this those through time to too two under up very was way
 :we well were what when where which while who will with work would
 :years you your

T:We now concentrate on words amongst the top one thousand most frequently used
 :that are 4 letters or more and that can be types using only the HOME row.

I:(3)
*:_C_R_C16_3
D:that this other there said their then these than side does three read
 :hand here need near earth head stand state tree hard start don't north
 :ease those idea hear horse soon door short area order heard interest
 :road rain note star rest done stood street test stead heat tire distant

I:(4)
*:_C_R_C16_4
D:east heart reason ride store train root raise third hair either sand
 :sense nation dress stone iron trade seed tone rise sent noon radio
 :rather thin enter send rose dead desert shoe nine noise shine nose
 :death season sister seat shore sheet share station instant dear teeth

G:_C_E_C16

#------------------------------------------------------------------------------
# Lesson C17
#------------------------------------------------------------------------------
*:C17
*:_C_S_C17
B:                            Lesson C17

T:			Alphabetic sentences
 :
 :In this lesson we practice alphabetic sentences.

I:(1)
*:_C_R_C17_1
D:Sixty-five quizzical sheep kept their jaws dry in a farm bungalow.

I:(2)
*:_C_R_C17_2
D:Balky Zulus find they can hoax weary men with quavery jumping.

I:(3)
*:_C_R_C17_3
D:Jerome quickly began to be vexed by the powerful blizzards.

I:(4)
*:_C_R_C17_4
D:Squawking gorillas could vex the brazen nymphs in a jiffy.

I:(5)
*:_C_R_C17_5
D:Can Jerry's equipment file saws, ax, hoe, knives and grind adz?

I:(6)
*:_C_R_C17_6
D:Ben works at squeezing very juicy plums with flexed thumbs.

I:(7)
*:_C_R_C17_7
D:The black wizard quipping jovially flexed his muscles.

I:(8)
*:_C_R_C17_8
D:Will you pack my jugs of liquid veneer in five dozen boxes?

I:(9)
*:_C_R_C17_9
D:Could the wizard jinx quivering folks by magic yelps?

I:(10)
*:_C_R_C17_10
D:Brazen gazelles quickly examined the forward jeep.

I:(11)
*:_C_R_C17_11
D:The brown dog quickly jumped over the lazy fox.

I:(12)
*:_C_R_C17_12
D:Will the kind judge squelch the five or six brazen nymphs?

I:(13)
*:_C_R_C17_13
D:Mix zippy Kadota figs with quivering cranberry jelly.

I:(14)
*:_C_R_C17_14
D:The wives quickly jerked extra big pizzas from the stand.

I:(15)
*:_C_R_C17_15
D:Lisa quickly mixed the very big jar of new soap.

I:(16)
*:_C_R_C17_16
D:The major will fix a quiet cozy nook for the vexed, bad Gypsy.

I:(17)
*:_C_R_C17_17
D:Pairs of lazy knowing oxen came by quietly evading the jam.

I:(18)
*:_C_R_C17_18
D:Juvenile zest for excitement whetted interest in parking by the quay.

I:(19)
*:_C_R_C17_19
D:Put your big ax, shovel and quartz where Mike's fence joins ours.

I:(20)
*:_C_R_C17_20
D:The brawny jaguar held fast till the quaking Zouave victim expired.

G:_C_E_C17

#------------------------------------------------------------------------------
# Lesson series C jump tables
#------------------------------------------------------------------------------
*:_C_E_C1
Q: Do you want to continue to lesson C2 [Y/N] ? 
N:_C_MENU
G:_C_S_C2
*:_C_E_C2
Q: Do you want to continue to lesson C3 [Y/N] ? 
N:_C_MENU
G:_C_S_C3
*:_C_E_C3
Q: Do you want to continue to lesson C4 [Y/N] ? 
N:_C_MENU
G:_C_S_C4
*:_C_E_C4
Q: Do you want to continue to lesson C5 [Y/N] ? 
N:_C_MENU
G:_C_S_C5
*:_C_E_C5
Q: Do you want to continue to lesson C6 [Y/N] ? 
N:_C_MENU
G:_C_S_C6
*:_C_E_C6
Q: Do you want to continue to lesson C7 [Y/N] ? 
N:_C_MENU
G:_C_S_C7
*:_C_E_C7
Q: Do you want to continue to lesson C8 [Y/N] ? 
N:_C_MENU
G:_C_S_C8
*:_C_E_C8
Q: Do you want to continue to lesson C9 [Y/N] ? 
N:_C_MENU
G:_C_S_C9
*:_C_E_C9
Q: Do you want to continue to lesson C10 [Y/N] ? 
N:_C_MENU
G:_C_S_C10
*:_C_E_C10
Q: Do you want to continue to lesson C11 [Y/N] ? 
N:_C_MENU
G:_C_S_C11
*:_C_E_C11
Q: Do you want to continue to lesson C12 [Y/N] ? 
N:_C_MENU
G:_C_S_C12
*:_C_E_C12
Q: Do you want to continue to lesson C13 [Y/N] ? 
N:_C_MENU
G:_C_S_C13
*:_C_E_C13
Q: Do you want to continue to lesson C14 [Y/N] ? 
N:_C_MENU
G:_C_S_C14
*:_C_E_C14
Q: Do you want to continue to lesson C15 [Y/N] ? 
N:_C_MENU
G:_C_S_C15
*:_C_E_C15
Q: Do you want to continue to lesson C16 [Y/N] ? 
N:_C_MENU
G:_C_S_C16
*:_C_E_C16
Q: Do you want to continue to lesson C17 [Y/N] ? 
N:_C_MENU
G:_C_S_C17
*:_C_E_C17
G:_C_MENU

#------------------------------------------------------------------------------
# Lesson series C menu
#------------------------------------------------------------------------------
*:_C_MENU
B:                  Colemak touch typing lessons
M: UP=_EXIT "The C series contains the following 17 lessons"
 :_C_S_C1  "Lesson C1     S, T, N and E"
 :_C_S_C2  "Lesson C2     R and I"
 :_C_S_C3  "Lesson C3     A and O"
 :_C_S_C4  "Lesson C4     D and H"
 :_C_S_C5  "Lesson C5     HOME row excercises"
 :_C_S_C6  "Lesson C6     P and L"
 :_C_S_C7  "Lesson C7     F and U"
 :_C_S_C8  "Lesson C8     W and Y"
 :_C_S_C9  "Lesson C9     G and J"
 :_C_S_C10 "Lesson C10    M and V"
 :_C_S_C11 "Lesson C11    B and K"
 :_C_S_C12 "Lesson C12    Q and C"
 :_C_S_C13 "Lesson C13    Z and X"
 :_C_S_C14 "Lesson C14    Learning the SHIFT key"
 :_C_S_C15 "Lesson C15    Learning punctuation"
 :_C_S_C16 "Lesson C16    Frequent words"
 :_C_S_C17 "Lesson C17    Alphabetic sentences"
*:_C_EXIT
#------------------------------------------------------------------------------
