#!/hint/bash -euE -o pipefail
# Copyright (C) 2013, 2017 Luke Shumaker <lukeshu@sbcglobal.net>
#
# License: GNU GPLv2+
#
# This file is part of Parabola.
#
# Parabola is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Parabola is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Parabola. If not, see <http://www.gnu.org/licenses/>.

hook_pre_build+=("distcc_start_odaemon")
hook_post_build+=("distcc_stop_odaemon")

_distcc_check() {
	local copydir=$1
	local home=$2

	local files=(
		# From previous versions
		"$home/.makepkg.conf"
		"$copydir/run/distcc-tool.pid"

		# From this version
		"$copydir/bin/distcc-tool"
		"$copydir/run/distcc-tool-idaemon.pid"
		"$copydir/run/distcc-tool-odaemon.pid"
		"$home/.config/pacman/makepkg.conf"
		"$home/.ssh/config"
	)

	local file file_err=false
	for file in "${files[@]}"; do
		if [[ -f $file ]]; then
			file_err=true
			error "Auto-generated file already exists, remove it: %s" "$file"
		fi
	done
	if $file_err; then
		exit 1
	fi
}

_distcc_start_idaemon() {
	(
		set -C
		echo $BASHPID >/run/distcc-tool-idaemon.pid || exit 0
		trap 'jobs -p | xargs -r kill --' EXIT
		/bin/distcc-tool idaemon "$@" &
		wait
	) &>/dev/null &
}

_distcc_stop_idaemon() {
	if [[ -f /run/distcc-tool-idaemon.pid ]]; then
		local idaemon
		idaemon=$(< /run/distcc-tool-idaemon.pid) || exit
		kill -- "$idaemon" || exit

		rm -f -- /run/distcc-tool-idaemon.pid
	fi
}

distcc_start_odaemon() {
	local copydir=$1

	# Because /{,usr/}{,s}bin are all symlinked together for
	# fileystem 2013.05-2 and up, I can take shortcuts when checking for
	# existance of programs.
	if $NONET && [[ -f "$copydir/bin/socat" && -f "$copydir/bin/distcc" ]]; then
		local home
		if $INCHROOT; then
			home=$LIBREHOME
		else
			home="$copydir/build"
		fi

		_distcc_check "$copydir" "$home"

		local _distcc_tool; _distcc_tool="$(librelib chroot/distcc-tool)"
		install -m755 "$_distcc_tool"  "$copydir/bin/distcc-tool"

		mkdir -p "$home/.config/pacman"
		{
			declare -f _distcc_start_idaemon
			declare -f _distcc_stop_idaemon
			printf '%s\n' \
			       '_discc_start_idaemon "$DISTCC_HOSTS"' \
			       'trap _distcc_stop_idaemon EXIT' \
			       'DISTCC_HOSTS="$(/bin/distcc-tool rewrite "$DISTCC_HOSTS")"'
		} > "$home/.config/pacman/makepkg.conf"

		mkdir -p "$home/.ssh"
		printf '%s\n' \
			'Host *' \
			'    ProxyCommand /bin/distcc-tool client %h %p' \
			> "$home/.ssh/config"

		(
			echo $BASHPID >"$copydir"/run/distcc-tool-odaemon.pid
			trap 'jobs -p | xargs -r kill --' EXIT
			"$_distcc_tool" odaemon "$copydir" &
			wait
		) &>/dev/null &
	fi
}

distcc_stop_odaemon() {
	local copydir=$1

	local home
	if $INCHROOT; then
		home=$LIBREHOME
	else
		home="$copydir/build"
	fi

	if [[ -f "$copydir/run/distcc-tool-odaemon.pid" ]]; then
		local odaemon
		odaemon=$(< "$copydir/run/distcc-tool-odaemon.pid")
		kill -- "$odaemon"

		rm -f -- \
			"$home/.config/pacman/makepkg.conf" \
			"$home/.ssh/config" \
			"$copydir/bin/distcc-tool" \
			"$copydir/run/distcc-tool-odaemon.pid" \
			"$copydir/run/distcc-tool-idaemon.pid"
	fi
}
