#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD6',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::ShotInfoZ7_2',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 107 => 0x69 },
	'about' => { 488 => 'about' },
	'aboutcvterm' => { 480 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 480 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 480 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 480 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 480 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 114 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 494 => 'absPeakAudioFilePath' },
	'academicfield' => { 484 => 'academicField' },
	'acceleration' => { 117 => 0x9404, 475 => 'Acceleration' },
	'accelerationtracking' => { 82 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 381 => 0x3 },
	'accelerometerdata' => { 371 => 'vrot' },
	'accelerometerx' => { 311 => 0x8d },
	'accelerometery' => { 311 => 0x8e },
	'accelerometerz' => { 311 => 0x8c },
	'accessoryserialnumber' => { 311 => 0x54 },
	'accessorytype' => { 311 => 0x53 },
	'actionadvised' => { 129 => 0x2a },
	'activearea' => { 117 => 0xc68d },
	'actived-lighting' => { 222 => 0x22, 262 => 0x24 },
	'actived-lightingmode' => { 262 => 0x25 },
	'adaptervoltage' => { 135 => 0x407 },
	'addaspectratioinfo' => { 82 => 0x80e },
	'addiptcinformation' => { 82 => 0x815 },
	'additionalmodelinformation' => { 480 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 82 => 0x80f, 83 => 0x11, 84 => 0x13, 87 => 0x14 },
	'address' => { 158 => 'Address' },
	'adjustmentmode' => { 388 => 0x15 },
	'adlbracketingstep' => { 241 => 0x883 },
	'adlbracketingtype' => { 241 => 0x884 },
	'adobe' => { 118 => 'Adobe' },
	'adultcontentwarning' => { 298 => 'AdultContentWarning', 487 => 'adultContentWarning' },
	'advancedfilter' => { 125 => 0x1201 },
	'advancedraw' => { 264 => 0x76a43203 },
	'advancedscenetype' => { 311 => 0x3d },
	'advisory' => { 492 => 'Advisory' },
	'ae_iso' => { 319 => 0x2, 320 => 0x4, 321 => 0x12 },
	'aeaperture' => { 319 => 0x1, 320 => 0x3, 321 => 0x11 },
	'aeaperturesteps' => { 319 => 0x8, 320 => 0xb },
	'aebautocancel' => { 82 => 0x104 },
	'aebbracketvalue' => { 75 => 0x11 },
	'aebracketingsteps' => { 240 => 0x174c, 241 => 0x87b, 250 => 0x1756 },
	'aebsequence' => { 82 => 0x105 },
	'aebsequenceautocancel' => { 80 => 0x9, 81 => 0x9, 83 => 0x8, 84 => 0x9, 87 => 0x9, 88 => 0x7 },
	'aebshotcount' => { 82 => 0x106 },
	'aebxv' => { 319 => 0x4, 320 => 0x6 },
	'aeerror' => { 320 => 0x8 },
	'aeexposuretime' => { 319 => 0x0, 320 => 0x2, 321 => 0x10 },
	'aelbutton' => { 181 => 0x45 },
	'aelexposureindicator' => { 181 => 0x51 },
	'aelock' => { 181 => 0x5b, 273 => '4.2', 282 => '4.2', 288 => 0x201, 346 => 0x48, 398 => 0x40, 399 => 0x40, 400 => [0x86,0x286] },
	'aelockbutton' => { 271 => '16.1', 273 => '4.1', 276 => '15.1', 277 => '16.1', 278 => '16.1', 280 => '30.1', 281 => '16.1', 282 => '4.1', 284 => '17.1', 286 => '17.1' },
	'aelockbuttonplusdials' => { 271 => '16.2', 280 => '32.1', 284 => '44.1' },
	'aelockformb-d80' => { 286 => '3.1' },
	'aelockmetermodeafterfocus' => { 82 => 0x114 },
	'aemaxaperture' => { 319 => 0x9, 320 => 0x10, 321 => 0x1c },
	'aemaxaperture2' => { 319 => 0xa, 320 => 0x11, 321 => 0x1d },
	'aemeteringmode' => { 319 => 0xc },
	'aemeteringmode2' => { 319 => '13.1' },
	'aemeteringsegments' => { 184 => 0x628, 346 => 0x209 },
	'aemicroadjustment' => { 82 => 0x110 },
	'aeminaperture' => { 319 => 0xb, 320 => 0x12, 321 => 0x1e },
	'aeminexposuretime' => { 319 => 0x5, 320 => 0x13, 321 => 0x1f },
	'aeprogrammode' => { 319 => 0x6 },
	'aeprojectlink' => { 469 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 469 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 469 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 469 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 469 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 469 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 319 => 0xd },
	'aexv' => { 319 => 0x3, 320 => 0x5 },
	'af-cpriority' => { 126 => '0.2' },
	'af-cpriorityselection' => { 271 => '1.1', 272 => '1.1', 274 => '1.1', 275 => '1.1', 277 => '0.1', 278 => '0.1', 279 => '0.1', 280 => '1.1', 281 => '0.1', 284 => '1.1', 285 => '1.1' },
	'af-csetting' => { 122 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 122 => '0.2' },
	'af-ctrackingsensitivity' => { 122 => '0.1' },
	'af-czoneareaswitching' => { 122 => '0.3' },
	'af-onbutton' => { 274 => '70.1', 275 => '70.1', 285 => '70.1' },
	'af-onformb-d10' => { 271 => '3.3', 280 => '3.2' },
	'af-onformb-d11' => { 281 => '2.2' },
	'af-onformb-d12' => { 284 => '50.1' },
	'af-spriority' => { 126 => '0.1' },
	'af-spriorityselection' => { 271 => '1.2', 272 => '1.2', 274 => '1.2', 275 => '1.2', 279 => '0.2', 280 => '1.2', 281 => '0.2', 284 => '1.2', 285 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 271 => '2.1', 272 => '2.1', 274 => '78.3', 275 => '78.3', 280 => '2.1', 284 => '2.1', 285 => '78.3' },
	'afadjustment' => { 346 => 0x72, 355 => 0x267 },
	'afandmeteringbuttons' => { 82 => 0x701 },
	'afaperture' => { 215 => 0x5, 216 => 0x5, 220 => 0x5 },
	'afareaheight' => { 190 => [0x1a,0x34,0x50] },
	'afareaillumination' => { 181 => 0x4b, 282 => '15.3' },
	'afareamode' => { 124 => '0.3', 177 => 0x33, 181 => 0xe, 189 => 0x0, 190 => 0x5, 311 => 0xf, 378 => 0x1205, 391 => [0xa,0x3a], 398 => 0x11, 399 => 0x10, 400 => 0x24, 411 => 0xb043, 435 => 0x17 },
	'afareamodesetting' => { 273 => '11.1', 276 => '0.1', 282 => '16.1', 286 => '2.1', 411 => 0x201c },
	'afareapointsize' => { 124 => '0.4' },
	'afareas' => { 288 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 82 => 0x51b },
	'afareawidth' => { 190 => [0x18,0x32,0x4e] },
	'afareaxposition' => { 190 => [0x14,0x2e,0x4a], 378 => 0x1203 },
	'afareaxposition1' => { 378 => 0x1201 },
	'afareayposition' => { 190 => [0x16,0x30,0x4c], 378 => 0x1204 },
	'afareayposition1' => { 378 => 0x1202 },
	'afareazonesize' => { 124 => '0.5' },
	'afassist' => { 80 => 0x5, 88 => 0x5, 181 => 0x48, 271 => '2.5', 273 => '0.2', 276 => '0.2', 277 => '1.1', 278 => '1.1', 279 => '1.3', 280 => '2.4', 281 => '1.3', 282 => '0.2', 284 => '2.4', 286 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 82 => 0x50e, 83 => 0x4, 84 => 0x5, 85 => 0x4, 86 => 0x4, 87 => 0x5 },
	'afassistlamp' => { 311 => 0x31 },
	'afbuttonpressed' => { 400 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 322 => 0x6 },
	'afduringliveview' => { 82 => 0x511 },
	'affinea' => { 462 => 'AffineA' },
	'affineb' => { 462 => 'AffineB' },
	'affinec' => { 462 => 'AffineC' },
	'affined' => { 462 => 'AffineD' },
	'affinetune' => { 191 => 0x0, 288 => 0x306 },
	'affinetuneadj' => { 191 => 0x2, 233 => 0x2d1, 234 => 0x2dc, 288 => 0x307 },
	'affinetuneadjtele' => { 191 => 0x3 },
	'affinetuneindex' => { 191 => 0x1 },
	'affinex' => { 462 => 'AffineX' },
	'affiney' => { 462 => 'AffineY' },
	'affocuspointxposition' => { 190 => 0x2f },
	'affocuspointyposition' => { 190 => 0x31 },
	'afhold' => { 322 => 0x1fd },
	'afilluminator' => { 398 => 0x29, 411 => 0xb044 },
	'afimageheight' => { 190 => [0x12,0x2c,0x48] },
	'afimagewidth' => { 190 => [0x10,0x2a,0x46] },
	'afintegrationtime' => { 322 => 0x7 },
	'afmicroadj' => { 391 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 395 => 0x131 },
	'afmicroadjregisteredlenses' => { 395 => '305.1' },
	'afmicroadjustment' => { 82 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 395 => 0x130 },
	'afmode' => { 111 => 0x3009, 125 => 0x1022, 177 => 0x16, 388 => 0x5 },
	'afmoderestrictions' => { 272 => '50.3', 274 => '48.3', 275 => '48.3', 284 => '48.3', 285 => '48.3' },
	'afonaelockbuttonswitch' => { 82 => 0x702 },
	'afonbutton' => { 271 => '3.1', 272 => '47.1' },
	'afpoint' => { 34 => 0x13, 110 => 0x18, 177 => 0x15, 189 => 0x1, 291 => 0x308, 388 => 0x1f, 391 => [0x37,0x7], 395 => 0x19, 396 => 0x18, 397 => [0x18,0x20] },
	'afpointactivationarea' => { 81 => 0x11, 87 => 0x11 },
	'afpointareaexpansion' => { 82 => 0x508 },
	'afpointatshutterrelease' => { 391 => [0x39,0x9] },
	'afpointautoselection' => { 82 => 0x50b },
	'afpointbrightness' => { 82 => 0x50d, 271 => '2.4', 272 => '46.5', 274 => '2.2', 275 => '2.2', 284 => '2.3', 285 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 82 => 0x50c },
	'afpointillumination' => { 81 => 0xa, 271 => '2.3', 272 => '46.2', 274 => '47.2', 275 => '47.2', 279 => '1.2', 280 => '2.3', 281 => '1.2', 284 => '47.2', 285 => '47.2', 286 => '2.4' },
	'afpointinfocus' => { 391 => [0x38,0x8] },
	'afpointmode' => { 327 => 0x3 },
	'afpointposition' => { 111 => 0x2021, 311 => 0x4d },
	'afpointregistration' => { 80 => 0x7 },
	'afpoints' => { 180 => 0x10 },
	'afpointselected' => { 181 => 0xd, 288 => 0x305, 346 => 0xe, 395 => 0x15, 396 => 0x14, 397 => [0x14,0x1c], 411 => 0x201e },
	'afpointselected2' => { 327 => 0x4 },
	'afpointselection' => { 81 => 0xb, 271 => '1.3', 272 => '1.3', 280 => '1.3', 284 => '1.3', 285 => '1.3' },
	'afpointselectionmethod' => { 82 => 0x50f, 83 => 0xc, 84 => 0xd, 87 => 0xd },
	'afpointsetting' => { 398 => 0x12, 399 => 0x11 },
	'afpointsinfocus' => { 75 => 0xe, 189 => 0x2, 190 => 0x30, 322 => 0xb, 323 => 0x4, 346 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 81 => 0xd },
	'afpointsselected' => { 190 => 0x1c, 323 => '4.1', 443 => 0x4 },
	'afpointsspecial' => { 323 => '4.2' },
	'afpointsunknown1' => { 322 => 0x0 },
	'afpointsunknown2' => { 322 => 0x2 },
	'afpointsused' => { 190 => [0xa,0x8], 391 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 322 => 0x4 },
	'afresponse' => { 222 => 0xad },
	'afresult' => { 293 => 0x1038 },
	'afsearch' => { 288 => 0x303 },
	'afsensoractive' => { 177 => 0x1 },
	'afstatus' => { 378 => 0x1200 },
	'afstatus_00_b4' => { 394 => 0x0 },
	'afstatus_01_c4' => { 394 => 0x2 },
	'afstatus_02_d4' => { 394 => 0x4 },
	'afstatus_03_e4' => { 394 => 0x6 },
	'afstatus_04_f4' => { 394 => 0x8 },
	'afstatus_05_g4' => { 394 => 0xa },
	'afstatus_06_h4' => { 394 => 0xc },
	'afstatus_07_b3' => { 394 => 0xe },
	'afstatus_08_c3' => { 394 => 0x10 },
	'afstatus_09_d3' => { 394 => 0x12 },
	'afstatus_10_e3' => { 394 => 0x14 },
	'afstatus_11_f3' => { 394 => 0x16 },
	'afstatus_12_g3' => { 394 => 0x18 },
	'afstatus_13_h3' => { 394 => 0x1a },
	'afstatus_14_b2' => { 394 => 0x1c },
	'afstatus_15_c2' => { 394 => 0x1e },
	'afstatus_16_d2' => { 394 => 0x20 },
	'afstatus_17_e2' => { 394 => 0x22 },
	'afstatus_18_f2' => { 394 => 0x24 },
	'afstatus_19_g2' => { 394 => 0x26 },
	'afstatus_20_h2' => { 394 => 0x28 },
	'afstatus_21_c1' => { 394 => 0x2a },
	'afstatus_22_d1' => { 394 => 0x2c },
	'afstatus_23_e1' => { 394 => 0x2e },
	'afstatus_24_f1' => { 394 => 0x30 },
	'afstatus_25_g1' => { 394 => 0x32 },
	'afstatus_26_a7_vertical' => { 394 => 0x34 },
	'afstatus_27_a6_vertical' => { 394 => 0x36 },
	'afstatus_28_a5_vertical' => { 394 => 0x38 },
	'afstatus_29_c7_vertical' => { 394 => 0x3a },
	'afstatus_30_c6_vertical' => { 394 => 0x3c },
	'afstatus_31_c5_vertical' => { 394 => 0x3e },
	'afstatus_32_e7_vertical' => { 394 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 394 => 0x42 },
	'afstatus_34_e5_vertical' => { 394 => 0x44 },
	'afstatus_35_g7_vertical' => { 394 => 0x46 },
	'afstatus_36_g6_vertical' => { 394 => 0x48 },
	'afstatus_37_g5_vertical' => { 394 => 0x4a },
	'afstatus_38_i7_vertical' => { 394 => 0x4c },
	'afstatus_39_i6_vertical' => { 394 => 0x4e },
	'afstatus_40_i5_vertical' => { 394 => 0x50 },
	'afstatus_41_a7' => { 394 => 0x52 },
	'afstatus_42_b7' => { 394 => 0x54 },
	'afstatus_43_c7' => { 394 => 0x56 },
	'afstatus_44_d7' => { 394 => 0x58 },
	'afstatus_45_e7' => { 394 => 0x5a },
	'afstatus_46_f7' => { 394 => 0x5c },
	'afstatus_47_g7' => { 394 => 0x5e },
	'afstatus_48_h7' => { 394 => 0x60 },
	'afstatus_49_i7' => { 394 => 0x62 },
	'afstatus_50_a6' => { 394 => 0x64 },
	'afstatus_51_b6' => { 394 => 0x66 },
	'afstatus_52_c6' => { 394 => 0x68 },
	'afstatus_53_d6' => { 394 => 0x6a },
	'afstatus_54_e6_center' => { 394 => 0x6c },
	'afstatus_55_f6' => { 394 => 0x6e },
	'afstatus_56_g6' => { 394 => 0x70 },
	'afstatus_57_h6' => { 394 => 0x72 },
	'afstatus_58_i6' => { 394 => 0x74 },
	'afstatus_59_a5' => { 394 => 0x76 },
	'afstatus_60_b5' => { 394 => 0x78 },
	'afstatus_61_c5' => { 394 => 0x7a },
	'afstatus_62_d5' => { 394 => 0x7c },
	'afstatus_63_e5' => { 394 => 0x7e },
	'afstatus_64_f5' => { 394 => 0x80 },
	'afstatus_65_g5' => { 394 => 0x82 },
	'afstatus_66_h5' => { 394 => 0x84 },
	'afstatus_67_i5' => { 394 => 0x86 },
	'afstatus_68_c11' => { 394 => 0x88 },
	'afstatus_69_d11' => { 394 => 0x8a },
	'afstatus_70_e11' => { 394 => 0x8c },
	'afstatus_71_f11' => { 394 => 0x8e },
	'afstatus_72_g11' => { 394 => 0x90 },
	'afstatus_73_b10' => { 394 => 0x92 },
	'afstatus_74_c10' => { 394 => 0x94 },
	'afstatus_75_d10' => { 394 => 0x96 },
	'afstatus_76_e10' => { 394 => 0x98 },
	'afstatus_77_f10' => { 394 => 0x9a },
	'afstatus_78_g10' => { 394 => 0x9c },
	'afstatus_79_h10' => { 394 => 0x9e },
	'afstatus_80_b9' => { 394 => 0xa0 },
	'afstatus_81_c9' => { 394 => 0xa2 },
	'afstatus_82_d9' => { 394 => 0xa4 },
	'afstatus_83_e9' => { 394 => 0xa6 },
	'afstatus_84_f9' => { 394 => 0xa8 },
	'afstatus_85_g9' => { 394 => 0xaa },
	'afstatus_86_h9' => { 394 => 0xac },
	'afstatus_87_b8' => { 394 => 0xae },
	'afstatus_88_c8' => { 394 => 0xb0 },
	'afstatus_89_d8' => { 394 => 0xb2 },
	'afstatus_90_e8' => { 394 => 0xb4 },
	'afstatus_91_f8' => { 394 => 0xb6 },
	'afstatus_92_g8' => { 394 => 0xb8 },
	'afstatus_93_h8' => { 394 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 394 => 0xbc },
	'afstatusactivesensor' => { 177 => 0x2, 391 => [0x4,0x3b], 395 => 0x1e, 396 => 0x1b, 397 => [0x1b,0x21] },
	'afstatusbottom' => { 177 => 0x8, 395 => 0x2a, 396 => 0x21, 397 => 0x21 },
	'afstatusbottom-left' => { 177 => 0x12, 396 => 0x2b, 397 => 0x2b },
	'afstatusbottom-right' => { 177 => 0x6, 396 => 0x1f, 397 => 0x1f },
	'afstatusbottomassist-left' => { 395 => 0x28 },
	'afstatusbottomassist-right' => { 395 => 0x2c },
	'afstatusbottomhorizontal' => { 392 => 0x10, 393 => 0x1c },
	'afstatusbottomvertical' => { 392 => 0x16, 393 => 0x26 },
	'afstatuscenter-10' => { 395 => 0x34 },
	'afstatuscenter-11' => { 395 => 0x36 },
	'afstatuscenter-12' => { 395 => 0x38 },
	'afstatuscenter-14' => { 395 => 0x3c },
	'afstatuscenter-7' => { 395 => 0x2e },
	'afstatuscenter-9' => { 395 => 0x32 },
	'afstatuscenter-horizontal' => { 395 => 0x30 },
	'afstatuscenter-vertical' => { 395 => 0x3a },
	'afstatuscenterf2-8' => { 395 => 0x4c },
	'afstatuscenterhorizontal' => { 177 => 0x2f, 392 => 0xc, 393 => 0x18, 396 => 0x2f, 397 => 0x2f },
	'afstatuscentervertical' => { 177 => 0xc, 392 => 0x14, 393 => 0x22, 396 => 0x25, 397 => 0x25 },
	'afstatusfarleft' => { 392 => 0x6, 395 => 0x26 },
	'afstatusfarlefthorizontal' => { 393 => 0x4 },
	'afstatusfarleftvertical' => { 393 => 0x12 },
	'afstatusfarright' => { 392 => 0x18, 395 => 0x44 },
	'afstatusfarrighthorizontal' => { 393 => 0x2c },
	'afstatusfarrightvertical' => { 393 => 0x34 },
	'afstatusleft' => { 177 => 0x2d, 392 => 0x2, 395 => 0x22, 396 => 0x2d, 397 => 0x2d },
	'afstatuslefthorizontal' => { 393 => 0x6 },
	'afstatusleftvertical' => { 393 => 0xe },
	'afstatuslower-left' => { 392 => 0x4, 395 => 0x24 },
	'afstatuslower-lefthorizontal' => { 393 => 0xa },
	'afstatuslower-leftvertical' => { 393 => 0x10 },
	'afstatuslower-middle' => { 392 => 0x22, 393 => 0x24 },
	'afstatuslower-right' => { 392 => 0x1e, 395 => 0x4a },
	'afstatuslower-righthorizontal' => { 393 => 0x32 },
	'afstatuslower-rightvertical' => { 393 => 0x3a },
	'afstatuslowerfarleft' => { 393 => 0x8 },
	'afstatuslowerfarright' => { 393 => 0x30 },
	'afstatusmiddlehorizontal' => { 177 => 0xa, 396 => 0x23, 397 => 0x23 },
	'afstatusnearleft' => { 392 => 0xe, 393 => 0x1a },
	'afstatusnearright' => { 392 => 0xa, 393 => 0x16 },
	'afstatusright' => { 177 => 0x31, 392 => 0x1c, 395 => 0x48, 396 => 0x31, 397 => 0x31 },
	'afstatusrighthorizontal' => { 393 => 0x2e },
	'afstatusrightvertical' => { 393 => 0x38 },
	'afstatustop' => { 177 => 0xe, 395 => 0x40, 396 => 0x27, 397 => 0x27 },
	'afstatustop-left' => { 177 => 0x10, 396 => 0x29, 397 => 0x29 },
	'afstatustop-right' => { 177 => 0x4, 396 => 0x1d, 397 => 0x1d },
	'afstatustopassist-left' => { 395 => 0x3e },
	'afstatustopassist-right' => { 395 => 0x42 },
	'afstatustophorizontal' => { 392 => 0x8, 393 => 0x14 },
	'afstatustopvertical' => { 392 => 0x12, 393 => 0x1e },
	'afstatusupper-left' => { 392 => 0x0, 395 => 0x20 },
	'afstatusupper-lefthorizontal' => { 393 => 0x2 },
	'afstatusupper-leftvertical' => { 393 => 0xc },
	'afstatusupper-middle' => { 392 => 0x20, 393 => 0x20 },
	'afstatusupper-right' => { 392 => 0x1a, 395 => 0x46 },
	'afstatusupper-righthorizontal' => { 393 => 0x2a },
	'afstatusupper-rightvertical' => { 393 => 0x36 },
	'afstatusupperfarleft' => { 393 => 0x0 },
	'afstatusupperfarright' => { 393 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 411 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 391 => 0x2 },
	'afwithshutter' => { 398 => 0x2a },
	'aggregateissuenumber' => { 484 => 'aggregateIssueNumber' },
	'aggregationtype' => { 484 => 'aggregationType' },
	'agreement' => { 487 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 135 => 0xe4e },
	'aiservocontinuousshooting' => { 81 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 82 => 0x519 },
	'aiservoimagepriority' => { 82 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 82 => 0x51a },
	'aiservotrackingmethod' => { 82 => 0x504 },
	'aiservotrackingsensitivity' => { 81 => 0x14, 82 => 0x502 },
	'album' => { 363 => ['albm',"\xa9alb"], 365 => 'album', 371 => ['albm',"\xa9alb"], 494 => 'album' },
	'albumartist' => { 176 => 'WM/AlbumArtist', 363 => 'aART', 371 => 'albr' },
	'albumcoverurl' => { 176 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 176 => 'WM/AlbumTitle' },
	'albumtitleid' => { 363 => 'atID' },
	'alreadyapplied' => { 468 => 'AlreadyApplied', 470 => 'AlreadyApplied' },
	'alternatetitle' => { 484 => 'alternateTitle' },
	'alternatetitlea-lang' => { 484 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 484 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 484 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 192 => 0x6 },
	'alttapename' => { 494 => 'altTapeName' },
	'alttimecode' => { 494 => 'altTimecode' },
	'alttimecodetimeformat' => { 494 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 494 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 494 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 374 => 0x5c },
	'ambientlight' => { 374 => 0x5e },
	'ambienttemperature' => { 117 => 0x9400, 372 => 0x14, 373 => 0x46, 374 => 0x50, 435 => 0x4, 475 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 372 => 0x13, 373 => 0x44, 374 => 0x4e },
	'analogbalance' => { 117 => 0xc627 },
	'analogcaptureiso' => { 135 => 0x89e },
	'analogisotable' => { 135 => 0x89d },
	'androidversion' => { 365 => 'com.android.version' },
	'angleadj' => { 101 => 0x10003, 107 => 0x8b },
	'angleinforoll' => { 464 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 464 => 'AngleInfoYaw' },
	'anti-blur' => { 411 => 0xb04b },
	'antialiasstrength' => { 117 => 0xc632 },
	'aperturelock' => { 272 => '38.2', 274 => '38.2', 275 => '38.2', 284 => '38.2', 285 => '38.2' },
	'aperturemode' => { 371 => 'apmd' },
	'aperturerange' => { 82 => 0x10d },
	'apertureringuse' => { 327 => '1.4' },
	'aperturesetting' => { 181 => 0x7, 398 => 0x30, 399 => 0x29, 400 => 0x1 },
	'aperturevalue' => { 91 => 0x2, 117 => 0x9202, 293 => 0x1002, 355 => 0x401, 474 => 'ApertureValue' },
	'appinfo' => { 448 => 'AppInfo' },
	'appinfoapplication' => { 448 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 448 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 448 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 297 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 365 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 363 => 'apID' },
	'applestoreaccounttype' => { 363 => 'akID' },
	'applestorecatalogid' => { 363 => 'cnID' },
	'applestorecountry' => { 363 => 'sfID' },
	'applicationkeystring' => { 135 => 0x400 },
	'applicationnotes' => { 117 => 0x2bc, 316 => 0x2bc },
	'applicationrecordversion' => { 129 => 0x0 },
	'applyshootingmeteringmode' => { 82 => 0x10e },
	'approved' => { 476 => 'Approved' },
	'approvedby' => { 476 => 'ApprovedBy' },
	'approximatefnumber' => { 306 => 0x313, 313 => 0x3406 },
	'approximatefocusdistance' => { 465 => 'ApproximateFocusDistance' },
	'appversion' => { 478 => 'AppVersion' },
	'aps-csizecapture' => { 429 => 0x114, 430 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 101 => 0x20914 },
	'armidentifier' => { 130 => 0x78 },
	'armversion' => { 130 => 0x7a },
	'arranger' => { 363 => "\xa9arg", 371 => "\xa9arg" },
	'arrangerkeywords' => { 371 => "\xa9ark" },
	'artdirector' => { 363 => "\xa9ard" },
	'artfilter' => { 288 => 0x529 },
	'artfiltereffect' => { 288 => 0x52f },
	'artist' => { 117 => 0x13b, 301 => 'Artist', 346 => 0x22e, 363 => "\xa9ART", 365 => 'artist', 371 => "\xa9ART", 490 => 'Artist', 494 => 'artist' },
	'artmode' => { 111 => 0x301b },
	'artmodeparameters' => { 111 => 0x310b },
	'artwork' => { 365 => 'artwork' },
	'artworkcircadatecreated' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 480 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 480 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 292 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 292 => 0x1112, 346 => 0x80, 398 => 0x55, 399 => 0x55, 400 => 0xa },
	'assetid' => { 458 => 'AssetID' },
	'asshoticcprofile' => { 117 => 0xc68f },
	'asshotneutral' => { 117 => 0xc628 },
	'asshotpreprofilematrix' => { 117 => 0xc690 },
	'asshotprofilename' => { 117 => 0xc6f6 },
	'asshotwhitexy' => { 117 => 0xc629 },
	'assignbktbutton' => { 271 => '4.2', 272 => '16.1', 274 => '16.1', 275 => '16.1', 284 => '16.1', 285 => '16.1' },
	'assignfuncbutton' => { 82 => 0x70b },
	'assignmb-d17af-onbutton' => { 275 => '79.1' },
	'assignmb-d17funcbutton' => { 275 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 275 => '68.1' },
	'assignmb-d18af-onbutton' => { 285 => '79.1' },
	'assignmb-d18funcbutton' => { 285 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 285 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 274 => '75.1', 275 => '75.1', 285 => '75.1' },
	'assignmoviefunc2button' => { 274 => '82.1', 275 => '82.1', 285 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 274 => '75.2', 275 => '75.2', 285 => '75.2' },
	'assignmovierecordbutton' => { 272 => '43.2', 284 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 274 => '45.1', 275 => '45.1', 285 => '45.1' },
	'assignmoviesubselector' => { 274 => '74.1', 275 => '74.1', 285 => '74.1' },
	'assignmoviesubselectorplusdials' => { 274 => '76.1', 275 => '76.1', 285 => '76.1' },
	'assignremotefnbutton' => { 272 => '54.1', 284 => '51.1' },
	'assistbuttonfunction' => { 80 => 0xd },
	'atcaptureusercrop' => { 135 => 0x943 },
	'attributionname' => { 466 => 'attributionName' },
	'attributionurl' => { 466 => 'attributionURL' },
	'audio' => { 311 => 0x20 },
	'audiobitrate' => { 65 => 0x6c, 480 => 'audioBitRate' },
	'audiobitratemode' => { 480 => 'audioBitRateMode' },
	'audiobitspersample' => { 480 => 'audioBitsPerSample' },
	'audiochannelcount' => { 480 => 'audioChannelCount' },
	'audiochannels' => { 65 => 0x70 },
	'audiochanneltype' => { 494 => 'audioChannelType' },
	'audiocompression' => { 82 => 0x816, 152 => 'Compression' },
	'audiocompressor' => { 494 => 'audioCompressor' },
	'audiodata' => { 450 => 'Data' },
	'audioduration' => { 129 => 0x99 },
	'audiogain' => { 365 => 'player.movie.audio.gain' },
	'audiomimetype' => { 450 => 'Mime' },
	'audiomoddate' => { 494 => 'audioModDate' },
	'audiooutcue' => { 129 => 0x9a },
	'audiosamplerate' => { 65 => 0x6e, 494 => 'audioSampleRate' },
	'audiosampletype' => { 494 => 'audioSampleType' },
	'audiosamplingrate' => { 129 => 0x97 },
	'audiosamplingresolution' => { 129 => 0x98 },
	'audiotype' => { 129 => 0x96 },
	'author' => { 154 => 'Author', 297 => 'Author', 301 => 'Author', 362 => 'Author', 363 => ['auth',"\xa9aut"], 365 => 'author', 371 => 'auth', 463 => 'author', 481 => 'Author', 492 => 'Author' },
	'authorsposition' => { 482 => 'AuthorsPosition' },
	'authorurl' => { 176 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 82 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 337 => '0.1' },
	'autobracket' => { 388 => 0x19 },
	'autobracketing' => { 125 => 0x1100, 346 => 0x18, 378 => 0x1007 },
	'autobracketingmode' => { 283 => '12.3' },
	'autobracketingset' => { 283 => '12.1' },
	'autobracketmodem' => { 271 => '21.2', 272 => '13.3', 274 => '13.2', 275 => '13.2', 280 => '26.2', 284 => '13.3', 285 => '13.2' },
	'autobracketorder' => { 181 => 0x43, 271 => '21.3', 272 => '13.2', 274 => '13.1', 275 => '13.1', 280 => '26.3', 281 => '12.2', 282 => '2.2', 283 => '12.2', 284 => '13.2', 285 => '13.1', 286 => '13.2' },
	'autobracketset' => { 271 => '21.1', 272 => '13.1', 276 => '11.1', 277 => '12.1', 278 => '12.1', 280 => '26.1', 281 => '12.1', 282 => '2.1', 284 => '13.1', 286 => '13.1' },
	'autobrightness' => { 468 => 'AutoBrightness', 470 => 'AutoBrightness' },
	'autocontrast' => { 468 => 'AutoContrast', 470 => 'AutoContrast' },
	'autodistortioncontrol' => { 202 => 0x4 },
	'autodynamicrange' => { 125 => 0x140b },
	'autoexposure' => { 468 => 'AutoExposure', 470 => 'AutoExposure' },
	'autoexposurebracketing' => { 75 => 0x10 },
	'autoflashisosensitivity' => { 274 => '38.5', 275 => '38.5', 285 => '38.5' },
	'autofocus' => { 291 => 0x209 },
	'autofp' => { 282 => '7.3', 286 => '31.4' },
	'autoiso' => { 75 => 0x1, 111 => 0x3008, 273 => '1.1', 282 => '1.1' },
	'autoisomax' => { 273 => '1.2', 282 => '1.2' },
	'autoisominshutterspeed' => { 273 => '1.3', 282 => '1.3' },
	'autolateralca' => { 468 => 'AutoLateralCA', 470 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 61 => 0x2, 82 => 0x204, 101 => 0x20500, 107 => 0x6f },
	'autolightingoptimizeron' => { 101 => '0x20500.0', 107 => 0x6e },
	'autoportraitframed' => { 411 => 0x2016 },
	'autoredeye' => { 264 => 0xfe28a44f },
	'autorotate' => { 75 => 0x1b },
	'autoshadows' => { 468 => 'AutoShadows', 470 => 'AutoShadows' },
	'autotone' => { 468 => 'AutoTone', 470 => 'AutoTone' },
	'autotonedigest' => { 468 => 'AutoToneDigest', 470 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 468 => 'AutoToneDigestNoSat', 470 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 468 => 'AutoWhiteVersion', 470 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 222 => 0x82 },
	'avaperturesetting' => { 327 => 0x13 },
	'averageblacklevel' => { 44 => 0xe7, 46 => 0xfb, 47 => 0x114, 48 => 0x146 },
	'averagelv' => { 184 => 0x38 },
	'avsettingwithoutlens' => { 82 => 0x707 },
	'azimuth' => { 162 => 'Azimuth' },
	'babyage' => { 311 => [0x8010,0x33] },
	'babyname' => { 311 => 0x66 },
	'backgroundalpha' => { 489 => 'bgalpha' },
	'balance' => { 365 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 327 => 0x15 },
	'baseiso' => { 75 => 0x2, 95 => 0x101c, 135 => 0x903, 313 => 0x312a, 441 => 0x6 },
	'baseisodaylight' => { 135 => 0x910 },
	'baseisoflash' => { 135 => 0x913 },
	'baseisofluorescent' => { 135 => 0x912 },
	'baseisotungsten' => { 135 => 0x911 },
	'baselineexposure' => { 117 => 0xc62a },
	'baselineexposureoffset' => { 117 => 0xc7a5 },
	'baselinenoise' => { 117 => 0xc62b },
	'baselinesharpness' => { 117 => 0xc62c },
	'baseurl' => { 492 => 'BaseURL' },
	'bass' => { 365 => 'player.movie.audio.bass' },
	'batterylevel' => { 311 => 0x38, 398 => 0x51, 402 => 0xc, 403 => 0x4, 404 => 0x4, 442 => 0x7 },
	'batterylevelgrip1' => { 442 => 0x6 },
	'batterylevelgrip2' => { 442 => 0x8 },
	'batteryorder' => { 271 => '12.5', 280 => '13.2', 281 => '2.1', 284 => '3.1' },
	'batterystate' => { 181 => 0x60, 398 => 0x50, 404 => 0x14 },
	'batterytemperature' => { 402 => 0x1, 404 => 0x2, 442 => 0x5 },
	'batterytype' => { 62 => 0x38, 374 => 0x66 },
	'batteryunknown' => { 402 => 0x2, 404 => 0x0 },
	'batteryvoltage' => { 135 => 0x408, 372 => 0x2a, 373 => 0x49, 374 => 0x62, 402 => 0x8 },
	'batteryvoltage1' => { 404 => 0x6 },
	'batteryvoltage2' => { 404 => 0x8 },
	'batteryvoltageavg' => { 374 => 0x64 },
	'bayergreensplit' => { 117 => 0xc62d },
	'bayerpattern' => { 134 => 0xf902, 185 => 0x17 },
	'beatsperminute' => { 363 => 'tmpo' },
	'beatspliceparams' => { 494 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 494 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 494 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 494 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 494 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 494 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 271 => '13.1', 272 => '5.4', 273 => '0.1', 276 => '2.1', 277 => '3.1', 278 => '3.1', 280 => '10.1', 282 => '0.1', 284 => '5.5', 286 => '4.1' },
	'beeppitch' => { 281 => '3.1' },
	'beepvolume' => { 281 => '4.5' },
	'bestqualityscale' => { 117 => 0xc65c },
	'bestshotmode' => { 111 => 0x3007 },
	'bitdepth' => { 159 => 'BitDepth', 185 => 0x11, 230 => 0x41 },
	'bitspercomponent' => { 131 => 0x87 },
	'bitspersample' => { 117 => 0x102, 316 => 0xa, 490 => 'BitsPerSample' },
	'blackacquirerows' => { 135 => 0x18ba },
	'blacklevel' => { 117 => 0xc61a, 200 => 0x20, 222 => 0x3d, 293 => [0x401,0x1012], 355 => 0x21d },
	'blacklevel2' => { 292 => 0x600, 296 => 0x600 },
	'blacklevelblue' => { 316 => 0x1e },
	'blacklevelbottom' => { 135 => 0x3f0 },
	'blackleveldata' => { 355 => 0x223 },
	'blackleveldeltah' => { 117 => 0xc61b },
	'blackleveldeltav' => { 117 => 0xc61c },
	'blacklevelgreen' => { 316 => 0x1d },
	'blacklevelred' => { 316 => 0x1c },
	'blacklevelrepeatdim' => { 117 => 0xc619 },
	'blacklevelrough' => { 135 => 0x40e },
	'blacklevelroughafter' => { 135 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 135 => 0x3ef },
	'blackpoint' => { 346 => 0x200 },
	'blacks2012' => { 468 => 'Blacks2012', 470 => 'Blacks2012' },
	'blacksadj' => { 445 => 0x9018 },
	'bleachbypasstoning' => { 346 => 0x7f },
	'blockshotafresponse' => { 274 => '1.5', 275 => '1.5', 285 => '1.5' },
	'blogtitle' => { 484 => 'blogTitle' },
	'blogurl' => { 484 => 'blogURL' },
	'bluebalance' => { 293 => 0x1018, 316 => 0x12, 346 => 0x1b },
	'bluecurvelimits' => { 106 => 0x1fe },
	'bluecurvepoints' => { 105 => 0x79, 106 => 0x1d4 },
	'bluehsl' => { 101 => 0x20915 },
	'bluehue' => { 468 => 'BlueHue', 470 => 'BlueHue' },
	'bluesaturation' => { 468 => 'BlueSaturation', 470 => 'BlueSaturation' },
	'bluratinfinity' => { 454 => 'BlurAtInfinity' },
	'blurcontrol' => { 346 => 0x82 },
	'blurwarning' => { 125 => 0x1300 },
	'bodybatteryadload' => { 325 => 0x3 },
	'bodybatteryadnoload' => { 325 => 0x2 },
	'bodybatterystate' => { 325 => '1.1' },
	'bodybatteryvoltage1' => { 325 => 0x2 },
	'bodybatteryvoltage2' => { 325 => 0x4 },
	'bodybatteryvoltage3' => { 325 => 0x6 },
	'bodybatteryvoltage4' => { 325 => 0x8 },
	'bodyfirmware' => { 379 => 0x0 },
	'bodyfirmwareversion' => { 289 => 0x104, 290 => 0x100, 293 => 0x104 },
	'bodyserialnumber' => { 379 => 0x10 },
	'bookedition' => { 484 => 'bookEdition' },
	'bootloaderversion' => { 373 => 0x26 },
	'bracketmode' => { 56 => 0x3 },
	'bracketsequence' => { 111 => 0x301d },
	'bracketsettings' => { 311 => 0x45 },
	'bracketshotnumber' => { 56 => 0x5, 327 => 0x9, 409 => 0x2b },
	'bracketshotnumber2' => { 409 => 0x2d },
	'bracketstep' => { 178 => 0xe },
	'bracketvalue' => { 56 => 0x4 },
	'brightness' => { 117 => 0xfe53, 153 => 'Brightness', 173 => 'Brightness', 178 => 0x2c, 224 => 0x34, 225 => 0x39, 226 => 0x41, 365 => 'player.movie.visual.brightness', 372 => 0x25, 374 => 0x54, 398 => 0x22, 411 => 0x2007, 468 => 'Brightness', 470 => 'Brightness' },
	'brightnessadj' => { 106 => 0x114, 257 => 0x0, 267 => 0x2d, 445 => 0x8018 },
	'brightnessvalue' => { 117 => 0x9203, 184 => [0x691,0x49c3], 293 => 0x1003, 416 => 0x1e, 419 => 0x1140, 420 => 0x1140, 421 => 0x111c, 422 => 0x1198, 423 => 0x1174, 424 => 0x102c, 425 => 0x224, 426 => 0x224, 427 => 0x219, 474 => 'BrightnessValue' },
	'buildnumber' => { 188 => 0x5500 },
	'bulbduration' => { 75 => 0x18 },
	'burstcount' => { 135 => 0x40d },
	'burstid' => { 451 => 'BurstID' },
	'burstmode' => { 137 => 0xa, 311 => 0x2a },
	'burstmode2' => { 137 => 0x18 },
	'burstprimary' => { 451 => 'BurstPrimary' },
	'burstshot' => { 388 => 0x34 },
	'burstspeed' => { 311 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 82 => 0x70a },
	'bwadjustment' => { 125 => 0x1049 },
	'bwfilter' => { 178 => 0x2a, 186 => 0x39 },
	'bwmode' => { 293 => 0x203 },
	'by-line' => { 129 => 0x50 },
	'by-linetitle' => { 129 => 0x55 },
	'bytecount' => { 484 => 'byteCount' },
	'c14configuration' => { 135 => 0x1964 },
	'cacheversion' => { 117 => 0xc7aa },
	'calibratedfocallength' => { 114 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 114 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 114 => 'CalibratedOpticalCenterY' },
	'calibration' => { 388 => [0x24,0x30] },
	'calibrationhistory' => { 135 => 0x9c9 },
	'calibrationilluminant1' => { 117 => 0xc65a },
	'calibrationilluminant2' => { 117 => 0xc65b },
	'calibrationversion' => { 135 => 0x9c6 },
	'callforimage' => { 458 => 'CallForImage' },
	'camera' => { 448 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 371 => 'angl', 494 => 'cameraAngle' },
	'cameraappinfo' => { 448 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 448 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 448 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 448 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 452 => 'CameraBurstID' },
	'cameracalibration' => { 388 => 0x11f },
	'cameracalibration1' => { 117 => 0xc623 },
	'cameracalibration2' => { 117 => 0xc624 },
	'cameracalibrationsig' => { 117 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 448 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 448 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 448 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 448 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 448 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 448 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 448 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 448 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 448 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 448 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 448 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 448 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 365 => 'direction.facing' },
	'camerae-mountversion' => { 444 => 0xb },
	'cameraelevationangle' => { 117 => 0x9405, 475 => 'CameraElevationAngle' },
	'camerafilename' => { 458 => 'CameraFilename' },
	'cameraid' => { 293 => 0x209, 371 => 'cmid', 387 => 0x209 },
	'cameraidentifier' => { 365 => 'camera.identifier' },
	'cameraimage' => { 448 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 448 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 448 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 448 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 448 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 448 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 448 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 448 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 448 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 448 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 448 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 448 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 448 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 448 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 117 => 0xc7a1, 494 => 'cameraLabel' },
	'cameralightestimate' => { 448 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 448 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 448 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 448 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 448 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 458 => 'CameraMakeModel' },
	'cameramodel' => { 355 => 0x410, 494 => 'cameraModel' },
	'cameramodelid' => { 173 => 'CameraModelID' },
	'cameramodelrestriction' => { 468 => 'CameraModelRestriction', 470 => 'CameraModelRestriction' },
	'cameramotion' => { 365 => 'direction.motion' },
	'cameramove' => { 494 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 311 => 0x8f, 350 => 0x1, 355 => 0x100, 404 => [0x16,0x18], 432 => 0x28, 433 => 0x24, 434 => 0x29 },
	'cameraowner' => { 138 => 0xc353 },
	'cameraparameters' => { 293 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 113 => 0x9, 371 => "\xa9gpt" },
	'camerapointcloud' => { 448 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 448 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 448 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 448 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 448 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 448 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 448 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 448 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 448 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 448 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 448 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 448 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 448 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 468 => 'CameraProfile', 470 => 'CameraProfile' },
	'cameraprofiledigest' => { 468 => 'CameraProfileDigest', 470 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 107 => 0xe1 },
	'camerarawcontrast' => { 107 => 0xe3 },
	'camerarawhighlightpoint' => { 107 => 0xe6 },
	'camerarawlinear' => { 107 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 107 => 0xe8 },
	'camerarawoutputshadowpoint' => { 107 => 0xe9 },
	'camerarawsaturation' => { 107 => 0xe2 },
	'camerarawshadowpoint' => { 107 => 0xe7 },
	'camerarawsharpness' => { 107 => 0xe5 },
	'cameraroll' => { 113 => 0xb, 371 => "\xa9grl" },
	'cameras' => { 448 => 'Cameras' },
	'cameraserialnumber' => { 117 => 0xc62f, 175 => 'CameraSerialNumber', 458 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 288 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 75 => 0xc, 135 => 0x406, 292 => 0x1306, 306 => 0x320, 313 => 0x3402, 346 => 0x47, 385 => 0x43, 436 => 0x5 },
	'cameratemperature4' => { 351 => 0x14 },
	'cameratemperature5' => { 351 => 0x16 },
	'cameratemperaturerangemax' => { 119 => 0x5 },
	'cameratemperaturerangemin' => { 119 => 0x6 },
	'cameratrait' => { 448 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 75 => 0x1a, 293 => 0x207 },
	'cameratype2' => { 289 => 0x100 },
	'cameravendorinfo' => { 448 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 448 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 448 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 448 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 113 => 0xa, 371 => "\xa9gyw" },
	'camreverse' => { 114 => 'CamReverse' },
	'canondr4' => { 118 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 95 => 0x805 },
	'canonfilelength' => { 62 => 0xe },
	'canonfirmwareversion' => { 62 => 0x7, 95 => 0x80b },
	'canonflashinfo' => { 95 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 62 => 0x6, 95 => 0x815 },
	'canonmodelid' => { 62 => 0x10, 95 => 0x1834 },
	'canonvrd' => { 118 => 'CanonVRD' },
	'caption' => { 463 => 'caption' },
	'caption-abstract' => { 129 => 0x78 },
	'captionsauthornames' => { 473 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 473 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 482 => 'CaptionWriter' },
	'captureframerate' => { 111 => 0x4001 },
	'captureheightnormal' => { 135 => 0x1839 },
	'capturelook' => { 135 => 0xc48 },
	'capturemode' => { 365 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 456 => 'CaptureSoftware' },
	'capturewidthnormal' => { 135 => 0x1838 },
	'capturewidthtest' => { 135 => 0x1842 },
	'cardshutterlock' => { 181 => 0x49 },
	'casioimagesize' => { 111 => 0x9 },
	'catalogsets' => { 129 => 0xff, 449 => 'CatalogSets', 461 => 'CatalogSets' },
	'categories' => { 62 => 0x23, 463 => 'categories' },
	'category' => { 129 => 0xf, 176 => 'WM/Category', 287 => 0x30, 363 => 'catg', 482 => 'Category' },
	'cbcrgain' => { 385 => 0xa036 },
	'cbcrgaindefault' => { 385 => 0xa035 },
	'cbcrmatrix' => { 385 => 0xa034 },
	'cbcrmatrixdefault' => { 385 => 0xa033 },
	'ccdboardversion' => { 306 => 0x331 },
	'ccdscanmode' => { 293 => 0x1039 },
	'ccdsensitivity' => { 254 => 0x6 },
	'ccdversion' => { 306 => 0x330 },
	'cellglobalid' => { 467 => 'cgi' },
	'celllength' => { 117 => 0x109 },
	'cellr' => { 467 => 'r' },
	'celltowerid' => { 467 => 'cellid' },
	'cellwidth' => { 117 => 0x108 },
	'centerafarea' => { 282 => '15.1' },
	'centerfocuspoint' => { 286 => '2.2' },
	'centerpixel' => { 135 => 0x40c },
	'centerweightedareasize' => { 271 => '7.1', 272 => '8.1', 274 => '8.1', 275 => '8.1', 279 => '7.1', 280 => '5.1', 281 => '7.1', 282 => '6.3', 284 => '8.1', 285 => '8.1', 286 => '8.1' },
	'certificate' => { 498 => 'Certificate' },
	'cfainterpolationalgorithm' => { 135 => 0xe60 },
	'cfainterpolationmetric' => { 135 => 0xe61 },
	'cfaoffsetcols' => { 135 => 0xc71 },
	'cfaoffsetrows' => { 135 => 0xc6f },
	'cfapattern' => { 117 => 0xa302, 316 => 0x9, 474 => 'CFAPattern' },
	'cfapattern2' => { 117 => 0x828e },
	'cfapatterncolumns' => { 474 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 474 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 474 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 117 => 0x828d },
	'cfazipperfixthreshold' => { 135 => 0xe62 },
	'channel' => { 484 => 'channel' },
	'channela-lang' => { 484 => [\'channel','channelA-lang'] },
	'channelchannel' => { 484 => [\'channel','channelChannel'] },
	'channels' => { 152 => 'Channels' },
	'channelsubchannel1' => { 484 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 484 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 484 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 484 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 371 => 'chpl' },
	'checkmark' => { 101 => 0x10101, 106 => 0x26a },
	'checkmark2' => { 107 => 0x8e },
	'childfontfiles' => { 499 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 271 => '10.3', 272 => '11.2' },
	'chromablurradius' => { 117 => 0xc631 },
	'chromanoisecolorspace' => { 135 => 0xe6d },
	'chromanoiseedgemapthresh' => { 135 => 0xe6c },
	'chromanoisehighfthresh' => { 135 => 0xe6a },
	'chromanoiselowfthresh' => { 135 => 0xe6b },
	'chromaticaberration' => { 101 => 0x20703, 107 => 0x66, 385 => 0xa051 },
	'chromaticaberrationb' => { 468 => 'ChromaticAberrationB', 470 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 101 => 0x20708, 107 => 0x6b },
	'chromaticaberrationcorr' => { 77 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 117 => 0x7034, 336 => 0x1, 445 => 0x900d },
	'chromaticaberrationcorrparams' => { 117 => 0x7035, 440 => 0x66a, 441 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 101 => '0x20703.0', 107 => 0x62 },
	'chromaticaberrationr' => { 468 => 'ChromaticAberrationR', 470 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 101 => 0x20707, 107 => 0x6a },
	'chromaticaberrationsetting' => { 78 => 0x6 },
	'chrominancenoisereduction' => { 101 => 0x20601, 107 => 0x5e, 388 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 107 => 0x60 },
	'circadatecreated' => { 480 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue','CircularGradientBasedCorrectionsLocalToningHue'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskcoloramount' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemasklumfeather' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemasklummax' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasktype' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 468 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 470 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 468 => 'CircularGradientBasedCorrections', 470 => 'CircularGradientBasedCorrections' },
	'city' => { 129 => 0x5a, 158 => 'City', 311 => 0x6d, 482 => 'City' },
	'city2' => { 311 => 0x80 },
	'clarity' => { 225 => 0x35, 226 => 0x3d, 411 => 0x2036, 468 => 'Clarity', 470 => 'Clarity' },
	'clarity2012' => { 468 => 'Clarity2012', 470 => 'Clarity2012' },
	'claritycontrol' => { 346 => 0x96 },
	'classification' => { 371 => 'clsf' },
	'classifystate' => { 129 => 0xe1 },
	'clearretouch' => { 311 => 0x7c },
	'clearretouchvalue' => { 311 => 0xa3 },
	'client' => { 494 => 'client' },
	'clientname' => { 476 => 'ClientName' },
	'clipboardaspectratio' => { 468 => 'ClipboardAspectRatio', 470 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 468 => 'ClipboardOrientation', 470 => 'ClipboardOrientation' },
	'clipfilename' => { 371 => 'clfn' },
	'clipid' => { 371 => 'clid' },
	'clmodeshootingspeed' => { 271 => '10.2', 272 => '11.3', 274 => '11.2', 275 => '11.2', 280 => '11.2', 281 => '10.2', 284 => '11.2', 285 => '11.2', 286 => '11.1' },
	'cluster' => { 468 => 'Cluster', 470 => 'Cluster' },
	'cmcontrast' => { 296 => 0x2022 },
	'cmexposurecompensation' => { 296 => 0x2000 },
	'cmhue' => { 296 => 0x2021 },
	'cmsaturation' => { 296 => 0x2020 },
	'cmsharpness' => { 296 => 0x2023 },
	'cmwhitebalance' => { 296 => 0x2001 },
	'cmwhitebalancecomp' => { 296 => 0x2002 },
	'cmwhitebalancegraypoint' => { 296 => 0x2010 },
	'codec' => { 166 => 'Codec' },
	'codedcharacterset' => { 130 => 0x5a },
	'codeversion' => { 371 => 'cver' },
	'collection' => { 301 => 'Collection' },
	'collectionname' => { 167 => [\'Collections','CollectionsCollectionName'], 371 => 'coll' },
	'collections' => { 167 => 'Collections', 463 => 'collections' },
	'collectionuri' => { 167 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 365 => 'player.movie.visual.color', 483 => 'color' },
	'coloraberrationcontrol' => { 264 => 0xc89224b },
	'coloradjustment' => { 388 => 0x14 },
	'coloradjustmentmode' => { 387 => 0x210 },
	'coloranta' => { 499 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 499 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 499 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 499 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 499 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 499 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 499 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 499 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 499 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 499 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 499 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 499 => 'Colorants' },
	'colorantswatchname' => { 499 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 499 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 499 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 499 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 153 => 'ColorBalance' },
	'colorbalanceadj' => { 264 => 0x76a43202 },
	'colorbalanceblue' => { 178 => 0x1e },
	'colorbalancegreen' => { 178 => 0x1d },
	'colorbalancered' => { 178 => 0x1c },
	'colorbalanceversion' => { 199 => 0x4, 200 => 0x4, 201 => 0x0 },
	'colorblur' => { 107 => 0x65 },
	'colorbluron' => { 101 => 0x20704 },
	'colorbooster' => { 264 => 0x5f0e7d23 },
	'colorboostlevel' => { 258 => 0x1 },
	'colorboosttype' => { 258 => 0x0 },
	'colorchromeeffect' => { 125 => 0x1048 },
	'colorchromefxblue' => { 125 => 0x104e },
	'colorclass' => { 357 => 0xde, 358 => 'ColorClass' },
	'colorcompensationfilter' => { 181 => [0x3a,0x5f], 183 => 0x111, 411 => 0xb022 },
	'colorcompensationfiltercustom' => { 398 => 0xd, 399 => 0xc },
	'colorcompensationfilterset' => { 398 => 0x8, 399 => 0x7, 400 => 0x18, 416 => 0xf },
	'colorcontrol' => { 293 => 0x102b },
	'colorcorrection' => { 445 => 0x8015 },
	'colorcreatoreffect' => { 288 => 0x532 },
	'colordataversion' => { 41 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0 },
	'coloreffect' => { 311 => 0x28 },
	'colorfilter' => { 110 => 0x17, 111 => 0x3017, 178 => 0x29, 186 => [0x38,0x4d,0x4f], 353 => 0x17 },
	'colorgain' => { 230 => 0x51 },
	'colorgradeblending' => { 468 => 'ColorGradeBlending', 470 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 468 => 'ColorGradeGlobalHue', 470 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 468 => 'ColorGradeGlobalLum', 470 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 468 => 'ColorGradeGlobalSat', 470 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 468 => 'ColorGradeHighlightLum', 470 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 468 => 'ColorGradeMidtoneHue', 470 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 468 => 'ColorGradeMidtoneLum', 470 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 468 => 'ColorGradeMidtoneSat', 470 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 468 => 'ColorGradeShadowLum', 470 => 'ColorGradeShadowLum' },
	'colorhue' => { 101 => 0x20900, 222 => 0x8d },
	'colorimetricreference' => { 117 => 0xc6bf },
	'colorlabel' => { 473 => 'ColorLabel' },
	'colormatrix' => { 292 => 0x200, 293 => 0x1011, 385 => 0xa030 },
	'colormatrix1' => { 117 => 0xc621, 355 => 0x106 },
	'colormatrix2' => { 117 => 0xc622, 296 => 0x200, 355 => 0x226 },
	'colormatrixa' => { 346 => 0x203 },
	'colormatrixa2' => { 346 => 0x21c },
	'colormatrixadobergb' => { 385 => 0xa032 },
	'colormatrixb' => { 346 => 0x204 },
	'colormatrixb2' => { 346 => 0x21d },
	'colormatrixnumber' => { 293 => 0x1019 },
	'colormatrixsrgb' => { 385 => 0xa031 },
	'colormode' => { 111 => 0x3015, 125 => 0x1210, 137 => 0x66, 178 => 0x28, 181 => 0x16, 183 => 0x101, 184 => 0x36, 186 => 0x7, 222 => 0x3, 254 => 0x4, 311 => 0x32, 388 => 0x2c, 411 => 0xb029, 482 => 'ColorMode' },
	'colormoirereduction' => { 101 => 0x20670, 265 => 0x15 },
	'colormoirereductionmode' => { 265 => 0x5 },
	'colormoirereductionon' => { 101 => '0x20670.0' },
	'colornoisereduction' => { 445 => 0x8029, 468 => 'ColorNoiseReduction', 470 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 468 => 'ColorNoiseReductionDetail', 470 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 265 => 0x18 },
	'colornoisereductionsharpness' => { 265 => 0x1c },
	'colornoisereductionsmoothness' => { 468 => 'ColorNoiseReductionSmoothness', 470 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 121 => 0x2 },
	'colorprofile' => { 178 => 0x33 },
	'colorprofilesettings' => { 288 => 0x539 },
	'colorrepresentation' => { 131 => 0x3c },
	'colorsaturationadj' => { 101 => 0x20305 },
	'colorsequence' => { 131 => 0x41 },
	'colorspace' => { 50 => 0x3, 62 => 0xb4, 95 => 0x10b4, 117 => 0xa001, 159 => 'ColorSpace', 179 => 0x2f, 180 => 0x25, 181 => 0x17, 222 => 0x1e, 288 => 0x507, 346 => 0x37, 385 => 0xa011, 388 => 0xb, 398 => 0x1b, 399 => 0x83, 400 => 0xe, 416 => 0x6, 474 => 'ColorSpace' },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x26, 43 => 0x43, 46 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x1c, 43 => 0x48, 46 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0x35, 43 => 0x5c, 46 => 0x75, 47 => 0x8e, 48 => 0x93, 49 => 0x96, 346 => 0x55 },
	'colortempcustom' => { 43 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0x2b, 43 => 0x52, 46 => 0x6b, 47 => 0x84, 48 => 0x89, 49 => 0x8c, 346 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 62 => 0xae, 72 => 0x9, 95 => 0x10ae, 125 => 0x1005, 135 => 0x846, 153 => 'ColorTemperature', 179 => [0x6e,0x49], 180 => 0x3f, 181 => [0x39,0x5e], 183 => 0x10b, 186 => [0x3c,0x4c,0x4e], 306 => 0x321, 346 => 0x50, 378 => 0x1308, 411 => 0xb021, 468 => 'Temperature', 470 => 'Temperature' },
	'colortemperatureadj' => { 445 => 0x8013 },
	'colortemperatureauto' => { 222 => 0x4f },
	'colortemperaturebg' => { 293 => 0x1013 },
	'colortemperaturecustom' => { 398 => 0xc, 399 => 0xb },
	'colortemperaturerg' => { 293 => 0x1014 },
	'colortemperatureset' => { 398 => 0x7, 399 => 0x6 },
	'colortemperaturesetting' => { 181 => 0x25, 400 => 0x17, 416 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0x49, 43 => 0x70, 46 => 0x89, 47 => 0xa2, 48 => 0xa7, 49 => 0xaa, 346 => 0x5a },
	'colortempflashdata' => { 43 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0x3f, 43 => 0x66, 46 => 0x7f, 47 => 0x98, 48 => 0x9d, 49 => 0xa0 },
	'colortempfluorescentd' => { 346 => 0x57 },
	'colortempfluorescentn' => { 346 => 0x58 },
	'colortempfluorescentw' => { 346 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0x44, 43 => 0x6b, 46 => 0x84, 47 => 0x9d, 48 => 0xa2, 49 => 0xa5, 311 => 0x44, 378 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 43 => 0x4d, 46 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x55 },
	'colortemppc1' => { 42 => 0x94, 43 => 0x75 },
	'colortemppc2' => { 42 => 0x99, 43 => 0x7a },
	'colortemppc3' => { 42 => 0x9e, 43 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0x30, 43 => 0x57, 46 => 0x70, 47 => 0x89, 48 => 0x8e, 49 => 0x91, 346 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0x3a, 43 => 0x61, 46 => 0x7a, 47 => 0x93, 48 => 0x98, 49 => 0x9b, 346 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x21, 46 => 0x52, 47 => 0x52, 48 => 0x52, 49 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0x76, 46 => 0xa2, 47 => 0x7f, 48 => 0x7f, 49 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => 0x7b, 46 => 0xa7, 47 => 0xa7, 48 => 0x84, 49 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0x80, 46 => 0xac, 47 => 0xac, 48 => 0xac, 49 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0x85, 46 => 0xb1, 47 => 0xb1, 48 => 0xb1, 49 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0x8a, 46 => 0xb6, 47 => 0xb6, 48 => 0xb6, 49 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0x8f, 46 => 0xbb, 47 => 0xbb, 48 => 0xbb, 49 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xa3, 47 => 0xc0, 48 => 0xc0, 49 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 47 => 0xc5, 48 => 0xc5, 49 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 47 => 0xca, 48 => 0xca, 49 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 47 => 0xcf, 48 => 0xcf, 49 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x4e, 46 => 0x57, 47 => 0x57, 48 => 0x57, 49 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 47 => 0xd4, 48 => 0xd4, 49 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 48 => 0xd9, 49 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 48 => 0xde, 49 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 48 => 0xe3, 49 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 48 => 0xe8, 49 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 48 => 0xed, 49 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 48 => 0xf2, 49 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 48 => 0xf7, 49 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 48 => 0xfc, 49 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 48 => 0x101, 49 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x53, 46 => 0x5c, 47 => 0x5c, 48 => 0x5c, 49 => 0x64 },
	'colortempunknown30' => { 48 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x58, 46 => 0x61, 47 => 0x61, 48 => 0x61, 49 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x5d, 46 => 0x66, 47 => 0x66, 48 => 0x66, 49 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x62, 46 => 0x8e, 47 => 0x6b, 48 => 0x6b, 49 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x67, 46 => 0x93, 47 => 0x70, 48 => 0x70, 49 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x6c, 46 => 0x98, 47 => 0x75, 48 => 0x75, 49 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0x71, 46 => 0x9d, 47 => 0x7a, 48 => 0x7a, 49 => 0x82 },
	'colortint' => { 310 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 50 => 0x2 },
	'colortoneadj' => { 101 => 0x20304, 106 => 0x11e },
	'colortoneauto' => { 69 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 68 => 0x6c, 69 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 68 => 0x3c, 69 => 0x3c },
	'colortonemonochrome' => { 68 => 0x84, 69 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 68 => 0x54, 69 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 68 => 0x24, 69 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 68 => 0xc, 69 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 68 => 0x9c, 69 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 68 => 0xb4, 69 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 68 => 0xcc, 69 => 0xe4 },
	'comlenblksize' => { 135 => 0xfde8 },
	'commanddials' => { 282 => '5.1' },
	'commanddialsaperturesetting' => { 271 => '17.3', 272 => '18.3', 274 => '18.3', 275 => '18.3', 280 => '33.3', 281 => '17.3', 284 => '18.3', 285 => '18.3' },
	'commanddialschangemainsub' => { 271 => '17.2', 272 => '18.1', 274 => '18.1', 275 => '18.1', 280 => '33.2', 281 => '17.2', 284 => '18.1', 285 => '18.1' },
	'commanddialsmenuandplayback' => { 271 => '17.4', 272 => '18.2', 274 => '18.2', 275 => '18.2', 280 => '33.4', 281 => '17.4', 284 => '18.2', 285 => '18.2' },
	'commanddialsreverserotation' => { 271 => '17.1', 272 => '6.4', 274 => '6.2', 275 => '6.2', 276 => '16.2', 277 => '17.2', 280 => '33.1', 281 => '17.1', 284 => '6.2', 285 => '6.2', 286 => '18.1' },
	'commanderchannel' => { 282 => '10.2', 283 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 282 => '13.1', 283 => '31.1' },
	'commandergroupa_ttlcomp' => { 286 => '32.1' },
	'commandergroupamanualoutput' => { 282 => '13.2', 283 => '28.2' },
	'commandergroupamode' => { 282 => '11.2', 283 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 282 => '14.1', 283 => '32.1' },
	'commandergroupb_ttlcomp' => { 286 => '33.1' },
	'commandergroupbmanualoutput' => { 282 => '14.2', 283 => '29.2' },
	'commandergroupbmode' => { 282 => '11.3', 283 => '29.1' },
	'commanderinternalflash' => { 282 => '11.1', 283 => '27.1' },
	'commanderinternalmanualoutput' => { 282 => '12.2', 283 => '27.2' },
	'commanderinternalttlchannel' => { 280 => '18.2' },
	'commanderinternalttlcomp' => { 282 => '12.1', 283 => '30.2', 286 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 280 => '20.1', 281 => '26.1' },
	'commanderinternalttlcompgroupa' => { 280 => '21.1', 281 => '27.1' },
	'commanderinternalttlcompgroupb' => { 280 => '22.1', 281 => '28.1' },
	'comment' => { 0 => 0x2, 118 => 'Comment', 154 => 'Comment', 301 => 'Comment', 363 => "\xa9cmt", 365 => 'comment', 371 => "\xa9cmt" },
	'compass' => { 381 => 0x4 },
	'compilation' => { 363 => 'cpil' },
	'compimageimagespersequence' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 475 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 484 => 'complianceProfile' },
	'componentsconfiguration' => { 117 => 0x9101, 159 => 'Components', 474 => 'ComponentsConfiguration' },
	'componentversion' => { 95 => 0x80c },
	'composer' => { 176 => 'WM/Composer', 363 => ["\xa9com","\xa9wrt"], 371 => ["\xa9com","\xa9wrt"], 494 => 'composer' },
	'composerkeywords' => { 371 => "\xa9cok" },
	'compositeimage' => { 117 => 0xa460, 475 => 'CompositeImage' },
	'compositeimagecount' => { 117 => 0xa461, 475 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 117 => 0xa462, 475 => 'CompositeImageExposureTimes' },
	'composition' => { 458 => 'Composition' },
	'compositionadjust' => { 345 => '0.1' },
	'compositionadjustrotation' => { 345 => 0x7 },
	'compositionadjustx' => { 345 => 0x5 },
	'compositionadjusty' => { 345 => 0x6 },
	'compressedbitsperpixel' => { 117 => 0x9102, 474 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 183 => 0x40, 293 => 0x40 },
	'compression' => { 117 => 0x103, 316 => 0xb, 490 => 'Compression' },
	'compressionfactor' => { 288 => 0x50d },
	'compressionratio' => { 159 => 'Compression', 293 => 0x1034 },
	'compressorversion' => { 371 => 'CNCV' },
	'condadobvfactor' => { 135 => 0xf3e },
	'condadodaybvthresh' => { 135 => 0xf3c },
	'condadodayoffsets' => { 135 => 0xf42 },
	'condadofluoffsets' => { 135 => 0xf44 },
	'condadofluthresh' => { 135 => 0xf41 },
	'condadoillfactor' => { 135 => 0xf3f },
	'condadoneurange' => { 135 => 0xf3d },
	'condadotunoffsets' => { 135 => 0xf43 },
	'condadotunthresh' => { 135 => 0xf40 },
	'conductor' => { 176 => 'WM/Conductor', 363 => "\xa9con" },
	'confidence' => { 453 => 'Confidence' },
	'confidencelevel' => { 464 => 'ConfidenceLevel' },
	'confidencemime' => { 453 => 'ConfidenceMime' },
	'constrainedcropheight' => { 106 => 0x266, 357 => 0xd6 },
	'constrainedcropwidth' => { 106 => 0x262, 357 => 0xd5 },
	'contact' => { 129 => 0x76 },
	'contactinfo' => { 468 => 'ContactInfo', 470 => 'ContactInfo', 483 => 'contactInfo' },
	'container' => { 448 => 'Container' },
	'containerdirectory' => { 448 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 448 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 448 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 448 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 448 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 448 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 480 => 'ContainerFormat' },
	'containerformatidentifier' => { 480 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 480 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 363 => "\xa9day", 371 => ['@day',"\xa9day"] },
	'contentdistributor' => { 176 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 371 => 'cdis' },
	'contentid' => { 371 => 'ccid' },
	'contentlocationcode' => { 129 => 0x1a },
	'contentlocationname' => { 129 => 0x1b },
	'contenttype' => { 484 => 'contentType' },
	'continuousbracketing' => { 181 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodeliveview' => { 285 => '77.2' },
	'continuousshootingspeed' => { 82 => 0x610 },
	'continuousshotlimit' => { 82 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 110 => 0xc, 111 => [0x3012,0x20], 117 => [0xa408,0xfe54], 125 => [0x1004,0x1006], 153 => 'Contrast', 173 => 'Contrast', 178 => 0x20, 179 => 0x31, 180 => 0x27, 181 => 0x19, 186 => 0x2, 224 => 0x33, 225 => 0x37, 226 => 0x3f, 293 => 0x1029, 311 => 0x39, 313 => 0x300a, 346 => 0x20, 353 => 0xc, 365 => 'player.movie.visual.contrast', 372 => 0x24, 374 => 0x52, 378 => 0x1012, 388 => 0xd, 398 => 0x1d, 399 => 0x1a, 411 => 0x2004, 468 => 'Contrast', 470 => 'Contrast', 474 => 'Contrast' },
	'contrast2012' => { 468 => 'Contrast2012', 470 => 'Contrast2012' },
	'contrastadj' => { 101 => 0x20303, 106 => 0x115, 267 => 0x2c, 445 => 0x8017 },
	'contrastauto' => { 69 => 0x90 },
	'contrastcurve' => { 222 => 0x8c },
	'contrastdetectaf' => { 190 => 0x4 },
	'contrastdetectafarea' => { 346 => 0x231 },
	'contrastdetectafinfocus' => { 190 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 68 => 0x60, 69 => 0x60 },
	'contrasthighlight' => { 346 => 0x6d },
	'contrasthighlightshadowadj' => { 346 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 68 => 0x30, 69 => 0x30 },
	'contrastmode' => { 311 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 68 => 0x78, 69 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 68 => 0x48, 69 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 68 => 0x18, 69 => 0x18 },
	'contrastsetting' => { 288 => 0x505, 296 => 0x1012, 400 => 0x10, 416 => 0x8 },
	'contrastshadow' => { 346 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 68 => 0x0, 69 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 68 => 0x90, 69 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 68 => 0xa8, 69 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 68 => 0xc0, 69 => 0xd8 },
	'contributedmedia' => { 494 => 'contributedMedia' },
	'contributedmediaduration' => { 494 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 494 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 494 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 494 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 494 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 494 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 494 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 494 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 494 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 494 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 471 => 'contributor', 480 => 'Contributor' },
	'contributoridentifier' => { 480 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 480 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 480 => [\'Contributor','ContributorRole'] },
	'contributors' => { 154 => 'Contributors' },
	'controldialset' => { 181 => 0x46 },
	'controlledvocabularyterm' => { 480 => 'CVterm' },
	'controllerboardversion' => { 306 => 0x332 },
	'controlmode' => { 75 => 0x12 },
	'controlringrotation' => { 82 => 0x712 },
	'conversionlens' => { 289 => 0x403, 311 => 0x35 },
	'converter' => { 117 => 0xfe4d, 254 => 0xb, 468 => 'Converter', 470 => 'Converter' },
	'converttograyscale' => { 468 => 'ConvertToGrayscale', 470 => 'ConvertToGrayscale' },
	'cookingequipment' => { 486 => 'cookingEquipment' },
	'cookingmethod' => { 486 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 117 => 0x8298, 154 => 'Copyright', 301 => 'Copyright', 346 => 0x22f, 362 => 'Copyright', 363 => ['cprt',"\xa9cpy"], 365 => 'copyright', 371 => ['cprt',"\xa9cpy"], 468 => 'Copyright', 470 => 'Copyright', 481 => 'Copyright', 487 => 'copyright', 490 => 'Copyright', 494 => 'copyright' },
	'copyrightflag' => { 360 => 0x40a },
	'copyrightnotice' => { 129 => 0x74 },
	'copyrightowner' => { 298 => 'CopyrightOwner' },
	'copyrightownerid' => { 298 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 298 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 298 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 298 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 298 => 'CopyrightStatus' },
	'copyrightyear' => { 480 => 'CopyrightYear', 484 => 'copyrightYear' },
	'coringfilter' => { 292 => 0x310, 293 => 0x102d, 296 => 0x310 },
	'coringvalues' => { 292 => 0x311, 296 => 0x311 },
	'corporateentity' => { 484 => 'corporateEntity' },
	'correlatedcolortemp' => { 310 => 0x35b },
	'country' => { 158 => 'Country', 311 => 0x69, 482 => 'Country' },
	'country-primarylocationcode' => { 129 => 0x64 },
	'country-primarylocationname' => { 129 => 0x65 },
	'countrycode' => { 221 => 0x5, 358 => 'CountryCode', 479 => 'CountryCode' },
	'course' => { 486 => 'course' },
	'coverage' => { 471 => 'coverage' },
	'coverart' => { 363 => 'covr' },
	'coverdate' => { 484 => 'coverDate' },
	'coverdisplaydate' => { 484 => 'coverDisplayDate' },
	'coveruri' => { 371 => 'cvru' },
	'cpufirmwareversion' => { 346 => 0x28 },
	'crc32' => { 472 => 'crc32' },
	'createdate' => { 117 => 0x9004, 154 => 'CreateDate', 297 => 'CreationDate', 301 => 'create-date', 362 => 'CreationDate', 368 => 0x1, 492 => 'CreateDate' },
	'creationdate' => { 365 => 'creationdate', 481 => 'CreationDate', 484 => 'creationDate' },
	'creationtime' => { 301 => 'Creation Time' },
	'creativestyle' => { 398 => 0x1a, 399 => 0x18, 409 => 0x41, 411 => 0xb020, 441 => 0x4a },
	'creativestylesetting' => { 400 => 0xf, 416 => 0x7 },
	'creativestylewaschanged' => { 445 => 0x8001 },
	'creator' => { 297 => 'Creator', 362 => 'Creator', 471 => 'creator', 480 => 'Creator', 481 => 'Creator' },
	'creatoraddress' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 175 => 'CreatorAppId' },
	'creatorcity' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 479 => 'CreatorContactInfo' },
	'creatorcountry' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 480 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 480 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 175 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 480 => [\'Creator','CreatorRole'] },
	'creatortool' => { 492 => 'CreatorTool' },
	'creatorworkemail' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 479 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 129 => 0x6e, 482 => 'Credit' },
	'creditline' => { 487 => 'creditLine' },
	'creditlinereq' => { 497 => 'CreditLineReq' },
	'creditlinerequired' => { 298 => 'CreditLineRequired' },
	'cropactive' => { 99 => 0x0, 106 => 0x244 },
	'cropangle' => { 468 => 'CropAngle', 470 => 'CropAngle' },
	'croparea' => { 222 => 0x45, 445 => 0x9011 },
	'cropaspectratio' => { 101 => 0x30101, 106 => 0x260 },
	'cropaspectratiocustom' => { 101 => 0x30102 },
	'cropbottom' => { 121 => 0x9, 259 => 0x36, 316 => 0x31, 357 => 0xdc, 468 => 'CropBottom', 470 => 'CropBottom' },
	'cropbottommargin' => { 52 => 0x3 },
	'cropcircleactive' => { 107 => 0xd6 },
	'cropcircleradius' => { 107 => 0xd9 },
	'cropcirclex' => { 107 => 0xd7 },
	'cropcircley' => { 107 => 0xd8 },
	'cropconstraintowarp' => { 468 => 'CropConstrainToWarp', 470 => 'CropConstrainToWarp' },
	'croph' => { 462 => 'CropH' },
	'cropheight' => { 99 => 0x6, 106 => 0x24c, 292 => 0x615, 296 => 0x615, 468 => 'CropHeight', 470 => 'CropHeight' },
	'crophispeed' => { 222 => 0x1b },
	'cropleft' => { 106 => 0x246, 121 => 0x6, 259 => 0x1e, 292 => 0x612, 296 => 0x612, 316 => 0x30, 357 => 0xd9, 468 => 'CropLeft', 470 => 'CropLeft' },
	'cropleftmargin' => { 52 => 0x0 },
	'cropmode' => { 125 => 0x104d, 378 => 0x1018 },
	'croporiginalheight' => { 99 => 0xb },
	'croporiginalwidth' => { 99 => 0xa },
	'cropoutputheight' => { 259 => 0xce },
	'cropoutputheightinches' => { 259 => 0x96 },
	'cropoutputpixels' => { 259 => 0xd6 },
	'cropoutputresolution' => { 259 => 0xb6 },
	'cropoutputscale' => { 259 => 0xbe },
	'cropoutputwidth' => { 259 => 0xc6 },
	'cropoutputwidthinches' => { 259 => 0x8e },
	'croppedareaimageheightpixels' => { 456 => 'CroppedAreaImageHeightPixels', 457 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 456 => 'CroppedAreaImageWidthPixels', 457 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 456 => 'CroppedAreaLeftPixels', 457 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 456 => 'CroppedAreaTopPixels', 457 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 378 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 378 => 0x1603 },
	'cropping' => { 445 => 0x9010 },
	'cropright' => { 121 => 0x8, 259 => 0x2e, 316 => 0x32, 357 => 0xdb, 468 => 'CropRight', 470 => 'CropRight' },
	'croprightmargin' => { 52 => 0x1 },
	'croprotatedoriginalheight' => { 99 => 0x2 },
	'croprotatedoriginalwidth' => { 99 => 0x1 },
	'croprotation' => { 99 => 0x8, 121 => 0xb },
	'cropscaledresolution' => { 259 => 0x9e },
	'cropsourceresolution' => { 259 => 0xae },
	'croptop' => { 106 => 0x248, 121 => 0x7, 259 => 0x26, 292 => 0x613, 296 => 0x613, 316 => 0x2f, 357 => 0xda, 468 => 'CropTop', 470 => 'CropTop' },
	'croptopmargin' => { 52 => 0x2 },
	'cropunit' => { 468 => 'CropUnit', 470 => 'CropUnit' },
	'cropunits' => { 468 => 'CropUnits', 470 => 'CropUnits' },
	'cropw' => { 462 => 'CropW' },
	'cropwidth' => { 99 => 0x5, 106 => 0x24a, 292 => 0x614, 296 => 0x614, 468 => 'CropWidth', 470 => 'CropWidth' },
	'cropx' => { 99 => 0x3, 462 => 'CropX' },
	'cropy' => { 99 => 0x4, 462 => 'CropY' },
	'crossprocess' => { 346 => 0x7b },
	'crossprocessparams' => { 346 => 0x235 },
	'cuisine' => { 486 => 'cuisine' },
	'currenticcprofile' => { 117 => 0xc691 },
	'currentpreprofilematrix' => { 117 => 0xc692 },
	'currentversion' => { 445 => 0xd000 },
	'curve0x' => { 462 => 'Curve0x' },
	'curve0y' => { 462 => 'Curve0y' },
	'curve1x' => { 462 => 'Curve1x' },
	'curve1y' => { 462 => 'Curve1y' },
	'curve2x' => { 462 => 'Curve2x' },
	'curve2y' => { 462 => 'Curve2y' },
	'curve3x' => { 462 => 'Curve3x' },
	'curve3y' => { 462 => 'Curve3y' },
	'curve4x' => { 462 => 'Curve4x' },
	'curve4y' => { 462 => 'Curve4y' },
	'curves' => { 264 => 0x76a43201 },
	'custom1' => { 298 => 'Custom1' },
	'custom10' => { 298 => 'Custom10' },
	'custom2' => { 298 => 'Custom2' },
	'custom3' => { 298 => 'Custom3' },
	'custom4' => { 298 => 'Custom4' },
	'custom5' => { 298 => 'Custom5' },
	'custom6' => { 298 => 'Custom6' },
	'custom7' => { 298 => 'Custom7' },
	'custom8' => { 298 => 'Custom8' },
	'custom9' => { 298 => 'Custom9' },
	'customcolortone' => { 107 => 0x4c },
	'customcontrast' => { 107 => 0x4e },
	'customcontrols' => { 82 => 0x70c },
	'customdefaultunsharpfineness' => { 107 => 0xbe },
	'customdefaultunsharpstrength' => { 107 => 0xbc },
	'customdefaultunsharpthreshold' => { 107 => 0xc0 },
	'customilluminant' => { 135 => 0x405 },
	'customizedials' => { 82 => 0x715 },
	'customlinear' => { 107 => 0x4f },
	'customoutputhighlightpoint' => { 107 => 0x53 },
	'customoutputshadowpoint' => { 107 => 0x54 },
	'custompicturestyle' => { 101 => 0x10021 },
	'custompicturestyledata' => { 101 => 0xf0500 },
	'custompicturestylefilename' => { 62 => 0x4010 },
	'customrawhighlight' => { 107 => 0x7c },
	'customrawhighlightpoint' => { 107 => 0x51 },
	'customrawshadow' => { 107 => 0x85 },
	'customrawshadowpoint' => { 107 => 0x52 },
	'customrendered' => { 117 => 0xa401, 474 => 'CustomRendered' },
	'customsaturation' => { 107 => 0x4d, 288 => 0x503 },
	'customsettingsalldefault' => { 271 => '0.2', 280 => '0.2' },
	'customsettingsbank' => { 271 => '0.1', 272 => '0.1', 274 => '0.1', 275 => '0.1', 280 => '0.1', 284 => '0.2', 285 => '0.2' },
	'customsharpness' => { 107 => 0x50 },
	'customunsharpmaskfineness' => { 107 => 0xb8 },
	'customunsharpmaskstrength' => { 107 => 0xb6 },
	'customunsharpmaskthreshold' => { 107 => 0xba },
	'customwb_rblevels' => { 416 => 0x1a },
	'customwb_rgblevels' => { 399 => 0x8, 400 => 0x19 },
	'customwbbluelevel' => { 181 => 0x36 },
	'customwberror' => { 181 => 0x37 },
	'customwbgreenlevel' => { 181 => 0x35 },
	'customwbredlevel' => { 181 => 0x34 },
	'customwbsetting' => { 181 => 0x26 },
	'cx' => { 371 => '_cx_' },
	'cy' => { 371 => '_cy_' },
	'd-lightinghq' => { 264 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 260 => 0x2 },
	'd-lightinghqhighlight' => { 260 => 0x1 },
	'd-lightinghqselected' => { 264 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 260 => 0x0 },
	'd-lightinghs' => { 264 => 0xce5554aa },
	'd-lightinghsadjustment' => { 261 => 0x0 },
	'd-lightinghscolorboost' => { 261 => 0x1 },
	'd-rangeoptimizerhighlight' => { 445 => 0x8024 },
	'd-rangeoptimizermode' => { 445 => 0x8022 },
	'd-rangeoptimizershadow' => { 445 => 0x802d },
	'd-rangeoptimizervalue' => { 445 => 0x8023 },
	'darkblacksegrows' => { 135 => 0x18d8 },
	'darkfocusenvironment' => { 311 => 0x8003 },
	'darkframecountfactor' => { 135 => 0xc85 },
	'darkframelongexposure' => { 135 => 0xc84 },
	'darkframeshortexposure' => { 135 => 0xc83 },
	'darkpedestal' => { 135 => 0xc7f },
	'datacompressionmethod' => { 131 => 0x6e },
	'dataimprint' => { 178 => 0x34 },
	'dataonscreen' => { 480 => 'DataOnScreen' },
	'dataonscreenregion' => { 480 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 480 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 480 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 480 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 480 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 480 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 480 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 480 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 346 => 0x3d },
	'date' => { 346 => 0x6, 471 => 'date' },
	'dateacquired' => { 175 => 'DateAcquired', 176 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 129 => 0x37, 482 => 'DateCreated' },
	'datedisplayformat' => { 256 => 0x3 },
	'dateidentified' => { 116 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 276 => '4.2' },
	'daterecieved' => { 484 => 'dateRecieved' },
	'datesent' => { 130 => 0x46 },
	'datestampmode' => { 62 => 0x1c, 222 => 0x9d },
	'datetime' => { 463 => 'datetime', 490 => 'DateTime' },
	'datetimedigitized' => { 474 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 98 => 0x0, 117 => 0x9003, 151 => 0x14, 154 => 'OriginalDate', 366 => 'IDIT', 371 => 'date', 372 => 0xb, 373 => 0x3b, 374 => 0x3e, 474 => 'DateTimeOriginal' },
	'datetimestamp' => { 137 => 0x64 },
	'datetimeutc' => { 288 => 0x908 },
	'daylightsavings' => { 76 => 0x3, 256 => 0x2 },
	'dayofweek' => { 373 => 0x42, 374 => 0x4a },
	'dccontinent' => { 116 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 116 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 116 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 116 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 116 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 116 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 116 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 116 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 116 => 'Event' },
	'dcfootprintspatialfit' => { 116 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 116 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 116 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 116 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 116 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 116 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 116 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 116 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 116 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 116 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 116 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 116 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 116 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 116 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 116 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 116 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 116 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 116 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 116 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 116 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 116 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 116 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 116 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 116 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 116 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 116 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 116 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 116 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 116 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 116 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 162 => 'Declination' },
	'decposition' => { 178 => 0x32 },
	'defaultautogray' => { 468 => 'DefaultAutoGray', 470 => 'DefaultAutoGray' },
	'defaultautotone' => { 468 => 'DefaultAutoTone', 470 => 'DefaultAutoTone' },
	'defaultblackrender' => { 117 => 0xc7a6 },
	'defaultcroporigin' => { 117 => 0xc61f },
	'defaultcropsize' => { 117 => 0xc620 },
	'defaulteraseoption' => { 82 => 0x813 },
	'defaultscale' => { 117 => 0xc61e },
	'defaultsspecifictoiso' => { 468 => 'DefaultsSpecificToISO', 470 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 468 => 'DefaultsSpecificToSerial', 470 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 117 => 0xc7b5 },
	'defectisocode' => { 135 => 0x90f },
	'defringe' => { 468 => 'Defringe', 470 => 'Defringe' },
	'defringegreenamount' => { 468 => 'DefringeGreenAmount', 470 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 468 => 'DefringeGreenHueHi', 470 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 468 => 'DefringeGreenHueLo', 470 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 468 => 'DefringePurpleAmount', 470 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 468 => 'DefringePurpleHueHi', 470 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 468 => 'DefringePurpleHueLo', 470 => 'DefringePurpleHueLo' },
	'dehaze' => { 468 => 'Dehaze', 470 => 'Dehaze' },
	'deletedimagecount' => { 222 => 0xa6, 231 => 0x6e },
	'deprecatedon' => { 466 => 'deprecatedOn' },
	'depthfar' => { 117 => 0xc7eb },
	'depthformat' => { 117 => 0xc7e9 },
	'depthimage' => { 453 => 'Data' },
	'depthmeasuretype' => { 117 => 0xc7ed },
	'depthnear' => { 117 => 0xc7ea },
	'depthunits' => { 117 => 0xc7ec },
	'derivedfrom' => { 495 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 495 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 495 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 495 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 495 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 495 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 495 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 495 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 495 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 495 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 495 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 495 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 495 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 495 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 495 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 495 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 495 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 495 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 495 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 495 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 495 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 495 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 495 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 495 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 301 => 'Description', 363 => ['desc','dscp',"\xa9des"], 365 => 'description', 371 => 'dscp', 468 => 'Description', 470 => 'Description', 471 => 'description', 492 => 'Description' },
	'destination' => { 130 => 0x5 },
	'destinationcity' => { 346 => 0x24, 352 => 0x3 },
	'destinationcitycode' => { 353 => 0x1001 },
	'destinationdst' => { 346 => 0x26, 352 => '0.3' },
	'developmentdynamicrange' => { 125 => 0x1403 },
	'deviantmatrixcustom' => { 135 => 0x7de },
	'deviantmatrixdaylight' => { 135 => 0x7da },
	'deviantmatrixflash' => { 135 => 0x7dd },
	'deviantmatrixfluorescent' => { 135 => 0x7dc },
	'deviantmatrixtungsten' => { 135 => 0x7db },
	'deviantwhitecustom' => { 135 => 0x842 },
	'deviantwhitedaylight' => { 135 => 0x83e },
	'deviantwhiteflash' => { 135 => 0x841 },
	'deviantwhitefluorescent' => { 135 => 0x840 },
	'deviantwhitetungsten' => { 135 => 0x83f },
	'device' => { 484 => 'device' },
	'devicesettingdescription' => { 474 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 474 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 474 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 474 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 385 => 0x2 },
	'dewarpdata' => { 114 => 'DewarpData' },
	'dewarpflag' => { 114 => 'DewarpFlag' },
	'dialdirectiontvav' => { 82 => 0x706 },
	'dietaryneeds' => { 486 => 'dietaryNeeds' },
	'diffractioncorrection' => { 311 => 0xbc, 336 => 0x3 },
	'diffractioncorrectionon' => { 101 => 0x2070b },
	'digitalcreationdate' => { 129 => 0x3e },
	'digitalcreationtime' => { 129 => 0x3f },
	'digitaldeehighlightadj' => { 230 => 0x202 },
	'digitaldeeshadowadj' => { 230 => 0x200 },
	'digitaldeethreshold' => { 230 => 0x201 },
	'digitalfilter' => { 388 => 0x59 },
	'digitalfilter01' => { 333 => 0x5 },
	'digitalfilter02' => { 333 => 0x16 },
	'digitalfilter03' => { 333 => 0x27 },
	'digitalfilter04' => { 333 => 0x38 },
	'digitalfilter05' => { 333 => 0x49 },
	'digitalfilter06' => { 333 => 0x5a },
	'digitalfilter07' => { 333 => 0x6b },
	'digitalfilter08' => { 333 => 0x7c },
	'digitalfilter09' => { 333 => 0x8d },
	'digitalfilter10' => { 333 => 0x9e },
	'digitalfilter11' => { 333 => 0xaf },
	'digitalfilter12' => { 333 => 0xc0 },
	'digitalfilter13' => { 333 => 0xd1 },
	'digitalfilter14' => { 333 => 0xe2 },
	'digitalfilter15' => { 333 => 0xf3 },
	'digitalfilter16' => { 333 => 0x104 },
	'digitalfilter17' => { 333 => 0x115 },
	'digitalfilter18' => { 333 => 0x126 },
	'digitalfilter19' => { 333 => 0x137 },
	'digitalfilter20' => { 333 => 0x148 },
	'digitalgain' => { 72 => 0xb },
	'digitalgem' => { 211 => 0x0 },
	'digitalice' => { 230 => 0x100 },
	'digitalimageguid' => { 480 => 'DigImageGUID' },
	'digitalroc' => { 228 => 0x0 },
	'digitalsourcefiletype' => { 480 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 480 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 110 => 0xa, 125 => 0x1044, 137 => 0x68, 148 => 0x22, 149 => 0x1e, 153 => 'DigitalZoom', 178 => 0xc, 222 => 0x86, 254 => 0xa, 293 => 0x204, 346 => 0x1e, 353 => 0xa, 387 => 0x204, 432 => 0x12, 433 => 0x12 },
	'digitalzoomon' => { 387 => 0x21b },
	'digitalzoomratio' => { 117 => 0xa404, 421 => 0x200, 423 => 0x21c, 474 => 'DigitalZoomRatio' },
	'director' => { 176 => 'WM/Director', 363 => "\xa9dir", 365 => 'director', 371 => "\xa9dir", 494 => 'director' },
	'directorphotography' => { 494 => 'directorPhotography' },
	'directory' => { 118 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 204 => 0x3, 374 => 0x12 },
	'disableautocreation' => { 451 => 'DisableAutoCreation' },
	'disclaimer' => { 301 => 'Disclaimer' },
	'discnumber' => { 494 => 'discNumber' },
	'dishtype' => { 486 => 'dishType' },
	'disknumber' => { 363 => 'disk' },
	'displayallafpoints' => { 82 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 361 => 0x2 },
	'displayedunitsy' => { 361 => 0x6 },
	'displayname' => { 365 => 'displayname', 483 => 'displayName' },
	'distance1' => { 137 => 0x28 },
	'distance2' => { 137 => 0x2c },
	'distance3' => { 137 => 0x30 },
	'distance4' => { 137 => 0x34 },
	'distortion' => { 385 => 0xa050 },
	'distortioncompensation' => { 445 => 0x8040 },
	'distortioncontrol' => { 231 => 0x10 },
	'distortioncorrection' => { 77 => 0x3, 101 => 0x20705, 107 => 0x67, 117 => 0x7036, 288 => 0x50b, 315 => '7.1', 336 => 0x0, 440 => 0x601, 441 => 0x5b },
	'distortioncorrection2' => { 292 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 465 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 101 => '0x20705.0', 107 => 0x63 },
	'distortioncorrectionsetting' => { 78 => 0x7, 411 => 0x2013 },
	'distortioncorrectionvalue' => { 77 => 0x9 },
	'distortioncorrparams' => { 117 => 0x7037, 420 => 0x1a23, 423 => 0x1870, 425 => 0x189c, 426 => 0x18cc, 427 => 0x17d0, 440 => 0x6ca, 441 => 0x64 },
	'distortioncorrparamsnumber' => { 423 => 0x1899, 425 => 0x18c5, 426 => 0x18f5, 427 => 0x17f9 },
	'distortioncorrparamspresent' => { 423 => 0x1898, 425 => 0x18c4, 426 => 0x18f4, 427 => 0x17f8, 429 => 0x10b, 430 => 0x10b, 440 => 0x600, 441 => 0x5a },
	'distortioneffect' => { 101 => 0x20709 },
	'distortionn' => { 315 => 0xc },
	'distortionparam02' => { 315 => 0x2 },
	'distortionparam04' => { 315 => 0x4 },
	'distortionparam08' => { 315 => 0x8 },
	'distortionparam09' => { 315 => 0x9 },
	'distortionparam11' => { 315 => 0xb },
	'distortionscale' => { 315 => 0x5 },
	'distributor' => { 484 => 'distributor' },
	'distributorproductid' => { 483 => 'distributorProductID' },
	'dloon' => { 101 => '0x20706.0', 107 => 0xdc },
	'dlosetting' => { 101 => 0x20706, 107 => 0xdd },
	'dlosettingapplied' => { 100 => 0x4 },
	'dloshootingdistance' => { 107 => 0xde },
	'dloversion' => { 100 => 0x5 },
	'dmcomment' => { 494 => 'comment' },
	'dmdithermatrix' => { 135 => 0xc7a },
	'dmdithermatrixheight' => { 135 => 0xc7c },
	'dmdithermatrixwidth' => { 135 => 0xc7b },
	'dngadobedata' => { 117 => 0xc634 },
	'dngbackwardversion' => { 117 => 0xc613 },
	'dngignoresidecars' => { 468 => 'DNGIgnoreSidecars', 470 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 117 => 0xc630 },
	'dngprivatedata' => { 117 => 0xc634 },
	'dngversion' => { 117 => 0xc612 },
	'document' => { 301 => 'Document' },
	'documentancestors' => { 482 => 'DocumentAncestors' },
	'documenthistory' => { 129 => 0xe7 },
	'documentid' => { 495 => 'DocumentID' },
	'documentname' => { 117 => 0x10d },
	'documentnotes' => { 129 => 0xe6 },
	'doi' => { 484 => 'doi' },
	'dopesheet' => { 480 => 'Dopesheet' },
	'dopesheetlink' => { 480 => 'DopesheetLink' },
	'dopesheetlinklink' => { 480 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 480 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 135 => 0xc82 },
	'dpp' => { 463 => 'dpp' },
	'dr4cameramodel' => { 102 => 0x3 },
	'drangepriority' => { 125 => 0x1443 },
	'drangepriorityauto' => { 125 => 0x1444 },
	'drangepriorityfixed' => { 125 => 0x1445 },
	'drivemode' => { 111 => 0x3103, 123 => '0.1', 178 => 0x6, 181 => 0x1e, 184 => 0xe, 288 => 0x600, 346 => 0x34, 378 => 0x1002, 388 => 0x3, 398 => 0x4, 399 => 0x7e, 400 => 0x34 },
	'drivemode2' => { 181 => 0xa, 327 => 0x7, 409 => 0xe, 416 => 0x1 },
	'drivemodesetting' => { 400 => 0x4 },
	'drivespeed' => { 123 => '0.2' },
	'dspfirmwareversion' => { 346 => 0x27 },
	'duration' => { 65 => 0x6a, 152 => 'Duration', 166 => 'Duration', 486 => 'duration', 494 => 'duration' },
	'durationscale' => { 494 => [\'duration','durationScale'] },
	'durationvalue' => { 494 => [\'duration','durationValue'] },
	'dustremovaldata' => { 62 => 0x97 },
	'dynamicafarea' => { 271 => '1.4', 280 => '1.4' },
	'dynamicareaafdisplay' => { 272 => '46.1', 274 => '47.1', 275 => '47.1', 284 => '47.1', 285 => '47.1' },
	'dynamicrange' => { 125 => 0x1400 },
	'dynamicrangeexpansion' => { 346 => 0x69, 378 => 0x100e },
	'dynamicrangemax' => { 106 => 0x7c },
	'dynamicrangemin' => { 106 => 0x7a },
	'dynamicrangeoptimizer' => { 181 => 0x15, 411 => [0xb025,0xb04f], 419 => 0x1144, 420 => [0x1144,0x324], 421 => [0x1120,0x300], 422 => [0x119c,0x37c], 423 => [0x1178,0x328], 424 => [0x1030,0x50], 425 => [0x228,0x50], 426 => [0x228,0x50], 427 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 409 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 398 => 0x19, 399 => 0x17, 400 => 0xd, 409 => 0x79, 416 => 0x5 },
	'dynamicrangeoptimizermode' => { 184 => 0x15, 398 => 0x18, 399 => 0x16, 409 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 181 => 0x27, 400 => 0xc, 416 => 0x4 },
	'dynamicrangesetting' => { 125 => 0x1402 },
	'e-dialinprogram' => { 327 => '1.3' },
	'earliestageorloweststage' => { 116 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 116 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 116 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 116 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 116 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 448 => 'EarthPos' },
	'earthposaltitude' => { 448 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 448 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 448 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 448 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 448 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 448 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 448 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 448 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 286 => '6.1' },
	'easyexposurecompensation' => { 271 => '6.4', 272 => '6.5', 274 => '6.3', 275 => '6.3', 279 => '5.1', 280 => '4.4', 281 => '5.2', 284 => '6.3', 285 => '6.3' },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 135 => 0x930 },
	'edgemapx1' => { 135 => 0x931 },
	'edgemapx2' => { 135 => 0x932 },
	'edgemapx3' => { 135 => 0x934 },
	'edgemapx4' => { 135 => 0x935 },
	'edgenoisereduction' => { 265 => 0x4, 445 => 0x8028 },
	'edit1' => { 371 => "\xa9ed1" },
	'edit2' => { 371 => "\xa9ed2" },
	'edit3' => { 371 => "\xa9ed3" },
	'edit4' => { 371 => "\xa9ed4" },
	'edit5' => { 371 => "\xa9ed5" },
	'edit6' => { 371 => "\xa9ed6" },
	'edit7' => { 371 => "\xa9ed7" },
	'edit8' => { 371 => "\xa9ed8" },
	'edit9' => { 371 => "\xa9ed9" },
	'edition' => { 484 => 'edition' },
	'editorialupdate' => { 129 => 0x8 },
	'editstatus' => { 129 => 0x7, 358 => 'EditStatus', 463 => 'EditStatus' },
	'editversionname' => { 264 => 0x3d136244 },
	'effectivelv' => { 346 => 0x2d },
	'effectivemaxaperture' => { 215 => 0x12, 216 => 0x13, 220 => 0x14 },
	'eissn' => { 484 => 'eIssn' },
	'electricalblackcolumns' => { 135 => 0x1810 },
	'electronicfront-curtainshutter' => { 274 => '5.2', 275 => '5.2', 284 => '5.3', 285 => '5.2' },
	'electronicfrontcurtainshutter' => { 411 => 0x201a },
	'elevation' => { 162 => 'Elevation' },
	'email' => { 154 => 'EMail' },
	'embargodate' => { 487 => 'embargoDate' },
	'embdencrightsexpr' => { 480 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 480 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 480 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 480 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 482 => 'EmbeddedXMPDigest' },
	'emissivity' => { 119 => 0x3 },
	'enablechromanoisereduction' => { 135 => 0xe6e },
	'enablesharpening' => { 135 => 0x92e },
	'encodedby' => { 176 => 'WM/EncodedBy', 363 => "\xa9enc" },
	'encodedwith' => { 365 => 'Encoded_With' },
	'encoder' => { 363 => "\xa9too", 371 => "\xa9too" },
	'encoderid' => { 371 => "\xa9enc" },
	'encodingtime' => { 176 => 'WM/EncodingTime' },
	'encryptionkey' => { 385 => 0xa020 },
	'endingpage' => { 484 => 'endingPage' },
	'enduser' => { 298 => 'EndUser' },
	'enduserid' => { 298 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 298 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 494 => 'engineer' },
	'enhancedarktones' => { 257 => 0x8 },
	'enhancement' => { 110 => 0x16, 111 => 0x3016 },
	'enhanceparams' => { 117 => 0xc7ee },
	'enhancer' => { 292 => 0x300 },
	'enhancervalues' => { 292 => 0x301 },
	'envelopenumber' => { 130 => 0x28 },
	'envelopepriority' => { 130 => 0x3c },
	'enveloperecordversion' => { 130 => 0x0 },
	'episode' => { 480 => 'Episode' },
	'episodeglobaluniqueid' => { 363 => 'egid' },
	'episodeidentifier' => { 480 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 480 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 480 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 293 => 0x20c },
	'epsonimagewidth' => { 293 => 0x20b },
	'epsonsoftware' => { 293 => 0x20d },
	'equipmentinstitution' => { 447 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 447 => 'EquipmentManufacturer' },
	'equipmentversion' => { 289 => 0x0 },
	'ettlii' => { 82 => 0x304, 83 => 0xd, 84 => 0xe, 85 => 0x7, 86 => 0x7, 87 => 0xe },
	'event' => { 449 => 'Event', 461 => 'Event', 480 => 'Event', 484 => 'event' },
	'eventalias' => { 483 => 'eventAlias' },
	'eventdate' => { 116 => [\'Event','EventEventDate'] },
	'eventday' => { 116 => [\'Event','EventDay'] },
	'eventearliestdate' => { 116 => [\'Event','EventEarliestDate'] },
	'eventend' => { 483 => 'eventEnd' },
	'eventenddayofyear' => { 116 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 116 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 116 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 116 => [\'Event','EventHabitat'] },
	'eventid' => { 116 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 116 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 116 => [\'Event','EventMonth'] },
	'eventnumber' => { 372 => 0x9, 373 => 0x37, 374 => 0x3a },
	'eventparenteventid' => { 116 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 116 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 116 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 116 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 116 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 116 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 483 => 'eventStart' },
	'eventstartdayofyear' => { 116 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 483 => 'eventSubtype' },
	'eventtime' => { 116 => [\'Event','EventEventTime'] },
	'eventtype' => { 483 => 'eventType' },
	'eventverbatimeventdate' => { 116 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 116 => [\'Event','EventYear'] },
	'evsteps' => { 327 => '1.2', 329 => 0x0 },
	'evstepsize' => { 276 => '5.1', 277 => '6.1', 278 => '6.1', 282 => '0.7' },
	'exclusivecoverage' => { 458 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 487 => 'exclusivityEndDate' },
	'excursiontolerance' => { 131 => 0x82 },
	'executiveproducer' => { 363 => "\xa9xpd" },
	'exif' => { 118 => 'EXIF' },
	'exifbyteorder' => { 118 => 'ExifByteOrder' },
	'exifcamerainfo' => { 129 => 0xe8 },
	'exifimageheight' => { 117 => 0xa003, 474 => 'PixelYDimension' },
	'exifimagewidth' => { 117 => 0xa002, 474 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 118 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 117 => 0x9000, 474 => 'ExifVersion' },
	'exitpupilposition' => { 215 => 0x4, 216 => 0x4, 220 => 0x4 },
	'expirationdate' => { 129 => 0x25, 487 => 'expirationDate' },
	'expirationtime' => { 129 => 0x26 },
	'exposure' => { 117 => 0xfe51, 468 => 'Exposure', 470 => 'Exposure' },
	'exposure2012' => { 468 => 'Exposure2012', 470 => 'Exposure2012' },
	'exposureadj' => { 262 => 0x0 },
	'exposureadj2' => { 262 => 0x12 },
	'exposureadjust' => { 388 => 0xc },
	'exposurebracketingindicatorlast' => { 181 => 0x52 },
	'exposurebracketshotnumber' => { 184 => 0x2d, 409 => 0x2f },
	'exposurebracketstepsize' => { 327 => 0x8 },
	'exposurebracketvalue' => { 222 => 0x19 },
	'exposurecompautocancel' => { 82 => 0x113 },
	'exposurecompensation' => { 75 => 0x6, 91 => 0x0, 117 => 0x9204, 137 => 0x24, 153 => 'ExposureComp', 173 => 'ExposureCompensation', 178 => 0xd, 179 => 0x53, 180 => 0x1e, 184 => 0x49c0, 293 => 0x1006, 346 => 0x16, 355 => 0x402, 385 => 0xa013, 388 => [0xc,0x35,0x4d], 419 => 0x114c, 420 => 0x114c, 421 => 0x1128, 423 => 0x1180, 424 => 0x1038, 425 => 0x230, 426 => 0x230, 427 => 0x223, 474 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 416 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 181 => 0x47, 184 => 0x2a },
	'exposurecompensationset' => { 398 => 0x3, 399 => 0x3, 400 => 0x3, 416 => 0x1e },
	'exposurecompensationsetting' => { 181 => 0x1 },
	'exposurecompstepsize' => { 271 => '6.3', 272 => '7.3', 274 => '7.3', 275 => '7.3', 280 => '4.3', 284 => '7.3', 285 => '7.3' },
	'exposurecontrolstep' => { 279 => '6.1', 281 => '6.1' },
	'exposurecontrolstepsize' => { 271 => '6.2', 272 => '7.1', 274 => '7.1', 275 => '7.1', 280 => '4.2', 284 => '7.1', 285 => '7.1', 286 => '7.1' },
	'exposurecount' => { 125 => 0x1032 },
	'exposuredelaymode' => { 271 => '10.1', 272 => '11.1', 274 => '11.1', 275 => '11.1', 276 => '9.1', 277 => '10.1', 278 => '10.1', 280 => '10.4', 281 => '10.1', 282 => '6.4', 284 => '11.1', 285 => '11.1', 286 => '11.2' },
	'exposuredifference' => { 222 => 0xe },
	'exposuregaincustom' => { 135 => 0x89c },
	'exposuregaindaylight' => { 135 => 0x898 },
	'exposuregainflash' => { 135 => 0x89b },
	'exposuregainfluorescent' => { 135 => 0x89a },
	'exposuregaintungsten' => { 135 => 0x899 },
	'exposureindex' => { 117 => 0xa215, 474 => 'ExposureIndex' },
	'exposureindicator' => { 181 => 0x50 },
	'exposurelevelincrements' => { 80 => 0x6, 81 => 0x6, 82 => 0x101, 83 => 0x5, 84 => 0x6, 85 => 0x5, 86 => 0x5, 87 => 0x6, 88 => 0x4, 398 => 0x58, 399 => 0x58 },
	'exposurelockused' => { 456 => 'ExposureLockUsed' },
	'exposuremode' => { 117 => 0xa402, 153 => 'ExposureMode', 178 => 0x1, 179 => 0xa, 180 => 0x0, 181 => 0x0, 184 => 0x34, 288 => 0x200, 308 => 0x40d, 388 => 0x8, 411 => 0xb041, 474 => 'ExposureMode' },
	'exposuremodeinmanual' => { 82 => 0x10b },
	'exposureprogram' => { 117 => 0x8822, 378 => 0x1001, 391 => [0x17e,0x43], 398 => 0x3c, 399 => 0x3c, 400 => 0x5, 404 => 0x14, 409 => 0x3f, 416 => 0x2, 419 => 0x1175, 420 => 0x1179, 421 => 0x1155, 422 => 0x11d1, 423 => 0x11ad, 424 => 0x1065, 425 => 0x25d, 426 => 0x25d, 427 => 0x24c, 437 => 0xb, 438 => 0xc, 439 => 0xb, 441 => 0x48, 474 => 'ExposureProgram' },
	'exposureshift' => { 288 => 0x203 },
	'exposurestandardadjustment' => { 411 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 75 => 0x16, 117 => 0x829a, 134 => 0xfd05, 137 => 0x20, 139 => 0xfa24, 141 => 0xf104, 144 => 0x12, 146 => 0x38, 148 => 0x14, 149 => 0x10, 151 => 0x10, 153 => 'ExposureTime', 178 => 0x9, 179 => 0x35, 180 => 0x48, 181 => 0x8, 184 => 0x49b8, 346 => 0x12, 385 => 0xa018, 388 => [0x32,0x4a], 398 => 0x0, 399 => 0x0, 416 => [0x21,0x23,0x27], 441 => 0x10, 474 => 'ExposureTime' },
	'exposuretime2' => { 388 => [0x33,0x4b] },
	'exposuretuning' => { 222 => 0x1c },
	'exposurevalue' => { 135 => 0x3 },
	'exposurewarning' => { 125 => 0x1302 },
	'exrauto' => { 125 => 0x1033 },
	'exrmode' => { 125 => 0x1034 },
	'extendedwbdetect' => { 288 => 0x902 },
	'extender' => { 289 => 0x301 },
	'extenderfirmwareversion' => { 289 => 0x304 },
	'extendermagnification' => { 155 => 'Magnification' },
	'extendermake' => { 155 => 'Make' },
	'extendermodel' => { 155 => 'Model', 289 => 0x303 },
	'extenderserialnumber' => { 155 => 'SerialNumber', 289 => 0x302 },
	'extenderstatus' => { 344 => 0x3 },
	'externalflash' => { 291 => 0x1201 },
	'externalflashae1' => { 293 => 0x101f },
	'externalflashae1_0' => { 293 => 0x101b },
	'externalflashae2' => { 293 => 0x1020 },
	'externalflashae2_0' => { 293 => 0x101c },
	'externalflashbounce' => { 291 => 0x1204, 293 => 0x1026, 334 => 0x1a },
	'externalflashcompensation' => { 207 => 0x1b },
	'externalflashexposurecomp' => { 222 => 0x17, 334 => 0x19 },
	'externalflashfirmware' => { 205 => 0x6, 206 => 0x6, 207 => 0x6, 208 => 0x6, 209 => 0x6, 210 => 0x6 },
	'externalflashflags' => { 205 => 0x8, 206 => 0x8, 207 => 0x8, 208 => 0x8 },
	'externalflashguidenumber' => { 291 => 0x1203, 334 => '24.1' },
	'externalflashgvalue' => { 293 => 0x1025 },
	'externalflashmode' => { 293 => 0x1028, 334 => 0x2 },
	'externalflashreadystate' => { 209 => '9.1' },
	'externalflashstatus' => { 209 => '8.2' },
	'externalflashzoom' => { 291 => 0x1205, 293 => 0x1027 },
	'externalflashzoomoverride' => { 209 => '8.1' },
	'externalmetadatalink' => { 480 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 306 => 0x311, 309 => 0x311, 310 => 0x311, 313 => 0x3408 },
	'extrainfoversion' => { 402 => 0x1a },
	'eyestartaf' => { 181 => 0x40 },
	'fac100per' => { 135 => 0xe94 },
	'fac170per' => { 135 => 0xe93 },
	'fac18per' => { 135 => 0xe92 },
	'face10position' => { 108 => 0x3f4, 109 => 0x1ec, 203 => 0x28, 331 => 0x12 },
	'face10size' => { 332 => 0x12 },
	'face11position' => { 203 => 0x2c, 331 => 0x14 },
	'face11size' => { 332 => 0x14 },
	'face12position' => { 203 => 0x30, 331 => 0x16 },
	'face12size' => { 332 => 0x16 },
	'face13position' => { 331 => 0x18 },
	'face13size' => { 332 => 0x18 },
	'face14position' => { 331 => 0x1a },
	'face14size' => { 332 => 0x1a },
	'face15position' => { 331 => 0x1c },
	'face15size' => { 332 => 0x1c },
	'face16position' => { 331 => 0x1e },
	'face16size' => { 332 => 0x1e },
	'face17position' => { 331 => 0x20 },
	'face17size' => { 332 => 0x20 },
	'face18position' => { 331 => 0x22 },
	'face18size' => { 332 => 0x22 },
	'face19position' => { 331 => 0x24 },
	'face19size' => { 332 => 0x24 },
	'face1position' => { 53 => 0x8, 108 => 0xd, 109 => 0x18, 203 => 0x4, 303 => 0x1, 331 => 0x0, 375 => 0xbc, 405 => 0x1, 406 => 0x0, 407 => 0x0, 408 => 0x5b },
	'face1size' => { 332 => 0x0 },
	'face20position' => { 331 => 0x26 },
	'face20size' => { 332 => 0x26 },
	'face21position' => { 331 => 0x28 },
	'face21size' => { 332 => 0x28 },
	'face22position' => { 331 => 0x2a },
	'face22size' => { 332 => 0x2a },
	'face23position' => { 331 => 0x2c },
	'face23size' => { 332 => 0x2c },
	'face24position' => { 331 => 0x2e },
	'face24size' => { 332 => 0x2e },
	'face25position' => { 331 => 0x30 },
	'face25size' => { 332 => 0x30 },
	'face26position' => { 331 => 0x32 },
	'face26size' => { 332 => 0x32 },
	'face27position' => { 331 => 0x34 },
	'face27size' => { 332 => 0x34 },
	'face28position' => { 331 => 0x36 },
	'face28size' => { 332 => 0x36 },
	'face29position' => { 331 => 0x38 },
	'face29size' => { 332 => 0x38 },
	'face2position' => { 53 => 0xa, 108 => 0x7c, 109 => 0x4c, 203 => 0x8, 303 => 0x5, 331 => 0x2, 375 => 0xc8, 405 => 0x6, 406 => 0x20, 407 => 0x25, 408 => 0x65 },
	'face2size' => { 332 => 0x2 },
	'face30position' => { 331 => 0x3a },
	'face30size' => { 332 => 0x3a },
	'face31position' => { 331 => 0x3c },
	'face31size' => { 332 => 0x3c },
	'face32position' => { 331 => 0x3e },
	'face32size' => { 332 => 0x3e },
	'face3position' => { 53 => 0xc, 108 => 0xeb, 109 => 0x80, 203 => 0xc, 303 => 0x9, 331 => 0x4, 375 => 0xd4, 405 => 0xb, 406 => 0x40, 407 => 0x4a, 408 => 0x6f },
	'face3size' => { 332 => 0x4 },
	'face4position' => { 53 => 0xe, 108 => 0x15a, 109 => 0xb4, 203 => 0x10, 303 => 0xd, 331 => 0x6, 375 => 0xe0, 405 => 0x10, 406 => 0x60, 407 => 0x6f, 408 => 0x79 },
	'face4size' => { 332 => 0x6 },
	'face5position' => { 53 => 0x10, 108 => 0x1c9, 109 => 0xe8, 203 => 0x14, 303 => 0x11, 331 => 0x8, 375 => 0xec, 405 => 0x15, 406 => 0x80, 407 => 0x94 },
	'face5size' => { 332 => 0x8 },
	'face6position' => { 53 => 0x12, 108 => 0x238, 109 => 0x11c, 203 => 0x18, 331 => 0xa, 375 => 0xf8, 405 => 0x1a, 406 => 0xa0, 407 => 0xb9 },
	'face6size' => { 332 => 0xa },
	'face7position' => { 53 => 0x14, 108 => 0x2a7, 109 => 0x150, 203 => 0x1c, 331 => 0xc, 375 => 0x104, 405 => 0x1f, 406 => 0xc0, 407 => 0xde },
	'face7size' => { 332 => 0xc },
	'face8position' => { 53 => 0x16, 108 => 0x316, 109 => 0x184, 203 => 0x20, 331 => 0xe, 375 => 0x110, 405 => 0x24, 406 => 0xe0, 407 => 0x103 },
	'face8size' => { 332 => 0xe },
	'face9position' => { 53 => 0x18, 108 => 0x385, 109 => 0x1b8, 203 => 0x24, 331 => 0x10 },
	'face9size' => { 332 => 0x10 },
	'facebalanceorigi' => { 462 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 462 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 462 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 462 => 'FaceBalanceWarmth' },
	'facedetect' => { 346 => 0x76, 385 => 0x100 },
	'facedetectarea' => { 292 => 0x1201 },
	'facedetectframecrop' => { 292 => 0x1207 },
	'facedetectframesize' => { 53 => 0x3, 108 => 0x1, 109 => 0x4, 203 => 0x1, 292 => 0x1203, 346 => 0x77, 375 => 0xb6 },
	'facedetection' => { 400 => 0x30, 416 => 0x19 },
	'faceelementpositions' => { 125 => 0x4203 },
	'faceelementselected' => { 125 => 0x4005 },
	'faceelementtypes' => { 125 => 0x4201 },
	'faceid' => { 464 => 'FaceID' },
	'faceinfounknown' => { 111 => 0x2089 },
	'facename' => { 385 => 0x123 },
	'faceorientation' => { 109 => 0x8 },
	'faceposition' => { 330 => 0x2, 386 => 0x4 },
	'facepositions' => { 125 => 0x4103 },
	'facerecognition' => { 385 => 0x120 },
	'facesdetected' => { 53 => 0x2, 54 => 0x2, 55 => 0x3, 108 => 0x0, 109 => 0x2, 111 => 0x211c, 125 => 0x4100, 203 => 0x3, 292 => 0x1200, 311 => 0x3f, 330 => 0x0, 375 => 0xb5, 386 => 0x0, 405 => 0x0, 408 => 0x3, 418 => 0x30 },
	'facesrecognized' => { 304 => 0x0 },
	'facewidth' => { 54 => 0x1 },
	'fade' => { 411 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 107 => 0x38 },
	'faithfuloutputshadowpoint' => { 107 => 0x39 },
	'faithfulrawcolortone' => { 107 => 0x31 },
	'faithfulrawcontrast' => { 107 => 0x33 },
	'faithfulrawhighlight' => { 107 => 0x79 },
	'faithfulrawhighlightpoint' => { 107 => 0x36 },
	'faithfulrawlinear' => { 107 => 0x34 },
	'faithfulrawsaturation' => { 107 => 0x32 },
	'faithfulrawshadow' => { 107 => 0x82 },
	'faithfulrawshadowpoint' => { 107 => 0x37 },
	'faithfulrawsharpness' => { 107 => 0x35 },
	'faithfulunsharpmaskfineness' => { 107 => 0xac },
	'faithfulunsharpmaskstrength' => { 107 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 107 => 0xae },
	'far' => { 453 => 'Far' },
	'fastresetlinetime' => { 135 => 0x1860 },
	'feedidentifier' => { 480 => 'FeedIdentifier' },
	'femicroadjustment' => { 82 => 0x111 },
	'ffid' => { 472 => 'ffid' },
	'field' => { 483 => 'field' },
	'fieldcount' => { 293 => 0x103f },
	'fieldofview' => { 371 => "FOV\x00" },
	'fifoenonepixeldelay' => { 135 => 0x1901 },
	'filecreatedate' => { 118 => 'FileCreateDate' },
	'filedatarate' => { 494 => 'fileDataRate' },
	'fileformat' => { 93 => 0x0, 130 => 0x14, 388 => [0x22,0x26], 411 => 0xb000 },
	'filegroupid' => { 118 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 312 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 118 => 'FileModifyDate' },
	'filename' => { 118 => 'FileName' },
	'filenameasdelivered' => { 298 => 'FileNameAsDelivered' },
	'filenumber' => { 56 => 0x1, 62 => 0x8, 95 => 0x1817, 112 => 'Canon-FileNumber', 204 => 0x4, 374 => 0x10 },
	'filenumbermemory' => { 178 => 0x1a },
	'filenumbersequence' => { 271 => '12.2', 276 => '3.1', 277 => '4.1', 278 => '4.1', 280 => '11.1', 281 => '4.3', 286 => '5.2' },
	'filepermissions' => { 118 => 'FilePermissions' },
	'filesource' => { 117 => 0xa300, 125 => 0x8000, 474 => 'FileSource' },
	'fileuserid' => { 118 => 'FileUserID' },
	'fileversion' => { 130 => 0x16 },
	'fillflashautoreduction' => { 80 => 0xe, 81 => 0xe, 88 => 0xa },
	'filllight' => { 468 => 'FillLight', 470 => 'FillLight' },
	'fillorder' => { 117 => 0x10a },
	'filmgraineffect' => { 288 => 0x538 },
	'filmmode' => { 125 => 0x1401, 308 => 0x412, 311 => 0x42 },
	'filmtype' => { 230 => 0x2 },
	'filtereffect' => { 56 => 0xe, 224 => 0x37, 225 => 0x3f, 226 => 0x47, 311 => 0xa1 },
	'filtereffectauto' => { 69 => 0xa0 },
	'filtereffectfaithful' => { 68 => 0x70, 69 => 0x70 },
	'filtereffectlandscape' => { 68 => 0x40, 69 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 68 => 0x88, 69 => 0x88 },
	'filtereffectneutral' => { 68 => 0x58, 69 => 0x58 },
	'filtereffectportrait' => { 68 => 0x28, 69 => 0x28 },
	'filtereffectstandard' => { 68 => 0x10, 69 => 0x10 },
	'filtereffectuserdef1' => { 68 => 0xa0, 69 => 0xb8 },
	'filtereffectuserdef2' => { 68 => 0xb8, 69 => 0xd0 },
	'filtereffectuserdef3' => { 68 => 0xd0, 69 => 0xe8 },
	'finderdisplayduringexposure' => { 81 => 0x1 },
	'finesharpness' => { 346 => 0x70 },
	'finetuneoptcenterweighted' => { 271 => '7.2', 272 => '9.1', 274 => '9.1', 275 => '9.1', 279 => '8.1', 284 => '9.1', 285 => '9.1', 286 => '9.1' },
	'finetuneopthighlightweighted' => { 274 => '46.1', 275 => '46.1', 284 => '46.1', 285 => '46.1' },
	'finetuneoptmatrixmetering' => { 271 => '8.1', 272 => '8.2', 274 => '8.2', 275 => '8.2', 279 => '7.2', 280 => '6.1', 284 => '8.2', 285 => '8.2', 286 => '8.2' },
	'finetuneoptspotmetering' => { 271 => '8.2', 272 => '9.2', 274 => '9.2', 275 => '9.2', 279 => '8.2', 280 => '6.2', 284 => '9.2', 285 => '9.2', 286 => '9.2' },
	'finishexposure' => { 135 => 0xdbd },
	'finishfiletype' => { 135 => 0xdb8 },
	'finishlook' => { 135 => 0xdbc },
	'finishnoise' => { 135 => 0xdba },
	'finishresolution' => { 135 => 0xdb9 },
	'finishsharpening' => { 135 => 0xdbb },
	'firmware' => { 293 => 0x405, 388 => [0x8c,0x17,0x3b], 465 => 'Firmware' },
	'firmware2' => { 388 => 0x57 },
	'firmwaredate' => { 110 => 0x15, 111 => 0x2001, 372 => 0x4, 374 => 0x30 },
	'firmwareid' => { 185 => 0x0 },
	'firmwarename' => { 385 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 62 => 0x1e, 376 => 0x0 },
	'firmwarerevision2' => { 376 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 135 => [0x415,0xce5], 151 => 0x57, 153 => 'FirmwareVersion', 309 => 0x320, 311 => 0x2, 313 => 0x3109, 346 => 0x230, 371 => ['CNFV','FIRM'], 373 => 0x18, 374 => 0x2a, 378 => 0x2 },
	'firmwareversions' => { 355 => 0x301 },
	'firstphotodate' => { 456 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 298 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 129 => 0x16, 463 => 'FixtureIdentifier' },
	'flash' => { 112 => 'XMP-Flash', 117 => 0x9209, 149 => 0x22, 179 => 0x1f, 180 => 0x15, 374 => 0x5a, 474 => 'Flash' },
	'flashaction' => { 398 => 0x3e, 399 => 0x3e, 411 => 0x2017, 416 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 398 => 0x4c, 399 => 0x4c, 416 => 0x77 },
	'flashactionexternal' => { 416 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 43 => 0x249 },
	'flashbias' => { 311 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashbuttonfunction' => { 82 => 0x70e },
	'flashchargelevel' => { 293 => 0x1010 },
	'flashcolorfilter' => { 207 => 0x10, 208 => 0x10 },
	'flashcommandermode' => { 205 => '9.1', 206 => '9.1', 207 => '9.1', 208 => '9.1' },
	'flashcompensation' => { 135 => 0x3f3, 205 => 0xa, 206 => 0xa, 207 => 0xa, 208 => 0x27, 209 => 0xa, 210 => 0x1b, 465 => 'FlashCompensation' },
	'flashcontrol' => { 398 => 0x23, 399 => 0x1f, 400 => 0x21 },
	'flashcontrolbuilt-in' => { 280 => '16.1', 281 => '23.1', 283 => '23.1', 284 => '24.1' },
	'flashcontrolmode' => { 205 => '9.2', 206 => '9.2', 207 => '9.2', 208 => '9.2', 288 => 0x404 },
	'flashcurtain' => { 311 => 0x48 },
	'flashdefault' => { 181 => 0x42 },
	'flashdevice' => { 293 => 0x1005 },
	'flashdistance' => { 111 => 0x2034 },
	'flashenergy' => { 117 => 0xa20b, 474 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 222 => 0x18 },
	'flashexposurecomp' => { 75 => 0xf, 125 => 0x1011, 156 => 'ExposureComp', 178 => 0x23, 183 => 0x104, 184 => 0x49c1, 222 => 0x12, 288 => 0x401, 293 => 0x1023, 346 => 0x4d, 378 => 0x100b, 388 => [0x3a,0x56], 411 => 0x104 },
	'flashexposurecomp2' => { 249 => 0x4d2 },
	'flashexposurecomp3' => { 207 => 0x1d },
	'flashexposurecomp4' => { 207 => 0x27 },
	'flashexposurecomparea' => { 272 => '38.4', 274 => '38.4', 275 => '38.4', 284 => '38.4', 285 => '38.4' },
	'flashexposurecompset' => { 181 => 0x10, 319 => 0xe, 398 => 0x14, 399 => 0x12, 400 => 0x23, 416 => 0x1f },
	'flashexposurecompset2' => { 416 => [0x26,0x2c] },
	'flashexposureindicator' => { 181 => 0x54 },
	'flashexposureindicatorlast' => { 181 => 0x56 },
	'flashexposureindicatornext' => { 181 => 0x55 },
	'flashexposurelock' => { 56 => 0x19 },
	'flashfired' => { 137 => 0x5d, 156 => 'Fired', 178 => 0x14, 248 => '590.3', 474 => [\'Flash','FlashFired'] },
	'flashfiring' => { 82 => 0x306, 83 => 0x6, 84 => 0x7, 87 => 0x7 },
	'flashfirmwareversion' => { 289 => 0x1002 },
	'flashfocallength' => { 205 => 0xb, 206 => 0xc, 207 => 0xc, 208 => 0xc, 209 => 0xc },
	'flashfunction' => { 184 => 0x31, 474 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 205 => 0xe, 206 => 0xf, 207 => 0xf, 208 => 0xf, 209 => 0xf },
	'flashgroupacompensation' => { 205 => 0x11, 206 => 0x12, 207 => 0x13, 208 => 0x28, 209 => 0x28 },
	'flashgroupacontrolmode' => { 205 => 0xf, 206 => '16.1', 207 => '17.1', 208 => '17.1', 209 => '17.1' },
	'flashgroupaoutput' => { 205 => 0x11, 206 => 0x12, 207 => 0x13, 208 => 0x28, 209 => 0x28 },
	'flashgroupbcompensation' => { 205 => 0x12, 206 => 0x13, 207 => 0x14, 208 => 0x29, 209 => 0x29 },
	'flashgroupbcontrolmode' => { 205 => 0x10, 206 => '17.1', 207 => '18.1', 208 => '18.1', 209 => '18.1' },
	'flashgroupboutput' => { 205 => 0x12, 206 => 0x13, 207 => 0x14, 208 => 0x29, 209 => 0x29 },
	'flashgroupccompensation' => { 206 => 0x14, 207 => 0x15, 208 => 0x2a, 209 => 0x2a },
	'flashgroupccontrolmode' => { 206 => '17.2', 207 => '18.2', 208 => '18.2', 209 => '18.2' },
	'flashgroupcoutput' => { 206 => 0x14, 207 => 0x15, 208 => 0x2a, 209 => 0x2a },
	'flashguidenumber' => { 75 => 0xd, 92 => 0x0, 156 => 'GuideNumber' },
	'flashintensity' => { 110 => [0x19,0x5], 288 => 0x405 },
	'flashlevel' => { 273 => 0x9, 411 => 0xb048 },
	'flashmake' => { 156 => 'Make' },
	'flashmanufacturer' => { 175 => 'FlashManufacturer' },
	'flashmetering' => { 178 => 0x3f, 181 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 346 => 0x20a },
	'flashmode' => { 110 => 0x4, 135 => 0x3f2, 137 => 0x5c, 148 => 0x27, 156 => 'Mode', 178 => 0x2, 179 => 0x20, 180 => 0x16, 181 => 0xf, 222 => 0x87, 288 => 0x400, 293 => 0x1004, 346 => 0xc, 353 => 0x4, 377 => 0x20, 378 => 0x100a, 387 => 0x225, 398 => 0x13, 399 => 0x7f, 400 => 0x20, 416 => 0x10, 419 => 0x1138, 420 => 0x1138, 421 => 0x1114, 422 => 0x1190, 423 => 0x116c, 424 => 0x1024, 425 => 0x21c, 426 => 0x21c, 427 => 0x211, 474 => [\'Flash','FlashMode'] },
	'flashmodel' => { 156 => 'Model', 175 => 'FlashModel', 289 => 0x1001 },
	'flashoptions' => { 327 => 0x2 },
	'flashoptions2' => { 327 => 0x10 },
	'flashoutput' => { 43 => 0x248, 75 => 0x21, 205 => 0xa, 206 => 0xa, 207 => 0xa, 208 => 0x27 },
	'flashpixversion' => { 117 => 0xa000, 474 => 'FlashpixVersion' },
	'flashredeyemode' => { 474 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 288 => 0x403 },
	'flashreturn' => { 474 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 156 => 'SerialNumber', 289 => 0x1003 },
	'flashsetting' => { 222 => 0x8 },
	'flashshutterspeed' => { 271 => '20.2', 272 => '23.2', 274 => '23.2', 275 => '23.2', 280 => '15.2', 281 => '22.2', 282 => '7.2', 283 => '22.2', 284 => '23.2', 285 => '23.2', 286 => '23.1' },
	'flashsource' => { 205 => 0x4, 206 => 0x4, 207 => 0x4, 208 => 0x4, 209 => 0x4, 210 => 0x4 },
	'flashstatus' => { 334 => 0x0, 416 => [0x82,0x86], 429 => 0x31, 430 => 0x39, 431 => 0x39 },
	'flashstatusbuilt-in' => { 400 => [0x87,0x287] },
	'flashstatusexternal' => { 400 => [0x88,0x288] },
	'flashsyncspeed' => { 271 => '20.1', 272 => '23.1', 274 => '23.1', 275 => '23.1', 280 => '15.1', 281 => '22.1', 283 => '22.1', 284 => '23.1', 285 => '23.1' },
	'flashsyncspeedav' => { 80 => 0x3, 82 => 0x10f, 83 => 0x2, 84 => 0x3, 85 => 0x2, 86 => 0x2, 87 => 0x3, 88 => 0x6 },
	'flashthreshold' => { 92 => 0x1 },
	'flashtype' => { 156 => 'Type', 181 => 0x59, 222 => 0x9, 289 => 0x1000 },
	'flashwarning' => { 281 => '30.1', 282 => '7.1', 286 => '31.1', 311 => 0x62 },
	'flexiblespotposition' => { 411 => 0x201d },
	'flickerreduce' => { 387 => 0x218 },
	'flickerreduction' => { 125 => 0x1446, 241 => 0xe84 },
	'flickerreductionindicator' => { 241 => 0x5e2 },
	'flightpitchdegree' => { 114 => 'FlightPitchDegree' },
	'flightrolldegree' => { 114 => 'FlightRollDegree' },
	'flightxspeed' => { 114 => 'FlightXSpeed' },
	'flightyawdegree' => { 114 => 'FlightYawDegree' },
	'flightyspeed' => { 114 => 'FlightYSpeed' },
	'flightzspeed' => { 114 => 'FlightZSpeed' },
	'fliphorizontal' => { 264 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 75 => 0x15, 117 => 0x829d, 134 => 0xfd04, 137 => 0x1e, 139 => 0xfa23, 141 => 0xf103, 144 => 0x13, 146 => 0x3c, 148 => 0x1c, 149 => 0x18, 151 => 0xc, 160 => 'FNumber', 178 => 0xa, 179 => 0x36, 180 => 0x47, 181 => 0x9, 184 => 0x49c7, 220 => 0x38, 310 => 0x35a, 346 => 0x13, 385 => 0xa019, 388 => [0x31,0x49], 398 => 0x1, 399 => 0x1, 416 => [0x20,0x22,0x26], 474 => 'FNumber' },
	'focaldistance' => { 454 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 58 => 0x1, 111 => 0x1d, 117 => 0x920a, 144 => 0x1d, 160 => 'FocalLength', 178 => 0x12, 215 => 0xa, 216 => 0xb, 220 => [0xc,0x3c], 305 => 0x1, 346 => 0x1d, 355 => 0x403, 378 => 0x1500, 397 => 0xe, 423 => 0x1278, 424 => 0x1134, 425 => 0x32c, 426 => 0x32c, 427 => 0x30a, 474 => 'FocalLength' },
	'focallength2' => { 416 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 117 => 0xa405, 385 => 0xa01a, 474 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 397 => 0x10 },
	'focalplaneafpointarea' => { 428 => 0x2 },
	'focalplaneafpointlocation1' => { 428 => 0x6 },
	'focalplaneafpointlocation10' => { 428 => 0x2a },
	'focalplaneafpointlocation11' => { 428 => 0x2e },
	'focalplaneafpointlocation12' => { 428 => 0x32 },
	'focalplaneafpointlocation13' => { 428 => 0x36 },
	'focalplaneafpointlocation14' => { 428 => 0x3a },
	'focalplaneafpointlocation15' => { 428 => 0x3e },
	'focalplaneafpointlocation2' => { 428 => 0xa },
	'focalplaneafpointlocation3' => { 428 => 0xe },
	'focalplaneafpointlocation4' => { 428 => 0x12 },
	'focalplaneafpointlocation5' => { 428 => 0x16 },
	'focalplaneafpointlocation6' => { 428 => 0x1a },
	'focalplaneafpointlocation7' => { 428 => 0x1e },
	'focalplaneafpointlocation8' => { 428 => 0x22 },
	'focalplaneafpointlocation9' => { 428 => 0x26 },
	'focalplaneafpointsused' => { 428 => 0x1 },
	'focalplanediagonal' => { 289 => 0x103, 293 => 0x205 },
	'focalplaneresolutionunit' => { 117 => 0xa210, 474 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 117 => 0xa20e, 474 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 58 => 0x2 },
	'focalplanexunknown' => { 58 => 0x2 },
	'focalplaneyresolution' => { 117 => 0xa20f, 474 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 58 => 0x3 },
	'focalplaneyunknown' => { 58 => 0x3 },
	'focalpointx' => { 454 => 'FocalPointX' },
	'focalpointy' => { 454 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 58 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 254 => 0x8 },
	'focusarea' => { 178 => 0x31 },
	'focusareaselection' => { 282 => '15.2' },
	'focusbracket' => { 311 => 0xbd },
	'focusbracketstepsize' => { 288 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 82 => 0x515 },
	'focusdistance' => { 160 => 'FocusDistance', 178 => 0x13, 184 => 0x49bb, 215 => 0x9, 216 => 0xa, 220 => [0xb,0x4f], 291 => 0x305, 305 => 0x0, 309 => 0x304, 310 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 56 => 0x15, 75 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 56 => 0x14, 75 => 0x13 },
	'focusholdbutton' => { 181 => 0x44 },
	'focusinfoversion' => { 291 => 0x0 },
	'focusingscreen' => { 81 => 0x0, 82 => 0x80b, 87 => 0x0 },
	'focuslocation' => { 411 => 0x2027 },
	'focuslocked' => { 177 => 0x14 },
	'focusmode' => { 34 => 0x7, 110 => 0x3, 111 => [0x3003,0xd], 125 => 0x1021, 135 => 0x3f5, 137 => 0x38, 153 => 'FocusMode', 178 => 0x30, 180 => 0xe, 181 => 0xc, 222 => 0x7, 288 => 0x301, 293 => 0x100b, 311 => 0x7, 346 => 0xd, 353 => 0x3, 378 => 0x1006, 391 => [0xb,0x5], 397 => [0x15,0x1d], 398 => 0x4d, 399 => 0x4d, 411 => [0xb042,0xb04e,0x201b], 416 => 0x13, 435 => 0x16 },
	'focusmode2' => { 124 => '0.1', 327 => '3.1', 416 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 273 => '10.1', 395 => 0x14, 396 => 0x15, 398 => 0x10, 399 => 0xf, 400 => 0x6 },
	'focusmodeswitch' => { 181 => 0x58, 398 => 0x2e },
	'focuspixel' => { 125 => 0x1023 },
	'focuspointwrap' => { 271 => '2.2', 272 => '2.2', 274 => '2.1', 275 => '2.1', 279 => '1.1', 280 => '2.2', 281 => '1.1', 284 => '2.2', 285 => '2.1', 286 => '2.5' },
	'focusposition' => { 215 => 0x8, 216 => 0x8, 220 => 0x9, 346 => 0x10, 409 => 0x9bb },
	'focusposition2' => { 416 => [0x29,0x2b,0x2f], 435 => 0x2d, 438 => 0x20 },
	'focusprocess' => { 288 => 0x302 },
	'focusrange' => { 34 => 0x12, 293 => 0x100a },
	'focusrangeindex' => { 337 => '3.1' },
	'focusringrotation' => { 82 => 0x713 },
	'focussetting' => { 388 => 0x6 },
	'focusstatus' => { 397 => 0x19, 398 => 0x53, 399 => 0x53 },
	'focusstepcount' => { 291 => 0x301, 293 => 0x100e },
	'focusstepinfinity' => { 291 => 0x303, 293 => 0x103b },
	'focusstepnear' => { 291 => 0x304, 293 => 0x103c },
	'focustrackinglockon' => { 271 => ['1.5','4.1'], 272 => '1.4', 279 => '0.4', 280 => '3.1', 281 => '0.4', 284 => '1.4' },
	'focuswarning' => { 125 => 0x1301 },
	'foldername' => { 178 => 0x27 },
	'foldernumber' => { 398 => 0x9a, 400 => [0x402,0x114,0x316] },
	'fontcomposite' => { 499 => [\'Fonts','FontsComposite'] },
	'fontface' => { 499 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 499 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 499 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 499 => [\'Fonts','FontsFontName'] },
	'fonts' => { 499 => 'Fonts' },
	'fonttype' => { 499 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 499 => [\'Fonts','FontsVersionString'] },
	'for' => { 362 => 'For' },
	'forcewrite' => { 118 => 'ForceWrite' },
	'format' => { 371 => "\xa9fmt", 453 => 'Format', 471 => 'format', 492 => 'Format' },
	'forwardlock' => { 489 => 'forwardlock' },
	'forwardmatrix1' => { 117 => 0xc714 },
	'forwardmatrix2' => { 117 => 0xc715 },
	'fossilspecimen' => { 116 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 116 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 65 => [0x2,0x4] },
	'frameheight' => { 125 => 0x3822 },
	'framenum' => { 357 => 0xd7 },
	'framenumber' => { 125 => 0x8003, 184 => 0x3c, 346 => 0x29 },
	'framerate' => { 65 => [0x1,0x6], 117 => 0xc764, 125 => 0x3820 },
	'framereadouttime' => { 365 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 125 => 0x3821 },
	'framing' => { 483 => 'framing' },
	'freebytes' => { 95 => 0x1 },
	'freememorycardimages' => { 179 => [0x37,0x54], 180 => [0x2d,0x4a], 181 => 0x32 },
	'fujiflashmode' => { 125 => 0x1010 },
	'fullhdhighspeedrec' => { 125 => 0x3824 },
	'fullimagesize' => { 411 => 0xb02b },
	'fullpanoheightpixels' => { 456 => 'FullPanoHeightPixels', 457 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 456 => 'FullPanoWidthPixels', 457 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 378 => 0x100d },
	'fullsizeimage' => { 159 => 'data' },
	'fullsizeimagename' => { 159 => '1Name' },
	'fullsizeimagetype' => { 159 => '0Type' },
	'func1button' => { 274 => '14.1', 275 => '14.1', 285 => '14.1' },
	'func1buttonplusdials' => { 274 => '42.1', 275 => '42.1', 285 => '42.1' },
	'func2button' => { 274 => '80.1', 275 => '80.1', 285 => '80.1' },
	'func2buttonplusdials' => { 274 => '81.1' },
	'func3button' => { 274 => '83.1' },
	'funcbutton' => { 271 => ['14.1','15.1'], 272 => '14.1', 280 => '28.1', 281 => '13.1', 284 => '14.1', 286 => '14.1' },
	'funcbuttonplusdials' => { 271 => ['14.2','15.2'], 272 => '14.2', 280 => '31.1', 284 => '42.1' },
	'functionbutton' => { 278 => '13.1', 282 => '5.2' },
	'gainbase' => { 292 => 0x610 },
	'gaincontrol' => { 117 => 0xa407, 474 => 'GainControl' },
	'gamma' => { 117 => 0xa500, 135 => 0x8fe, 316 => 0x11c, 475 => 'Gamma' },
	'gammablackpoint' => { 103 => 0xc },
	'gammacolortone' => { 103 => 0x3 },
	'gammacompensatedvalue' => { 131 => 0x91 },
	'gammacontrast' => { 103 => 0x2 },
	'gammacurveoutputrange' => { 103 => 0xf },
	'gammahighlight' => { 103 => 0xa },
	'gammalinear' => { 101 => 0x20200 },
	'gammamidpoint' => { 103 => 0xe },
	'gammasaturation' => { 103 => 0x4 },
	'gammashadow' => { 103 => 0x9 },
	'gammasharpnessstrength' => { 103 => 0x8 },
	'gammaunsharpmaskfineness' => { 103 => 0x6 },
	'gammaunsharpmaskstrength' => { 103 => 0x5 },
	'gammaunsharpmaskthreshold' => { 103 => 0x7 },
	'gammawhitepoint' => { 103 => 0xd },
	'garminsettings' => { 371 => 'pmcc' },
	'garminsoftware' => { 371 => 'uuid' },
	'gdalmetadata' => { 117 => 0xa480 },
	'gdalnodata' => { 117 => 0xa481 },
	'geimagesize' => { 125 => 0x1304 },
	'gemake' => { 127 => 0x300 },
	'gemodel' => { 127 => 0x207 },
	'genre' => { 363 => ['gnre',"\xa9gen"], 365 => 'genre', 371 => ['gnre',"\xa9gen"], 480 => 'Genre', 484 => 'genre', 494 => 'genre' },
	'genrecvid' => { 480 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 480 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 480 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 480 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 363 => 'geID' },
	'geography' => { 485 => 'geography' },
	'geologicalcontext' => { 116 => 'GeologicalContext' },
	'geologicalcontextbed' => { 116 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 116 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 116 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 116 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 116 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 118 => 'Geosync' },
	'geotag' => { 118 => 'Geotag' },
	'geotiffasciiparams' => { 117 => 0x87b1 },
	'geotiffdirectory' => { 117 => 0x87af },
	'geotiffdoubleparams' => { 117 => 0x87b0 },
	'geotime' => { 118 => 'Geotime' },
	'giftftppriority' => { 458 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 114 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 114 => 'GimbalReverse' },
	'gimbalrolldegree' => { 114 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 114 => 'GimbalYawDegree' },
	'globalaltitude' => { 360 => 0x419 },
	'globalangle' => { 360 => 0x40d },
	'good' => { 494 => 'good' },
	'googlehostheader' => { 363 => 'gshh' },
	'googlepingmessage' => { 363 => 'gspm' },
	'googlepingurl' => { 363 => 'gspu' },
	'googleplusuploadcode' => { 117 => 0x9009 },
	'googlesourcedata' => { 363 => 'gssd' },
	'googlestarttime' => { 363 => 'gsst' },
	'googletrackduration' => { 363 => 'gstd' },
	'goprotype' => { 371 => 'GoPr' },
	'gpsaltitude' => { 128 => 0x6, 157 => 'Altitude', 474 => 'GPSAltitude' },
	'gpsaltituderef' => { 128 => 0x5, 474 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 128 => 0x1c, 474 => 'GPSAreaInformation' },
	'gpscoordinates' => { 363 => "\xa9xyz", 365 => 'location.ISO6709', 371 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 128 => 0x1d },
	'gpsdatetime' => { 157 => 'DateTime', 474 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 128 => 0x18, 157 => 'Bearing', 474 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 128 => 0x17, 474 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 128 => 0x1a, 157 => 'Distance', 474 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 128 => 0x19, 474 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 128 => 0x14, 474 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 128 => 0x13 },
	'gpsdestlongitude' => { 128 => 0x16, 474 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 128 => 0x15 },
	'gpsdifferential' => { 128 => 0x1e, 157 => 'Differential', 474 => 'GPSDifferential' },
	'gpsdop' => { 128 => 0xb, 474 => 'GPSDOP' },
	'gpshpositioningerror' => { 128 => 0x1f, 474 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 128 => 0x11, 474 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 128 => 0x10, 474 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 'GpsLatitude', 128 => 0x2, 157 => 'Latitude', 474 => 'GPSLatitude' },
	'gpslatituderef' => { 128 => 0x1 },
	'gpslongitude' => { 114 => 'GpsLongitude', 128 => 0x4, 157 => 'Longitude', 474 => 'GPSLongitude' },
	'gpslongituderef' => { 128 => 0x3 },
	'gpslongtitude' => { 114 => 'GpsLongtitude' },
	'gpsmapdatum' => { 128 => 0x12, 157 => 'Datum', 474 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 128 => 0xa, 157 => 'MeasureMode', 474 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 128 => 0x1b, 474 => 'GPSProcessingMethod' },
	'gpssatellites' => { 128 => 0x8, 157 => 'Satellites', 474 => 'GPSSatellites' },
	'gpsspeed' => { 128 => 0xd, 157 => 'Speed', 474 => 'GPSSpeed' },
	'gpsspeedref' => { 128 => 0xc, 474 => 'GPSSpeedRef' },
	'gpsstatus' => { 128 => 0x9, 474 => 'GPSStatus' },
	'gpsstring' => { 135 => 0x402 },
	'gpstimestamp' => { 128 => 0x7 },
	'gpstrack' => { 128 => 0xf, 157 => 'Heading', 474 => 'GPSTrack' },
	'gpstrackref' => { 128 => 0xe, 474 => 'GPSTrackRef' },
	'gpsversionid' => { 128 => 0x0, 474 => 'GPSVersionID' },
	'gradation' => { 288 => 0x50f },
	'gradientbasedcorractive' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 468 => 'GradientBasedCorrections', 470 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue','GradientBasedCorrectionsLocalToningHue'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskcoloramount' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemasklumfeather' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemasklummax' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasktype' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 468 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 470 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 468 => 'GrainAmount', 470 => 'GrainAmount' },
	'graineffect' => { 125 => 0x1047 },
	'grainfrequency' => { 468 => 'GrainFrequency', 470 => 'GrainFrequency' },
	'grainseed' => { 468 => 'GrainSeed', 470 => 'GrainSeed' },
	'grainsize' => { 468 => 'GrainSize', 470 => 'GrainSize' },
	'graymixeraqua' => { 468 => 'GrayMixerAqua', 470 => 'GrayMixerAqua' },
	'graymixerblue' => { 468 => 'GrayMixerBlue', 470 => 'GrayMixerBlue' },
	'graymixergreen' => { 468 => 'GrayMixerGreen', 470 => 'GrayMixerGreen' },
	'graymixermagenta' => { 468 => 'GrayMixerMagenta', 470 => 'GrayMixerMagenta' },
	'graymixerorange' => { 468 => 'GrayMixerOrange', 470 => 'GrayMixerOrange' },
	'graymixerpurple' => { 468 => 'GrayMixerPurple', 470 => 'GrayMixerPurple' },
	'graymixerred' => { 468 => 'GrayMixerRed', 470 => 'GrayMixerRed' },
	'graymixeryellow' => { 468 => 'GrayMixerYellow', 470 => 'GrayMixerYellow' },
	'graypoint' => { 445 => 0x8021 },
	'grayresponseunit' => { 117 => 0x122 },
	'greencurvelimits' => { 106 => 0x1c4 },
	'greencurvepoints' => { 105 => 0x53, 106 => 0x19a },
	'greenhsl' => { 101 => 0x20913 },
	'greenhue' => { 468 => 'GreenHue', 470 => 'GreenHue' },
	'greensaturation' => { 468 => 'GreenSaturation', 470 => 'GreenSaturation' },
	'griddisplay' => { 271 => '13.3', 272 => '4.3', 274 => '4.2', 275 => '4.2', 276 => '2.2', 280 => '10.5', 281 => '3.4', 282 => '6.1', 284 => '4.4', 285 => '4.2', 286 => '4.2' },
	'gripbatteryadload' => { 325 => 0x5 },
	'gripbatteryadnoload' => { 325 => 0x4 },
	'gripbatterystate' => { 325 => '1.2' },
	'group' => { 468 => 'Group', 470 => 'Group' },
	'groupareaafillumination' => { 272 => '46.4', 275 => '47.4', 284 => '47.4' },
	'grouping' => { 363 => ['grup',"\xa9grp"], 371 => "\xa9grp" },
	'guid' => { 363 => 'GUID' },
	'h2resetblackpixels' => { 135 => 0x18a6 },
	'h3resetblackcolumns' => { 135 => 0x18ce },
	'h3resetblackpixels' => { 135 => 0x18b0 },
	'halftonehints' => { 117 => 0x141 },
	'hardlink' => { 118 => 'HardLink' },
	'hasalternative' => { 484 => 'hasAlternative' },
	'hascorrection' => { 484 => 'hasCorrection' },
	'hascorrectiona-lang' => { 484 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 484 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 484 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 468 => 'HasCrop', 470 => 'HasCrop' },
	'hasextendedxmp' => { 496 => 'HasExtendedXMP' },
	'hassettings' => { 468 => 'HasSettings', 470 => 'HasSettings' },
	'hastranslation' => { 484 => 'hasTranslation' },
	'hasvisibleoverprint' => { 499 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 499 => 'HasVisibleTransparency' },
	'hdr' => { 59 => 0x1, 212 => 0x4, 311 => 0x9e, 346 => 0x85, 411 => 0x200a },
	'hdreffect' => { 59 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 212 => 0x0 },
	'hdrlevel' => { 212 => 0x5, 400 => 0x2e, 416 => 0x17 },
	'hdrlevel2' => { 212 => 0x7 },
	'hdrpmakernote' => { 451 => 'hdrp_makernote' },
	'hdrsetting' => { 400 => 0x2d, 416 => 0x16, 419 => 0x1148, 420 => 0x1148, 421 => 0x1124, 422 => 0x11a0, 423 => 0x117c, 424 => 0x1034, 425 => 0x22c, 426 => 0x22c, 427 => 0x21f },
	'hdrshot' => { 311 => 0x76 },
	'hdrsmoothing' => { 212 => 0x6 },
	'hdvideo' => { 363 => 'hdvd' },
	'headline' => { 129 => 0x69, 480 => 'Headline', 482 => 'Headline' },
	'hierarchicalkeywords' => { 168 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 168 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 168 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 168 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 168 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 168 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 168 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 460 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 116 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 316 => 0x1a },
	'highisomultipliergreen' => { 316 => 0x19 },
	'highisomultiplierred' => { 316 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 61 => 0x5, 82 => 0x202, 222 => 0xb1, 346 => 0x71, 398 => 0x2c, 399 => 0x26, 400 => 0x26, 411 => 0x2009, 416 => 0x12, 441 => 0x42 },
	'highisonoisereduction2' => { 411 => 0xb050 },
	'highlight' => { 388 => 0xf },
	'highlight2012' => { 468 => 'Highlight2012', 470 => 'Highlight2012' },
	'highlightadj' => { 101 => 0x2030c },
	'highlightcolordistortreduct' => { 445 => 0x8026 },
	'highlightlinearitylimit' => { 385 => 0xa025 },
	'highlightprotection' => { 263 => 0x6 },
	'highlightrecovery' => { 468 => 'HighlightRecovery', 470 => 'HighlightRecovery' },
	'highlights' => { 411 => 0x2033, 462 => 'Highlights' },
	'highlights2012' => { 468 => 'Highlights2012', 470 => 'Highlights2012' },
	'highlightsadj' => { 445 => 0x9019 },
	'highlightshadow' => { 311 => 0xad },
	'highlighttone' => { 125 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 61 => 0x3, 82 => 0x203 },
	'highlightwarning' => { 311 => 0x8002 },
	'highlowkeyadj' => { 346 => 0x6c },
	'highspeedsync' => { 181 => 0x5, 398 => 0x2, 399 => 0x2 },
	'hintversion' => { 371 => 'hinv' },
	'histogramxml' => { 264 => 0x83a1a25 },
	'history' => { 482 => 'History', 495 => 'History' },
	'historyaction' => { 495 => [\'History','HistoryAction'] },
	'historychanged' => { 495 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 495 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 495 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 495 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 495 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 135 => 0xc88 },
	'holefilldeltathreshold' => { 135 => 0xc7e },
	'hometowncity' => { 111 => 0x3006, 346 => 0x23, 352 => 0x2 },
	'hometowncitycode' => { 353 => 0x1000 },
	'hometowndst' => { 346 => 0x25, 352 => '0.2' },
	'hostcomputer' => { 117 => 0x13c },
	'hostsoftwarerendering' => { 135 => 0xce7 },
	'hue' => { 186 => 0x3b, 225 => 0x3d, 226 => 0x45, 346 => 0x67 },
	'hueadj' => { 267 => 0x2f, 445 => 0x8019 },
	'hueadjust' => { 378 => 0x1016 },
	'hueadjustment' => { 179 => 0x4a, 180 => 0x40, 222 => 0x92, 224 => 0x36 },
	'hueadjustmentaqua' => { 468 => 'HueAdjustmentAqua', 470 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 468 => 'HueAdjustmentBlue', 470 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 468 => 'HueAdjustmentGreen', 470 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 468 => 'HueAdjustmentMagenta', 470 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 468 => 'HueAdjustmentOrange', 470 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 468 => 'HueAdjustmentPurple', 470 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 468 => 'HueAdjustmentRed', 470 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 468 => 'HueAdjustmentYellow', 470 => 'HueAdjustmentYellow' },
	'huesetting' => { 296 => 0x1011 },
	'humanobservation' => { 116 => 'HumanObservation' },
	'humanobservationday' => { 116 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 116 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 116 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 116 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 116 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 116 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 116 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 116 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 116 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 116 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 116 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 116 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 116 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 116 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 116 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 116 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 116 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 116 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 116 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 116 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 117 => 0x9401, 475 => 'Humidity' },
	'icc_profile' => { 118 => 'ICC_Profile' },
	'iccprofilename' => { 482 => 'ICCProfile' },
	'iconuri' => { 371 => 'icnu' },
	'idccreativestyle' => { 445 => 0x8000 },
	'idcpreviewlength' => { 445 => 0x202 },
	'idcpreviewstart' => { 445 => 0x201 },
	'identification' => { 116 => 'Identification' },
	'identificationid' => { 116 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 116 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 116 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 116 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 116 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 116 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 471 => 'identifier', 492 => 'Identifier' },
	'ifcameramodel' => { 135 => 0x9c8 },
	'illumination' => { 282 => '0.5', 373 => 0x48 },
	'imageabsolutex' => { 135 => 0x3fe },
	'imageabsolutey' => { 135 => 0x3ff },
	'imageadjustment' => { 222 => 0x80, 254 => 0x5 },
	'imagealterationconstraints' => { 298 => 'ImageAlterationConstraints' },
	'imagearea' => { 235 => 0x10, 238 => 0x10 },
	'imageareaoffset' => { 346 => 0x38 },
	'imageauthentication' => { 222 => 0x20 },
	'imageboundary' => { 222 => 0x16 },
	'imagecount' => { 125 => 0x1438, 222 => 0xa5, 414 => 0x11b },
	'imagecreator' => { 298 => 'ImageCreator' },
	'imagecreatorid' => { 298 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 298 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 298 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 135 => 0x41f },
	'imagecropy' => { 135 => 0x420 },
	'imagedata' => { 455 => 'Data' },
	'imagedatasize' => { 222 => 0xa2 },
	'imagedescription' => { 117 => 0x10e, 490 => 'ImageDescription' },
	'imageduplicationconstraints' => { 298 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 264 => 0xfe443a45 },
	'imageeditcount' => { 346 => 0x41 },
	'imageediting' => { 346 => 0x32 },
	'imageeffects' => { 378 => 0x1010 },
	'imagefileconstraints' => { 298 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 298 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 298 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 125 => 0x1436 },
	'imageheight' => { 117 => 0x101, 185 => 0xc, 355 => 0x10d, 453 => 'ImageHeight', 490 => 'ImageLength' },
	'imagehistory' => { 117 => 0x9213, 473 => 'ImageHistory' },
	'imageidnumber' => { 306 => 0x340 },
	'imagemimetype' => { 455 => 'Mime' },
	'imagenumber' => { 117 => 0x9211, 153 => 'ImageNumber', 179 => 0xae, 180 => 0x5e, 355 => 0x113, 398 => 0x9b, 400 => [0x400,'276.1',0x314], 465 => 'ImageNumber' },
	'imagenumber2' => { 180 => 0x62 },
	'imageoptimization' => { 222 => 0xa9 },
	'imageorientation' => { 129 => 0x83 },
	'imageprocessing' => { 222 => 0x1a },
	'imageprocessingfiledatecreated' => { 135 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 135 => 0xc80 },
	'imageprocessingversion' => { 292 => 0x0 },
	'imagequality' => { 153 => 'ImageQuality', 237 => '723.2', 238 => '732.2', 248 => '708.1', 311 => 0x1 },
	'imagequality2' => { 288 => 0x603 },
	'imagerank' => { 458 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 135 => 0x600 },
	'imagerboardversion' => { 135 => 0x439 },
	'imagercols' => { 135 => 0x17d4 },
	'imageref' => { 478 => 'ImageRef' },
	'imageregion' => { 480 => 'ImageRegion' },
	'imageregionboundary' => { 480 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 480 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 480 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 480 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 480 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 480 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 480 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 480 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 480 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 480 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 135 => 0x944 },
	'imageresolutionjpg' => { 135 => 0x945 },
	'imagereview' => { 273 => '0.4', 282 => '0.4' },
	'imagereviewmonitorofftime' => { 272 => '21.1', 274 => '21.1', 275 => '21.1', 279 => '20.1', 284 => '21.1', 285 => '21.1' },
	'imagereviewtime' => { 271 => '25.1', 273 => '2.1', 276 => '19.1', 277 => '20.1', 278 => '20.1', 280 => '9.2', 281 => '20.1', 286 => '21.2' },
	'imagerfiledatecreated' => { 135 => 0x9c5 },
	'imagerfileproductionlevel' => { 135 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 135 => 0x9c7 },
	'imagerotated' => { 148 => 0x2a },
	'imagerpowerondelaymsec' => { 135 => 0x5fd },
	'imagerrows' => { 135 => 0x17de },
	'imagesegmentlines' => { 135 => 0x184d },
	'imagesegmentstartline' => { 135 => 0x184c },
	'imagesize' => { 159 => 'ImageSize' },
	'imagesizeraw' => { 222 => 0x3e },
	'imagesizerestriction' => { 487 => 'imageSizeRestriction' },
	'imagesourcedata' => { 117 => 0x935c },
	'imagespace' => { 135 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 111 => 0x3020, 125 => 0x1422, 153 => 'ImageStabilization', 179 => 0xbd, 180 => 0x71, 181 => 0x57, 182 => 0x0, 183 => [0x18,0x107,0x113], 184 => 0x49c2, 222 => 0xac, 288 => 0x604, 291 => 0x1600, 311 => 0x1a, 403 => 0x12, 404 => 0x11, 411 => 0xb026 },
	'imagestabilization2' => { 402 => 0xa },
	'imagestabilizationsetting' => { 184 => 0x14, 398 => 0x3d, 399 => 0x3d, 409 => 0x14 },
	'imagestyle' => { 398 => 0x2d, 399 => 0x27 },
	'imagesupplier' => { 298 => 'ImageSupplier' },
	'imagesupplierid' => { 298 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 298 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 298 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 119 => 0x1 },
	'imagetemperaturemin' => { 119 => 0x2 },
	'imagetone' => { 346 => 0x4f },
	'imagetype' => { 129 => 0x82, 298 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 62 => 0x28, 117 => 0xa420, 473 => 'ImageUniqueID', 474 => 'ImageUniqueID' },
	'imagewidth' => { 117 => 0x100, 185 => 0xe, 355 => 0x10c, 453 => 'ImageWidth', 490 => 'ImageWidth' },
	'inclinationangle' => { 445 => 0x900f },
	'inclinationcorrection' => { 445 => 0x900e },
	'incrementaltemperature' => { 468 => 'IncrementalTemperature', 470 => 'IncrementalTemperature' },
	'incrementaltint' => { 468 => 'IncrementalTint', 470 => 'IncrementalTint' },
	'industry' => { 484 => 'industry', 485 => 'industry' },
	'infobuttonwhenshooting' => { 82 => 0x409 },
	'information' => { 365 => 'information', 371 => "\xa9inf" },
	'infourl' => { 371 => 'infu' },
	'infraredilluminator' => { 372 => 0x28 },
	'ingredientexclusion' => { 486 => 'ingredientExclusion' },
	'ingredients' => { 495 => 'Ingredients' },
	'ingredientsalternatepaths' => { 495 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 495 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 495 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 495 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 495 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 495 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 495 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 495 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 495 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 495 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 495 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 495 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 495 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 495 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 495 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 495 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 495 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 495 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 495 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 495 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 495 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 495 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 495 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 82 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 456 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 456 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 176 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 456 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 456 => 'InitialViewHeadingDegrees', 457 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 456 => 'InitialViewPitchDegrees', 457 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 456 => 'InitialViewRollDegrees', 457 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 271 => '4.4' },
	'initialzoomsetting' => { 271 => '9.3', 280 => '27.3' },
	'inkset' => { 117 => 0x14c },
	'inputprofile' => { 135 => 0x1389 },
	'instanceid' => { 495 => 'InstanceID' },
	'instantplaybacksetup' => { 181 => 0x3e },
	'instantplaybacktime' => { 181 => 0x3d },
	'instructions' => { 482 => 'Instructions' },
	'instrument' => { 494 => 'instrument' },
	'integrationtime' => { 135 => 0x423 },
	'intellectualgenre' => { 479 => 'IntellectualGenre' },
	'intelligentauto' => { 411 => 0xb052, 437 => 0xd, 438 => 0xe, 439 => 0xd },
	'intelligentcontrast' => { 51 => 0x4 },
	'intelligentd-range' => { 311 => 0x79 },
	'intelligentexposure' => { 311 => 0x5d },
	'intelligentresolution' => { 311 => 0x70 },
	'interchangecolorspace' => { 131 => 0x40 },
	'intergraphmatrix' => { 117 => 0x8480 },
	'internalflash' => { 178 => 0x2b, 271 => '23.1', 273 => '8.1', 276 => '22.1', 278 => '23.1', 282 => '8.1', 286 => '24.1', 291 => 0x1208 },
	'internalflashae1' => { 293 => 0x1021 },
	'internalflashae1_0' => { 293 => 0x101d },
	'internalflashae2' => { 293 => 0x1022 },
	'internalflashae2_0' => { 293 => 0x101e },
	'internalflashmode' => { 334 => 0x1 },
	'internalflashstrength' => { 334 => 0x3 },
	'internalflashtable' => { 293 => 0x1024 },
	'internallensserialnumber' => { 385 => 0xa005 },
	'internalndfilter' => { 311 => 0x9d },
	'internalserialnumber' => { 62 => 0x96, 74 => 0x9, 125 => 0x10, 184 => 0x49dc, 287 => 0x18, 289 => 0x102, 308 => 0x500, 311 => 0x25, 326 => 0x4, 378 => 0x5, 429 => [0x7c,0xf0], 430 => 0x88, 431 => [0x88,0x8a] },
	'interopindex' => { 117 => 0x1, 475 => 'InteroperabilityIndex' },
	'interopversion' => { 117 => 0x2 },
	'intervallength' => { 178 => 0x10 },
	'intervalmode' => { 178 => 0x26 },
	'intervalnumber' => { 178 => 0x11 },
	'intervalshooting' => { 346 => 0x92 },
	'introtime' => { 494 => 'introTime' },
	'introtimescale' => { 494 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 494 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 135 => 0xdae },
	'ipfcameramodel' => { 135 => 0xe4d },
	'iptc' => { 118 => 'IPTC' },
	'iptc-naa' => { 117 => 0x83bb, 316 => 0x83bb },
	'iptcbitspersample' => { 131 => 0x56 },
	'iptcdigest' => { 360 => 0x425 },
	'iptcimageheight' => { 131 => 0x1e },
	'iptcimagerotation' => { 131 => 0x66 },
	'iptcimagewidth' => { 131 => 0x14 },
	'iptclastedited' => { 480 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 131 => 0xa },
	'iptcpixelheight' => { 131 => 0x32 },
	'iptcpixelwidth' => { 131 => 0x28 },
	'isalternativeof' => { 484 => 'isAlternativeOf' },
	'isbn' => { 484 => 'isbn' },
	'iscorrectionof' => { 484 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 107 => 0x3 },
	'ismergedhdr' => { 465 => 'IsMergedHDR' },
	'ismergedpanorama' => { 465 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 110 => 0x14, 111 => [0x3014,0x14], 117 => 0x8827, 134 => 0xfd06, 135 => 0x1784, 137 => 0x60, 139 => [0xfa2e,0xfa46], 140 => [0x27,0x28], 141 => 0xf105, 144 => 0x14, 146 => 0x4e, 148 => 0x1e, 149 => 0x1a, 151 => 0x34, 153 => 'ISO', 178 => 0x8, 184 => 0x49ba, 213 => 0x0, 222 => 0x2, 311 => 0xd1, 316 => 0x17, 346 => [0x8b,0x14], 353 => 0x14, 355 => 0x105, 385 => 0xa014, 388 => 0x86, 409 => 0x6f, 416 => [0x1f,0x21,0x25], 474 => 'ISOSpeedRatings' },
	'iso2' => { 213 => 0x6, 232 => 0x265, 233 => 0x25c, 234 => 0x265, 235 => 0x221, 236 => 0x25d, 237 => 0x256, 238 => 0x25d, 242 => 0x2b5, 246 => 0x265, 252 => 0x2b5 },
	'isoauto' => { 327 => '14.4' },
	'isoautohilimit' => { 240 => 0x18eb, 241 => 0xe82, 250 => 0x185d },
	'isoautomax' => { 410 => 0x4 },
	'isoautomin' => { 410 => 0x2 },
	'isoautoparameters' => { 346 => 0x7a },
	'isoautoshuttertime' => { 240 => 0x18ea, 241 => 0xe81, 250 => 0x185c },
	'isocalibrationgain' => { 135 => 0x89f },
	'isodisplay' => { 274 => '4.1', 275 => '4.1', 276 => '2.3', 277 => '3.3', 278 => '3.3', 281 => '3.3', 284 => '4.3', 285 => '4.1', 286 => '4.3' },
	'isoexpansion' => { 82 => 0x103, 83 => 0x7, 84 => 0x8, 87 => 0x8, 213 => 0x4 },
	'isoexpansion2' => { 213 => 0xa },
	'isofloor' => { 327 => 0x6 },
	'isoselected' => { 310 => 0x359 },
	'isoselection' => { 222 => 0xf },
	'isosensitivitystep' => { 279 => '6.2', 281 => '6.2' },
	'isosetting' => { 137 => 0x5e, 149 => 0x14, 153 => 'ISOSetting', 178 => 0x24, 179 => 0x26, 180 => 0x1c, 181 => 0x13, 186 => 0x6, 222 => 0x13, 327 => '17.3', 377 => 0x27, 398 => 0x16, 399 => 0x14, 400 => 0x2, 409 => 0x6d, 410 => 0x0 },
	'isospeed' => { 117 => 0x8833, 475 => 'ISOSpeed' },
	'isospeedexpansion' => { 81 => 0x3 },
	'isospeedincrements' => { 82 => 0x102 },
	'isospeedlatitudeyyy' => { 117 => 0x8834, 475 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 117 => 0x8835, 475 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 82 => 0x103 },
	'isostepsize' => { 271 => '6.1', 272 => '7.2', 274 => '7.2', 275 => '7.2', 280 => '4.1', 284 => '7.2', 285 => '7.2' },
	'isovalue' => { 293 => 0x1001 },
	'isrccode' => { 371 => "\xa9isr" },
	'issn' => { 484 => 'issn' },
	'issueidentifier' => { 484 => 'issueIdentifier' },
	'issuename' => { 484 => 'issueName' },
	'issueteaser' => { 484 => 'issueTeaser' },
	'issuetype' => { 484 => 'issueType' },
	'istranslationof' => { 484 => 'isTranslationOf' },
	'itemsubtype' => { 175 => 'ItemSubType' },
	'itunesu' => { 363 => 'itnu' },
	'jobid' => { 129 => 0xb8 },
	'jobname' => { 476 => 'JobName' },
	'jobref' => { 493 => 'JobRef' },
	'jobrefid' => { 493 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 493 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 493 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 476 => 'JobStatus' },
	'jpeg-heifswitch' => { 411 => 0x2039 },
	'jpeghandling' => { 468 => 'JPEGHandling', 470 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 311 => 0x43, 313 => 0x3034, 411 => 0xb047 },
	'jpegsize' => { 313 => 0x303a },
	'jpgcompression' => { 241 => 0x7d4 },
	'jpgfromraw' => { 95 => 0x2007, 112 => 'Exif-JpgFromRaw', 316 => 0x2e },
	'jpgfromrawlength' => { 117 => [0x117,0x202] },
	'jpgfromrawstart' => { 117 => [0x111,0x201] },
	'jpgrecordedpixels' => { 327 => '14.1' },
	'jurisdiction' => { 466 => 'jurisdiction' },
	'kelvinwb_01' => { 335 => 0x5 },
	'kelvinwb_02' => { 335 => 0x9 },
	'kelvinwb_03' => { 335 => 0xd },
	'kelvinwb_04' => { 335 => 0x11 },
	'kelvinwb_05' => { 335 => 0x15 },
	'kelvinwb_06' => { 335 => 0x19 },
	'kelvinwb_07' => { 335 => 0x1d },
	'kelvinwb_08' => { 335 => 0x21 },
	'kelvinwb_09' => { 335 => 0x25 },
	'kelvinwb_10' => { 335 => 0x29 },
	'kelvinwb_11' => { 335 => 0x2d },
	'kelvinwb_12' => { 335 => 0x31 },
	'kelvinwb_13' => { 335 => 0x35 },
	'kelvinwb_14' => { 335 => 0x39 },
	'kelvinwb_15' => { 335 => 0x3d },
	'kelvinwb_16' => { 335 => 0x41 },
	'kelvinwb_daylight' => { 335 => 0x1 },
	'kerneldenominators' => { 135 => 0x933 },
	'key' => { 494 => 'key' },
	'keystonecompensation' => { 292 => 0x1900 },
	'keystonedirection' => { 292 => 0x1901 },
	'keystonevalue' => { 292 => 0x1906 },
	'keyword' => { 363 => 'keyw', 484 => 'keyword' },
	'keywordinfo' => { 168 => 'Keywords' },
	'keywords' => { 129 => 0x19, 154 => 'Keywords', 297 => 'Keywords', 362 => 'Keywords', 365 => 'keywords', 463 => 'keywords', 481 => 'Keywords', 492 => 'Keywords' },
	'killdate' => { 484 => 'killDate' },
	'killdatea-platform' => { 484 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 484 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 134 => 0xf908, 137 => 0xe, 139 => [0xfa1e,0xfa52], 145 => 0x70 },
	'kodakimagewidth' => { 134 => 0xf907, 137 => 0xc, 139 => [0xfa1d,0xfa51], 145 => 0x6c },
	'kodakinfotype' => { 134 => 0xfa00 },
	'kodaklook' => { 135 => 0xe4c },
	'kodaklookprofile' => { 135 => 0x138a },
	'kodakmaker' => { 145 => 0x8 },
	'kodakmodel' => { 137 => 0x0, 145 => 0x28 },
	'kodaktag' => { 135 => 0x3ea },
	'kodakversion' => { 135 => 0x0 },
	'label' => { 301 => 'Label', 492 => 'Label' },
	'labelname1' => { 478 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 478 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 311 => 0x6f },
	'landscapeoutputhighlightpoint' => { 107 => 0x26 },
	'landscapeoutputshadowpoint' => { 107 => 0x27 },
	'landscaperawcolortone' => { 107 => 0x1f },
	'landscaperawcontrast' => { 107 => 0x21 },
	'landscaperawhighlight' => { 107 => 0x77 },
	'landscaperawhighlightpoint' => { 107 => 0x24 },
	'landscaperawlinear' => { 107 => 0x22 },
	'landscaperawsaturation' => { 107 => 0x20 },
	'landscaperawshadow' => { 107 => 0x80 },
	'landscaperawshadowpoint' => { 107 => 0x25 },
	'landscaperawsharpness' => { 107 => 0x23 },
	'landscapeunsharpmaskfineness' => { 107 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 107 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 107 => 0xa2 },
	'language' => { 471 => 'language' },
	'languageidentifier' => { 129 => 0x87 },
	'largestvalidinteriorrectheight' => { 456 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 456 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 456 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 456 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 178 => 0x1b },
	'lastkeywordiptc' => { 175 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 175 => 'LastKeywordXMP' },
	'lastphotodate' => { 456 => 'LastPhotoDate' },
	'lasturl' => { 495 => 'LastURL' },
	'lateralchromaticaberration' => { 411 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 465 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 116 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 116 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 116 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 116 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 116 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 114 => 'Latitude' },
	'lc1' => { 337 => 0x2 },
	'lc10' => { 337 => 0xb },
	'lc11' => { 337 => 0xc },
	'lc12' => { 337 => 0xd },
	'lc14' => { 337 => 0xf },
	'lc15' => { 337 => 0x10 },
	'lc3' => { 337 => 0x4 },
	'lc4' => { 337 => 0x5 },
	'lc5' => { 337 => 0x6 },
	'lc6' => { 337 => 0x7 },
	'lc7' => { 337 => 0x8 },
	'lc8' => { 337 => 0x9 },
	'lcddisplayatpoweron' => { 82 => 0x811, 86 => 0xa },
	'lcddisplayreturntoshoot' => { 87 => 0x12 },
	'lcdillumination' => { 271 => '17.5', 272 => '5.2', 274 => '5.1', 275 => '5.1', 280 => '10.3', 281 => '4.2', 284 => '5.2', 285 => '5.1', 286 => '5.4' },
	'lcdilluminationduringbulb' => { 82 => 0x408 },
	'lcdmatrix' => { 135 => 0xe74 },
	'lcdmatrixchickfix' => { 135 => 0xe75 },
	'lcdmatrixmarvin' => { 135 => 0xe76 },
	'lcdpanels' => { 81 => 0x8 },
	'lcheditor' => { 264 => 0x8ae85e },
	'legacyiptcdigest' => { 482 => 'LegacyIPTCDigest' },
	'legalcode' => { 466 => 'legalcode' },
	'lens' => { 117 => 0xfdea, 222 => 0x84, 465 => 'Lens' },
	'lensafstopbutton' => { 80 => 0x11, 81 => 0x13, 82 => 0x506, 83 => 0x10, 84 => 0x12, 87 => 0x13, 88 => 0x9 },
	'lensaperturerange' => { 388 => [0x30,0x48] },
	'lenscorrectionsettings' => { 473 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 465 => 'LensDistortInfo' },
	'lensdistortionparams' => { 293 => 0x206 },
	'lensdrivenoaf' => { 82 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 400 => 0x3f0, 444 => 0xd },
	'lensfirmware' => { 379 => 0x20, 385 => 0xa004 },
	'lensfirmwareversion' => { 289 => 0x204, 311 => 0x60, 400 => 0x3f3, 444 => 0x14 },
	'lensfocallength' => { 101 => 0xf0512, 337 => 0x9 },
	'lensfocalrange' => { 388 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 272 => '55.1', 274 => '52.1', 275 => '52.1', 284 => '52.1', 285 => '52.1' },
	'lensformat' => { 423 => 0x1891, 425 => 0x18bd, 426 => 0x18ed, 427 => 0x17f1, 429 => 0x106, 430 => 0x106, 440 => 0x603, 441 => 0x5d },
	'lensfstops' => { 214 => 0x7, 215 => 0xc, 216 => 0xd, 220 => 0xe, 222 => 0x8b, 337 => '0.3' },
	'lensid' => { 220 => 0x30, 465 => 'LensID' },
	'lensidnumber' => { 214 => 0x6, 215 => 0xb, 216 => 0xc, 220 => 0xd },
	'lensinfo' => { 117 => 0xa432, 343 => 0x2a, 465 => 'LensInfo', 475 => 'LensSpecification' },
	'lenskind' => { 337 => 0x1 },
	'lensmake' => { 117 => 0xa433, 160 => 'Make', 475 => 'LensMake' },
	'lensmanualdistortionamount' => { 468 => 'LensManualDistortionAmount', 470 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 175 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 388 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 62 => 0x95, 117 => 0xa434, 160 => 'Model', 175 => 'LensModel', 217 => 0x18a, 218 => 0x18b, 219 => 0x2ac, 289 => 0x203, 343 => 0xc, 355 => 0x412, 475 => 'LensModel' },
	'lensmodulationoptimizer' => { 125 => 0x1045 },
	'lensmount' => { 400 => 0x99, 423 => 0x1892, 425 => 0x18be, 426 => 0x18ee, 427 => 0x17f2, 429 => 0x105, 430 => 0x105, 440 => 0x604, 441 => 0x5e },
	'lensmount2' => { 444 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 468 => 'LensProfileChromaticAberrationScale', 470 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 468 => 'LensProfileDigest', 470 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 468 => 'LensProfileDistortionScale', 470 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 468 => 'LensProfileEnable', 470 => 'LensProfileEnable' },
	'lensprofilefilename' => { 468 => 'LensProfileFilename', 470 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 468 => 'LensProfileIsEmbedded', 470 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 468 => 'LensProfileMatchKeyCameraModelName', 470 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 468 => 'LensProfileMatchKeyExifMake', 470 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 468 => 'LensProfileMatchKeyExifModel', 470 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 468 => 'LensProfileMatchKeyIsRaw', 470 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 468 => 'LensProfileMatchKeyLensID', 470 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 468 => 'LensProfileMatchKeyLensInfo', 470 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 468 => 'LensProfileMatchKeyLensName', 470 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 468 => 'LensProfileMatchKeySensorFormatFactor', 470 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 468 => 'LensProfileName', 470 => 'LensProfileName' },
	'lensprofilesetup' => { 468 => 'LensProfileSetup', 470 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 468 => 'LensProfileVignettingScale', 470 => 'LensProfileVignettingScale' },
	'lensproperties' => { 289 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 60 => 0x0, 117 => 0xa435, 160 => 'SerialNumber', 289 => 0x202, 309 => 0x321, 311 => 0x52, 371 => 'LENS', 379 => 0x30, 465 => 'LensSerialNumber', 475 => 'LensSerialNumber' },
	'lensshutterlock' => { 181 => 0x4a },
	'lensspec' => { 395 => 0x0, 396 => 0x0, 397 => 0x0, 411 => 0xb02a },
	'lensspecfeatures' => { 429 => [0x115,0x116], 430 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 293 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 183 => 0x10c, 184 => 0x49bd, 222 => 0x83, 289 => 0x201, 302 => 0x16, 306 => 0x310, 308 => 0x303, 309 => 0x303, 311 => 0x51, 313 => 0x3405, 338 => 0x0, 339 => 0x0, 340 => 0x1, 341 => 0x1, 342 => 0x1, 344 => 0x0, 385 => 0xa003, 388 => 0x27, 411 => 0xb027, 423 => 0x1896, 425 => 0x18c2, 426 => 0x18f2, 427 => 0x17f6, 429 => 0x109, 430 => 0x109, 440 => 0x608, 441 => 0x62 },
	'lenstype2' => { 400 => 0x3f7, 423 => 0x1893, 425 => 0x18bf, 426 => 0x18ef, 427 => 0x17f3, 429 => 0x107, 430 => 0x107, 440 => 0x605, 441 => 0x60 },
	'lenstype3' => { 444 => 0x9 },
	'lenstypemake' => { 311 => 0xc4 },
	'lenstypemodel' => { 311 => [0xc5,0xe4] },
	'lenszoomposition' => { 437 => 0x19, 438 => 0x1e, 441 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 319 => 0x15 },
	'levelmeter' => { 371 => ['Lvlm','lvlm'] },
	'levelorientation' => { 345 => 0x0 },
	'license' => { 466 => 'license' },
	'licensee' => { 298 => 'Licensee' },
	'licenseeid' => { 298 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 298 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 298 => 'LicenseeImageNotes' },
	'licenseename' => { 298 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 298 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 298 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 298 => 'LicenseeTransactionID' },
	'licenseid' => { 298 => 'LicenseID' },
	'licensestartdate' => { 298 => 'LicenseStartDate' },
	'licensetransactiondate' => { 298 => 'LicenseTransactionDate' },
	'licensetype' => { 472 => 'licensetype' },
	'licensor' => { 298 => 'Licensor' },
	'licensorcity' => { 298 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 298 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 298 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 298 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 298 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 298 => 'LicensorImageID' },
	'licensorname' => { 298 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 298 => 'LicensorNotes' },
	'licensorpostalcode' => { 298 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 298 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 298 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 298 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 298 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 298 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 298 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 298 => 'LicensorTransactionID' },
	'licensorurl' => { 298 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 293 => 0x1009 },
	'lightingmode' => { 111 => 0x302a },
	'lightreading' => { 346 => 0x15 },
	'lightsource' => { 117 => 0x9208, 222 => 0x90, 296 => 0x1000, 474 => 'LightSource' },
	'lightsourcespecial' => { 387 => 0x21d },
	'lightswitch' => { 284 => '0.1', 286 => '0.1' },
	'lightvaluecenter' => { 293 => 0x103d },
	'lightvalueperiphery' => { 293 => 0x103e },
	'limitafareamodeselection' => { 272 => '51.1', 274 => '49.1', 275 => '49.1', 284 => '49.1', 285 => '49.1' },
	'linearitylimitblue' => { 316 => 0x10 },
	'linearitylimitgreen' => { 316 => 0xf },
	'linearitylimitred' => { 316 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 44 => [0x2ba,0x2d1,0x2d5], 46 => 0x1e5, 47 => [0x1fe,0x2de], 48 => [0x232,0x310], 49 => 0x31e },
	'linearizationtable' => { 117 => 0xc618 },
	'linearresponselimit' => { 117 => 0xc62e },
	'link' => { 484 => 'link' },
	'linkaetoafpoint' => { 327 => '14.2' },
	'linkedencodedrightsexpr' => { 480 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 480 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 480 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 480 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 135 => 0x904 },
	'lithostratigraphicterms' => { 116 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 365 => 'live-photo.auto' },
	'livephotovitalityscore' => { 365 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 365 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 276 => '32.1', 286 => '34.1' },
	'liveviewafareamode' => { 281 => '34.1' },
	'liveviewafmethod' => { 416 => 0x20 },
	'liveviewafmode' => { 281 => '34.2' },
	'liveviewafsetting' => { 400 => 0x36 },
	'liveviewbuttonoptions' => { 272 => '50.2', 274 => '48.2', 275 => '48.2', 284 => '48.2', 285 => '48.2' },
	'liveviewexposuresimulation' => { 82 => 0x810 },
	'liveviewfocusmode' => { 400 => [0x8b,0x28b] },
	'liveviewmetering' => { 400 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 272 => '21.2', 274 => '21.2', 275 => '21.2', 277 => '20.2', 278 => '20.2', 279 => '20.2', 281 => '20.2', 284 => '21.2', 285 => '21.2' },
	'liveviewshooting' => { 56 => 0x13 },
	'livingspecimen' => { 116 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 116 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 129 => 0x79 },
	'localizedcameramodel' => { 117 => 0xc615 },
	'locallocationname' => { 385 => 0x30 },
	'location' => { 221 => 0x9, 311 => 0x67, 461 => 'Location', 479 => 'Location', 483 => 'location', 484 => 'location' },
	'locationaccuracyhorizontal' => { 365 => 'location.accuracy.horizontal' },
	'locationareacode' => { 467 => 'lac' },
	'locationbody' => { 365 => 'location.body' },
	'locationcreated' => { 480 => 'LocationCreated' },
	'locationcreatedcity' => { 480 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 480 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 480 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 480 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 480 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 480 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 480 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 480 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 480 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 480 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 480 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 480 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 365 => 'location.date' },
	'locationinformation' => { 371 => 'loci' },
	'locationinfoversion' => { 221 => 0x0 },
	'locationname' => { 365 => 'location.name', 385 => 0x31 },
	'locationnote' => { 365 => 'location.note' },
	'locationrole' => { 365 => 'location.role' },
	'locationshown' => { 480 => 'LocationShown' },
	'locationshowncity' => { 480 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 480 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 480 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 480 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 480 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 480 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 480 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 480 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 480 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 480 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 480 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 480 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 82 => 0x709 },
	'logcomment' => { 494 => 'logComment' },
	'logscale' => { 135 => 0x902 },
	'longdescription' => { 363 => 'ldes' },
	'longexposurenoisereduction' => { 61 => 0x4, 82 => 0x201, 83 => 0x1, 84 => 0x2, 85 => 0x1, 86 => 0x1, 87 => 0x2, 88 => 0x1, 311 => 0x49, 398 => 0x2b, 399 => 0x25, 400 => 0x25, 411 => 0x2008, 416 => 0x11, 441 => 0x44 },
	'longexposurenoisereduction2' => { 56 => 0x8 },
	'longexposurenrused' => { 311 => 0xbe },
	'longitude' => { 114 => 'Longitude' },
	'look' => { 468 => 'Look', 470 => 'Look' },
	'lookamount' => { 468 => [\'Look','LookAmount'], 470 => [\'Look','LookAmount'] },
	'lookcluster' => { 468 => [\'Look','LookCluster'], 470 => [\'Look','LookCluster'] },
	'lookcopyright' => { 468 => [\'Look','LookCopyright'], 470 => [\'Look','LookCopyright'] },
	'lookgroup' => { 468 => [\'Look','LookGroup'], 470 => [\'Look','LookGroup'] },
	'lookname' => { 468 => 'LookName', 470 => 'LookName' },
	'lookparameters' => { 468 => [\'Look','LookParameters'], 470 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 468 => [\'Look','LookParametersCameraProfile'], 470 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 468 => [\'Look','LookParametersClarity2012'], 470 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 468 => [\'Look','LookParametersConvertToGrayscale'], 470 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 468 => [\'Look','LookParametersLookTable'], 470 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 468 => [\'Look','LookParametersProcessVersion'], 470 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 468 => [\'Look','LookParametersToneCurvePV2012'], 470 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparametersversion' => { 468 => [\'Look','LookParametersVersion'], 470 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 468 => [\'Look','LookSupportsAmount'], 470 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 468 => [\'Look','LookSupportsMonochrome'], 470 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 468 => [\'Look','LookSupportsOutputReferred'], 470 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 468 => [\'Look','LookUUID'], 470 => [\'Look','LookUUID'] },
	'loop' => { 494 => 'loop' },
	'loopstyle' => { 371 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 116 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 468 => 'LuminanceAdjustmentAqua', 470 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 468 => 'LuminanceAdjustmentBlue', 470 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 468 => 'LuminanceAdjustmentGreen', 470 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 468 => 'LuminanceAdjustmentMagenta', 470 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 468 => 'LuminanceAdjustmentOrange', 470 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 468 => 'LuminanceAdjustmentPurple', 470 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 468 => 'LuminanceAdjustmentRed', 470 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 468 => 'LuminanceAdjustmentYellow', 470 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 106 => 0x150 },
	'luminancecurvepoints' => { 106 => 0x126 },
	'luminancenoisereduction' => { 101 => 0x20600, 107 => 0x5f, 388 => 0x1b },
	'luminancenoisereductioncontrast' => { 468 => 'LuminanceNoiseReductionContrast', 470 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 468 => 'LuminanceNoiseReductionDetail', 470 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 107 => 0x6d },
	'luminancesmoothing' => { 468 => 'LuminanceSmoothing', 470 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 82 => [0x40b,0x40c] },
	'lyrics' => { 363 => "\xa9lyr", 371 => "\xa9lyr", 494 => 'lyrics' },
	'lyricsuri' => { 371 => 'lrcu' },
	'm16cversion' => { 306 => 0x333 },
	'macatom' => { 469 => 'macAtom' },
	'macatomapplicationcode' => { 469 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 469 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 469 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 116 => 'MachineObservation' },
	'machineobservationday' => { 116 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 116 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 116 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 116 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 116 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 116 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 116 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 116 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 116 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 116 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 116 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 116 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 116 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 116 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 116 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 116 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 116 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 116 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 116 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 116 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 125 => 0x1020, 127 => 0x202, 148 => 0x2b, 293 => 0x202, 377 => 0x21, 387 => 0x202, 411 => 0xb040 },
	'macroled' => { 291 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 56 => 0x10 },
	'macromode' => { 34 => 0x1, 178 => 0xb, 288 => 0x300, 311 => 0x1c, 378 => 0x1009 },
	'magentahsl' => { 101 => 0x20917 },
	'magicfilter' => { 288 => 0x52c },
	'magnifiedview' => { 84 => 0x11, 86 => 0x9 },
	'mainboardversion' => { 135 => 0x438 },
	'maindialexposurecomp' => { 282 => '0.6' },
	'mainingredient' => { 486 => 'mainIngredient' },
	'majorversion' => { 459 => 'MajorVersion' },
	'make' => { 96 => 0x0, 113 => 0x1, 117 => 0x10f, 153 => 'Make', 301 => 'Make', 316 => 0x10f, 365 => 'make', 371 => ['@mak',"\xa9mak"], 483 => 'make', 490 => 'Make' },
	'makernote' => { 474 => 'MakerNote' },
	'makernoteapple' => { 115 => 'MakN', 117 => 0x927c },
	'makernotecanon' => { 115 => 'MakN', 117 => 0x927c },
	'makernotecasio' => { 115 => 'MakN', 117 => 0x927c },
	'makernotecasio2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotedji' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteflir' => { 115 => 'MakN', 117 => 0x927c },
	'makernotefujifilm' => { 115 => 'MakN', 117 => 0x927c },
	'makernotege' => { 115 => 'MakN', 117 => 0x927c },
	'makernotege2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotehasselblad' => { 115 => 'MakN', 117 => 0x927c },
	'makernotehp' => { 115 => 'MakN', 117 => 0x927c },
	'makernotehp2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotehp4' => { 115 => 'MakN', 117 => 0x927c },
	'makernotehp6' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteisl' => { 115 => 'MakN', 117 => 0x927c },
	'makernotejvc' => { 115 => 'MakN', 117 => 0x927c },
	'makernotejvctext' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak10' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak11' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak12' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak1a' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak1b' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak4' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak5' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak6a' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak6b' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak7' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak8a' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak8b' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak8c' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodak9' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekodakunknown' => { 115 => 'MakN', 117 => 0x927c },
	'makernotekyocera' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica10' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica2' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica3' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica4' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica5' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica6' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica7' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica8' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteleica9' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteminolta' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteminolta2' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteminolta3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotemotorola' => { 115 => 'MakN', 117 => 0x927c },
	'makernotenikon' => { 115 => 'MakN', 117 => 0x927c },
	'makernotenikon2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotenikon3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotenintendo' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteoffset' => { 387 => 0xff },
	'makernoteolympus' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteolympus2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepanasonic' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepanasonic2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepanasonic3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentax' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentax2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentax3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentax4' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentax5' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentax6' => { 115 => 'MakN', 117 => 0x927c },
	'makernotepentaxunknown' => { 371 => 'PXMN' },
	'makernotephaseone' => { 115 => 'MakN', 117 => 0x927c },
	'makernotereconyx' => { 115 => 'MakN', 117 => 0x927c },
	'makernotereconyx2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotereconyx3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotericoh' => { 115 => 'MakN', 117 => 0x927c },
	'makernotericoh2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotericohpentax' => { 115 => 'MakN', 117 => 0x927c },
	'makernotericohtext' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesafety' => { 117 => 0xc635 },
	'makernotesamsung1a' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesamsung1b' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesamsung2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesanyo' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesanyoc4' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesanyopatch' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesigma' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesony' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesony2' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesony3' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesony4' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesony5' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesonyericsson' => { 115 => 'MakN', 117 => 0x927c },
	'makernotesonysrf' => { 115 => 'MakN', 117 => 0x927c },
	'makernotetype' => { 378 => 0x1 },
	'makernoteunknown' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteunknownbinary' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteunknowntext' => { 115 => 'MakN', 117 => 0x927c },
	'makernoteversion' => { 183 => 0x0, 222 => 0x1, 293 => 0x0, 311 => 0x8000, 382 => 0x0, 385 => 0x1, 388 => [0x1d,0x1f], 401 => 0x2000 },
	'makerurl' => { 371 => "\xa9mal" },
	'managedfrom' => { 495 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 495 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 495 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 495 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 495 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 495 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 495 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 495 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 495 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 495 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 495 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 495 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 495 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 495 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 495 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 495 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 495 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 495 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 495 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 495 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 495 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 495 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 495 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 495 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 495 => 'Manager' },
	'managervariant' => { 495 => 'ManagerVariant' },
	'manageto' => { 495 => 'ManageTo' },
	'manageui' => { 495 => 'ManageUI' },
	'manifest' => { 495 => 'Manifest' },
	'manifestlinkform' => { 495 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 495 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 495 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 495 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 495 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 495 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 495 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 495 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 495 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 495 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 495 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 495 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 495 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 495 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 495 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 495 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 495 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 495 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 495 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 495 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 495 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 495 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 495 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 495 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 495 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 495 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 495 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 495 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 288 => 0x900, 311 => 0x86 },
	'manometerreading' => { 288 => 0x901 },
	'manualafpointselectpattern' => { 82 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 291 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 273 => '8.2', 276 => '22.2', 277 => '23.1', 278 => '23.2', 280 => '16.2', 281 => '23.2', 282 => '8.2', 283 => '23.2', 286 => '24.2', 378 => 0x100c },
	'manualflashstrength' => { 288 => 0x406 },
	'manualfocusdistance' => { 222 => 0x85, 293 => 0x100c, 387 => 0x223 },
	'manualtv' => { 81 => 0x5, 82 => 0x705 },
	'manufacturedate' => { 188 => 0x6705, 326 => 0x1 },
	'manufacturedate1' => { 380 => 0x4 },
	'manufacturedate2' => { 380 => 0x5 },
	'manufacturer' => { 453 => 'Manufacturer', 483 => 'manufacturer' },
	'mariahchromablursize' => { 135 => 0xf0d },
	'mariahmaphithreshold' => { 135 => 0xf0c },
	'mariahmaplothreshold' => { 135 => 0xf0b },
	'mariahsigmathreshold' => { 135 => 0xf0e },
	'mariahtexturethreshold' => { 135 => 0xf0a },
	'marked' => { 481 => 'Marked', 498 => 'Marked' },
	'markers' => { 494 => 'markers' },
	'markerscomment' => { 494 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 494 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 494 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 494 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 494 => [\'markers','markersCuePointType'] },
	'markersduration' => { 494 => [\'markers','markersDuration'] },
	'markerslocation' => { 494 => [\'markers','markersLocation'] },
	'markersname' => { 494 => [\'markers','markersName'] },
	'markersprobability' => { 494 => [\'markers','markersProbability'] },
	'markersspeaker' => { 494 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 494 => [\'markers','markersStartTime'] },
	'markerstarget' => { 494 => [\'markers','markersTarget'] },
	'markerstype' => { 494 => [\'markers','markersType'] },
	'maskedareas' => { 117 => 0xc68e },
	'masterdocumentid' => { 129 => 0xb9 },
	'mastergain' => { 230 => 0x50 },
	'materialsample' => { 116 => 'MaterialSample' },
	'materialsampleid' => { 116 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 272 => '50.1', 274 => '48.1', 275 => '48.1', 284 => '48.1', 285 => '48.1' },
	'matrixselectk' => { 135 => 0x91b },
	'matrixselectthreshold' => { 135 => 0x91a },
	'matrixselectthreshold1' => { 135 => 0x91e },
	'matrixselectthreshold2' => { 135 => 0x91f },
	'matrixstructure' => { 370 => 0xa },
	'maxaperture' => { 34 => 0x1a, 135 => 0x3f9, 141 => 0x6103, 160 => 'MaxAperture', 178 => 0x17, 184 => 0x49c5, 220 => 0x36, 289 => 0x20a, 337 => '14.1' },
	'maxapertureatmaxfocal' => { 125 => 0x1407, 160 => 'MaxApertureAtMaxFocal', 214 => 0xb, 215 => 0x10, 216 => 0x11, 220 => 0x12, 289 => 0x206 },
	'maxapertureatminfocal' => { 125 => 0x1406, 214 => 0xa, 215 => 0xf, 216 => 0x10, 220 => 0x11, 289 => 0x205 },
	'maxaperturevalue' => { 117 => 0x9205, 355 => 0x414, 474 => 'MaxApertureValue' },
	'maxavailheight' => { 480 => 'MaxAvailHeight' },
	'maxavailwidth' => { 480 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 271 => 0xb, 272 => 0xc, 274 => '12.1', 275 => '12.1', 280 => 0xc, 281 => 0xb, 284 => '12.1', 285 => '12.1' },
	'maxfaces' => { 292 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 125 => 0x1405, 160 => 'MaxFocalLength', 214 => 0x9, 215 => 0xe, 216 => 0xf, 220 => 0x10, 289 => 0x208, 423 => 0x127c, 424 => 0x1138, 425 => 0x330, 426 => 0x330, 427 => 0x30e },
	'maximumdensityrange' => { 131 => 0x8c },
	'maxpagesize' => { 499 => 'MaxPageSize' },
	'maxpagesizeh' => { 499 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 499 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 499 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 135 => 0xc7d },
	'maxsamplevalue' => { 117 => 0x119 },
	'maxstorage' => { 489 => 'maxstorage' },
	'mb-d10batteries' => { 271 => '12.6' },
	'mb-d10batterytype' => { 280 => '13.3' },
	'mb-d11batterytype' => { 281 => '2.3' },
	'mb-d12batterytype' => { 284 => '3.2' },
	'mb-d80batteries' => { 282 => '6.5' },
	'mb-d80batterytype' => { 286 => '3.2' },
	'mcuversion' => { 214 => 0xc, 215 => 0x11, 216 => 0x12, 220 => 0x13 },
	'md5digest' => { 161 => 'zmd5' },
	'mditemfindercomment' => { 170 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 170 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 170 => 'MDItemFSLabel' },
	'mditemusertags' => { 170 => 'MDItemUserTags' },
	'meal' => { 486 => 'meal' },
	'measuredev' => { 28 => 0x9, 75 => 0x3, 95 => 0x1814, 153 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 75 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 184 => 0x690, 306 => 0x312, 309 => 0x312, 310 => 0x312, 313 => 0x3407 },
	'measuredrggb' => { 63 => 0x1 },
	'measuredrggbdata' => { 43 => 0x287 },
	'measurementaccuracy' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 116 => 'MeasurementOrFact' },
	'measurementremarks' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 116 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 453 => 'MeasureType' },
	'mechanicalshuttercount' => { 222 => 0x37 },
	'mediaclassprimaryid' => { 176 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 176 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 298 => 'MediaConstraints' },
	'mediacreatedate' => { 367 => 0x1 },
	'mediaeventiddate' => { 458 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 367 => 0x2 },
	'mediasummarycode' => { 298 => 'MediaSummaryCode' },
	'mediatype' => { 363 => 'stik' },
	'memoaudioquality' => { 82 => 0x812 },
	'memorycardconfiguration' => { 404 => 0x16 },
	'memorycardnumber' => { 204 => 0x2 },
	'menubuttondisplayposition' => { 80 => 0xb, 83 => 0xa, 84 => 0xb, 87 => 0xb },
	'menubuttonreturn' => { 88 => 0xb },
	'menumonitorofftime' => { 271 => '26.1', 272 => '22.1', 274 => '22.1', 275 => '22.1', 279 => '21.1', 280 => '8.2', 281 => '21.1', 284 => '22.1', 285 => '22.1', 286 => '22.1' },
	'metadatadate' => { 492 => 'MetadataDate' },
	'metadatamoddate' => { 494 => 'metadataModDate' },
	'metaversion' => { 418 => 0x34 },
	'meterinfo1row1' => { 412 => 0x0, 413 => 0x0 },
	'meterinfo1row2' => { 412 => 0x6c, 413 => 0x5a },
	'meterinfo1row3' => { 412 => 0xd8, 413 => 0xb4 },
	'meterinfo1row4' => { 412 => 0x144, 413 => 0x10e },
	'meterinfo1row5' => { 412 => 0x1b0, 413 => 0x168 },
	'meterinfo1row6' => { 412 => 0x21c, 413 => 0x1c2 },
	'meterinfo1row7' => { 412 => 0x288, 413 => 0x21c },
	'meterinfo2row1' => { 412 => 0x2f4, 413 => 0x276 },
	'meterinfo2row2' => { 412 => 0x378, 413 => 0x2e4 },
	'meterinfo2row3' => { 412 => 0x3fc, 413 => 0x352 },
	'meterinfo2row4' => { 412 => 0x480, 413 => 0x3c0 },
	'meterinfo2row5' => { 412 => 0x504, 413 => 0x42e },
	'meterinfo2row6' => { 412 => 0x588, 413 => 0x49c },
	'meterinfo2row7' => { 412 => 0x60c, 413 => 0x50a },
	'meterinfo2row8' => { 412 => 0x690, 413 => 0x578 },
	'meterinfo2row9' => { 412 => 0x714, 413 => 0x5e6 },
	'metering' => { 273 => '6.1' },
	'meteringmode' => { 34 => 0x11, 117 => 0x9207, 137 => 0x1c, 178 => 0x7, 179 => 0x25, 181 => 0x12, 288 => 0x202, 346 => 0x17, 388 => 0x9, 398 => 0x15, 399 => 0x13, 400 => 0x7, 416 => 0x3, 419 => 0x1174, 420 => 0x1178, 421 => 0x1154, 422 => 0x11d0, 423 => 0x11ac, 424 => 0x1064, 425 => 0x25c, 426 => 0x25c, 427 => 0x24b, 474 => 'MeteringMode' },
	'meteringmode2' => { 327 => '2.1', 411 => 0x202c },
	'meteringmode3' => { 327 => '16.1' },
	'meteringoffscaleindicator' => { 181 => 0x53 },
	'meteringtime' => { 271 => '22.2', 273 => '3.2', 276 => '17.1', 277 => '18.1', 280 => '7.3', 281 => '18.1', 282 => '3.2', 286 => '19.1' },
	'micro1version' => { 373 => 0x1f },
	'micro2version' => { 373 => 0x2d },
	'microvideo' => { 451 => 'MicroVideo' },
	'microvideooffset' => { 451 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 451 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 451 => 'MicroVideoVersion' },
	'midrangesharpness' => { 226 => 0x3b },
	'mieversion' => { 161 => '0Vers' },
	'mime' => { 453 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 135 => 0x3f8, 160 => 'MinAperture', 337 => '0.2' },
	'minaperturevalue' => { 355 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 125 => 0x1404, 160 => 'MinFocalLength', 214 => 0x8, 215 => 0xd, 216 => 0xe, 220 => 0xf, 289 => 0x207, 423 => 0x127a, 424 => 0x1136, 425 => 0x32e, 426 => 0x32e, 427 => 0x30c },
	'minfocusdistance' => { 337 => 0x3 },
	'minintegrationrows' => { 135 => 0x1874 },
	'minoltadate' => { 178 => 0x15 },
	'minoltaimagesize' => { 178 => 0x4, 179 => 0xc, 180 => 0x2, 183 => 0x103 },
	'minoltamodelid' => { 178 => 0x25 },
	'minoltaquality' => { 178 => 0x5, 179 => 0xd, 180 => 0x3, 183 => [0x102,0x103] },
	'minoltatime' => { 178 => 0x16 },
	'minormodelagedisclosure' => { 298 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 459 => 'MinorVersion' },
	'minsamplevalue' => { 117 => 0x118 },
	'mirrorlockup' => { 80 => 0xc, 81 => 0xc, 82 => 0x60f, 83 => 0xb, 84 => 0xc, 85 => 0x6, 86 => 0x6, 87 => 0xc, 88 => 0x3 },
	'mobilecountrycode' => { 467 => 'mcc' },
	'mobilenetworkcode' => { 467 => 'mnc' },
	'moddate' => { 301 => 'modify-date', 481 => 'ModDate' },
	'modedialposition' => { 404 => 0x14 },
	'model' => { 96 => 0x6, 117 => 0x110, 153 => 'Model', 301 => 'Model', 316 => 0x110, 346 => 0x23f, 365 => 'model', 371 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 388 => 0x84, 453 => 'Model', 483 => 'model', 490 => 'Model' },
	'modelage' => { 480 => 'ModelAge' },
	'modelid' => { 287 => 0x0 },
	'modelingflash' => { 271 => '21.4', 272 => '31.1', 274 => '31.1', 275 => '31.1', 280 => '26.4', 281 => '30.2', 282 => '7.4', 283 => '30.1', 284 => '31.1', 285 => '31.1', 286 => '31.3' },
	'modelreleaseid' => { 298 => 'ModelReleaseID' },
	'modelreleasestatus' => { 298 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 432 => 0x52, 433 => 0x46, 434 => 0x53 },
	'modeltiepoint' => { 117 => 0x8482 },
	'modeltransform' => { 117 => 0x85d8 },
	'modelyear' => { 483 => 'modelYear' },
	'modificationdate' => { 484 => 'modificationDate' },
	'modifiedcolortemp' => { 64 => 0x9 },
	'modifieddigitalgain' => { 64 => 0xb },
	'modifiedparamflag' => { 57 => 0x1 },
	'modifiedpicturestyle' => { 64 => 0xa },
	'modifiedsaturation' => { 288 => 0x504 },
	'modifiedsensorbluelevel' => { 64 => 0x5 },
	'modifiedsensorredlevel' => { 64 => 0x4 },
	'modifiedsharpness' => { 64 => 0x2 },
	'modifiedsharpnessfreq' => { 64 => 0x3 },
	'modifiedtonecurve' => { 64 => 0x1 },
	'modifiedwhitebalance' => { 64 => 0x8 },
	'modifiedwhitebalanceblue' => { 64 => 0x7 },
	'modifiedwhitebalancered' => { 64 => 0x6 },
	'modifydate' => { 117 => 0x132, 154 => 'ModifyDate', 297 => 'ModDate', 299 => 'tIME', 362 => 'ModDate', 368 => 0x2, 492 => 'ModifyDate' },
	'moirefilter' => { 117 => 0xfe58, 468 => 'MoireFilter', 470 => 'MoireFilter' },
	'monitordisplayoff' => { 181 => 0x4c },
	'monitormatrix' => { 135 => 0x8fc },
	'monitorofftime' => { 271 => '18.2', 273 => '3.1', 282 => '3.1' },
	'monochromecolor' => { 288 => 0x53b },
	'monochromecontrast' => { 107 => 0x3c },
	'monochromefiltereffect' => { 101 => 0x20307, 107 => 0x3a, 311 => 0xac, 346 => 0x73 },
	'monochromegraineffect' => { 311 => 0xd2 },
	'monochromelinear' => { 107 => 0x3d },
	'monochromeoutputhighlightpoint' => { 107 => 0x41 },
	'monochromeoutputshadowpoint' => { 107 => 0x42 },
	'monochromeprofilesettings' => { 288 => 0x537 },
	'monochromerawhighlight' => { 107 => 0x7a },
	'monochromerawhighlightpoint' => { 107 => 0x3f },
	'monochromerawshadow' => { 107 => 0x83 },
	'monochromerawshadowpoint' => { 107 => 0x40 },
	'monochromesharpness' => { 107 => 0x3e },
	'monochrometoning' => { 346 => 0x74 },
	'monochrometoningeffect' => { 101 => 0x20306, 107 => 0x3b },
	'monochromeunsharpmaskfineness' => { 107 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 107 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 107 => 0xb4 },
	'monochromevignetting' => { 288 => 0x53a },
	'monthdaycreated' => { 137 => 0x12, 146 => 0xe },
	'mood' => { 176 => 'WM/Mood' },
	'moonphase' => { 372 => 0x12, 373 => 0x43, 374 => 0x4c },
	'morepermissions' => { 466 => 'morePermissions' },
	'motionsensitivity' => { 372 => 0x29, 374 => 0x60 },
	'movementcount' => { 363 => "\xa9mvc" },
	'movementname' => { 363 => "\xa9mvn" },
	'movementnumber' => { 363 => "\xa9mvi" },
	'movieaelockbuttonassignment' => { 284 => '40.1' },
	'moviefunc1button' => { 274 => '41.1', 275 => '41.1', 285 => '41.1' },
	'moviefunctionbutton' => { 272 => '41.1', 284 => '41.1' },
	'moviefunctionbuttonplusdials' => { 272 => '52.1' },
	'moviepreviewbutton' => { 272 => '41.2', 274 => '41.2', 275 => '41.2', 284 => '41.2', 285 => '41.2' },
	'moviepreviewbuttonplusdials' => { 272 => '52.2' },
	'movieshutterbutton' => { 272 => '38.3', 274 => '38.3', 275 => '38.3', 284 => '38.3', 285 => '38.3' },
	'moviesubselectorassignment' => { 272 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 272 => '53.1' },
	'multiburstimageheight' => { 411 => 0x1002 },
	'multiburstimagewidth' => { 411 => 0x1001 },
	'multiburstmode' => { 411 => 0x1000 },
	'multicontrollerwhilemetering' => { 82 => 0x517 },
	'multiexposure' => { 66 => 0x1, 311 => 0xb4 },
	'multiexposureautogain' => { 223 => 0x3 },
	'multiexposurecontrol' => { 66 => 0x2 },
	'multiexposuremode' => { 223 => 0x1 },
	'multiexposureshots' => { 66 => 0x3, 223 => 0x2 },
	'multiframenoisereduction' => { 400 => 0x35, 411 => 0x200b, 416 => 0x15 },
	'multiframenreffect' => { 411 => 0x2023 },
	'multifunctionlock' => { 82 => 0x70f },
	'multipleexposuremode' => { 292 => 0x101c },
	'multipleexposureset' => { 327 => '10.1' },
	'multisample' => { 230 => 0x40 },
	'multiselector' => { 271 => '9.4', 272 => '10.3', 274 => '10.3', 275 => '10.3', 280 => '27.4', 284 => '10.3', 285 => '10.3' },
	'multiselectorliveview' => { 271 => '4.3', 274 => '37.1', 275 => '37.1', 284 => '37.1', 285 => '37.1' },
	'multiselectorliveviewmode' => { 240 => 0x18c2 },
	'multiselectorplaybackmode' => { 271 => ['13.5','9.2'], 272 => '10.2', 275 => '10.2', 280 => '27.2', 284 => '10.2', 285 => '10.2' },
	'multiselectorshootmode' => { 271 => '9.1', 272 => '10.1', 274 => '10.1', 275 => '10.1', 280 => '27.1', 284 => '10.1', 285 => '10.1' },
	'multishot' => { 316 => 0x121 },
	'mute' => { 365 => 'player.movie.audio.mute' },
	'mycolormode' => { 67 => 0x2 },
	'name' => { 371 => 'name', 468 => 'Name', 470 => 'Name' },
	'narrator' => { 363 => "\xa9nrt" },
	'nationalcatalognumber' => { 484 => 'nationalCatalogNumber' },
	'nativedigest' => { 474 => 'NativeDigest', 490 => 'NativeDigest' },
	'ndfilter' => { 75 => 0x1c, 288 => 0x204, 378 => 0x1019 },
	'near' => { 453 => 'Near' },
	'nefbitdepth' => { 222 => 0xe22 },
	'nefcompression' => { 222 => 0x93 },
	'neflinearizationtable' => { 222 => 0x96 },
	'negativecachelargepreviewsize' => { 468 => 'NegativeCacheLargePreviewSize', 470 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 468 => 'NegativeCacheMaximumSize', 470 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 468 => 'NegativeCachePath', 470 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 346 => 0x88 },
	'neutraloutputhighlightpoint' => { 107 => 0x2f },
	'neutraloutputshadowpoint' => { 107 => 0x30 },
	'neutralrawcolortone' => { 107 => 0x28 },
	'neutralrawcontrast' => { 107 => 0x2a },
	'neutralrawhighlight' => { 107 => 0x78 },
	'neutralrawhighlightpoint' => { 107 => 0x2d },
	'neutralrawlinear' => { 107 => 0x2b },
	'neutralrawsaturation' => { 107 => 0x29 },
	'neutralrawshadow' => { 107 => 0x81 },
	'neutralrawshadowpoint' => { 107 => 0x2e },
	'neutralrawsharpness' => { 107 => 0x2c },
	'neutralunsharpmaskfineness' => { 107 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 107 => 0xa8 },
	'neutraunsharpmaskstrength' => { 107 => 0xa4 },
	'newrawimagedigest' => { 117 => 0xc7a7 },
	'newsphotoversion' => { 131 => 0x0 },
	'nickname' => { 492 => 'Nickname' },
	'nikoncapturedata' => { 222 => 0xe01 },
	'nikoncaptureeditversions' => { 222 => 0xe13 },
	'nikoncaptureoffsets' => { 222 => 0xe0e },
	'nikoncaptureoutput' => { 222 => 0xe1e },
	'nikoncaptureversion' => { 222 => 0xe09 },
	'nikoniccprofile' => { 222 => 0xe1d },
	'nikonimagesize' => { 237 => '723.1', 238 => '732.1', 248 => 0x2c4 },
	'nikonmeteringmode' => { 241 => 0x2ea4, 250 => 0x175e },
	'nikonsettings' => { 222 => 0x4e },
	'noisefilter' => { 288 => 0x527 },
	'noiseprofile' => { 117 => 0xc761 },
	'noisereduction' => { 125 => [0x100b,0x100e], 179 => 0xb0, 180 => 0x60, 181 => 0x3f, 222 => 0x95, 264 => 0x753dcbc0, 265 => 0x17, 288 => 0x50a, 293 => 0x103a, 311 => 0x2d, 346 => 0x49, 378 => 0x100f, 380 => 0x2a },
	'noisereduction2' => { 292 => 0x1010 },
	'noisereductionapplied' => { 117 => 0xc6f7 },
	'noisereductionintensity' => { 265 => 0x9 },
	'noisereductionmethod' => { 265 => 0x11 },
	'noisereductionmode' => { 445 => 0x801e },
	'noisereductionparametersatcapture' => { 135 => 0xe73 },
	'noisereductionparameterscamera' => { 135 => 0xe72 },
	'noisereductionparametershost3mp' => { 135 => 0xe71 },
	'noisereductionparametershost6mp' => { 135 => 0xe70 },
	'noisereductionparametershostrgb' => { 135 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 135 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 135 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 135 => 0xe63 },
	'noisereductionparams' => { 316 => 0x1b },
	'noisereductionsharpness' => { 265 => 0xd },
	'noisereductionstrength' => { 311 => 0xd6 },
	'noisereductionvalue' => { 445 => 0x8027 },
	'nomemorycard' => { 271 => '22.1', 272 => '4.2', 273 => '0.3', 276 => '2.4', 277 => '3.2', 278 => '3.2', 280 => '33.7', 281 => '3.2', 282 => '0.3', 284 => '4.2', 286 => '4.5' },
	'nominalmaxaperture' => { 337 => 0xa },
	'nominalminaperture' => { 337 => '10.1' },
	'normallinetime' => { 135 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 44 => [0x2b8,0x2cf,0x2d3], 45 => 0x569, 46 => 0x1e3, 47 => [0x1fc,0x2dc], 48 => [0x230,0x30e], 49 => 0x31c },
	'notes' => { 446 => 'Notes', 463 => 'notes' },
	'npages' => { 499 => 'NPages' },
	'nullrecord' => { 95 => 0x0 },
	'numafpoints' => { 323 => 0x2 },
	'number' => { 484 => 'number' },
	'numberofbeats' => { 494 => 'numberOfBeats' },
	'numberoffocuspoints' => { 274 => '1.3', 275 => '1.3', 278 => '0.2', 279 => '0.3', 281 => '0.3' },
	'numfaceelements' => { 125 => 0x4200 },
	'numfacepositions' => { 303 => 0x0 },
	'numindexentries' => { 131 => 0x54 },
	'numwbentries' => { 317 => 0x0, 318 => 0x0 },
	'object' => { 484 => 'object' },
	'objectattributereference' => { 129 => 0x4 },
	'objectcycle' => { 129 => 0x4b, 463 => 'ObjectCycle' },
	'objectdescription' => { 483 => 'objectDescription' },
	'objectdistance' => { 110 => 0x6, 111 => 0x2022 },
	'objectname' => { 129 => 0x5 },
	'objectpreviewdata' => { 129 => 0xca },
	'objectpreviewfileformat' => { 129 => 0xc8 },
	'objectpreviewfileversion' => { 129 => 0xc9 },
	'objectsubtype' => { 483 => 'objectSubtype' },
	'objecttype' => { 483 => 'objectType' },
	'objecttypereference' => { 129 => 0x3 },
	'occurrence' => { 116 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 116 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 116 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 116 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 116 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 116 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 116 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 116 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 116 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 116 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 116 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 116 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 116 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 116 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 116 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 116 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 116 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 116 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 116 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 116 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 116 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 116 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 116 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 116 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 116 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 116 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 474 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 474 => [\'OECF','OECFNames'] },
	'oecfrows' => { 474 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 474 => [\'OECF','OECFValues'] },
	'offsaledate' => { 484 => 'offSaleDate' },
	'offsaledatea-platform' => { 484 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 484 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 135 => 0x190a },
	'offsetschema' => { 117 => 0xea1d },
	'offsettime' => { 117 => 0x9010 },
	'offsettimedigitized' => { 117 => 0x9012 },
	'offsettimeoriginal' => { 117 => 0x9011 },
	'okbutton' => { 281 => '15.1', 286 => '16.1' },
	'oldsubfiletype' => { 117 => 0xff },
	'olympusimageheight' => { 293 => 0x102f },
	'olympusimagewidth' => { 293 => 0x102e },
	'omenatcapturestrength' => { 135 => 0xa60 },
	'omenautostrength' => { 135 => 0xa5f },
	'omenearlystrength' => { 135 => 0xa5e },
	'omenfocallengthlimit' => { 135 => 0xa62 },
	'omeninitialipfstrength' => { 135 => 0xa5d },
	'omensurfaceindex' => { 135 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 293 => 0x302 },
	'onsaledate' => { 484 => 'onSaleDate' },
	'onsaledatea-platform' => { 484 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 484 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 484 => 'onSaleDay' },
	'onsaledaya-platform' => { 484 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 484 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 117 => 0xc740 },
	'opcodelist2' => { 117 => 0xc741 },
	'opcodelist3' => { 117 => 0xc74e },
	'opticalzoom' => { 139 => 0xfa3d, 141 => [0x6006,0xf006], 142 => 0x1000, 143 => 0xf, 146 => 0x1e, 148 => 0x20, 149 => 0x1c, 160 => 'OpticalZoom' },
	'opticalzoomcode' => { 75 => 0xa },
	'opticalzoommode' => { 311 => 0x34 },
	'opticalzoomon' => { 387 => 0x219 },
	'optionenddate' => { 487 => 'optionEndDate' },
	'opto-electricconvfactor' => { 474 => 'OECF' },
	'orangehsl' => { 101 => 0x20911 },
	'ordernumber' => { 125 => 0x8002 },
	'organisationinimagecode' => { 480 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 480 => 'OrganisationInImageName' },
	'organism' => { 116 => 'Organism' },
	'organismassociatedoccurrences' => { 116 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 116 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 116 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 116 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 116 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 116 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 116 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 484 => 'organization' },
	'orientation' => { 117 => 0x112, 316 => 0x112, 483 => 'orientation', 490 => 'Orientation' },
	'orientation2' => { 416 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 82 => 0x516 },
	'originalalbumtitle' => { 176 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 176 => 'WM/OriginalArtist', 363 => "\xa9ope" },
	'originalbestqualitysize' => { 117 => 0xc792 },
	'originalcreatedatetime' => { 458 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 112 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 62 => 0x83 },
	'originaldefaultcropsize' => { 117 => 0xc793 },
	'originaldefaultfinalsize' => { 117 => 0xc791 },
	'originaldirectory' => { 308 => 0x408 },
	'originaldocumentid' => { 495 => 'OriginalDocumentID' },
	'originalfilename' => { 95 => 0x816, 135 => 0x3e9, 147 => 0x20, 308 => 0x407, 458 => 'OriginalFilename' },
	'originalimageheight' => { 77 => 0xc, 121 => 0x1 },
	'originalimagewidth' => { 77 => 0xb, 121 => 0x0 },
	'originallyricist' => { 176 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 117 => 0xc68c },
	'originalrawfiledigest' => { 117 => 0xc71d },
	'originalrawfilename' => { 117 => 0xc68b },
	'originaltransmissionreference' => { 129 => 0x67 },
	'originatingprogram' => { 129 => 0x41, 463 => 'OriginatingProgram' },
	'originplatform' => { 484 => 'originPlatform' },
	'os' => { 472 => 'os' },
	'otherconditions' => { 298 => 'OtherConditions' },
	'otherconstraints' => { 298 => 'OtherConstraints' },
	'otherimage' => { 112 => 'Exif-OtherImage' },
	'otherimageinfo' => { 298 => 'OtherImageInfo' },
	'otherimagelength' => { 117 => 0x202 },
	'otherimagestart' => { 117 => 0x201 },
	'otherlicensedocuments' => { 298 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 298 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 298 => 'OtherLicenseRequirements' },
	'outcue' => { 494 => 'outCue' },
	'outcuescale' => { 494 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 494 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 193 => 0x3 },
	'outputimagewidth' => { 193 => 0x2 },
	'outputlut' => { 311 => 0xa7 },
	'outputprofile' => { 135 => 0x138b },
	'outputresolution' => { 193 => 0x4 },
	'overclockcols' => { 135 => 0x189c },
	'overclockrows' => { 135 => 0x18c4 },
	'overridelookvignette' => { 468 => 'OverrideLookVignette', 470 => 'OverrideLookVignette' },
	'owner' => { 498 => 'Owner' },
	'ownerid' => { 129 => 0xbc },
	'ownername' => { 15 => 0x10f, 62 => 0x9, 95 => 0x810, 117 => [0xa430,0xfde8], 153 => 'OwnerName', 465 => 'OwnerName', 475 => 'CameraOwnerName' },
	'padding' => { 117 => 0xea1c },
	'pagecount' => { 484 => 'pageCount' },
	'pageimage' => { 492 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 492 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 492 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 492 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 492 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 492 => 'PageInfo' },
	'pagename' => { 117 => 0x11d },
	'pagenumber' => { 117 => 0x129 },
	'pageprogressiondirection' => { 484 => 'pageProgressionDirection' },
	'pagerange' => { 484 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 468 => 'PaintBasedCorrections', 470 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue','PaintBasedCorrectionsLocalToningHue'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskcoloramount' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemasklumfeather' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemasklummax' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasktype' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 468 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 470 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 314 => 0x0 },
	'panasonicexifversion' => { 311 => 0x26 },
	'panasonicimageheight' => { 311 => 0x4c },
	'panasonicimagewidth' => { 311 => 0x4b },
	'panasonicrawversion' => { 316 => 0x1 },
	'panasonictitle' => { 117 => 0xc6d2 },
	'panasonictitle2' => { 117 => 0xc6d3 },
	'panoramaangle' => { 125 => 0x1153 },
	'panoramacropbottom' => { 417 => 0x7 },
	'panoramacropleft' => { 417 => 0x4 },
	'panoramacropright' => { 417 => 0x6 },
	'panoramacroptop' => { 417 => 0x5 },
	'panoramadirection' => { 70 => 0x5, 125 => 0x1154, 417 => 0x3 },
	'panoramaframeheight' => { 417 => 0x9 },
	'panoramaframenumber' => { 70 => 0x2 },
	'panoramaframewidth' => { 417 => 0x8 },
	'panoramafullheight' => { 417 => 0x2 },
	'panoramafullwidth' => { 417 => 0x1 },
	'panoramamode' => { 137 => 0x3c, 288 => 0x601 },
	'panoramasize3d' => { 400 => 0x38 },
	'panoramasourceheight' => { 417 => 0xb },
	'panoramasourcewidth' => { 417 => 0xa },
	'panoramicstitchcameramotion' => { 173 => 'PanoramicStitchCameraMotion', 174 => 0x1 },
	'panoramicstitchmaptype' => { 173 => 'PanoramicStitchMapType', 174 => 0x2 },
	'panoramicstitchphi0' => { 173 => 'PanoramicStitchPhi0', 174 => 0x5 },
	'panoramicstitchphi1' => { 173 => 'PanoramicStitchPhi1', 174 => 0x6 },
	'panoramicstitchtheta0' => { 173 => 'PanoramicStitchTheta0', 174 => 0x3 },
	'panoramicstitchtheta1' => { 173 => 'PanoramicStitchTheta1', 174 => 0x4 },
	'panoramicstitchversion' => { 174 => 0x0 },
	'pantry' => { 495 => 'Pantry' },
	'pantryinstanceid' => { 495 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 125 => 0xb211, 287 => 0x28 },
	'parametricdarks' => { 468 => 'ParametricDarks', 470 => 'ParametricDarks' },
	'parametrichighlights' => { 468 => 'ParametricHighlights', 470 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 468 => 'ParametricHighlightSplit', 470 => 'ParametricHighlightSplit' },
	'parametriclights' => { 468 => 'ParametricLights', 470 => 'ParametricLights' },
	'parametricmidtonesplit' => { 468 => 'ParametricMidtoneSplit', 470 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 468 => 'ParametricShadows', 470 => 'ParametricShadows' },
	'parametricshadowsplit' => { 468 => 'ParametricShadowSplit', 470 => 'ParametricShadowSplit' },
	'parentalrating' => { 176 => 'WM/ParentalRating' },
	'parentmediaeventid' => { 458 => 'ParentMediaEventID' },
	'parentmeid' => { 458 => 'ParentMEID' },
	'parentproductid' => { 363 => '@ppi' },
	'parentreference1' => { 478 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 478 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 363 => '@PST' },
	'parenttitle' => { 363 => '@pti' },
	'partialactivecols1' => { 135 => 0x17e8 },
	'partialactivecols2' => { 135 => 0x17f2 },
	'partialactiverows1' => { 135 => 0x17fc },
	'partialactiverows2' => { 135 => 0x1806 },
	'partofcompilation' => { 494 => 'partOfCompilation' },
	'patientbirthdate' => { 447 => 'PatientDOB' },
	'patientid' => { 447 => 'PatientID' },
	'patientname' => { 447 => 'PatientName' },
	'patientsex' => { 447 => 'PatientSex' },
	'patternareaheight' => { 135 => 0x963 },
	'patternareawidth' => { 135 => 0x962 },
	'patterncorrectionfactorscale' => { 135 => 0x969 },
	'patterncropcols1' => { 135 => 0x96c },
	'patterncropcols2' => { 135 => 0x96d },
	'patterncroprows1' => { 135 => 0x96a },
	'patterncroprows2' => { 135 => 0x96b },
	'patternimagerheight' => { 135 => 0x961 },
	'patternimagerwidth' => { 135 => 0x960 },
	'patternx' => { 135 => 0x966 },
	'patterny' => { 135 => 0x967 },
	'pdfversion' => { 481 => 'PDFVersion' },
	'pentaximagesize' => { 346 => 0x9 },
	'pentaxmodelid' => { 326 => 0x0, 346 => 0x5 },
	'pentaxmodeltype' => { 346 => 0x1 },
	'pentaxversion' => { 346 => 0x0 },
	'people' => { 449 => 'People', 461 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 43 => 0xc4, 44 => [0x2b4,0x2cb,0x2cf], 45 => [0x108,0x14d], 46 => 0x1df, 47 => [0x1f8,0x2d8], 48 => [0x22c,0x30a], 49 => 0x149 },
	'performer' => { 363 => 'perf', 371 => 'perf' },
	'performerkeywords' => { 371 => "\xa9prk" },
	'performers' => { 371 => "\xa9prf" },
	'performerurl' => { 371 => "\xa9prl" },
	'period' => { 176 => 'WM/Period' },
	'peripheralillumcentralradius' => { 445 => 0x8030 },
	'peripheralillumcentralvalue' => { 445 => 0x8031 },
	'peripheralillumination' => { 101 => 0x20702, 107 => 0x68 },
	'peripheralilluminationcorr' => { 61 => 0x1, 336 => 0x2 },
	'peripheralilluminationon' => { 101 => '0x20702.0', 107 => 0x64 },
	'peripheralillumperiphvalue' => { 445 => 0x8032 },
	'peripherallighting' => { 77 => 0x2, 125 => 0x3804 },
	'peripherallightingsetting' => { 78 => 0x5 },
	'peripherallightingvalue' => { 77 => 0x6 },
	'permissions' => { 487 => 'permissions' },
	'permits' => { 466 => 'permits' },
	'person' => { 484 => 'person' },
	'personality' => { 458 => 'Personality' },
	'personheard' => { 480 => 'PersonHeard' },
	'personheardidentifier' => { 480 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 480 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 480 => 'PersonInImage' },
	'personinimagecharacteristic' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 480 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 480 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 468 => 'PerspectiveAspect', 470 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 468 => 'PerspectiveHorizontal', 470 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 468 => 'PerspectiveRotate', 470 => 'PerspectiveRotate' },
	'perspectivescale' => { 468 => 'PerspectiveScale', 470 => 'PerspectiveScale' },
	'perspectiveupright' => { 468 => 'PerspectiveUpright', 470 => 'PerspectiveUpright' },
	'perspectivevertical' => { 468 => 'PerspectiveVertical', 470 => 'PerspectiveVertical' },
	'perspectivex' => { 468 => 'PerspectiveX', 470 => 'PerspectiveX' },
	'perspectivey' => { 468 => 'PerspectiveY', 470 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 90 => 0x1 },
	'pf10retainprogramshift' => { 90 => 0xb },
	'pf13drivepriority' => { 90 => 0xe },
	'pf14disablefocussearch' => { 90 => 0xf },
	'pf15disableafassistbeam' => { 90 => 0x10 },
	'pf16autofocuspointshoot' => { 90 => 0x11 },
	'pf17disableafpointsel' => { 90 => 0x12 },
	'pf18enableautoafpointsel' => { 90 => 0x13 },
	'pf19continuousshootspeed' => { 90 => 0x14 },
	'pf19shootingspeedhigh' => { 89 => 0xa },
	'pf19shootingspeedlow' => { 89 => 0x9 },
	'pf1disableshootingmodes' => { 90 => 0x2 },
	'pf1value' => { 89 => 0x1 },
	'pf20limitcontinousshots' => { 90 => 0x15 },
	'pf20maxcontinousshots' => { 89 => 0xb },
	'pf21enablequietoperation' => { 90 => 0x16 },
	'pf23felocktime' => { 89 => 0xd },
	'pf23postreleasetime' => { 89 => 0xe },
	'pf23settimerlengths' => { 90 => 0x18 },
	'pf23shutterbuttontime' => { 89 => 0xc },
	'pf24lightlcdduringbulb' => { 90 => 0x19 },
	'pf25aemode' => { 89 => 0xf },
	'pf25afmode' => { 89 => 0x12 },
	'pf25afpointsel' => { 89 => 0x13 },
	'pf25colormatrix' => { 89 => 0x17 },
	'pf25defaultclearsettings' => { 90 => 0x1a },
	'pf25drivemode' => { 89 => 0x11 },
	'pf25imagesize' => { 89 => 0x14 },
	'pf25meteringmode' => { 89 => 0x10 },
	'pf25parameters' => { 89 => 0x16 },
	'pf25wbmode' => { 89 => 0x15 },
	'pf26shortenreleaselag' => { 90 => 0x1b },
	'pf27reversedialrotation' => { 90 => 0x1c },
	'pf27value' => { 89 => 0x18 },
	'pf28noquickdialexpcomp' => { 90 => 0x1d },
	'pf29quickdialswitchoff' => { 90 => 0x1e },
	'pf2disablemeteringmodes' => { 90 => 0x3 },
	'pf2value' => { 89 => 0x2 },
	'pf30enlargementmode' => { 90 => 0x1f },
	'pf31originaldecisiondata' => { 90 => 0x20 },
	'pf3manualexposuremetering' => { 90 => 0x4 },
	'pf3value' => { 89 => 0x3 },
	'pf4exposuretimelimits' => { 90 => 0x5 },
	'pf4exposuretimemax' => { 89 => 0x5 },
	'pf4exposuretimemin' => { 89 => 0x4 },
	'pf5aperturelimits' => { 90 => 0x6 },
	'pf5aperturemax' => { 89 => 0x7 },
	'pf5aperturemin' => { 89 => 0x6 },
	'pf6presetshootingmodes' => { 90 => 0x7 },
	'pf7bracketcontinuousshoot' => { 90 => 0x8 },
	'pf8bracketshots' => { 89 => 0x8 },
	'pf8setbracketshots' => { 90 => 0x9 },
	'pf9changebracketsequence' => { 90 => 0xa },
	'phasedetectaf' => { 190 => 0x6 },
	'phonenumber' => { 154 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 264 => 0xe9651831 },
	'photoeffects' => { 264 => 0xab5eca5e },
	'photoeffectsblue' => { 266 => 0x8 },
	'photoeffectsgreen' => { 266 => 0x6 },
	'photoeffectsred' => { 266 => 0x4 },
	'photoeffectstype' => { 266 => 0x0 },
	'photographicsensitivity' => { 475 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 271 => '17.6', 280 => '33.6' },
	'photometricinterpretation' => { 117 => 0x106, 490 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 241 => 0xe7d, 251 => 0xfbd },
	'photoshootingmenubankimagearea' => { 241 => '3716.1', 251 => 0x791 },
	'photoshopbgrthumbnail' => { 360 => 0x409 },
	'photoshopquality' => { 359 => 0x0 },
	'photoshopthumbnail' => { 360 => 0x40c },
	'photostyle' => { 311 => 0x89 },
	'picklabel' => { 473 => 'PickLabel' },
	'pictinfo' => { 387 => 0x208 },
	'picturecontrol' => { 264 => 0xe2173c47 },
	'picturecontrolactive' => { 267 => 0x0 },
	'picturecontroladjust' => { 224 => 0x30, 225 => 0x30, 226 => 0x36 },
	'picturecontrolbase' => { 224 => 0x18, 225 => 0x18, 226 => 0x1c },
	'picturecontroldata' => { 222 => [0xbd,0x23] },
	'picturecontrolmode' => { 267 => 0x13 },
	'picturecontrolname' => { 224 => 0x4, 225 => 0x4, 226 => 0x8 },
	'picturecontrolquickadjust' => { 224 => 0x31, 225 => 0x31, 226 => 0x37 },
	'pictureeffect' => { 411 => 0x200e },
	'pictureeffect2' => { 419 => 0x1163, 420 => 0x1167, 421 => 0x1143, 422 => 0x11bf, 423 => 0x119b, 424 => 0x1053, 425 => 0x24b, 426 => 0x24b, 427 => 0x23c, 441 => 0x46 },
	'picturefinish' => { 179 => 0x71 },
	'picturemode' => { 125 => 0x1031, 288 => 0x520, 346 => [0xb,0x33], 388 => 0x3d },
	'picturemode2' => { 327 => 0x0 },
	'picturemodebwfilter' => { 288 => 0x525 },
	'picturemodecontrast' => { 288 => 0x523 },
	'picturemodeeffect' => { 288 => 0x52d },
	'picturemodehue' => { 288 => 0x522 },
	'picturemodesaturation' => { 288 => 0x521 },
	'picturemodesharpness' => { 288 => 0x524 },
	'picturemodetone' => { 288 => 0x526 },
	'pictureprofile' => { 419 => [0x115e,0x115f], 420 => [0x1162,0x1163], 421 => [0x113e,0x113f], 422 => [0x11ba,0x11bb], 423 => [0x1196,0x1197], 424 => [0x104e,0x104f], 425 => [0x246,0x247], 426 => [0x246,0x247], 427 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 72 => 0xa, 101 => 0x20301, 107 => 0x2 },
	'picturestylepc' => { 62 => 0x4009 },
	'picturestyleuserdef' => { 62 => 0x4008 },
	'picturewizard' => { 385 => 0x21 },
	'picturewizardcolor' => { 384 => 0x1 },
	'picturewizardcontrast' => { 384 => 0x4 },
	'picturewizardmode' => { 384 => 0x0 },
	'picturewizardsaturation' => { 384 => 0x2 },
	'picturewizardsharpness' => { 384 => 0x3 },
	'pipelineversion' => { 173 => 'PipelineVersion' },
	'pitch' => { 113 => 0x6, 272 => '4.1', 284 => '4.1', 371 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 240 => 0x350f, 241 => 0x2c28, 245 => 0xc21e, 250 => 0x36f8, 251 => 0x2eff, 253 => 0xce36, 288 => 0x904, 311 => 0x91, 345 => 0x2, 383 => 0x1 },
	'pitchshift' => { 365 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 364 => 'pasp' },
	'pixelclockfrequency' => { 135 => 0x40b },
	'pixelcorrectionoffset' => { 135 => 0x972 },
	'pixelcorrectionscale' => { 135 => 0x971 },
	'pixelscale' => { 117 => 0x830e },
	'pixelshiftinfo' => { 411 => 0x202f },
	'pixelshiftoffset' => { 125 => 0x1106 },
	'pixelshiftresolution' => { 347 => 0x0 },
	'pixelshiftshots' => { 125 => 0x1105 },
	'pixelsperunitx' => { 300 => 0x0 },
	'pixelsperunity' => { 300 => 0x4 },
	'pixelunits' => { 300 => 0x8 },
	'planarconfiguration' => { 117 => 0x11c, 490 => 'PlanarConfiguration' },
	'plane' => { 448 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 448 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 448 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 448 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 448 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 448 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 448 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 448 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 448 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 448 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 448 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 448 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 448 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 448 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 448 => 'Planes' },
	'planningref' => { 480 => 'PlanningRef' },
	'planningrefidentifier' => { 480 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 480 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 480 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 499 => 'PlateNames' },
	'platform' => { 484 => 'platform' },
	'playallframes' => { 371 => 'AllF' },
	'playbackmenustime' => { 276 => '20.1', 277 => '21.1', 278 => '21.1' },
	'playbackmonitorofftime' => { 271 => '25.2', 272 => '36.1', 274 => '36.1', 275 => '36.1', 279 => '35.1', 280 => '8.1', 281 => '35.1', 284 => '36.1', 285 => '36.1', 286 => '21.1' },
	'playbackzoom' => { 272 => '37.1' },
	'playdisplay' => { 181 => 0x4e },
	'playerversion' => { 365 => 'player.version' },
	'playgap' => { 363 => 'pgap' },
	'playlistid' => { 363 => 'plID' },
	'playmode' => { 371 => 'SDLN' },
	'playselection' => { 371 => 'SelO' },
	'plusversion' => { 298 => 'Version' },
	'pmversion' => { 358 => 'PMVersion' },
	'pngwarning' => { 301 => 'Warning' },
	'podcast' => { 363 => 'pcst' },
	'podcasturl' => { 363 => 'purl' },
	'poilevel' => { 221 => 0x8 },
	'portraitnote' => { 451 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 107 => 0x1d },
	'portraitoutputshadowpoint' => { 107 => 0x1e },
	'portraitrawcolortone' => { 107 => 0x16 },
	'portraitrawcontrast' => { 107 => 0x18 },
	'portraitrawhighlight' => { 107 => 0x76 },
	'portraitrawhighlightpoint' => { 107 => 0x1b },
	'portraitrawlinear' => { 107 => 0x19 },
	'portraitrawsaturation' => { 107 => 0x17 },
	'portraitrawshadow' => { 107 => 0x7f },
	'portraitrawshadowpoint' => { 107 => 0x1c },
	'portraitrawsharpness' => { 107 => 0x1a },
	'portraitrefiner' => { 111 => 0x302b },
	'portraitrequest' => { 451 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 107 => 0x9a },
	'portraitunsharpmaskstrength' => { 107 => 0x98 },
	'portraitunsharpmaskthreshold' => { 107 => 0x9c },
	'portraitversion' => { 451 => 'PortraitVersion' },
	'pose' => { 448 => 'Pose' },
	'poseheadingdegrees' => { 456 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 456 => 'PosePitchDegrees' },
	'posepositionx' => { 448 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 448 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 448 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 456 => 'PoseRollDegrees' },
	'poserotationw' => { 448 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 448 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 448 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 448 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 448 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 483 => 'positionDescriptor' },
	'postalcode' => { 158 => 'PostalCode' },
	'postcropvignetteamount' => { 468 => 'PostCropVignetteAmount', 470 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 468 => 'PostCropVignetteFeather', 470 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 468 => 'PostCropVignetteHighlightContrast', 470 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 468 => 'PostCropVignetteMidpoint', 470 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 468 => 'PostCropVignetteRoundness', 470 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 468 => 'PostCropVignetteStyle', 470 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 311 => 0xbf },
	'potentialface1position' => { 408 => 0xb },
	'potentialface2position' => { 408 => 0x15 },
	'potentialface3position' => { 408 => 0x1f },
	'potentialface4position' => { 408 => 0x29 },
	'potentialface5position' => { 408 => 0x33 },
	'potentialface6position' => { 408 => 0x3d },
	'potentialface7position' => { 408 => 0x47 },
	'potentialface8position' => { 408 => 0x51 },
	'powersource' => { 325 => '0.1' },
	'poweruptime' => { 222 => 0xb6 },
	'preaf' => { 124 => '0.2' },
	'precaptureframes' => { 293 => 0x300 },
	'predictor' => { 117 => 0x13d },
	'preflashreturnstrength' => { 238 => 0x28a },
	'prefs' => { 129 => 0xdd, 358 => 'Prefs' },
	'prereadfastresetcount' => { 135 => 0x187e },
	'preservedfilename' => { 495 => 'PreservedFileName' },
	'preservedspecimen' => { 116 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 116 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 468 => 'PresetType', 470 => 'PresetType' },
	'presetwhitebalance' => { 181 => 0x24, 445 => 0x8002 },
	'presetwhitebalanceadj' => { 445 => 0x8014 },
	'pressure' => { 117 => 0x9402, 475 => 'Pressure' },
	'previewapplicationname' => { 117 => 0xc716 },
	'previewapplicationversion' => { 117 => 0xc717 },
	'previewbutton' => { 271 => ['14.1','15.1'], 272 => '15.1', 274 => '15.1', 275 => '15.1', 280 => '29.1', 281 => '14.1', 284 => '15.1', 285 => '15.1' },
	'previewbuttonplusdials' => { 271 => ['14.2','15.2'], 272 => '15.2', 274 => '43.1', 275 => '43.1', 280 => '31.2', 284 => '43.1', 285 => '43.1' },
	'previewcolorspace' => { 117 => 0xc71a },
	'previewcropbottom' => { 357 => 0xef },
	'previewcropleft' => { 357 => 0xec },
	'previewcropright' => { 357 => 0xee },
	'previewcroptop' => { 357 => 0xed },
	'previewdate' => { 369 => 0x0 },
	'previewdatetime' => { 117 => 0xc71b },
	'previewimage' => { 111 => 0x2000, 112 => 'Exif-PreviewImage', 118 => 'PreviewImage', 120 => 0x4, 163 => 'data', 183 => 0x81, 293 => 0x280, 309 => 0x300, 411 => 0x2001 },
	'previewimageborders' => { 346 => 0x3e },
	'previewimageheight' => { 71 => 0x4, 139 => 0xfa58 },
	'previewimagelength' => { 71 => 0x2, 111 => 0x3, 117 => [0x117,0x202], 183 => 0x89, 227 => 0x202, 288 => 0x102, 293 => 0x1037, 346 => 0x3, 377 => 0x1e, 382 => 0x3, 388 => [0x1b,0x1d], 401 => 0x202 },
	'previewimagename' => { 163 => '1Name' },
	'previewimagesize' => { 111 => 0x2, 144 => 0x2, 163 => 'ImageSize', 346 => 0x2, 388 => [0x1c,0x1e], 411 => 0xb02c, 445 => 0x9012 },
	'previewimagestart' => { 71 => 0x5, 111 => 0x4, 117 => [0x111,0x201], 183 => 0x88, 227 => 0x201, 288 => 0x101, 293 => 0x1036, 346 => 0x4, 377 => 0x1c, 382 => 0x2, 388 => [0x1a,0x1c], 401 => 0x201 },
	'previewimagetype' => { 163 => '0Type' },
	'previewimagevalid' => { 288 => 0x100, 293 => 0x1035 },
	'previewimagewidth' => { 71 => 0x3, 139 => 0xfa57 },
	'previewquality' => { 71 => 0x1 },
	'previewsettingsdigest' => { 117 => 0xc719 },
	'previewsettingsname' => { 117 => 0xc718 },
	'primaryafpoint' => { 190 => [0x38,0x44,0x7] },
	'primarychromaticities' => { 117 => 0x13f, 490 => 'PrimaryChromaticities' },
	'primaryftp' => { 458 => 'PrimaryFTP' },
	'primaryslot' => { 241 => 0xe7f, 251 => 0xfbf },
	'printim' => { 117 => 0xc4a5 },
	'prioritysetinawb' => { 411 => 0x202b },
	'prioritysetupshutterrelease' => { 181 => 0x1d, 398 => 0x28 },
	'privatertkinfo' => { 460 => 'privateRTKInfo' },
	'processbordercolsleft' => { 135 => 0xc61 },
	'processbordercolsright' => { 135 => 0xc62 },
	'processborderrowsbottom' => { 135 => 0xc64 },
	'processborderrowstop' => { 135 => 0xc63 },
	'processingsoftware' => { 117 => 0xb },
	'processversion' => { 468 => 'ProcessVersion', 470 => 'ProcessVersion' },
	'producer' => { 176 => 'WM/Producer', 297 => 'Producer', 363 => "\xa9prd", 365 => 'producer', 371 => "\xa9prd", 481 => 'Producer' },
	'producerkeywords' => { 371 => "\xa9pdk" },
	'productcode' => { 484 => 'productCode' },
	'productid' => { 130 => 0x32, 363 => 'prID', 483 => 'productID' },
	'productidtype' => { 483 => 'productIDType' },
	'productinimage' => { 480 => 'ProductInImage' },
	'productinimagedescription' => { 480 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 480 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 480 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 326 => 0x2 },
	'productorserviceconstraints' => { 298 => 'ProductOrServiceConstraints' },
	'productversion' => { 363 => 'VERS' },
	'profession' => { 484 => 'profession' },
	'profile' => { 448 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 117 => 0xc6f4 },
	'profilecameraindices' => { 448 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 117 => 0xc6fe },
	'profileembedpolicy' => { 117 => 0xc6fd },
	'profilehuesatmapdata1' => { 117 => 0xc6fa },
	'profilehuesatmapdata2' => { 117 => 0xc6fb },
	'profilehuesatmapdims' => { 117 => 0xc6f9 },
	'profilehuesatmapencoding' => { 117 => 0xc7a3 },
	'profilelooktabledata' => { 117 => 0xc726 },
	'profilelooktabledims' => { 117 => 0xc725 },
	'profilelooktableencoding' => { 117 => 0xc7a4 },
	'profilename' => { 117 => 0xc6f8 },
	'profiles' => { 448 => 'Profiles' },
	'profiletonecurve' => { 117 => 0xc6fc },
	'profiletype' => { 448 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 311 => 0x3c },
	'programline' => { 327 => '1.1' },
	'programmode' => { 186 => 0x5 },
	'programshift' => { 222 => 0xd },
	'programversion' => { 129 => 0x46 },
	'prohibits' => { 466 => 'prohibits' },
	'projectiontype' => { 456 => 'ProjectionType', 457 => 'ProjectionType' },
	'projectname' => { 494 => 'projectName' },
	'projectref' => { 494 => 'projectRef' },
	'projectrefpath' => { 494 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 494 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 176 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 298 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 298 => 'PropertyReleaseStatus' },
	'provider' => { 176 => 'WM/Provider' },
	'province-state' => { 129 => 0x5f },
	'publicationdate' => { 484 => 'publicationDate' },
	'publicationdatea-platform' => { 484 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 484 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 484 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 484 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 484 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 480 => 'PublicationEvent' },
	'publicationeventdate' => { 480 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 480 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 480 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 484 => 'publicationName' },
	'publisher' => { 176 => 'WM/Publisher', 363 => "\xa9pub", 365 => 'publisher', 471 => 'publisher' },
	'publishingfrequency' => { 484 => 'publishingFrequency' },
	'pulldown' => { 494 => 'pullDown' },
	'purchasedate' => { 363 => 'purd' },
	'purplehsl' => { 101 => 0x20916 },
	'pxshiftperiphedgenr' => { 445 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 445 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 110 => 0x2, 111 => 0x3002, 125 => 0x1000, 137 => 0x9, 222 => 0x4, 254 => 0x3, 293 => 0x201, 306 => 0x300, 346 => 0x8, 353 => 0x2, 388 => 0x16, 398 => 0x56, 399 => 0x56, 400 => 0xb, 411 => [0x102,0x202e] },
	'quality2' => { 419 => 0x1170, 420 => 0x1174, 421 => 0x1150, 423 => 0x11a8, 424 => 0x1060, 425 => 0x258, 426 => 0x258, 427 => 0x247, 432 => 0x29, 433 => 0x25, 434 => 0x2a },
	'qualitymode' => { 111 => 0x8 },
	'quantizationmethod' => { 131 => 0x78 },
	'quickadjust' => { 267 => 0x2a },
	'quickcontroldialinmeter' => { 82 => 0x703 },
	'quickfix' => { 264 => 0x416391c6 },
	'quickshot' => { 387 => 0x213 },
	'quiettime' => { 135 => 0x188a },
	'rads' => { 371 => 'rads' },
	'rangefinder' => { 276 => '4.1', 277 => '5.1', 278 => '5.1' },
	'rasterizedcaption' => { 129 => 0x7d },
	'rating' => { 117 => 0x4746, 125 => 0x1431, 357 => 0xdf, 363 => 'rtng', 371 => 'rtng', 411 => 0x2002, 463 => 'rating', 472 => 'rating', 480 => 'Rating', 484 => 'rating', 492 => 'Rating' },
	'ratingpercent' => { 117 => 0x4749, 175 => 'Rating', 363 => 'rate', 492 => 'RatingPercent' },
	'ratingregion' => { 480 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 480 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 480 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 480 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 480 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 480 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 480 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 480 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 480 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 480 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 480 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 480 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 480 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 480 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 480 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 480 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 480 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 480 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 80 => 0x8, 183 => 0x109, 327 => 0xd },
	'rawbrightnessadj' => { 101 => 0x20001, 106 => 0x38 },
	'rawburstimagecount' => { 73 => 0x2 },
	'rawburstimagenum' => { 73 => 0x1 },
	'rawcoloradj' => { 106 => 0x2e },
	'rawcropbottom' => { 357 => 0xd4 },
	'rawcropleft' => { 357 => 0xd1 },
	'rawcropright' => { 357 => 0xd3 },
	'rawcroptop' => { 357 => 0xd2 },
	'rawcustomsaturation' => { 106 => 0x30 },
	'rawcustomtone' => { 106 => 0x34 },
	'rawdata' => { 385 => 0xa048 },
	'rawdatabyteorder' => { 385 => 0x40 },
	'rawdatacfapattern' => { 385 => 0x50 },
	'rawdatauniqueid' => { 117 => 0xc65d },
	'rawdepth' => { 185 => 0x10 },
	'rawdevartfilter' => { 295 => 0x121 },
	'rawdevautogradation' => { 295 => 0x119 },
	'rawdevcolorspace' => { 294 => 0x108, 295 => 0x109 },
	'rawdevcontrastvalue' => { 294 => 0x106, 295 => 0x105 },
	'rawdeveditstatus' => { 294 => 0x10b },
	'rawdevelopmentprocess' => { 346 => 0x62 },
	'rawdevengine' => { 294 => 0x109, 295 => 0x10b },
	'rawdevexposurebiasvalue' => { 294 => 0x100, 295 => 0x100 },
	'rawdevgradation' => { 295 => 0x112 },
	'rawdevgraypoint' => { 294 => 0x103, 295 => 0x104 },
	'rawdevmemorycoloremphasis' => { 294 => 0x105, 295 => 0x108 },
	'rawdevnoisereduction' => { 294 => 0x10a, 295 => 0x10a },
	'rawdevpicturemode' => { 295 => 0x10c },
	'rawdevpm_bwfilter' => { 295 => 0x110 },
	'rawdevpmcontrast' => { 295 => 0x10e },
	'rawdevpmnoisefilter' => { 295 => 0x120 },
	'rawdevpmpicturetone' => { 295 => 0x111 },
	'rawdevpmsaturation' => { 295 => 0x10d },
	'rawdevpmsharpness' => { 295 => 0x10f },
	'rawdevsaturation3' => { 295 => 0x113 },
	'rawdevsaturationemphasis' => { 294 => 0x104, 295 => 0x107 },
	'rawdevsettings' => { 294 => 0x10c },
	'rawdevsharpnessvalue' => { 294 => 0x107, 295 => 0x106 },
	'rawdevversion' => { 294 => 0x0, 295 => 0x0 },
	'rawdevwbfineadjustment' => { 294 => 0x102, 295 => 0x103 },
	'rawdevwhitebalance' => { 295 => 0x101 },
	'rawdevwhitebalancevalue' => { 294 => 0x101, 295 => 0x102 },
	'rawfile' => { 117 => 0xfe4c },
	'rawfilename' => { 468 => 'RawFileName', 470 => 'RawFileName' },
	'rawfiletype' => { 411 => 0x2029 },
	'rawformat' => { 316 => 0x2d, 355 => 0x10e },
	'rawimagecenter' => { 222 => 0x99 },
	'rawimagedigest' => { 117 => 0xc71c },
	'rawimagesize' => { 346 => 0x39 },
	'rawinfoversion' => { 296 => 0x0 },
	'rawjpgheight' => { 97 => 0x4 },
	'rawjpgquality' => { 56 => 0x6, 97 => 0x1 },
	'rawjpgsize' => { 56 => 0x7, 97 => 0x2 },
	'rawjpgwidth' => { 97 => 0x3 },
	'rawmeasuredrggb' => { 42 => 0x26a, 44 => 0x280, 46 => 0x194, 47 => [0x1ad,0x26b] },
	'rawrppused' => { 463 => 'rawrppused' },
	'rawtopreviewgain' => { 117 => 0xc7a8 },
	'readouttypeactual' => { 135 => 0x1903 },
	'readouttyperequested' => { 135 => 0x1902 },
	'reardisplay' => { 271 => '12.3', 272 => '6.2' },
	'recdevice' => { 480 => 'RecDevice' },
	'recdeviceattlensdescription' => { 480 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 480 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 480 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 480 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 480 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 486 => 'recipeEndingPage' },
	'recipepagerange' => { 486 => 'recipePageRange' },
	'recipesource' => { 486 => 'recipeSource' },
	'recipestartingpage' => { 486 => 'recipeStartingPage' },
	'recipetitle' => { 486 => 'recipeTitle' },
	'recognizedface1age' => { 304 => 0x20 },
	'recognizedface1name' => { 304 => 0x4 },
	'recognizedface1position' => { 304 => 0x18 },
	'recognizedface2age' => { 304 => 0x50 },
	'recognizedface2name' => { 304 => 0x34 },
	'recognizedface2position' => { 304 => 0x48 },
	'recognizedface3age' => { 304 => 0x80 },
	'recognizedface3name' => { 304 => 0x64 },
	'recognizedface3position' => { 304 => 0x78 },
	'recognizedfaceflags' => { 311 => 0x63 },
	'recommendedexposureindex' => { 117 => 0x8832, 475 => 'RecommendedExposureIndex' },
	'record' => { 116 => 'Record' },
	'recordbasisofrecord' => { 116 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 116 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 116 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 116 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 116 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 116 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 181 => 0x4d },
	'recorddynamicproperties' => { 116 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 95 => 0x1804 },
	'recordinformationwithheld' => { 116 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 371 => "\xa9phg" },
	'recordingformat' => { 378 => 0x1000 },
	'recordingmode' => { 110 => 0x1, 353 => 0x1 },
	'recordinstitutioncode' => { 116 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 116 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 371 => "\xa9lab" },
	'recordlabelurl' => { 371 => "\xa9lal" },
	'recordmode' => { 34 => 0x9, 111 => 0x3000 },
	'recordownerinstitutioncode' => { 116 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 387 => 0x217 },
	'redbalance' => { 293 => 0x1017, 316 => 0x11, 346 => 0x1c },
	'redcurvelimits' => { 106 => 0x18a },
	'redcurvepoints' => { 105 => 0x2d, 106 => 0x160 },
	'redeyecorrection' => { 268 => 0x0 },
	'redeyeinfo' => { 468 => 'RedEyeInfo', 470 => 'RedEyeInfo' },
	'redeyereduction' => { 181 => 0x41, 398 => 0x6a, 400 => 0x28 },
	'redeyeremoval' => { 311 => 0xb9 },
	'redhsl' => { 101 => 0x20910 },
	'redhue' => { 468 => 'RedHue', 470 => 'RedHue' },
	'redsaturation' => { 468 => 'RedSaturation', 470 => 'RedSaturation' },
	'reductionmatrix1' => { 117 => 0xc625 },
	'reductionmatrix2' => { 117 => 0xc626 },
	'reelname' => { 117 => 0xc789, 371 => 'reel' },
	'reference1' => { 478 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 478 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 117 => 0x214, 490 => 'ReferenceBlackWhite' },
	'referencedate' => { 129 => 0x2f },
	'referencenumber' => { 129 => 0x32 },
	'references' => { 154 => 'References' },
	'referenceservice' => { 129 => 0x2d },
	'regionappliedtodimensions' => { 169 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 169 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 169 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 169 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 169 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 169 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 169 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 169 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 169 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 169 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 169 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 169 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 298 => 'RegionConstraints' },
	'regiondescription' => { 169 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 169 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 169 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 169 => 'Regions' },
	'regioninfodateregionsvalid' => { 172 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 172 => 'RegionInfo' },
	'regioninforegions' => { 172 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 169 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 169 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 172 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 172 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 172 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 172 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 172 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 169 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 169 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 169 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 480 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 480 => 'RegistryId' },
	'registryitemid' => { 480 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 480 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 152 => 'data' },
	'relatedaudiofilename' => { 152 => '1Name' },
	'relatedaudiofiletype' => { 152 => '0Type' },
	'relatedimagefileformat' => { 117 => 0x1000 },
	'relatedimageheight' => { 117 => 0x1002 },
	'relatedimagewidth' => { 117 => 0x1001 },
	'relatedresourceid' => { 116 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 117 => 0xa004, 474 => 'RelatedSoundFile' },
	'relatedvideofile' => { 166 => 'data' },
	'relatedvideofilename' => { 166 => '1Name' },
	'relatedvideofiletype' => { 166 => '0Type' },
	'relation' => { 471 => 'relation' },
	'relationshipaccordingto' => { 116 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 116 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 116 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 116 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 114 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 494 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 494 => 'relativeTimestamp' },
	'relativetimestampscale' => { 494 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 494 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 271 => '17.8', 272 => '18.5', 274 => '18.4', 275 => '18.4', 280 => '33.8', 281 => '17.6', 284 => '18.5', 285 => '18.4' },
	'releasedate' => { 129 => 0x1e, 363 => 'rldt', 463 => 'ReleaseDate', 494 => 'releaseDate' },
	'releasemode' => { 111 => 0x3001, 240 => 0x184d, 411 => 0xb049 },
	'releasemode2' => { 419 => 0x112c, 420 => [0x112c,0x8], 421 => [0x1108,0x8], 422 => [0x1184,0x8], 423 => [0x1160,0x8], 424 => [0x4,0x1018], 425 => [0x4,0x210], 426 => [0x4,0x210], 427 => [0x4,0x208], 429 => [0x67,0x3f], 430 => [0x6b,0x6d,0x73,0x4b], 431 => [0x6b,0x4b], 432 => 0x10, 433 => 0x10, 434 => 0x9, 441 => 0x34 },
	'releasemode3' => { 419 => 0x1128, 420 => 0x1128, 421 => 0x1104, 422 => 0x1180, 423 => 0x115c, 424 => 0x1014, 425 => 0x20c, 426 => 0x20c, 427 => 0x204 },
	'releaseready' => { 480 => 'ReleaseReady' },
	'releasesetting' => { 95 => 0x1016 },
	'releasetime' => { 129 => 0x23, 463 => 'ReleaseTime' },
	'remoteonduration' => { 273 => '3.4', 276 => '17.2', 277 => '18.2', 278 => '18.2', 279 => '18.2', 281 => '18.2', 282 => '4.3', 286 => '19.2' },
	'renditionclass' => { 495 => 'RenditionClass' },
	'renditionof' => { 495 => 'RenditionOf' },
	'renditionofalternatepaths' => { 495 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 495 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 495 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 495 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 495 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 495 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 495 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 495 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 495 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 495 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 495 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 495 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 495 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 495 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 495 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 495 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 495 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 495 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 495 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 495 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 495 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 495 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 495 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 495 => 'RenditionParams' },
	'repeatingflashcount' => { 205 => 0xd, 206 => 0xe, 207 => 0xe, 208 => 0xe, 209 => 0xe, 280 => '17.2', 281 => '24.2', 282 => '9.2', 283 => '24.2', 286 => '25.2' },
	'repeatingflashcountbuilt-in' => { 249 => 0x4db },
	'repeatingflashcountexternal' => { 249 => 0x4c3 },
	'repeatingflashoutput' => { 280 => '17.1', 281 => '24.1', 282 => '9.1', 283 => '24.1', 286 => '25.1' },
	'repeatingflashoutputexternal' => { 249 => 0x4c0 },
	'repeatingflashrate' => { 205 => 0xc, 206 => 0xd, 207 => 0xd, 208 => 0xd, 209 => 0xd, 280 => '18.1', 281 => '25.1', 282 => '10.1', 283 => '25.1', 286 => '26.1' },
	'repeatingflashratebuilt-in' => { 249 => 0x4da },
	'repeatingflashrateexternal' => { 249 => 0x4c2 },
	'requirements' => { 371 => "\xa9req" },
	'requires' => { 466 => 'requires' },
	'resampleparams' => { 494 => 'resampleParams' },
	'resampleparamsquality' => { 494 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 135 => 0xe50 },
	'resamplingkerneldenominators067' => { 135 => 0xe4f },
	'resamplingkerneldenominators100' => { 135 => 0xe51 },
	'resaved' => { 387 => 0x21e },
	'resetblacksegrows' => { 135 => 0x181a },
	'resolution' => { 159 => 'Resolution' },
	'resolutionmode' => { 388 => [0x87,0x4] },
	'resolutionunit' => { 117 => 0x128, 132 => 0x2, 490 => 'ResolutionUnit' },
	'resourceid' => { 116 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 116 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 116 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 82 => 0x612 },
	'restrictions' => { 487 => 'restrictions' },
	'retouchareafeather' => { 468 => [\'RetouchAreas','RetouchAreasFeather'], 470 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 468 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 470 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 468 => [\'RetouchAreas','RetouchAreasMasksAngle'], 470 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 468 => [\'RetouchAreas','RetouchAreasMasksBottom'], 470 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 468 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 470 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 468 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 470 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 468 => [\'RetouchAreas','RetouchAreasMasksDabs'], 470 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 468 => [\'RetouchAreas','RetouchAreasMasksFeather'], 470 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 468 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 470 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 468 => [\'RetouchAreas','RetouchAreasMasksFlow'], 470 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 468 => [\'RetouchAreas','RetouchAreasMasksFullX'], 470 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 468 => [\'RetouchAreas','RetouchAreasMasksFullY'], 470 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 468 => [\'RetouchAreas','RetouchAreasMasksLeft'], 470 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 468 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 470 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 468 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 470 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 468 => [\'RetouchAreas','RetouchAreasMasksRadius'], 470 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 468 => [\'RetouchAreas','RetouchAreasMasksRight'], 470 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 468 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 470 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 468 => [\'RetouchAreas','RetouchAreasMasks'], 470 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 468 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 470 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 468 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 470 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 468 => [\'RetouchAreas','RetouchAreasMasksTop'], 470 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 468 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 470 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 468 => [\'RetouchAreas','RetouchAreasMasksVersion'], 470 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 468 => [\'RetouchAreas','RetouchAreasMasksWhat'], 470 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 468 => [\'RetouchAreas','RetouchAreasMasksX'], 470 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 468 => [\'RetouchAreas','RetouchAreasMasksY'], 470 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 468 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 470 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 468 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 470 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 468 => [\'RetouchAreas','RetouchAreasMethod'], 470 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 468 => [\'RetouchAreas','RetouchAreasOffsetY'], 470 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 468 => [\'RetouchAreas','RetouchAreasOpacity'], 470 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 468 => 'RetouchAreas', 470 => 'RetouchAreas' },
	'retouchareaseed' => { 468 => [\'RetouchAreas','RetouchAreasSeed'], 470 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 468 => [\'RetouchAreas','RetouchAreasSourceState'], 470 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 468 => [\'RetouchAreas','RetouchAreasSourceX'], 470 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 468 => [\'RetouchAreas','RetouchAreasSpotType'], 470 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 222 => 0x9e },
	'retouchinfo' => { 468 => 'RetouchInfo', 470 => 'RetouchInfo' },
	'retouchnefprocessing' => { 229 => 0x5 },
	'retractlensonpoweroff' => { 82 => 0x814 },
	'reuse' => { 298 => 'Reuse' },
	'reuseallowed' => { 497 => 'ReuseAllowed' },
	'reuseprohibited' => { 487 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 278 => '5.2' },
	'reverseindicators' => { 271 => '12.1', 272 => '6.1', 274 => '6.1', 275 => '6.1', 276 => '4.3', 277 => '5.2', 278 => '5.4', 280 => '33.5', 281 => '5.1', 284 => '6.1', 285 => '6.1', 286 => '6.2' },
	'reverseshutterspeedaperture' => { 278 => '5.3' },
	'revision' => { 472 => 'revision' },
	'rflensmffocusringsensitivity' => { 82 => 0x714 },
	'rflenstype' => { 56 => 0x3d },
	'rgbcurvelimits' => { 106 => 0x238 },
	'rgbcurvepoints' => { 105 => 0x7, 106 => 0x20e },
	'richtextcomment' => { 477 => 'RichTextComment' },
	'ricohdate' => { 377 => 0x6 },
	'ricohimageheight' => { 377 => 0x2 },
	'ricohimagewidth' => { 377 => 0x0 },
	'rightalbedo' => { 459 => 'RightAlbedo' },
	'rightascension' => { 162 => 'RightAscension' },
	'rights' => { 471 => 'rights' },
	'rightsagent' => { 487 => 'rightsAgent' },
	'rightsowner' => { 487 => 'rightsOwner' },
	'roll' => { 113 => 0x8, 371 => ['roll',"\xa9frl"] },
	'rollangle' => { 240 => 0x350b, 241 => 0x2c24, 245 => 0xc21a, 250 => 0x36f4, 251 => 0x2efb, 253 => 0xce32, 288 => 0x903, 311 => 0x90, 345 => 0x1, 383 => 0x2 },
	'romoperationmode' => { 95 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 94 => 0x3, 101 => 0x10002, 106 => 0x26e, 112 => 'QuickTime-Rotation', 121 => 0x4, 162 => 'Rotation', 179 => [0x65,0x50], 180 => 0x46, 181 => 0x5a, 184 => 0x10, 240 => 0x3693, 241 => 0xca, 248 => '590.1', 264 => 0x76a43207, 311 => 0x30, 327 => '17.2', 357 => 0xd8, 364 => 'irot', 398 => 0x3f, 399 => 0x3f, 409 => 0x10 },
	'routedto' => { 476 => 'RoutedTo' },
	'routing' => { 362 => 'Routing' },
	'routingdestinations' => { 458 => 'RoutingDestinations' },
	'routingexclusions' => { 458 => 'RoutingExclusions' },
	'routingnotes' => { 476 => 'RoutingNotes' },
	'rowsperstrip' => { 117 => 0x116 },
	'rpp' => { 463 => 'rpp' },
	'rtkflag' => { 114 => 'RtkFlag' },
	'rtkstdhgt' => { 114 => 'RtkStdHgt' },
	'rtkstdlat' => { 114 => 'RtkStdLat' },
	'rtkstdlon' => { 114 => 'RtkStdLon' },
	'safetyshift' => { 82 => 0x108 },
	'safetyshiftinavortv' => { 80 => 0x10, 81 => 0x10, 83 => 0xf, 84 => 0x10, 87 => 0x10 },
	'sameexposurefornewaperture' => { 82 => 0x112 },
	'samplebits' => { 152 => 'SampleBits' },
	'samplepagerange' => { 484 => 'samplePageRange' },
	'samplerate' => { 152 => 'SampleRate' },
	'samplesperpixel' => { 117 => 0x115, 316 => 0x8, 490 => 'SamplesPerPixel' },
	'samplestructure' => { 131 => 0x5a },
	'samsungmodelid' => { 385 => 0x3 },
	'sanyoquality' => { 387 => 0x201 },
	'sanyothumbnail' => { 387 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 50 => 0x1, 110 => 0xd, 111 => [0x3013,0x1f], 117 => [0xa409,0xfe55], 125 => 0x1003, 153 => 'Saturation', 178 => 0x1f, 179 => 0x32, 180 => 0x28, 181 => 0x1a, 186 => 0x1, 222 => 0xaa, 224 => 0x35, 225 => 0x3b, 226 => 0x43, 311 => 0x40, 313 => 0x300d, 346 => 0x1f, 353 => 0xd, 372 => 0x27, 374 => 0x58, 377 => 0x28, 378 => 0x1013, 388 => 0x10, 398 => 0x1e, 399 => 0x1b, 411 => 0x2005, 468 => 'Saturation', 470 => 'Saturation', 474 => 'Saturation' },
	'saturationadj' => { 101 => 0x20901, 106 => 0x116, 222 => 0x94, 263 => 0x1, 267 => 0x2e, 445 => 0x8016 },
	'saturationadjustmentaqua' => { 468 => 'SaturationAdjustmentAqua', 470 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 468 => 'SaturationAdjustmentBlue', 470 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 468 => 'SaturationAdjustmentGreen', 470 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 468 => 'SaturationAdjustmentMagenta', 470 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 468 => 'SaturationAdjustmentOrange', 470 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 468 => 'SaturationAdjustmentPurple', 470 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 468 => 'SaturationAdjustmentRed', 470 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 468 => 'SaturationAdjustmentYellow', 470 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 69 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 68 => 0x68, 69 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 68 => 0x38, 69 => 0x38 },
	'saturationmonochrome' => { 68 => 0x80, 69 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 68 => 0x50, 69 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 68 => 0x20, 69 => 0x20 },
	'saturationsetting' => { 296 => 0x1010, 400 => 0x11, 416 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 68 => 0x8, 69 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 68 => 0x98, 69 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 68 => 0xb0, 69 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 68 => 0xc8, 69 => 0xe0 },
	'saveid' => { 495 => 'SaveID' },
	'sbaanalysiscomplete' => { 135 => 0xc35 },
	'sbablack' => { 135 => 0xc25 },
	'sbagmoffset' => { 135 => 0xc4a },
	'sbagray' => { 135 => 0xc26 },
	'sbagreenmagentabal' => { 135 => 0xc33 },
	'sbahighgray' => { 135 => 0xc46 },
	'sbailloffset' => { 135 => 0xc49 },
	'sbailluminantbal' => { 135 => 0xc34 },
	'sbalowgray' => { 135 => 0xc47 },
	'sbaneutralbal' => { 135 => 0xc32 },
	'sbawhite' => { 135 => 0xc27 },
	'scaletype' => { 494 => 'scaleType' },
	'scanimageenhancer' => { 230 => 0x60 },
	'scanningdirection' => { 131 => 0x64 },
	'scene' => { 371 => 'scen', 479 => 'Scene', 494 => 'scene' },
	'scenearea' => { 291 => 0x211, 293 => 0x1031 },
	'sceneassist' => { 222 => 0x9c },
	'scenecapturetype' => { 117 => 0xa406, 474 => 'SceneCaptureType' },
	'scenedetect' => { 291 => 0x210, 293 => 0x1030 },
	'scenedetectdata' => { 291 => 0x212, 293 => 0x1033 },
	'scenemode' => { 139 => 0xfa02, 183 => 0x100, 222 => 0x8f, 288 => 0x509, 293 => 0x403, 311 => 0x8001, 320 => 0xf, 411 => 0xb023 },
	'scenemodeused' => { 141 => [0x6002,0xf002] },
	'scenerecognition' => { 125 => 0x1425 },
	'sceneselect' => { 387 => 0x21f },
	'scenetype' => { 117 => 0xa301, 474 => 'SceneType' },
	'screentips' => { 271 => '12.7', 272 => '5.3', 280 => '13.1', 281 => '4.4', 284 => '5.4', 286 => '5.1' },
	'scriptversion' => { 135 => 0x1770 },
	'season' => { 480 => 'Season', 483 => 'season' },
	'seasonidentifier' => { 480 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 480 => [\'Season','SeasonName'] },
	'seasonnumber' => { 480 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 458 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 240 => 0x1d0, 250 => 0x1d0 },
	'section' => { 484 => 'section' },
	'securityclassification' => { 117 => 0x9212 },
	'selectableafpoint' => { 82 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 82 => 0x512 },
	'selfdata' => { 114 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 311 => 0x2e, 387 => 0x214, 419 => 0x1134, 420 => 0x1134, 421 => 0x1110, 422 => 0x118c, 423 => 0x1168, 424 => 0x1020, 425 => 0x218, 426 => 0x218, 427 => 0x210 },
	'selftimer2' => { 75 => 0x1d },
	'selftimerinterval' => { 281 => '19.2' },
	'selftimermode' => { 117 => 0x882b },
	'selftimershotcount' => { 272 => '20.2', 274 => '20.3', 275 => '20.3', 276 => '18.2', 277 => '19.2', 278 => '19.2', 279 => '19.3', 281 => '19.3', 284 => '20.3', 285 => '20.3', 286 => '20.2' },
	'selftimershotinterval' => { 272 => '20.3', 274 => '20.2', 275 => '20.2', 279 => '19.2', 284 => '20.2', 285 => '20.2' },
	'selftimertime' => { 95 => 0x1806, 181 => 0x1f, 271 => '18.1', 272 => '20.1', 273 => '3.3', 274 => '20.1', 275 => '20.1', 276 => '18.1', 277 => '19.1', 278 => '19.1', 279 => '19.1', 280 => '7.2', 281 => '19.1', 282 => '3.3', 284 => '20.1', 285 => '20.1', 286 => '20.1' },
	'sellingagency' => { 484 => 'sellingAgency' },
	'seminfo' => { 117 => 0x8546 },
	'sensingmethod' => { 117 => 0xa217, 474 => 'SensingMethod' },
	'sensitivityadjust' => { 346 => 0x40 },
	'sensitivitysteps' => { 327 => ['14.3','17.4'], 329 => 0x1 },
	'sensitivitytype' => { 117 => 0x8830, 475 => 'SensitivityType' },
	'sensor' => { 188 => 0x665e },
	'sensorarea' => { 293 => 0x400 },
	'sensorareas' => { 385 => 0xa010 },
	'sensorbitdepth' => { 313 => 0x312d },
	'sensorbluelevel' => { 72 => 0x5 },
	'sensorcalibration' => { 292 => 0x805 },
	'sensorcleaning' => { 88 => 0xd },
	'sensorfullheight' => { 134 => 0xf904 },
	'sensorfullwidth' => { 134 => 0xf903 },
	'sensorheight' => { 134 => 0xf901, 139 => 0xfa21, 185 => 0x8, 313 => 0x312c, 355 => 0x109, 378 => 0x1602 },
	'sensorimageheight' => { 135 => 0x3ee },
	'sensorimagewidth' => { 135 => 0x3ed },
	'sensorleftborder' => { 135 => 0x3eb },
	'sensorleftmargin' => { 355 => 0x10a },
	'sensorpixelsize' => { 222 => 0x9a },
	'sensorredlevel' => { 72 => 0x4 },
	'sensorserialnumber' => { 135 => 0x9ce },
	'sensorsize' => { 153 => 'SensorSize', 346 => 0x35 },
	'sensortemperature' => { 291 => 0x1500, 293 => 0x1007, 351 => 0xc, 355 => 0x210, 388 => [0x39,0x55] },
	'sensortemperature2' => { 351 => 0xe, 355 => 0x211 },
	'sensortopborder' => { 135 => 0x3ec },
	'sensortopmargin' => { 355 => 0x10b },
	'sensortype' => { 311 => 0xca },
	'sensorwidth' => { 134 => 0xf900, 139 => 0xfa20, 185 => 0xa, 313 => 0x312b, 355 => 0x108, 378 => 0x1601 },
	'sequence' => { 372 => 0x7, 373 => 0x35, 374 => 0x36 },
	'sequencefilenumber' => { 420 => 0x4, 421 => 0x4, 422 => 0x4, 423 => 0x4, 432 => 0xc, 433 => 0xc, 434 => 0x1a },
	'sequenceimagenumber' => { 420 => 0x0, 421 => 0x0, 422 => 0x0, 423 => 0x0, 432 => 0x8, 433 => 0x8, 434 => 0x12, 441 => 0x24 },
	'sequencelength' => { 432 => 0x22, 433 => 0x1e, 434 => [0x16,0x1e] },
	'sequencename' => { 483 => 'sequenceName' },
	'sequencenumber' => { 75 => 0x9, 111 => 0x301c, 125 => 0x1101, 137 => 0x1d, 249 => 0x51c, 311 => 0x2b, 400 => [0x10c,0x30c], 411 => 0xb04a, 483 => 'sequenceNumber' },
	'sequenceshotinterval' => { 387 => 0x224 },
	'sequencetotalnumber' => { 483 => 'sequenceTotalNumber' },
	'sequentialshot' => { 387 => 0x20e },
	'serialnumber' => { 62 => 0xc, 95 => 0x180b, 117 => [0xa431,0xfde9], 134 => 0xfa04, 136 => 0xfa00, 138 => 0xc354, 139 => 0xfa19, 150 => 0x0, 153 => 'SerialNumber', 188 => 0x5501, 222 => [0xa0,0x1d], 289 => 0x101, 293 => [0x404,0x101a], 306 => 0x303, 308 => 0x305, 313 => 0x3103, 346 => 0x229, 355 => 0x102, 356 => 0x407, 371 => ['SNum','slno'], 372 => 0x15, 373 => 0x4b, 374 => 0x7e, 378 => 0x5, 385 => 0xa002, 388 => 0x2, 411 => 0x2031, 465 => 'SerialNumber', 475 => 'BodySerialNumber' },
	'serialnumberformat' => { 62 => 0x15, 95 => 0x183b },
	'serialnumberhash' => { 371 => 'CAME' },
	'series' => { 480 => 'Series' },
	'seriesdatetime' => { 447 => 'SeriesDateTime' },
	'seriesdescription' => { 447 => 'SeriesDescription' },
	'seriesidentifier' => { 480 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 447 => 'SeriesModality' },
	'seriesname' => { 480 => [\'Series','SeriesName'] },
	'seriesnumber' => { 447 => 'SeriesNumber', 484 => 'seriesNumber' },
	'seriestitle' => { 484 => 'seriesTitle' },
	'serviceidentifier' => { 130 => 0x1e },
	'servingsize' => { 486 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 85 => 0x0, 86 => 0x0 },
	'setbuttonwhenshooting' => { 80 => 0x1, 82 => 0x704, 88 => 0xc },
	'setfunctionwhenshooting' => { 83 => 0x0, 84 => 0x1, 87 => 0x1 },
	'setting' => { 483 => 'setting' },
	'shadingcompensation' => { 288 => 0x50c, 311 => 0x8a },
	'shadingcompensation2' => { 292 => 0x1012 },
	'shadow' => { 388 => 0xe },
	'shadowadj' => { 101 => 0x2030b },
	'shadowcorrection' => { 346 => 0x79 },
	'shadowprotection' => { 263 => 0x0 },
	'shadows' => { 117 => 0xfe52, 411 => 0x2032, 462 => 'Shadows', 468 => 'Shadows', 470 => 'Shadows' },
	'shadows2012' => { 468 => 'Shadows2012', 470 => 'Shadows2012' },
	'shadowsadj' => { 445 => 0x901a },
	'shadowscale' => { 117 => 0xc633 },
	'shadowtint' => { 468 => 'ShadowTint', 470 => 'ShadowTint' },
	'shadowtone' => { 125 => 0x1040 },
	'shakereduction' => { 348 => 0x1, 349 => 0x1 },
	'shareduserrating' => { 176 => 'WM/SharedUserRating' },
	'sharpendetail' => { 468 => 'SharpenDetail', 470 => 'SharpenDetail' },
	'sharpenedgemasking' => { 468 => 'SharpenEdgeMasking', 470 => 'SharpenEdgeMasking' },
	'sharpening' => { 313 => 0x300b },
	'sharpeningadj' => { 267 => 0x2b },
	'sharpeningkernel' => { 135 => 0x92f },
	'sharpenradius' => { 468 => 'SharpenRadius', 470 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 72 => 0x2, 110 => 0xb, 111 => [0x3011,0x21], 117 => [0xa40a,0xfe56], 125 => 0x1001, 137 => 0x6b, 146 => 0x37, 153 => 'Sharpness', 178 => 0x21, 179 => 0x30, 180 => 0x26, 181 => 0x18, 186 => 0x3, 222 => 0x6, 224 => 0x32, 225 => 0x33, 226 => 0x39, 293 => 0x100f, 311 => 0x41, 346 => 0x21, 353 => 0xb, 372 => 0x26, 374 => 0x56, 377 => 0x22, 378 => [0x1003,0x1014], 388 => 0x11, 398 => 0x1c, 399 => 0x19, 411 => 0x2006, 441 => 0x52, 468 => 'Sharpness', 470 => 'Sharpness', 474 => 'Sharpness' },
	'sharpnessadj' => { 101 => 0x20310, 106 => 0x25a, 445 => 0x801a },
	'sharpnessadjon' => { 101 => '0x20310.0' },
	'sharpnessauto' => { 69 => 0x94 },
	'sharpnessfactor' => { 293 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 68 => 0x64, 69 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 72 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 68 => 0x34, 69 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 68 => 0x7c, 69 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 68 => 0x4c, 69 => 0x4c },
	'sharpnessovershoot' => { 445 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 68 => 0x1c, 69 => 0x1c },
	'sharpnessrange' => { 411 => 0x2035 },
	'sharpnesssetting' => { 288 => 0x506, 296 => 0x1013, 400 => 0x12, 416 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 68 => 0x4, 69 => 0x4 },
	'sharpnessstrength' => { 101 => 0x20311 },
	'sharpnessthreshold' => { 445 => 0x801d },
	'sharpnessundershoot' => { 445 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 68 => 0x94, 69 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 68 => 0xac, 69 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 68 => 0xc4, 69 => 0xdc },
	'shiftcols' => { 135 => 0xc70 },
	'shootid' => { 483 => 'shootID' },
	'shootingdistance' => { 101 => 0x20701 },
	'shootinginfodisplay' => { 271 => '13.2', 272 => '5.1', 280 => '10.2', 281 => '4.1', 284 => '5.1', 286 => '5.3' },
	'shootinginfomonitorofftime' => { 271 => '26.2', 272 => '22.2', 274 => '22.2', 275 => '22.2', 279 => '21.2', 280 => '9.1', 281 => '21.2', 284 => '22.2', 285 => '22.2', 286 => '22.2' },
	'shootingmode' => { 153 => 'ShootingMode', 222 => 0x89, 311 => 0x1f },
	'shootingmodesetting' => { 273 => '5.1' },
	'shortdescription' => { 472 => 'shortdescription' },
	'shortdocumentid' => { 129 => 0xba },
	'shortname' => { 468 => 'ShortName', 470 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 82 => 0x80d },
	'shorttitle' => { 363 => '@sti' },
	'shotdate' => { 494 => 'shotDate' },
	'shotday' => { 494 => 'shotDay' },
	'shotlocation' => { 494 => 'shotLocation' },
	'shotname' => { 371 => 'shot', 494 => 'shotName' },
	'shotnumber' => { 494 => 'shotNumber' },
	'shotnumbersincepowerup' => { 415 => 0x44e, 432 => 0x1a, 433 => 0x16, 434 => 0xa },
	'shotnumbersincepowerup2' => { 400 => 0x200 },
	'shotsize' => { 494 => 'shotSize' },
	'showmovement' => { 363 => 'shwm' },
	'shownevent' => { 480 => 'EventExt' },
	'showneventidentifier' => { 480 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 480 => [\'EventExt','EventExtName'] },
	'shutter' => { 429 => 0x20, 430 => 0x26, 431 => 0x26 },
	'shutter-aelock' => { 80 => 0x4, 82 => 0x701, 83 => 0x3, 84 => 0x4, 85 => 0x3, 86 => 0x3, 87 => 0x4, 88 => 0x2 },
	'shutteraelbutton' => { 81 => 0x4 },
	'shutterbuttonafonbutton' => { 82 => 0x701 },
	'shuttercount' => { 11 => 0x176, 56 => 0x1, 222 => 0xa7, 231 => [0x6a,0x157,0x24d], 232 => 0x286, 233 => 0x279, 234 => 0x284, 235 => 0x242, 236 => 0x280, 237 => 0x276, 238 => [0x27d,0x27f], 239 => 0x246, 242 => 0x2d6, 243 => 0x321, 244 => 0xbd8, 246 => 0x287, 247 => 0x320, 248 => 0x24a, 249 => 0x5fb, 252 => 0x2d5, 346 => 0x5d, 409 => 0x846, 414 => [0x125,0x14a], 429 => 0x32, 430 => 0x3a, 431 => 0x3a },
	'shuttercount2' => { 429 => 0x4c, 430 => [0x50,0x52,0x58], 431 => 0x50 },
	'shuttercount3' => { 429 => [0x1a0,0x1aa,0x1bd], 430 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 80 => 0xf, 81 => 0xf, 82 => 0x305, 83 => 0xe, 84 => 0xf, 85 => 0x8, 86 => 0x8, 87 => 0xf, 88 => 0x8 },
	'shuttermode' => { 137 => 0x1b, 222 => 0x34 },
	'shutterreleasebuttonae-l' => { 271 => '17.7', 272 => '18.4', 274 => '78.4', 275 => '78.4', 276 => '16.1', 277 => '17.1', 278 => '17.1', 279 => '17.1', 280 => '7.1', 281 => '17.5', 284 => '18.4', 285 => '78.4', 286 => '18.2' },
	'shutterreleasemethod' => { 95 => 0x1010 },
	'shutterreleasenocfcard' => { 80 => 0x2, 81 => 0x2, 88 => 0xf },
	'shutterreleasetiming' => { 95 => 0x1011 },
	'shutterreleasewithoutlens' => { 82 => 0x711 },
	'shutterspeedlock' => { 272 => '38.1', 274 => '38.1', 275 => '38.1', 284 => '38.1', 285 => '38.1' },
	'shutterspeedrange' => { 82 => 0x10c },
	'shutterspeedsetting' => { 181 => 0x6, 398 => 0x2f, 399 => 0x28, 400 => 0x0 },
	'shutterspeedvalue' => { 91 => 0x1, 117 => 0x9201, 293 => 0x1000, 355 => 0x400, 474 => 'ShutterSpeedValue' },
	'shuttertype' => { 125 => 0x1050, 311 => 0x9f, 346 => 0x87 },
	'sidecarforextension' => { 482 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 135 => 0xe0d },
	'sigmascalingfactorcamera' => { 135 => 0xe0c },
	'sigmascalingfactorlowres' => { 135 => 0xe0b },
	'sigmasizetable' => { 135 => 0xe0f },
	'similarityindex' => { 129 => 0xe4 },
	'singleframebracketing' => { 181 => 0x21 },
	'skilllevel' => { 486 => 'skillLevel' },
	'skintonecorrection' => { 346 => 0x95 },
	'skiplinetime' => { 135 => 0x184e },
	'slaveflashmeteringsegments' => { 346 => 0x20b },
	'slideshowname' => { 483 => 'slideshowName' },
	'slideshownumber' => { 483 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 483 => 'slideshowTotalNumber' },
	'slowshutter' => { 75 => 0x8 },
	'slowsync' => { 125 => 0x1030 },
	'smartalbumcolor' => { 385 => 0x20 },
	'smartrange' => { 385 => 0xa012 },
	'smileshutter' => { 400 => 0x31 },
	'smileshuttermode' => { 400 => 0x27 },
	'smoothness' => { 117 => 0xfe57, 468 => 'Smoothness', 470 => 'Smoothness' },
	'snapshot' => { 480 => 'SnapshotLink' },
	'snapshotformat' => { 480 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 480 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 480 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 480 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 480 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 463 => 'Snapshots' },
	'snapshotusedvideoframe' => { 480 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 480 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 480 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 480 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 480 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 411 => 0x200f },
	'software' => { 117 => 0x131, 154 => 'Software', 301 => 'Software', 355 => 0x203, 365 => 'software', 388 => 0x18, 453 => 'Software', 490 => 'Software' },
	'softwareversion' => { 371 => ['@swr',"\xa9swr"], 387 => 0x207 },
	'soloist' => { 363 => "\xa9sol" },
	'songwriter' => { 371 => "\xa9swf" },
	'songwriterkeywords' => { 371 => "\xa9swk" },
	'sonycropsize' => { 117 => 0x74c8 },
	'sonycroptopleft' => { 117 => 0x74c7 },
	'sonydatetime' => { 418 => 0x6, 420 => 0x1b6, 421 => 0x210, 422 => 0x1fe, 423 => 0x22c },
	'sonydatetime2' => { 429 => 0x51 },
	'sonyexposuretime' => { 429 => 0x3a, 430 => 0x46, 431 => [0x66,0x46] },
	'sonyexposuretime2' => { 441 => 0xe },
	'sonyfnumber' => { 429 => 0x3c, 430 => 0x48, 431 => [0x68,0x48], 441 => 0x14 },
	'sonyimageheight' => { 418 => 0x1a, 432 => 0x44, 433 => 0x3f, 434 => 0x47 },
	'sonyimageheightmax' => { 441 => 0x40 },
	'sonyimagesize' => { 181 => 0x3b, 398 => 0x54, 399 => 0x54, 400 => 0x9 },
	'sonyimagewidth' => { 418 => 0x1c },
	'sonyimagewidthmax' => { 441 => 0x3e },
	'sonyiso' => { 420 => 0x1218, 421 => 0x11f4, 422 => 0x1270, 423 => [0x1254,0x1258,0x1280], 424 => 0x113c, 425 => 0x344, 426 => 0x346, 427 => 0x320, 441 => 0x4 },
	'sonymaxaperture' => { 429 => 0x0, 430 => 0x0 },
	'sonymaxaperturevalue' => { 441 => 0x16 },
	'sonyminaperture' => { 429 => 0x1, 430 => 0x1 },
	'sonymodelid' => { 411 => 0xb001 },
	'sonyquality' => { 181 => 0x3c },
	'sonytimeminsec' => { 430 => 0x61 },
	'sortalbum' => { 363 => 'soal' },
	'sortalbumartist' => { 363 => 'soaa' },
	'sortartist' => { 363 => 'soar' },
	'sortcomposer' => { 363 => 'soco' },
	'sortname' => { 363 => 'sonm', 468 => 'SortName', 470 => 'SortName' },
	'sortshow' => { 363 => 'sosn' },
	'soundengineer' => { 363 => "\xa9sne" },
	'source' => { 129 => 0x73, 301 => 'Source', 471 => 'source', 472 => 'source', 482 => 'Source' },
	'sourcecount' => { 457 => 'SourceCount' },
	'sourcecredits' => { 371 => "\xa9src" },
	'sourcedirectoryindex' => { 333 => 0x0 },
	'sourcefileindex' => { 333 => 0x2 },
	'sourcephotoscount' => { 456 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 135 => 0x1390 },
	'spatialfrequencyresponse' => { 474 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 474 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 474 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 474 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 474 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 494 => 'speakerPlacement' },
	'specialeffectlevel' => { 111 => 0x3030 },
	'specialeffectmode' => { 111 => 0x2076 },
	'specialeffectsetting' => { 111 => 0x3031 },
	'specialinstructions' => { 129 => 0x28 },
	'specialmode' => { 293 => 0x200, 387 => 0x200 },
	'specialoccasion' => { 486 => 'specialOccasion' },
	'specialtypeid' => { 451 => 'SpecialTypeID' },
	'spectralsensitivity' => { 117 => 0x8824, 474 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 44 => [0x2b9,0x2d0,0x2d4], 45 => 0x56a, 46 => 0x1e4, 47 => [0x1fd,0x2dd], 48 => [0x231,0x30f], 49 => 0x31d },
	'speedx' => { 113 => 0x3, 371 => "\xa9xsp" },
	'speedy' => { 113 => 0x4, 371 => "\xa9ysp" },
	'speedz' => { 113 => 0x5, 371 => "\xa9zsp" },
	'spherical' => { 457 => 'Spherical' },
	'splitcolumn' => { 355 => 0x222 },
	'splittoningbalance' => { 468 => 'SplitToningBalance', 470 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 468 => 'SplitToningHighlightHue', 470 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 468 => 'SplitToningHighlightSaturation', 470 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 468 => 'SplitToningShadowHue', 470 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 468 => 'SplitToningShadowSaturation', 470 => 'SplitToningShadowSaturation' },
	'sport' => { 484 => 'sport' },
	'spotfocuspointx' => { 178 => 0x2d },
	'spotfocuspointy' => { 178 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 82 => 0x107 },
	'sractive' => { 327 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 348 => 0x3 },
	'srhalfpresstime' => { 348 => 0x2 },
	'srresult' => { 348 => 0x0, 349 => 0x0 },
	'stackedimage' => { 288 => 0x804 },
	'standardmatrixcustom' => { 135 => 0x7d4 },
	'standardmatrixdaylight' => { 135 => 0x7d0 },
	'standardmatrixflash' => { 135 => 0x7d3 },
	'standardmatrixfluorescent' => { 135 => 0x7d2 },
	'standardmatrixtungsten' => { 135 => 0x7d1 },
	'standardoutputhighlightpoint' => { 107 => 0x14 },
	'standardoutputsensitivity' => { 117 => 0x8831, 475 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 107 => 0x15 },
	'standardrawcolortone' => { 107 => 0xd },
	'standardrawcontrast' => { 107 => 0xf },
	'standardrawhighlight' => { 107 => 0x75 },
	'standardrawhighlightpoint' => { 107 => 0x12 },
	'standardrawlinear' => { 107 => 0x10 },
	'standardrawsaturation' => { 107 => 0xe },
	'standardrawshadow' => { 107 => 0x7e },
	'standardrawshadowpoint' => { 107 => 0x13 },
	'standardrawsharpness' => { 107 => 0x11 },
	'standardunsharpmaskfineness' => { 107 => 0x94 },
	'standardunsharpmaskstrength' => { 107 => 0x92 },
	'standardunsharpmaskthreshold' => { 107 => 0x96 },
	'standardwhitecustom' => { 135 => 0x838 },
	'standardwhitedaylight' => { 135 => 0x834 },
	'standardwhiteflash' => { 135 => 0x837 },
	'standardwhitefluorescent' => { 135 => 0x836 },
	'standardwhitetungsten' => { 135 => 0x835 },
	'standbytimer' => { 272 => '19.1', 274 => '19.1', 275 => '19.1', 278 => '18.1', 279 => '18.1', 284 => '19.1', 285 => '19.1' },
	'startingpage' => { 484 => 'startingPage' },
	'startmovieshooting' => { 82 => 0x70d },
	'starttimecode' => { 371 => "\xa9TIM", 494 => 'startTimecode' },
	'starttimecodetimeformat' => { 494 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 494 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 494 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 371 => "\xa9TSZ", 494 => 'startTimeSampleSize' },
	'starttimescale' => { 371 => "\xa9TSC", 494 => 'startTimeScale' },
	'state' => { 158 => 'State', 311 => 0x6b, 482 => 'State' },
	'status' => { 449 => 'Status', 461 => 'Status' },
	'stereomode' => { 457 => 'StereoMode' },
	'stitched' => { 457 => 'Stitched' },
	'stitchingsoftware' => { 456 => 'StitchingSoftware', 457 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 419 => 0x113e, 420 => 0x113e, 421 => 0x111a, 422 => 0x1196, 423 => 0x1172, 424 => 0x102a, 425 => 0x222, 426 => 0x222, 427 => 0x217, 441 => 0xa },
	'storagemethod' => { 185 => 0x12 },
	'storebyorientation' => { 272 => '46.3', 274 => '47.3', 275 => '47.3', 284 => '47.3', 285 => '47.3' },
	'storedescription' => { 363 => 'sdes' },
	'storylineidentifier' => { 480 => 'StorylineIdentifier' },
	'straightenangle' => { 264 => 0x2fc08431 },
	'streamready' => { 480 => 'StreamReady' },
	'streamtype' => { 173 => 'StreamType' },
	'stretchmode' => { 494 => 'stretchMode' },
	'studydatetime' => { 447 => 'StudyDateTime' },
	'studydescription' => { 447 => 'StudyDescription' },
	'studyid' => { 447 => 'StudyID' },
	'studyphysician' => { 447 => 'StudyPhysician' },
	'styleperiod' => { 480 => 'StylePeriod' },
	'sub-location' => { 129 => 0x5c },
	'subfiledata' => { 161 => 'data' },
	'subfiledirectory' => { 161 => '1Directory' },
	'subfilemimetype' => { 161 => '2MIME' },
	'subfilename' => { 161 => '1Name' },
	'subfileresource' => { 161 => 'rsrc' },
	'subfiletype' => { 117 => 0xfe, 161 => '0Type' },
	'subject' => { 297 => 'Subject', 362 => 'Subject', 471 => 'subject', 481 => 'Subject', 495 => 'subject' },
	'subjectarea' => { 117 => 0x9214, 474 => 'SubjectArea' },
	'subjectcode' => { 479 => 'SubjectCode' },
	'subjectdistance' => { 117 => 0x9206, 137 => 0x3e, 474 => 'SubjectDistance' },
	'subjectdistancerange' => { 117 => 0xa40c, 474 => 'SubjectDistanceRange' },
	'subjectlocation' => { 117 => 0xa214, 474 => 'SubjectLocation' },
	'subjectmotion' => { 274 => '78.2', 275 => '78.2', 285 => '78.2' },
	'subjectprogram' => { 178 => 0x22 },
	'subjectreference' => { 129 => 0xc },
	'sublabels1' => { 478 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 478 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 112 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 112 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 112 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 117 => 0x9290 },
	'subsectimedigitized' => { 117 => 0x9292 },
	'subsectimeoriginal' => { 117 => 0x9291 },
	'subsection1' => { 484 => 'subsection1' },
	'subsection2' => { 484 => 'subsection2' },
	'subsection3' => { 484 => 'subsection3' },
	'subsection4' => { 484 => 'subsection4' },
	'subselector' => { 272 => '49.1', 274 => '71.1', 275 => '71.1', 285 => '71.1' },
	'subselectorassignment' => { 272 => '48.1' },
	'subselectorcenter' => { 274 => '72.1', 275 => '72.1', 285 => '72.1' },
	'subselectorplusdials' => { 272 => '49.2', 274 => '73.1', 275 => '73.1', 285 => '73.1' },
	'subtitle' => { 176 => 'WM/SubTitle', 363 => "\xa9st3", 371 => "\xa9snm", 484 => 'subtitle' },
	'subtitlekeywords' => { 371 => "\xa9snk" },
	'subversionfilename' => { 478 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 478 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 478 => 'SubVersions' },
	'superimposeddisplay' => { 80 => 0xa, 82 => 0x510, 83 => 0x9, 84 => 0xa, 87 => 0xa, 88 => 0xe },
	'supermacro' => { 62 => 0x1a },
	'supplementalcategories' => { 129 => 0x14, 482 => 'SupplementalCategories' },
	'supplementaltype' => { 131 => 0x37 },
	'supplementdisplayid' => { 484 => 'supplementDisplayID' },
	'supplementstartingpage' => { 484 => 'supplementStartingPage' },
	'supplementtitle' => { 484 => 'supplementTitle' },
	'supplychainsource' => { 480 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 480 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 480 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 468 => 'SupportsAmount', 470 => 'SupportsAmount' },
	'supportscolor' => { 468 => 'SupportsColor', 470 => 'SupportsColor' },
	'supportshighdynamicrange' => { 468 => 'SupportsHighDynamicRange', 470 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 468 => 'SupportsMonochrome', 470 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 468 => 'SupportsNormalDynamicRange', 470 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 468 => 'SupportsOutputReferred', 470 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 468 => 'SupportsSceneReferred', 470 => 'SupportsSceneReferred' },
	'svisosetting' => { 327 => 0x14 },
	'swatchcoloranta' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 499 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 499 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 499 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 499 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 499 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 311 => 0x93, 400 => 0x33 },
	'sweeppanoramafieldofview' => { 311 => 0x94 },
	'sweeppanoramasize' => { 400 => 0x32 },
	'switchtoregisteredafpoint' => { 81 => 0x12, 82 => 0x50a },
	'symlink' => { 118 => 'SymLink' },
	'syncreleasemode' => { 274 => '77.1', 275 => '77.1', 285 => '77.1' },
	'system' => { 355 => 0x204 },
	'tagged' => { 357 => 0xdd, 358 => 'Tagged', 463 => 'tagged' },
	'tagslist' => { 473 => 'TagsList' },
	'tagstructure' => { 478 => 'TagStructure' },
	'takenumber' => { 494 => 'takeNumber' },
	'tapename' => { 494 => 'tapeName' },
	'targetaperture' => { 75 => 0x4 },
	'targetcompressionratio' => { 93 => 0x1 },
	'targetdistancesetting' => { 95 => 0x1807 },
	'targetexposuretime' => { 75 => 0x5 },
	'targetimagetype' => { 95 => 0x100a },
	'targetprinter' => { 117 => 0x151 },
	'taxon' => { 116 => 'Taxon' },
	'taxonacceptednameusage' => { 116 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 116 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 116 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 116 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 116 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 116 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 116 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 116 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 116 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 116 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 116 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 116 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 116 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 116 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 116 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 116 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 116 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 116 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 116 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 116 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 116 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 116 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 116 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 116 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 116 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 116 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 116 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 116 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 116 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 116 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 116 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 116 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 116 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 135 => 0x196f },
	'tda1edgepolarity' => { 135 => 0x1971 },
	'tda1gain' => { 135 => 0x1970 },
	'tda1offset' => { 135 => 0x196e },
	'tda2bandwidth' => { 135 => 0x1979 },
	'tda2edgepolarity' => { 135 => 0x197b },
	'tda2gain' => { 135 => 0x197a },
	'tda2offset' => { 135 => 0x1978 },
	'tda3bandwidth' => { 135 => 0x1983 },
	'tda3edgepolarity' => { 135 => 0x1985 },
	'tda3gain' => { 135 => 0x1984 },
	'tda3offset' => { 135 => 0x1982 },
	'tda4bandwidth' => { 135 => 0x198d },
	'tda4edgepolarity' => { 135 => 0x198f },
	'tda4gain' => { 135 => 0x198e },
	'tda4offset' => { 135 => 0x198c },
	'teaser' => { 484 => 'teaser' },
	'teleconverter' => { 183 => 0x105, 411 => 0x105 },
	'tempampgainx100' => { 135 => 0x1914 },
	'tempo' => { 494 => 'tempo' },
	'temporalcoverage' => { 480 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 480 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 480 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 298 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 298 => 'TermsAndConditionsURL' },
	'testname' => { 118 => 'TestName' },
	'textencoding' => { 221 => 0x4 },
	'textlayername' => { 482 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 482 => 'TextLayers' },
	'textlayertext' => { 482 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 311 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 468 => 'Texture', 470 => 'Texture' },
	'three-dtrackingfacedetection' => { 274 => '1.4', 275 => '1.4', 285 => '1.4' },
	'three-dtrackingwatcharea' => { 274 => '78.1', 275 => '78.1', 285 => '78.1' },
	'thresholding' => { 117 => 0x107 },
	'thumbnailfilename' => { 95 => 0x817 },
	'thumbnailformat' => { 492 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 139 => 0xfa55, 492 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 95 => 0x2008, 112 => 'Exif-ThumbnailImage', 120 => 0x3, 164 => 'data', 293 => 0x100, 371 => 'thmb', 492 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 164 => '1Name' },
	'thumbnailimagesize' => { 164 => 'ImageSize' },
	'thumbnailimagetype' => { 164 => '0Type' },
	'thumbnailimagevalidarea' => { 62 => 0x13 },
	'thumbnaillength' => { 117 => 0x202 },
	'thumbnailoffset' => { 117 => 0x201 },
	'thumbnailpng' => { 371 => 'thmb' },
	'thumbnails' => { 492 => 'Thumbnails' },
	'thumbnailwidth' => { 139 => 0xfa54, 492 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 484 => 'ticker' },
	'tiffhandling' => { 468 => 'TIFFHandling', 470 => 'TIFFHandling' },
	'tiffmeteringimage' => { 184 => 0x104c, 409 => 0x1110 },
	'tilelength' => { 117 => 0x143 },
	'tilewidth' => { 117 => 0x142 },
	'time' => { 135 => 0x401, 346 => 0x7 },
	'timecodes' => { 117 => 0xc763 },
	'timecreated' => { 129 => 0x3c, 137 => 0x14, 146 => 0x10, 358 => 'TimeCreated' },
	'timelapseshotnumber' => { 314 => 0x10 },
	'timeperiod' => { 484 => 'timePeriod' },
	'timerfunctionbutton' => { 273 => '5.2', 276 => '12.1', 277 => '13.1' },
	'timerlength' => { 82 => 0x80c },
	'timerrecording' => { 311 => 0x96 },
	'timescaleparams' => { 494 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 494 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 494 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 494 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 130 => 0x50 },
	'timeshot' => { 458 => 'TimeShot' },
	'timesignature' => { 494 => 'timeSignature' },
	'timesincepoweron' => { 311 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 287 => 0x8, 301 => 'TimeStamp', 311 => 0xaf, 457 => 'Timestamp', 464 => 'Timestamp', 478 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 76 => 0x1, 256 => 0x0, 381 => 0xa },
	'timezonecity' => { 76 => 0x2 },
	'timezonecode' => { 98 => 0x1 },
	'timezoneinfo' => { 98 => 0x2 },
	'timezoneoffset' => { 117 => 0x882a },
	'tint' => { 365 => 'player.movie.visual.tint', 468 => 'Tint', 470 => 'Tint' },
	'title' => { 154 => 'Title', 297 => 'Title', 301 => 'Title', 311 => 0x65, 362 => 'Title', 363 => ['titl',"\xa9nam"], 365 => 'title', 371 => ['titl',"\xa9nam"], 471 => 'title', 481 => 'Title', 492 => 'Title' },
	'togglestyleamount' => { 468 => 'ToggleStyleAmount', 470 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 468 => 'ToggleStyleDigest', 470 => 'ToggleStyleDigest' },
	'tonecomp' => { 222 => 0x81 },
	'tonecurve' => { 72 => 0x1, 346 => 0x402, 468 => 'ToneCurve', 470 => 'ToneCurve' },
	'tonecurveactive' => { 106 => 0x110 },
	'tonecurveadobergb' => { 385 => 0xa043 },
	'tonecurveadobergbdefault' => { 385 => 0xa041 },
	'tonecurveblue' => { 468 => 'ToneCurveBlue', 470 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 445 => 0x9003 },
	'tonecurvebluey' => { 445 => 0x9007 },
	'tonecurvebrightness' => { 101 => 0x20410 },
	'tonecurvebrightnessx' => { 445 => 0x9000 },
	'tonecurvebrightnessy' => { 445 => 0x9004 },
	'tonecurvecolorspace' => { 105 => 0x0 },
	'tonecurvecontrast' => { 101 => 0x20411 },
	'tonecurvegreen' => { 468 => 'ToneCurveGreen', 470 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 445 => 0x9002 },
	'tonecurvegreeny' => { 445 => 0x9006 },
	'tonecurveinputrange' => { 105 => 0x3 },
	'tonecurveinterpolation' => { 106 => 0x159 },
	'tonecurvemode' => { 106 => 0x113 },
	'tonecurvename' => { 468 => 'ToneCurveName', 470 => 'ToneCurveName' },
	'tonecurvename2012' => { 468 => 'ToneCurveName2012', 470 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 101 => '0x20400.1' },
	'tonecurveoutputrange' => { 105 => 0x5 },
	'tonecurveprofilename' => { 135 => 0x1391 },
	'tonecurveproperty' => { 106 => 0x3c },
	'tonecurvepv2012' => { 468 => 'ToneCurvePV2012', 470 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 468 => 'ToneCurvePV2012Blue', 470 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 468 => 'ToneCurvePV2012Green', 470 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 468 => 'ToneCurvePV2012Red', 470 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 468 => 'ToneCurveRed', 470 => 'ToneCurveRed' },
	'tonecurveredx' => { 445 => 0x9001 },
	'tonecurveredy' => { 445 => 0x9005 },
	'tonecurves' => { 346 => 0x403 },
	'tonecurveshape' => { 105 => 0x1 },
	'tonecurvesrgb' => { 385 => 0xa042 },
	'tonecurvesrgbdefault' => { 385 => 0xa040 },
	'tonecurvex' => { 105 => 0xa },
	'tonecurvey' => { 105 => 0xb },
	'tonelevel' => { 288 => 0x52e },
	'tonemapstrength' => { 468 => 'ToneMapStrength', 470 => 'ToneMapStrength' },
	'toningeffect' => { 56 => 0xf, 222 => 0xb3, 224 => 0x38, 225 => 0x40, 226 => 0x48, 378 => 0x1015 },
	'toningeffectauto' => { 69 => 0xa4 },
	'toningeffectfaithful' => { 68 => 0x74, 69 => 0x74 },
	'toningeffectlandscape' => { 68 => 0x44, 69 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 68 => 0x8c, 69 => 0x8c },
	'toningeffectneutral' => { 68 => 0x5c, 69 => 0x5c },
	'toningeffectportrait' => { 68 => 0x2c, 69 => 0x2c },
	'toningeffectstandard' => { 68 => 0x14, 69 => 0x14 },
	'toningeffectuserdef1' => { 68 => 0xa4, 69 => 0xbc },
	'toningeffectuserdef2' => { 68 => 0xbc, 69 => 0xd4 },
	'toningeffectuserdef3' => { 68 => 0xd4, 69 => 0xec },
	'toningsaturation' => { 224 => 0x39, 225 => 0x41, 226 => 0x49 },
	'totalzoom' => { 137 => 0x62 },
	'touchae' => { 311 => 0xab },
	'track' => { 363 => "\xa9trk", 371 => "\xa9trk" },
	'trackcreatedate' => { 370 => 0x1 },
	'trackmodifydate' => { 370 => 0x2 },
	'tracknumber' => { 363 => 'trkn', 494 => 'trackNumber' },
	'tracks' => { 494 => 'Tracks' },
	'tracksframerate' => { 494 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 494 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 494 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 494 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 494 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 494 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 494 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 494 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 494 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 494 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 494 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 494 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 494 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 494 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 494 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 494 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 494 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 371 => 'kgtt' },
	'trailer' => { 118 => 'Trailer' },
	'trailersignature' => { 161 => 'zmie' },
	'transcript' => { 480 => 'Transcript' },
	'transcriptlink' => { 480 => 'TranscriptLink' },
	'transcriptlinklink' => { 480 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 480 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 117 => 0x12d, 490 => 'TransferFunction' },
	'transfertimenormal' => { 135 => 0x1888 },
	'transfertimetest' => { 135 => 0x1889 },
	'transform' => { 311 => [0x8012,0x59] },
	'transmissionreference' => { 482 => 'TransmissionReference' },
	'trapped' => { 297 => 'Trapped', 481 => 'Trapped' },
	'trashbuttonfunction' => { 82 => 0x710 },
	'travelday' => { 311 => 0x36 },
	'trebel' => { 365 => 'player.movie.audio.treble' },
	'triggermode' => { 372 => 0x6, 373 => 0x34, 374 => 0x34 },
	'tstop' => { 117 => 0xc772 },
	'ttl_da_adown' => { 334 => 0x5 },
	'ttl_da_aup' => { 334 => 0x4 },
	'ttl_da_bdown' => { 334 => 0x7 },
	'ttl_da_bup' => { 334 => 0x6 },
	'tungstenawb' => { 324 => 0x1 },
	'tvepisode' => { 363 => 'tves' },
	'tvepisodeid' => { 363 => 'tven' },
	'tvexposuretimesetting' => { 327 => 0x12 },
	'tvnetworkname' => { 363 => 'tvnn' },
	'tvseason' => { 363 => 'tvsn' },
	'tvshow' => { 363 => 'tvsh' },
	'type' => { 471 => 'type', 489 => 'type' },
	'typestatus' => { 116 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 117 => 0xc614 },
	'uniquedocumentid' => { 129 => 0xbb },
	'uniquematrixauto' => { 135 => 0x7e9 },
	'uniquematrixcustom' => { 135 => 0x7e8 },
	'uniquematrixdaylight' => { 135 => 0x7e4 },
	'uniquematrixflash' => { 135 => 0x7e7 },
	'uniquematrixfluorescent' => { 135 => 0x7e6 },
	'uniquematrixtungsten' => { 135 => 0x7e5 },
	'uniqueobjectname' => { 130 => 0x64 },
	'units' => { 453 => 'Units' },
	'unknown_aacr' => { 363 => 'AACR' },
	'unknown_cdek' => { 363 => 'CDEK' },
	'unknown_cdet' => { 363 => 'CDET' },
	'unknownblock' => { 346 => 0x405 },
	'unknownblock1' => { 292 => 0x635 },
	'unknownblock2' => { 292 => 0x636 },
	'unknownblock3' => { 292 => 0x1103 },
	'unknownblock4' => { 292 => 0x1104 },
	'unknowncontrast' => { 107 => 0x45 },
	'unknowndate' => { 355 => 0x212 },
	'unknownev' => { 135 => 0x1 },
	'unknownlinear' => { 107 => 0x46 },
	'unknownnumber' => { 95 => 0x180b },
	'unknownoutputhighlightpoint' => { 107 => 0x4a },
	'unknownoutputshadowpoint' => { 107 => 0x4b },
	'unknownrawhighlight' => { 107 => 0x7b },
	'unknownrawhighlightpoint' => { 107 => 0x48 },
	'unknownrawshadow' => { 107 => 0x84 },
	'unknownrawshadowpoint' => { 107 => 0x49 },
	'unknownsharpness' => { 107 => 0x47 },
	'unknowntags' => { 371 => 'TAGS' },
	'unknowntemperature' => { 119 => 0x4 },
	'unknownthumbnail' => { 371 => 'thmb' },
	'unsharp1color' => { 269 => 0x13 },
	'unsharp1halowidth' => { 269 => 0x19 },
	'unsharp1intensity' => { 269 => 0x17 },
	'unsharp1threshold' => { 269 => 0x1b },
	'unsharp2color' => { 269 => 0x2e },
	'unsharp2halowidth' => { 269 => 0x34 },
	'unsharp2intensity' => { 269 => 0x32 },
	'unsharp2threshold' => { 269 => 0x36 },
	'unsharp3color' => { 269 => 0x49 },
	'unsharp3halowidth' => { 269 => 0x4f },
	'unsharp3intensity' => { 269 => 0x4d },
	'unsharp3threshold' => { 269 => 0x51 },
	'unsharp4color' => { 269 => 0x64 },
	'unsharp4halowidth' => { 269 => 0x6a },
	'unsharp4intensity' => { 269 => 0x68 },
	'unsharp4threshold' => { 269 => 0x6c },
	'unsharpcount' => { 269 => 0x0 },
	'unsharpmask' => { 107 => 0x90, 264 => 0x76a43200 },
	'unsharpmaskfineness' => { 101 => 0x20309 },
	'unsharpmaskstrength' => { 101 => 0x20308 },
	'unsharpmaskthreshold' => { 101 => 0x2030a },
	'uprightcentermode' => { 468 => 'UprightCenterMode', 470 => 'UprightCenterMode' },
	'uprightcenternormx' => { 468 => 'UprightCenterNormX', 470 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 468 => 'UprightCenterNormY', 470 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 468 => 'UprightDependentDigest', 470 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 468 => 'UprightFocalLength35mm', 470 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 468 => 'UprightFocalMode', 470 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 468 => 'UprightFourSegmentsCount', 470 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 468 => 'UprightPreview', 470 => 'UprightPreview' },
	'uprighttransform_0' => { 468 => 'UprightTransform_0', 470 => 'UprightTransform_0' },
	'uprighttransform_1' => { 468 => 'UprightTransform_1', 470 => 'UprightTransform_1' },
	'uprighttransform_2' => { 468 => 'UprightTransform_2', 470 => 'UprightTransform_2' },
	'uprighttransform_3' => { 468 => 'UprightTransform_3', 470 => 'UprightTransform_3' },
	'uprighttransform_4' => { 468 => 'UprightTransform_4', 470 => 'UprightTransform_4' },
	'uprighttransform_5' => { 468 => 'UprightTransform_5', 470 => 'UprightTransform_5' },
	'uprighttransformcount' => { 468 => 'UprightTransformCount', 470 => 'UprightTransformCount' },
	'uprightversion' => { 468 => 'UprightVersion', 470 => 'UprightVersion' },
	'urgency' => { 129 => 0xa, 482 => 'Urgency' },
	'url' => { 154 => 'URL', 301 => 'URL', 360 => 0x40b, 484 => 'url' },
	'url_list' => { 360 => 0x41e },
	'urla-platform' => { 484 => [\'url','urlA-platform'] },
	'urlurl' => { 484 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 82 => 0x10a },
	'usableshootingmodes' => { 82 => 0x109 },
	'usage' => { 485 => 'usage' },
	'usageterms' => { 498 => 'UsageTerms' },
	'useguidelines' => { 466 => 'useGuidelines' },
	'usepanoramaviewer' => { 456 => 'UsePanoramaViewer' },
	'usercollection' => { 365 => 'collection.user' },
	'usercomment' => { 95 => 0x805, 117 => 0x9286, 474 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 68 => 0xd8, 69 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 68 => 0xda, 69 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 68 => 0xdc, 69 => 0xf4 },
	'userfields' => { 461 => 'UserFields' },
	'userlabel' => { 372 => 0x2b, 373 => 0x5a, 374 => 0x68 },
	'userprofile' => { 306 => 0x302, 310 => 0x34c, 313 => 0x3038 },
	'userrating' => { 365 => 'rating.user', 371 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 81 => 0x7, 82 => 0x501 },
	'uspsnumber' => { 484 => 'uspsNumber' },
	'utmeasting' => { 165 => 'Easting' },
	'utmmapdatum' => { 165 => 'Datum' },
	'utmnorthing' => { 165 => 'Northing' },
	'utmzone' => { 165 => 'Zone' },
	'uuid' => { 468 => 'UUID', 470 => 'UUID' },
	'uv-irfiltercorrection' => { 306 => 0x325 },
	'validbits' => { 292 => 0x611, 293 => 0x102c },
	'validpixeldepth' => { 296 => 0x611 },
	'variablelowpassfilter' => { 411 => 0x2028 },
	'variousmodes' => { 137 => 0x26 },
	'variousmodes2' => { 137 => 0x3a },
	'variprogram' => { 222 => 0xab },
	'varraydacnominalvalues' => { 135 => 0x191e },
	'vendor' => { 371 => 'vndr' },
	'vendorinfo' => { 448 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 448 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 448 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 448 => [\'VendorInfo','VendorInfoNotes'] },
	'version' => { 125 => 0x0, 362 => 'Version', 365 => 'version', 468 => 'Version', 470 => 'Version' },
	'versioncreatedate' => { 445 => 0xd100 },
	'versionid' => { 495 => 'VersionID' },
	'versionidentifier' => { 484 => 'versionIdentifier' },
	'versionmodifydate' => { 445 => 0xd101 },
	'versions' => { 495 => 'Versions' },
	'versionscomments' => { 495 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 495 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 495 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 495 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 495 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 495 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 495 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 495 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 495 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 495 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 495 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 271 => '3.2', 272 => '47.2', 274 => '79.1' },
	'verticalclockoverlaps' => { 135 => 0x412 },
	'verticalfuncbutton' => { 272 => '42.2', 274 => '67.1' },
	'verticalfuncbuttonplusdials' => { 272 => '43.1' },
	'verticalfuncplusdials' => { 274 => '68.1' },
	'verticalmultiselector' => { 272 => '42.1', 274 => '66.1', 275 => '66.1', 285 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 82 => [0x510,0x51d] },
	'vibrance' => { 462 => 'Vibrance', 468 => 'Vibrance', 470 => 'Vibrance' },
	'vibrationreduction' => { 231 => [0x75,0x82,0x1ae], 239 => '586.1', 248 => '590.2', 255 => 0x4 },
	'videoalphamode' => { 494 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 494 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 494 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 494 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 480 => 'videoBitRate' },
	'videobitratemode' => { 480 => 'videoBitRateMode' },
	'videoburstmode' => { 311 => 0xbb },
	'videoburstresolution' => { 311 => 0xb3 },
	'videocodec' => { 65 => 0x74 },
	'videocolorspace' => { 494 => 'videoColorSpace' },
	'videocompression' => { 125 => 0x3806 },
	'videocompressor' => { 494 => 'videoCompressor' },
	'videodisplayaspectratio' => { 480 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 480 => 'videoEncodingProfile' },
	'videofieldorder' => { 494 => 'videoFieldOrder' },
	'videoframerate' => { 311 => 0x27, 494 => 'videoFrameRate' },
	'videoframesize' => { 494 => 'videoFrameSize' },
	'videoframesizeh' => { 494 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 494 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 494 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 494 => 'videoModDate' },
	'videopixelaspectratio' => { 494 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 494 => 'videoPixelDepth' },
	'videopreburst' => { 311 => 0xc1 },
	'videoquality' => { 111 => 0x4003 },
	'videorecordingmode' => { 125 => 0x3803 },
	'videoshottype' => { 480 => 'VideoShotType' },
	'videoshottypeidentifier' => { 480 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 480 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 480 => 'videoStreamsCount' },
	'viewfinder' => { 355 => 0x455 },
	'viewfinderdisplay' => { 271 => '12.4', 272 => '6.3' },
	'viewfinderwarning' => { 271 => '13.4', 281 => '3.5', 282 => '6.2', 286 => '4.4' },
	'viewfinderwarnings' => { 82 => 0x40a },
	'viewinfoduringexposure' => { 82 => 0x407 },
	'viewingmode' => { 400 => 0x2f, 416 => 0x18 },
	'viewingmode2' => { 400 => [0x85,0x285] },
	'viewpoint' => { 483 => 'viewpoint' },
	'vignetteamount' => { 468 => 'VignetteAmount', 470 => 'VignetteAmount' },
	'vignettecontrol' => { 222 => 0x2a, 264 => 0x76a43205 },
	'vignettecontrolintensity' => { 264 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 465 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 468 => 'VignetteMidpoint', 470 => 'VignetteMidpoint' },
	'vignetting' => { 378 => 0x1011, 385 => 0xa052 },
	'vignettingcorrection' => { 117 => 0x7031, 385 => 0xa053, 411 => 0x2011 },
	'vignettingcorrparams' => { 117 => 0x7032, 440 => 0x64a, 441 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 385 => 0xa054 },
	'visualcolor' => { 480 => 'VisualColour' },
	'visualtechnique' => { 483 => 'visualTechnique' },
	'voicememo' => { 387 => 0x216 },
	'volume' => { 484 => 'volume' },
	'vr_0x66' => { 231 => 0x66 },
	'vrdoffset' => { 62 => 0xd0 },
	'vrmode' => { 255 => 0x6 },
	'waterdepth' => { 117 => 0x9403, 475 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 184 => 0x19a },
	'wb_bluelevel6500k' => { 184 => 0x18a },
	'wb_bluelevelcustom' => { 184 => 0x18e },
	'wb_bluelevelscloudy' => { 184 => 0x106 },
	'wb_bluelevelsdaylight' => { 184 => 0xea },
	'wb_bluelevelsflash' => { 184 => 0x122 },
	'wb_bluelevelsfluorescent' => { 184 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 184 => 0x254 },
	'wb_bluelevelsshade' => { 184 => 0x176 },
	'wb_bluelevelstungsten' => { 184 => 0xce },
	'wb_gbrglevels' => { 184 => 0xae, 187 => 0x4 },
	'wb_glevel' => { 292 => 0x11f },
	'wb_glevel3000k' => { 292 => 0x113 },
	'wb_glevel3300k' => { 292 => 0x114 },
	'wb_glevel3600k' => { 292 => 0x115 },
	'wb_glevel3900k' => { 292 => 0x116 },
	'wb_glevel4000k' => { 292 => 0x117 },
	'wb_glevel4300k' => { 292 => 0x118 },
	'wb_glevel4500k' => { 292 => 0x119 },
	'wb_glevel4800k' => { 292 => 0x11a },
	'wb_glevel5300k' => { 292 => 0x11b },
	'wb_glevel6000k' => { 292 => 0x11c },
	'wb_glevel6600k' => { 292 => 0x11d },
	'wb_glevel7500k' => { 292 => 0x11e },
	'wb_grbglevels' => { 197 => 0x0 },
	'wb_grgblevelsauto' => { 79 => 0x2 },
	'wb_grgblevelscloudy' => { 79 => 0x12 },
	'wb_grgblevelscustom1' => { 79 => 0x42 },
	'wb_grgblevelscustom2' => { 79 => 0x4a },
	'wb_grgblevelsdaylight' => { 79 => 0xa },
	'wb_grgblevelsflash' => { 79 => 0x32 },
	'wb_grgblevelsfluorescent' => { 79 => 0x22 },
	'wb_grgblevelsfluorhigh' => { 79 => 0x2a },
	'wb_grgblevelstungsten' => { 79 => 0x1a },
	'wb_grgblevelsunderwater' => { 79 => 0x3a },
	'wb_rbgglevels' => { 194 => 0x0 },
	'wb_rblevels' => { 198 => 0x270, 222 => 0xc, 292 => 0x100 },
	'wb_rblevels1' => { 317 => 0x2 },
	'wb_rblevels2' => { 317 => 0x5 },
	'wb_rblevels3' => { 317 => 0x8 },
	'wb_rblevels3000k' => { 292 => 0x102 },
	'wb_rblevels3300k' => { 292 => 0x103 },
	'wb_rblevels3500k' => { 184 => 0x430 },
	'wb_rblevels3600k' => { 292 => 0x104 },
	'wb_rblevels3900k' => { 292 => 0x105 },
	'wb_rblevels4' => { 317 => 0xb },
	'wb_rblevels4000k' => { 292 => 0x106 },
	'wb_rblevels4300k' => { 292 => 0x107 },
	'wb_rblevels4500k' => { 292 => 0x108 },
	'wb_rblevels4800k' => { 292 => 0x109 },
	'wb_rblevels5' => { 317 => 0xe },
	'wb_rblevels5300k' => { 292 => 0x10a },
	'wb_rblevels6' => { 317 => 0x11 },
	'wb_rblevels6000k' => { 292 => 0x10b },
	'wb_rblevels6500k' => { 184 => 0x420 },
	'wb_rblevels6600k' => { 292 => 0x10c },
	'wb_rblevels7' => { 317 => 0x14 },
	'wb_rblevels7500k' => { 292 => 0x10d },
	'wb_rblevelsauto' => { 198 => 0x272, 296 => 0x110 },
	'wb_rblevelscloudy' => { 184 => 0x3f0, 186 => 0x10, 198 => 0x296, 296 => 0x121 },
	'wb_rblevelscoolwhitef' => { 184 => 0x308, 186 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 296 => 0x132 },
	'wb_rblevelscustom' => { 184 => 0x424, 186 => 0x1c },
	'wb_rblevelscwb1' => { 292 => 0x10e },
	'wb_rblevelscwb2' => { 292 => 0x10f },
	'wb_rblevelscwb3' => { 292 => 0x110 },
	'wb_rblevelscwb4' => { 292 => 0x111 },
	'wb_rblevelsdaylight' => { 184 => [0x3ec,0x528], 186 => 0xc, 198 => 0x274 },
	'wb_rblevelsdaylightf' => { 186 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 296 => 0x130 },
	'wb_rblevelsdaywhitef' => { 186 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 296 => 0x131 },
	'wb_rblevelseveningsunlight' => { 296 => 0x124 },
	'wb_rblevelsfineweather' => { 296 => 0x122 },
	'wb_rblevelsflash' => { 184 => [0x3f4,0x304], 186 => 0x18, 198 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 198 => 0x290 },
	'wb_rblevelsincandescent' => { 198 => 0x282 },
	'wb_rblevelsshade' => { 184 => 0x418, 186 => 0x20, 198 => 0x2b2, 296 => 0x120 },
	'wb_rblevelstungsten' => { 184 => 0x3e8, 186 => 0x8, 296 => 0x123 },
	'wb_rblevelsused' => { 296 => 0x100 },
	'wb_rblevelswhitef' => { 186 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 296 => 0x133 },
	'wb_redlevel3500k' => { 184 => 0x198 },
	'wb_redlevel6500k' => { 184 => 0x188 },
	'wb_redlevelcustom' => { 184 => 0x18c },
	'wb_redlevelscloudy' => { 184 => 0xf8 },
	'wb_redlevelsdaylight' => { 184 => 0xdc },
	'wb_redlevelsflash' => { 184 => 0x114 },
	'wb_redlevelsfluorescent' => { 184 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 184 => 0x1be },
	'wb_redlevelsshade' => { 184 => 0x168 },
	'wb_redlevelstungsten' => { 184 => 0xc0 },
	'wb_rgbglevels' => { 196 => 0x0 },
	'wb_rgblevels' => { 184 => [0x546,0x96], 307 => 0xd, 308 => 0x413, 313 => 0x3036, 355 => 0x107, 419 => 0x117c, 420 => 0x1180, 421 => 0x115c, 422 => 0x11d8, 423 => 0x11b4, 424 => 0x106c, 425 => 0x264, 426 => 0x264, 427 => 0x252 },
	'wb_rgblevels1' => { 318 => 0x2 },
	'wb_rgblevels2' => { 318 => 0x6 },
	'wb_rgblevels3' => { 318 => 0xa },
	'wb_rgblevels4' => { 318 => 0xe },
	'wb_rgblevels5' => { 318 => 0x12 },
	'wb_rgblevels6' => { 318 => 0x16 },
	'wb_rgblevels7' => { 318 => 0x1a },
	'wb_rgblevelsauto' => { 389 => 0x0 },
	'wb_rgblevelscustom1' => { 389 => 0x15 },
	'wb_rgblevelscustom2' => { 389 => 0x18 },
	'wb_rgblevelscustom3' => { 389 => 0x1b },
	'wb_rgblevelsdaylight' => { 389 => 0x3 },
	'wb_rgblevelsflash' => { 389 => 0x12 },
	'wb_rgblevelsfluorescent' => { 389 => 0xf },
	'wb_rgblevelsincandescent' => { 389 => 0xc },
	'wb_rgblevelsovercast' => { 389 => 0x9 },
	'wb_rgblevelsshade' => { 389 => 0x6 },
	'wb_rgblevelsunknown0' => { 390 => 0x0 },
	'wb_rgblevelsunknown1' => { 390 => 0x3 },
	'wb_rgblevelsunknown2' => { 390 => 0x6 },
	'wb_rgblevelsunknown3' => { 390 => 0x9 },
	'wb_rgblevelsunknown4' => { 390 => 0xc },
	'wb_rgblevelsunknown5' => { 390 => 0xf },
	'wb_rgblevelsunknown6' => { 390 => 0x12 },
	'wb_rgblevelsunknown7' => { 390 => 0x15 },
	'wb_rgblevelsunknown8' => { 390 => 0x18 },
	'wb_rgblevelsunknown9' => { 390 => 0x1b },
	'wb_rgbmuldaylight' => { 135 => 0x852 },
	'wb_rgbmulflash' => { 135 => 0x855 },
	'wb_rgbmulfluorescent' => { 135 => 0x854 },
	'wb_rgbmultungsten' => { 135 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 187 => 0x4, 195 => 0x0, 199 => 0x13e8, 200 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x22, 43 => 0x3f, 46 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x18, 43 => 0x44, 46 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x4c, 199 => 0x1478, 200 => 0x114, 385 => 0xa022 },
	'wb_rggblevelsblack' => { 385 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0x31, 43 => 0x58, 46 => 0x71, 47 => 0x8a, 48 => 0x8f, 49 => 0x92, 199 => 0x1408, 200 => 0x60, 346 => 0x20f, 354 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 43 => 0x80, 199 => 0x1468, 200 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0x27, 43 => 0x4e, 46 => 0x67, 47 => 0x80, 48 => 0x85, 49 => 0x88, 199 => 0x13f8, 200 => 0x4c, 346 => 0x20d, 354 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0x45, 43 => 0x6c, 46 => 0x85, 47 => 0x9e, 48 => 0xa3, 49 => 0xa6, 199 => 0x1448, 346 => 0x214, 354 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0x3b, 43 => 0x62, 46 => 0x7b, 47 => 0x94, 48 => 0x99, 49 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 200 => 0xc4, 346 => 0x211, 354 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 354 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 200 => 0xb0, 346 => 0x212, 354 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 199 => 0x1438, 200 => 0x9c, 346 => 0x213, 354 => 0x38 },
	'wb_rggblevelshtmercury' => { 200 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 385 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 385 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0x40, 43 => 0x67, 46 => 0x80, 47 => 0x99, 48 => 0x9e, 49 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 43 => 0x49, 46 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x51 },
	'wb_rggblevelspc1' => { 42 => 0x90, 43 => 0x71 },
	'wb_rggblevelspc2' => { 42 => 0x95, 43 => 0x76 },
	'wb_rggblevelspc3' => { 42 => 0x9a, 43 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0x2c, 43 => 0x53, 46 => 0x6c, 47 => 0x85, 48 => 0x8a, 49 => 0x8d, 200 => 0x74, 346 => 0x20e, 354 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0x36, 43 => 0x5d, 46 => 0x76, 47 => 0x8f, 48 => 0x94, 49 => 0x97, 199 => 0x1428, 200 => 0x88, 346 => 0x210, 354 => 0x1d },
	'wb_rggblevelsuncorrected' => { 385 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x1d, 46 => 0x4e, 47 => 0x4e, 48 => 0x4e, 49 => 0x56, 354 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0x72, 46 => 0x9e, 47 => 0x7b, 48 => 0x7b, 49 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => 0x77, 46 => 0xa3, 47 => 0xa3, 48 => 0x80, 49 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0x7c, 46 => 0xa8, 47 => 0xa8, 48 => 0xa8, 49 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0x81, 46 => 0xad, 47 => 0xad, 48 => 0xad, 49 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0x86, 46 => 0xb2, 47 => 0xb2, 48 => 0xb2, 49 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0x8b, 46 => 0xb7, 47 => 0xb7, 48 => 0xb7, 49 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0x9f, 47 => 0xbc, 48 => 0xbc, 49 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 47 => 0xc1, 48 => 0xc1, 49 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 47 => 0xc6, 48 => 0xc6, 49 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 47 => 0xcb, 48 => 0xcb, 49 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x4a, 46 => 0x53, 47 => 0x53, 48 => 0x53, 49 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 47 => 0xd0, 48 => 0xd0, 49 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 48 => 0xd5, 49 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 48 => 0xda, 49 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 48 => 0xdf, 49 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 48 => 0xe4, 49 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 48 => 0xe9, 49 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 48 => 0xee, 49 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 48 => 0xf3, 49 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 48 => 0xf8, 49 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 48 => 0xfd, 49 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x4f, 46 => 0x58, 47 => 0x58, 48 => 0x58, 49 => 0x60 },
	'wb_rggblevelsunknown30' => { 48 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x54, 46 => 0x5d, 47 => 0x5d, 48 => 0x5d, 49 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x59, 46 => 0x62, 47 => 0x62, 48 => 0x62, 49 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x5e, 46 => 0x8a, 47 => 0x67, 48 => 0x67, 49 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x63, 46 => 0x8f, 47 => 0x6c, 48 => 0x6c, 49 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x68, 46 => 0x94, 47 => 0x71, 48 => 0x71, 49 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0x6d, 46 => 0x99, 47 => 0x76, 48 => 0x76, 49 => 0x7e },
	'wb_rggblevelsuserselected' => { 354 => 0x5c },
	'wbadjblueamber' => { 101 => 0x20106 },
	'wbadjbluebalance' => { 270 => 0x8 },
	'wbadjcolortemp' => { 101 => 0x20102, 106 => 0x1a },
	'wbadjlighting' => { 270 => 0x14 },
	'wbadjmagentagreen' => { 101 => 0x20105 },
	'wbadjmode' => { 270 => 0x10 },
	'wbadjredbalance' => { 270 => 0x0 },
	'wbadjrggblevels' => { 101 => 0x20125, 106 => 0x6 },
	'wbadjtemperature' => { 270 => 0x18 },
	'wbadjtint' => { 270 => 0x25 },
	'wbbluelevel' => { 306 => 0x324, 311 => 0x8006, 316 => 0x26 },
	'wbbracketingsteps' => { 240 => 0x174d, 241 => 0x87c, 250 => 0x1757 },
	'wbbracketmode' => { 56 => 0x9 },
	'wbbracketshotnumber' => { 184 => 0x2b, 378 => 0x101a },
	'wbbracketvalueab' => { 56 => 0xc },
	'wbbracketvaluegm' => { 56 => 0xd },
	'wbfinetuneactive' => { 106 => 0x24 },
	'wbfinetunesaturation' => { 106 => 0x28 },
	'wbfinetunetone' => { 106 => 0x2c },
	'wbgreenlevel' => { 306 => 0x323, 311 => 0x8005, 316 => 0x25 },
	'wbmediaimagesizesetting' => { 82 => 0x708 },
	'wbmode' => { 186 => 0x4, 293 => 0x1015 },
	'wbredlevel' => { 306 => 0x322, 311 => 0x8004, 316 => 0x24 },
	'wbscale' => { 187 => 0x0 },
	'wbshiftab' => { 72 => 0xc, 311 => 0x46, 328 => 0x10 },
	'wbshiftab_gm' => { 411 => 0x2014 },
	'wbshiftab_gm_precise' => { 411 => 0x2026 },
	'wbshiftcreativecontrol' => { 311 => 0x92 },
	'wbshiftgm' => { 72 => 0xd, 311 => 0x47, 328 => 0x11 },
	'wbshiftintelligentauto' => { 311 => 0x8b },
	'wbtype1' => { 317 => 0x1, 318 => 0x1 },
	'wbtype2' => { 317 => 0x4, 318 => 0x5 },
	'wbtype3' => { 317 => 0x7, 318 => 0x9 },
	'wbtype4' => { 317 => 0xa, 318 => 0xd },
	'wbtype5' => { 317 => 0xd, 318 => 0x11 },
	'wbtype6' => { 317 => 0x10, 318 => 0x15 },
	'wbtype7' => { 317 => 0x13, 318 => 0x19 },
	'webstatement' => { 498 => 'WebStatement' },
	'what' => { 468 => 'What', 470 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 72 => 0x8, 75 => 0x7, 110 => 0x7, 111 => [0x19,0x2012], 117 => [0xa403,0xfe4e], 125 => 0x1002, 135 => 0x3fc, 136 => 0xfa0d, 137 => 0x40, 148 => 0x1a, 178 => 0x3, 179 => 0xe, 180 => 0x4, 181 => 0xb, 183 => 0x115, 222 => 0x5, 254 => 0x7, 306 => 0x304, 311 => 0x3, 313 => 0x3033, 346 => 0x19, 353 => 0x7, 377 => 0x26, 378 => 0x1003, 388 => [0x88,0x3c,0x7,0x58], 398 => 0xf, 399 => 0xe, 411 => [0x115,0xb054], 468 => 'WhiteBalance', 470 => 'WhiteBalance', 474 => 'WhiteBalance' },
	'whitebalance0' => { 173 => 'WhiteBalance0' },
	'whitebalance1' => { 173 => 'WhiteBalance1' },
	'whitebalance2' => { 173 => 'WhiteBalance2', 288 => 0x500 },
	'whitebalanceadj' => { 101 => 0x20101, 106 => 0x18, 264 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 324 => 0x0 },
	'whitebalancebias' => { 111 => 0x2011, 293 => 0x304, 311 => 0x23 },
	'whitebalanceblue' => { 72 => 0x7 },
	'whitebalancebracket' => { 288 => 0x502, 293 => 0x303 },
	'whitebalancebracketing' => { 181 => 0x22, 184 => 0x2c, 409 => 0x2c },
	'whitebalancecomp' => { 296 => 0x1001 },
	'whitebalancedetected' => { 135 => 0x3fb },
	'whitebalancefinetune' => { 125 => 0x100a, 181 => 0x38, 183 => 0x112, 222 => 0xb, 378 => 0x1004, 398 => 0x6, 399 => 0x5, 411 => 0x112 },
	'whitebalancemode' => { 135 => 0x3fa, 346 => 0x1a },
	'whitebalancered' => { 72 => 0x6 },
	'whitebalanceset' => { 327 => 0xa },
	'whitebalancesetting' => { 181 => 0x23, 398 => 0x5, 399 => 0x4, 400 => 0x16, 416 => 0xd },
	'whitebalancesetup' => { 385 => 0x41 },
	'whitebalancetemperature' => { 288 => 0x501 },
	'whiteboard' => { 293 => 0x301 },
	'whitelevel' => { 117 => 0xc61d, 346 => 0x7e },
	'whitepoint' => { 117 => 0x13e, 310 => 0x35d, 346 => 0x201, 490 => 'WhitePoint' },
	'whites2012' => { 468 => 'Whites2012', 470 => 'Whites2012' },
	'whitesadj' => { 445 => 0x9017 },
	'wideadapter' => { 378 => 0x1017 },
	'widefocuszone' => { 178 => 0x2f },
	'widerange' => { 387 => 0x20f },
	'windmode' => { 135 => 0x3f4 },
	'windowlocation' => { 371 => 'WLOC' },
	'windowsatom' => { 469 => 'windowsAtom' },
	'windowsatomextension' => { 469 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 469 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 469 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 484 => 'wordCount' },
	'work' => { 363 => "\xa9wrk" },
	'workcolorspace' => { 101 => 0x10200, 106 => 0x270 },
	'workflowtag' => { 480 => 'WorkflowTag' },
	'workflowtagcvid' => { 480 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 480 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 480 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 480 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 476 => 'WorkToDo' },
	'worldtimelocation' => { 311 => 0x3a, 346 => 0x22, 352 => '0.1' },
	'writer' => { 176 => 'WM/Writer' },
	'writer-editor' => { 129 => 0x7a },
	'x3filllight' => { 388 => 0x12 },
	'xattrquarantine' => { 171 => 'com.apple.quarantine' },
	'xilinxversion' => { 135 => 0x414 },
	'xml' => { 133 => 'xml ' },
	'xmp' => { 104 => 0xffff00f6, 118 => 'XMP' },
	'xmptoolkit' => { 491 => 'xmptk' },
	'xpauthor' => { 117 => 0x9c9d },
	'xpcomment' => { 117 => 0x9c9c },
	'xpkeywords' => { 117 => 0x9c9e },
	'xposition' => { 117 => 0x11e },
	'xpsubject' => { 117 => 0x9c9f },
	'xptitle' => { 117 => 0x9c9b },
	'xresolution' => { 117 => 0x11a, 132 => 0x3, 361 => 0x0, 490 => 'XResolution' },
	'xyresolution' => { 121 => 0x3 },
	'yaw' => { 113 => 0x7, 371 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 240 => 0x3513, 241 => 0x2c2c, 245 => 0xc222, 250 => 0x36fc, 251 => 0x2f03, 253 => 0xce3a, 383 => 0x0 },
	'ycbcrcoefficients' => { 117 => 0x211, 490 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 117 => 0x213, 490 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 117 => 0x212, 490 => 'YCbCrSubSampling' },
	'year' => { 363 => 'yrrc', 365 => 'year', 371 => 'yrrc' },
	'yearcreated' => { 137 => 0x10, 146 => 0xc },
	'yellowhsl' => { 101 => 0x20912 },
	'yield' => { 486 => 'yield' },
	'yposition' => { 117 => 0x11f },
	'yresolution' => { 117 => 0x11b, 132 => 0x5, 361 => 0x4, 490 => 'YResolution' },
	'zonematching' => { 183 => 0x10a, 186 => [0x3a,0x4a], 411 => 0xb024 },
	'zonematchingmode' => { 181 => 0x14 },
	'zonematchingon' => { 180 => 0x75 },
	'zonematchingvalue' => { 398 => 0x1f },
	'zoomedpreviewlength' => { 293 => 0xf05 },
	'zoomedpreviewsize' => { 293 => 0xf06 },
	'zoomedpreviewstart' => { 293 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 291 => 0x300, 293 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometertime' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'af-assistilluminator' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsel' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airspeed' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autofocusmoderestrictions' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketincrement' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketprogram' => 1,
	'bracketset' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotation' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'continuousmodedisplay' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicareaafassist' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedshutterspeeds' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashburstpriority' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flickadvancedirection' => 1,
	'flickerreductionshooting' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspeakinghighlightcolor' => 1,
	'focuspeakinglevel' => 1,
	'focuspointbrightness' => 1,
	'focuspointpersistence' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupareac1' => 1,
	'groupareac2' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indications' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautoflashlimit' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscontrolring' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensfunc1button' => 1,
	'lensfunc2button' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselpinpoint' => 1,
	'limitaf-areamodeselwideaf_l' => 1,
	'limitaf-areamodeselwideaf_s' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeselauto' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselch' => 1,
	'limitreleasemodeselcl' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea16to9' => 1,
	'limitselectableimagearea1to1' => 1,
	'limitselectableimagearea5to4' => 1,
	'limitselectableimageareadx' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manualfocuspointillumination' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'mastergainadjustment' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieaf-onbutton' => 1,
	'movieafspeed' => 1,
	'movieafspeedapply' => 1,
	'movieaftrackingsensitivity' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'moviefunc2button' => 1,
	'moviefunc3button' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'moviehighlightdisplaythreshold' => 1,
	'movieinfo' => 1,
	'movieisoautocontrolmanualmode' => 1,
	'movieisoautohilimit' => 1,
	'moviemultiselector' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdown' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickup' => 1,
	'playbackflickuprating' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversefocusring' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7_2' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silentphotography' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usbpowerdelivery' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalmovieafonbutton' => 1,
	'verticalmoviefuncbutton' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2021, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
