include(CMakeFindDependencyMacro)

find_dependency(ZLIB)
find_dependency(Threads)

# OSG

set(SIMGEAR_HEADLESS OFF)
set(SIMGEAR_SOUND ON)
set(USE_AEONWAVE FALSE)

# OpenAL isn't a public dependency, so maybe not needed
#if (SIMGEAR_SOUND)
#  find_dependency(OpenAL)
#endif()

# SSE/SSE2 support

set(ENABLE_SIMD ON)

# OpenRTI support
set(ENABLE_RTI OFF)
if(ENABLE_RTI)
  set(RTI_FOUND )
  if(RTI_FOUND)
    set(RTI_INCLUDE_DIRS )
    set(RTI_LDFLAGS )
  endif(RTI_FOUND)
endif(ENABLE_RTI)

# Alternative terrain engine based on pagedLOD

set(ENABLE_GDAL OFF)
set(ENABLE_OPENMP OFF)

include("${CMAKE_CURRENT_LIST_DIR}/SimGearTargets.cmake")
