/* spice-client-glib-2.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Spice", gir_namespace = "SpiceClientGLib", gir_version = "2.0", lower_case_cprefix = "spice_")]
namespace Spice {
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_audio_get_type ()")]
	public abstract class Audio : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "0.8")]
		public Audio (Spice.Session session, GLib.MainContext? context, string? name);
		[NoWrapper]
		public virtual bool connect_channel (Spice.Channel channel);
		public static unowned Spice.Audio @get (Spice.Session session, GLib.MainContext? context);
		[NoWrapper]
		public virtual async bool get_playback_volume_info_async (GLib.Cancellable? cancellable, Spice.MainChannel main_channel) throws GLib.Error;
		[NoWrapper]
		public virtual async bool get_record_volume_info_async (GLib.Cancellable? cancellable, Spice.MainChannel main_channel) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.MainContext main_context { owned get; construct; }
		[NoAccessorMethod]
		public Spice.Session session { owned get; construct; }
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_channel_get_type ()")]
	public class Channel : GLib.Object {
		[CCode (has_construct_function = false)]
		public Channel (Spice.Session s, int type, int id);
		[NoWrapper]
		public virtual void channel_reset (bool migrating);
		[NoWrapper]
		public virtual void channel_send_migration_handshake ();
		[NoWrapper]
		public virtual void channel_up ();
		public bool connect ();
		[Version (deprecated = true, deprecated_since = "0.27")]
		public void destroy ();
		public void disconnect (Spice.ChannelEvent reason);
		[Version (since = "0.15")]
		public async bool flush_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.24")]
		public unowned GLib.Error get_error ();
		[NoWrapper]
		public virtual void handle_msg (Spice.MsgIn msg);
		[NoWrapper]
		public virtual void iterate_read ();
		[NoWrapper]
		public virtual void iterate_write ();
		[Version (deprecated = true, deprecated_since = "0.13")]
		public void set_capability (uint32 cap);
		[Version (since = "0.21")]
		public static int string_to_type (string str);
		public bool test_capability (uint32 cap);
		public bool test_common_capability (uint32 cap);
		[Version (since = "0.20")]
		public static unowned string type_to_string (int type);
		[NoAccessorMethod]
		public int channel_id { get; construct; }
		[NoAccessorMethod]
		public int channel_type { get; construct; }
		[NoAccessorMethod]
		[Version (since = "0.33")]
		public GLib.Socket socket { owned get; }
		[NoAccessorMethod]
		public Spice.Session spice_session { owned get; construct; }
		[NoAccessorMethod]
		public ulong total_read_bytes { get; }
		public virtual signal void channel_event (Spice.ChannelEvent event);
		[HasEmitter]
		public virtual signal void open_fd (int with_tls);
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_cursor_channel_get_type ()")]
	public class CursorChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected CursorChannel ();
		[NoAccessorMethod]
		[Version (since = "0.34")]
		public Spice.CursorShape cursor { owned get; }
		public virtual signal void cursor_hide ();
		public virtual signal void cursor_move (int x, int y);
		public virtual signal void cursor_reset ();
		[Version (deprecated = true, deprecated_since = "0.34")]
		public virtual signal void cursor_set (int width, int height, int hot_x, int hot_y, void* rgba);
	}
	[CCode (cheader_filename = "spice-client.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "spice_cursor_shape_get_type ()")]
	[Compact]
	public class CursorShape {
		public void* data;
		public uint16 height;
		public uint16 hot_spot_x;
		public uint16 hot_spot_y;
		public uint16 width;
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_display_channel_get_type ()")]
	public class DisplayChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected DisplayChannel ();
		[Version (since = "0.35")]
		public static void change_preferred_compression (Spice.Channel channel, int compression);
		[Version (deprecated = true, deprecated_since = "0.38", since = "0.35")]
		public static void change_preferred_video_codec_type (Spice.Channel channel, int codec_type);
		public static bool change_preferred_video_codec_types (Spice.Channel channel, int codecs, size_t ncodecs) throws GLib.Error;
		[Version (since = "0.35")]
		public unowned Spice.GlScanout get_gl_scanout ();
		[Version (since = "0.35")]
		public static bool get_primary (Spice.Channel channel, uint32 surface_id, Spice.DisplayPrimary primary);
		[Version (since = "0.35")]
		public void gl_draw_done ();
		[Version (since = "0.31")]
		public Spice.GlScanout gl_scanout { get; }
		[NoAccessorMethod]
		public uint height { get; }
		[NoAccessorMethod]
		[Version (since = "0.13")]
		public GLib.Array<void*> monitors { owned get; }
		[NoAccessorMethod]
		[Version (since = "0.13")]
		public uint monitors_max { get; }
		[NoAccessorMethod]
		public uint width { get; }
		public virtual signal void display_invalidate (int x, int y, int w, int h);
		public virtual signal void display_mark (int mark);
		public virtual signal void display_primary_create (int format, int width, int height, int stride, int shmid, void* data);
		public virtual signal void display_primary_destroy ();
		[Version (since = "0.31")]
		public signal void gl_draw (uint x, uint y, uint width, uint height);
		[Version (since = "0.36")]
		public signal bool gst_video_overlay (Gst.Pipeline pipeline);
		[Version (deprecated = true, deprecated_since = "0.36", since = "0.35")]
		public signal void* streaming_mode (bool streaming_mode);
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_file_transfer_task_get_type ()")]
	public class FileTransferTask : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FileTransferTask ();
		public void cancel ();
		public string get_filename ();
		public double get_progress ();
		public uint64 get_total_bytes ();
		public uint64 get_transferred_bytes ();
		[NoAccessorMethod]
		public GLib.Cancellable cancellable { owned get; construct; }
		[NoAccessorMethod]
		public Spice.MainChannel channel { owned get; construct; }
		[NoAccessorMethod]
		public GLib.File file { owned get; construct; }
		[NoAccessorMethod]
		public uint id { get; construct; }
		public double progress { get; }
		public uint64 total_bytes { get; }
		public uint64 transferred_bytes { get; }
		public signal void finished (GLib.Error object);
	}
	[CCode (cheader_filename = "spice-client.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "spice_gl_scanout_get_type ()")]
	[Compact]
	public class GlScanout {
		public int fd;
		public uint32 format;
		public uint32 height;
		public uint32 stride;
		public uint32 width;
		public bool y0top;
		[Version (since = "0.31")]
		public void free ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_inputs_channel_get_type ()")]
	public class InputsChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected InputsChannel ();
		[Version (since = "0.35")]
		public void button_press (int button, int button_state);
		[Version (since = "0.35")]
		public void button_release (int button, int button_state);
		[Version (since = "0.35")]
		public void key_press (uint scancode);
		[Version (since = "0.35")]
		public void key_press_and_release (uint scancode);
		[Version (since = "0.35")]
		public void key_release (uint scancode);
		[Version (since = "0.35")]
		public void motion (int dx, int dy, int button_state);
		[Version (since = "0.35")]
		public void position (int x, int y, int display, int button_state);
		[Version (since = "0.35")]
		public void set_key_locks (uint locks);
		[NoAccessorMethod]
		public int key_modifiers { get; }
		public virtual signal void inputs_modifiers ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_main_channel_get_type ()")]
	public class MainChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected MainChannel ();
		[Version (since = "0.35")]
		public bool agent_test_capability (uint32 cap);
		[Version (since = "0.35")]
		public void clipboard_selection_grab (uint selection, uint32 types, int ntypes);
		[Version (since = "0.35")]
		public void clipboard_selection_notify (uint selection, uint32 type, uint8 data, size_t size);
		[Version (since = "0.35")]
		public void clipboard_selection_release (uint selection);
		[Version (since = "0.35")]
		public void clipboard_selection_request (uint selection, uint32 type);
		[Version (since = "0.35")]
		public async bool file_copy_async ([CCode (array_length = false, array_null_terminated = true)] GLib.File[] sources, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable, GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		[Version (since = "0.35")]
		public void request_mouse_mode (int mode);
		[Version (since = "0.35")]
		public bool send_monitor_config ();
		[Version (since = "0.35")]
		public void update_display (int id, int x, int y, int width, int height, bool update);
		[Version (since = "0.35")]
		public void update_display_enabled (int id, bool enabled, bool update);
		[Version (since = "0.39")]
		public void update_display_mm (int id, int width_mm, int height_mm, bool update);
		[NoAccessorMethod]
		public int agent_caps_0 { get; }
		[NoAccessorMethod]
		public bool agent_connected { get; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "0.37")]
		public uint color_depth { get; set construct; }
		[NoAccessorMethod]
		public bool disable_animation { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.13")]
		public bool disable_display_align { get; set construct; }
		[NoAccessorMethod]
		public bool disable_display_position { get; set construct; }
		[NoAccessorMethod]
		public bool disable_font_smooth { get; set construct; }
		[NoAccessorMethod]
		public bool disable_wallpaper { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.22")]
		public int max_clipboard { get; set construct; }
		[NoAccessorMethod]
		public int mouse_mode { get; }
		public signal void main_agent_update ();
		[Version (deprecated = true, deprecated_since = "0.6")]
		public signal void main_clipboard (uint type, void* data, uint size);
		[Version (deprecated = true, deprecated_since = "0.6")]
		public signal bool main_clipboard_grab (void* types, uint ntypes);
		[Version (deprecated = true, deprecated_since = "0.6")]
		public signal void main_clipboard_release ();
		[Version (deprecated = true, deprecated_since = "0.6")]
		public signal bool main_clipboard_request (uint types);
		[Version (since = "0.6")]
		public signal void main_clipboard_selection (uint selection, uint type, void* data, uint size);
		[Version (since = "0.6")]
		public signal bool main_clipboard_selection_grab (uint selection, void* types, uint ntypes);
		[Version (since = "0.6")]
		public signal void main_clipboard_selection_release (uint selection);
		[Version (since = "0.6")]
		public signal bool main_clipboard_selection_request (uint selection, uint types);
		public signal void main_mouse_update ();
		public signal void migration_started (GLib.Object session);
		[Version (since = "0.31")]
		public signal void new_file_transfer (GLib.Object task);
	}
	[CCode (cheader_filename = "spice-client.h", has_type_id = false)]
	[Compact]
	public class MsgIn {
	}
	[CCode (cheader_filename = "spice-client.h", has_type_id = false)]
	[Compact]
	public class MsgOut {
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_playback_channel_get_type ()")]
	public class PlaybackChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected PlaybackChannel ();
		public void set_delay (uint32 delay_ms);
		[NoAccessorMethod]
		public uint min_latency { get; set; }
		[NoAccessorMethod]
		public bool mute { get; set; }
		[NoAccessorMethod]
		public uint nchannels { get; set; }
		[NoAccessorMethod]
		public void* volume { get; set; }
		public virtual signal void playback_data (void* data, int size);
		public signal void playback_get_delay ();
		public virtual signal void playback_start (int format, int channels, int freq);
		public virtual signal void playback_stop ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_port_channel_get_type ()")]
	public class PortChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected PortChannel ();
		[Version (since = "0.35")]
		public void event (uint8 event);
		[Version (since = "0.35")]
		public async ssize_t write_async ([CCode (array_length_cname = "count", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] buffer, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public string port_name { owned get; }
		[NoAccessorMethod]
		public bool port_opened { get; }
		[Version (since = "0.15")]
		public signal void port_data (void* data, int size);
		[Version (since = "0.15")]
		public signal void port_event (int event);
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_qmp_port_get_type ()")]
	[Version (since = "0.36")]
	public class QmpPort : GLib.Object {
		[CCode (has_construct_function = false)]
		protected QmpPort ();
		public static unowned Spice.QmpPort @get (Spice.PortChannel channel);
		public async Spice.QmpStatus query_status_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool vm_action_async (Spice.QmpPortVmAction action, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public Spice.PortChannel channel { owned get; construct; }
		[NoAccessorMethod]
		public bool ready { get; }
		public signal void event (string name, void* node);
	}
	[CCode (cheader_filename = "spice-client.h", ref_function = "spice_qmp_status_ref", type_id = "spice_qmp_status_get_type ()", unref_function = "spice_qmp_status_unref")]
	[Compact]
	[Version (since = "0.36")]
	public class QmpStatus {
		public bool running;
		public bool singlestep;
		public weak string status;
		public int version;
		public Spice.QmpStatus @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_record_channel_get_type ()")]
	public class RecordChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected RecordChannel ();
		[NoWrapper]
		public virtual void record_data (void* data, int size);
		[Version (since = "0.35")]
		public void send_data (void* data, size_t bytes, uint32 time);
		[NoAccessorMethod]
		public bool mute { get; set; }
		[NoAccessorMethod]
		public uint nchannels { get; set; }
		[NoAccessorMethod]
		public void* volume { get; set; }
		public virtual signal void record_start (int format, int channels, int freq);
		public virtual signal void record_stop ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_session_get_type ()")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		public Session ();
		public bool connect ();
		public void disconnect ();
		public GLib.List<weak Spice.Channel> get_channels ();
		[Version (since = "0.24")]
		public unowned Spice.URI get_proxy_uri ();
		public bool get_read_only ();
		public bool has_channel_type (int type);
		[Version (since = "0.27")]
		public bool is_for_migration ();
		public bool open_fd (int fd);
		[NoAccessorMethod]
		[Version (since = "0.15")]
		public GLib.ByteArray ca { owned get; set; }
		[NoAccessorMethod]
		public string ca_file { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9")]
		public int cache_size { get; set; }
		[NoAccessorMethod]
		public string cert_subject { owned get; set; }
		[NoAccessorMethod]
		public string ciphers { owned get; set; }
		[NoAccessorMethod]
		public bool client_sockets { get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "0.37", since = "0.7")]
		public int color_depth { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		[Version (since = "0.7")]
		public string[] disable_effects { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.8")]
		public bool enable_audio { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.7")]
		public bool enable_smartcard { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.8")]
		public bool enable_usbredir { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.36")]
		public bool gl_scanout { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.9")]
		public int glz_window_size { get; set; }
		[NoAccessorMethod]
		public string host { owned get; set construct; }
		[NoAccessorMethod]
		public bool inhibit_keyboard_grab { get; set; }
		[NoAccessorMethod]
		public Spice.SessionMigration migration_state { get; }
		[NoAccessorMethod]
		[Version (since = "0.11")]
		public string name { owned get; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public string port { owned get; set; }
		[NoAccessorMethod]
		public int protocol { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.17")]
		public string proxy { owned get; set; }
		[NoAccessorMethod]
		public GLib.ByteArray pubkey { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.8")]
		public bool read_only { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		[Version (since = "0.20")]
		public string[] secure_channels { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.28")]
		public bool share_dir_ro { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.24")]
		public string shared_dir { owned get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		[Version (since = "0.7")]
		public string[] smartcard_certificates { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.7")]
		public string smartcard_db { owned get; set; }
		[NoAccessorMethod]
		public string tls_port { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.28")]
		public string unix_path { owned get; set construct; }
		[NoAccessorMethod]
		public string uri { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.11")]
		public void* uuid { get; }
		[NoAccessorMethod]
		public Spice.SessionVerify verify { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.39")]
		public GLib.Object webdav_server { owned get; }
		public virtual signal void channel_destroy (Spice.Channel channel);
		public virtual signal void channel_new (Spice.Channel channel);
		[Version (since = "0.35")]
		public signal void disconnected ();
		public signal void mm_time_reset ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_smartcard_channel_get_type ()")]
	public class SmartcardChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected SmartcardChannel ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_smartcard_manager_get_type ()")]
	public class SmartcardManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SmartcardManager ();
		public static unowned Spice.SmartcardManager @get ();
		[Version (since = "0.20")]
		public GLib.List<Spice.SmartcardReader> get_readers ();
		[Version (since = "0.20")]
		public bool insert_card ();
		[Version (since = "0.20")]
		public bool remove_card ();
		public virtual signal void card_inserted (Spice.VReader reader);
		public virtual signal void card_removed (Spice.VReader reader);
		public virtual signal void reader_added (Spice.VReader reader);
		public virtual signal void reader_removed (Spice.VReader reader);
	}
	[CCode (cheader_filename = "spice-client.h", has_type_id = false)]
	[Compact]
	public class SmartcardReader {
		public bool insert_card ();
		public bool is_software ();
		public bool remove_card ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_uri_get_type ()")]
	public class URI : GLib.Object {
		[CCode (has_construct_function = false)]
		protected URI ();
		public unowned string get_hostname ();
		public unowned string get_password ();
		public uint get_port ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public void set_hostname (string hostname);
		public void set_password (string password);
		public void set_port (uint port);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public string to_string ();
		public string hostname { get; set; }
		public string password { get; set; }
		public uint port { get; set; }
		public string scheme { get; set; }
		public string user { get; set; }
	}
	[CCode (cheader_filename = "spice-client.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "spice_usb_device_get_type ()")]
	[Compact]
	public class UsbDevice {
		public string get_description (string? format);
		[Version (since = "0.27")]
		public void* get_libusb_device ();
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_usb_device_manager_get_type ()")]
	public class UsbDeviceManager : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected UsbDeviceManager ();
		public bool can_redirect_device (Spice.UsbDevice device) throws GLib.Error;
		public async bool connect_device_async (Spice.UsbDevice device, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool create_shared_cd_device (string filename) throws GLib.Error;
		public void disconnect_device (Spice.UsbDevice device);
		[Version (since = "0.32")]
		public async bool disconnect_device_async (Spice.UsbDevice device, GLib.Cancellable? cancellable) throws GLib.Error;
		public static unowned Spice.UsbDeviceManager @get (Spice.Session session) throws GLib.Error;
		public GLib.GenericArray<Spice.UsbDevice> get_devices ();
		[Version (since = "0.20")]
		public GLib.GenericArray<Spice.UsbDevice> get_devices_with_filter (string? filter);
		public bool is_device_connected (Spice.UsbDevice device);
		public bool is_device_shared_cd (Spice.UsbDevice device);
		[Version (since = "0.32")]
		public bool is_redirecting ();
		[NoAccessorMethod]
		public bool auto_connect { get; set; }
		[NoAccessorMethod]
		public string auto_connect_filter { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.31")]
		public int free_channels { get; }
		[NoAccessorMethod]
		public string redirect_on_connect { owned get; set; }
		[NoAccessorMethod]
		public Spice.Session session { owned get; construct; }
		public virtual signal void auto_connect_failed (Spice.UsbDevice device, GLib.Error error);
		public virtual signal void device_added (Spice.UsbDevice device);
		public virtual signal void device_error (Spice.UsbDevice device, GLib.Error error);
		public virtual signal void device_removed (Spice.UsbDevice device);
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_usbredir_channel_get_type ()")]
	public class UsbredirChannel : Spice.Channel {
		[CCode (has_construct_function = false)]
		protected UsbredirChannel ();
	}
	[CCode (cheader_filename = "spice-client.h", cname = "VReader", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "smartcard_reader", type_id = "spice_smartcard_reader_get_type ()")]
	[Compact]
	public class VReader {
	}
	[CCode (cheader_filename = "spice-client.h", type_id = "spice_webdav_channel_get_type ()")]
	public class WebdavChannel : Spice.PortChannel {
		[CCode (has_construct_function = false)]
		protected WebdavChannel ();
	}
	[CCode (cheader_filename = "spice-client.h", has_type_id = false)]
	public struct DisplayMonitorConfig {
		public uint id;
		public uint surface_id;
		public uint x;
		public uint y;
		public uint width;
		public uint height;
	}
	[CCode (cheader_filename = "spice-client.h", has_type_id = false)]
	public struct DisplayPrimary {
		public void* format;
		public int width;
		public int height;
		public int stride;
		public int shmid;
		public uint8 data;
		public bool marked;
	}
	[CCode (cheader_filename = "spice-client.h", cprefix = "SPICE_CHANNEL_", type_id = "spice_channel_event_get_type ()")]
	public enum ChannelEvent {
		NONE,
		OPENED,
		SWITCHING,
		CLOSED,
		ERROR_CONNECT,
		ERROR_TLS,
		ERROR_LINK,
		ERROR_AUTH,
		ERROR_IO
	}
	[CCode (cheader_filename = "spice-client.h", cprefix = "SPICE_INPUTS_", type_id = "spice_inputs_lock_get_type ()")]
	[Flags]
	public enum InputsLock {
		SCROLL_LOCK,
		NUM_LOCK,
		CAPS_LOCK
	}
	[CCode (cheader_filename = "spice-client.h", cprefix = "SPICE_QMP_PORT_VM_ACTION_", has_type_id = false)]
	[Version (since = "0.36")]
	public enum QmpPortVmAction {
		QUIT,
		RESET,
		POWER_DOWN,
		PAUSE,
		CONTINUE,
		LAST
	}
	[CCode (cheader_filename = "spice-client.h", cprefix = "SPICE_SESSION_MIGRATION_", type_id = "spice_session_migration_get_type ()")]
	public enum SessionMigration {
		NONE,
		SWITCHING,
		MIGRATING,
		CONNECTING
	}
	[CCode (cheader_filename = "spice-client.h", cprefix = "SPICE_SESSION_VERIFY_", type_id = "spice_session_verify_get_type ()")]
	[Flags]
	public enum SessionVerify {
		PUBKEY,
		HOSTNAME,
		SUBJECT
	}
	[CCode (cheader_filename = "spice-client.h", cprefix = "SPICE_CLIENT_ERROR_")]
	public errordomain ClientError {
		FAILED,
		USB_DEVICE_REJECTED,
		USB_DEVICE_LOST,
		AUTH_NEEDS_PASSWORD,
		AUTH_NEEDS_USERNAME,
		AUTH_NEEDS_PASSWORD_AND_USERNAME,
		USB_SERVICE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "spice-client.h", cname = "spice_msg_handler", has_target = false)]
	public delegate void msg_handler (Spice.Channel channel, Spice.MsgIn @in);
	[CCode (cheader_filename = "spice-client.h", cname = "SPICE_GTK_MAJOR_VERSION")]
	[Version (since = "0.24")]
	public const int GTK_MAJOR_VERSION;
	[CCode (cheader_filename = "spice-client.h", cname = "SPICE_GTK_MICRO_VERSION")]
	[Version (since = "0.24")]
	public const int GTK_MICRO_VERSION;
	[CCode (cheader_filename = "spice-client.h", cname = "SPICE_GTK_MINOR_VERSION")]
	[Version (since = "0.24")]
	public const int GTK_MINOR_VERSION;
	[CCode (cheader_filename = "spice-client.h", cname = "SPICE_WEBDAV_CLIPBOARD_FOLDER_PATH")]
	public const string WEBDAV_CLIPBOARD_FOLDER_PATH;
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.31")]
	public static void display_change_preferred_compression (Spice.Channel channel, int compression);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.34")]
	public static void display_change_preferred_video_codec_type (Spice.Channel channel, int codec_type);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.31")]
	public static unowned Spice.GlScanout display_get_gl_scanout (Spice.DisplayChannel channel);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static bool display_get_primary (Spice.Channel channel, uint32 surface_id, Spice.DisplayPrimary primary);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.31")]
	public static void display_gl_draw_done (Spice.DisplayChannel channel);
	[CCode (cheader_filename = "spice-client.h")]
	public static GLib.OptionGroup get_option_group ();
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_button_press (Spice.InputsChannel channel, int button, int button_state);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_button_release (Spice.InputsChannel channel, int button, int button_state);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_key_press (Spice.InputsChannel channel, uint scancode);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.13")]
	public static void inputs_key_press_and_release (Spice.InputsChannel channel, uint scancode);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_key_release (Spice.InputsChannel channel, uint scancode);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_motion (Spice.InputsChannel channel, int dx, int dy, int button_state);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_position (Spice.InputsChannel channel, int x, int y, int display, int button_state);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void inputs_set_key_locks (Spice.InputsChannel channel, uint locks);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static bool main_agent_test_capability (Spice.MainChannel channel, uint32 cap);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.6")]
	public static void main_clipboard_grab (Spice.MainChannel channel, uint32 types, int ntypes);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.6")]
	public static void main_clipboard_notify (Spice.MainChannel channel, uint32 type, uint8 data, size_t size);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.6")]
	public static void main_clipboard_release (Spice.MainChannel channel);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.6")]
	public static void main_clipboard_request (Spice.MainChannel channel, uint32 type);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.6")]
	public static void main_clipboard_selection_grab (Spice.MainChannel channel, uint selection, uint32 types, int ntypes);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.6")]
	public static void main_clipboard_selection_notify (Spice.MainChannel channel, uint selection, uint32 type, uint8 data, size_t size);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.6")]
	public static void main_clipboard_selection_release (Spice.MainChannel channel, uint selection);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.6")]
	public static void main_clipboard_selection_request (Spice.MainChannel channel, uint selection, uint32 type);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static async bool main_file_copy_async (Spice.MainChannel channel, [CCode (array_length = false, array_null_terminated = true)] GLib.File[] sources, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable, GLib.FileProgressCallback? progress_callback) throws GLib.Error;
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.32")]
	public static void main_request_mouse_mode (Spice.MainChannel channel, int mode);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static bool main_send_monitor_config (Spice.MainChannel channel);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void main_set_display (Spice.MainChannel channel, int id, int x, int y, int width, int height);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.6")]
	public static void main_set_display_enabled (Spice.MainChannel channel, int id, bool enabled);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void main_update_display (Spice.MainChannel channel, int id, int x, int y, int width, int height, bool update);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.30")]
	public static void main_update_display_enabled (Spice.MainChannel channel, int id, bool enabled, bool update);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.15")]
	public static void port_event (Spice.PortChannel port, uint8 event);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35", since = "0.15")]
	public static async ssize_t port_write_async (Spice.PortChannel port, [CCode (array_length_cname = "count", array_length_pos = 2.5, array_length_type = "gsize")] uint8[] buffer, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "spice-client.h")]
	[Version (deprecated = true, deprecated_since = "0.35")]
	public static void record_send_data (Spice.RecordChannel channel, void* data, size_t bytes, uint32 time);
	[CCode (cheader_filename = "spice-client.h")]
	public static void set_session_option (Spice.Session session);
	[CCode (cheader_filename = "spice-client.h")]
	public static bool util_get_debug ();
	[CCode (cheader_filename = "spice-client.h")]
	public static unowned string util_get_version_string ();
	[CCode (cheader_filename = "spice-client.h")]
	public static void util_set_debug (bool enabled);
	[CCode (cheader_filename = "spice-client.h")]
	[Version (since = "0.22")]
	public static string uuid_to_string (uint8 uuid);
}
