#  SHIBOKEN_INCLUDE_DIR        - Directories to include to use SHIBOKEN
#  SHIBOKEN_LIBRARY            - Files to link against to use SHIBOKEN
#  SHIBOKEN_BINARY             - Executable name
#  SHIBOKEN_BUILD_TYPE         - Tells if Shiboken was compiled in Release or Debug mode.
#  SHIBOKEN_PYTHON_INTERPRETER - Python interpreter (regular or debug) to be used with the bindings.
#  SHIBOKEN_PYTHON_LIBRARIES   - Python libraries (regular or debug) Shiboken is linked against.

SET(SHIBOKEN_INCLUDE_DIR "/usr/include/shiboken")
if(MSVC)
    SET(SHIBOKEN_LIBRARY "/usr/lib/libshiboken-python2.8.lib")
elseif(CYGWIN)
    SET(SHIBOKEN_LIBRARY "/usr/lib/shiboken-python2.8")
elseif(WIN32)
    SET(SHIBOKEN_LIBRARY "/usr/bin/libshiboken-python2.8.so")
else()
    SET(SHIBOKEN_LIBRARY "/usr/lib/libshiboken-python2.8.so")
endif()
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/usr/include/tauthon2.8")
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/usr/include/tauthon2.8")
SET(SHIBOKEN_PYTHON_INTERPRETER "/usr/bin/tauthon")
SET(SHIBOKEN_PYTHON_LIBRARIES "/usr/lib")
SET(SHIBOKEN_PYTHON_SUFFIX "-python2.8")
message(STATUS "libshiboken built for Release")


set(SHIBOKEN_BINARY "/usr/bin/shiboken")
