 #    Copyright 2003,2008 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

proc file_list_w_modif_dir { file_list_to_modif } {
	#puts "$file_list_to_modif"
	set file_list_to_modif_f ""
	#set modified false
	for { set i 0 } { $i < [llength $file_list_to_modif]} { incr i } {
		if { [file isdirectory [lindex $file_list_to_modif $i]] } {
			set file_list_to_modif [lreplace $file_list_to_modif $i $i "[lindex [split [lindex $file_list_to_modif $i] /] end]/=[lindex $file_list_to_modif $i]"]
		} else {
		}
	}
	#if { $modified == true } { return [eval concat $file_list_to_modif] } else { return $file_list_to_modif }
	return $file_list_to_modif
}



proc choose_iso_file {} {
	global iso_file burn_type burning_device i18n_select_iso_image
	set iso_file_o ""
	if { $burn_type == "burn_iso" } {
		set iso_file_o [tk_getOpenFile -filetypes {{{Iso image} {.iso .ISO}} {{All Files} * }} -title "$i18n_select_iso_image"]
		if { $iso_file_o != "" } {
			set iso_file $iso_file_o
		}
	} else {
		set burning_device ""
		set iso_file_o [tk_getSaveFile -filetypes {{{Iso image} {.iso}} {{All Files} * }}]
		if { $iso_file_o != "" } {
			set iso_file $iso_file_o
		}
		set burning_device "-o"
		lappend burning_device $iso_file
	}
	refresh_cmd_line
}

proc check_volume_id {} {
	global volume_id volume_id_o
	set volume_id ""
	if { $volume_id_o == "" } {
		set volume_id ""
	} elseif { [llength $volume_id_o] > 1} {
			set volume_id [lindex $volume_id_o 0]
			for { set i 1} {$i < [llength $volume_id_o]} {incr i} {
				set volume_id "$volume_id\\ [lindex $volume_id_o $i]"
			}
			set volume_id "-V $volume_id"
		} else { set volume_id "-V $volume_id_o" }
}

proc add_file {files} {
	global file_list option_auto_refresh_space i18n_error i18n_error_file_already_present i18n_quest_file_contained
	if { $files != "" } {
		#foreach needed for multiple files selection
		foreach i $files {
			set answer "yes"
			set file_present [file_is_present_or_conatained "$i"]
			if { "$file_present" == "yes" } {
				set answer "no"
				tk_messageBox -icon error -message "$i18n_error_file_already_present: $i" -type ok -title $i18n_error
			} elseif { "$file_present" == "yes_c" } {
				set answer [tk_messageBox -icon error -message "$i18n_quest_file_contained $i" -type yesno -default no -title $i18n_error]
			}
		
			if { $answer == "yes" } {
				lappend file_list $i
			}
		}
		if { $option_auto_refresh_space == "1" } {
			refresh_total_file_size
		}
		refresh_cmd_line
	}
}

proc add_d {} {
	global file_list option_auto_refresh_space i18n_error i18n_error_directory_already_present i18n_quest_directory_contained i18n_quest_directory_contains
	set temp [tk_chooseDirectory]
	set answer "yes"
	if { $temp != "" } {
		set file_present [file_is_present_or_conatained "$temp"]
		if { "$file_present" == "yes" } {
			set answer "no"
			tk_messageBox -icon error -message "$i18n_error_directory_already_present" -type ok -title $i18n_error
		} elseif { "$file_present" == "yes_c" } {
			set answer [tk_messageBox -icon error -message "$i18n_quest_directory_contained" -type yesno -default no -title $i18n_error]
		} elseif { "$file_present" == "will_contains" } {
			set answer [tk_messageBox -icon error -message "$i18n_quest_directory_contains" -type yesno -default no -title $i18n_error]
		}
		
		if { $answer == "yes" } {
			lappend file_list $temp
			#refresh command line entry after checking space used to check overburn condition
			if { $option_auto_refresh_space == "1" } {
				refresh_total_file_size
			}
			refresh_cmd_line
		}
	}
}

proc delete_files {} {
	global file_list option_auto_refresh_space
	if { "[.file_list.file_list curselection]" == "" } {
	} else {
		set file_list [lreplace $file_list [.file_list.file_list curselection] [.file_list.file_list curselection]]
		#refresh command line entry after checking space used to check overburn condition
		if { $option_auto_refresh_space == "1" } {
			refresh_total_file_size
		}
		refresh_cmd_line
	}
}

proc launch {burn_type burn_opt} {
	global input command_line burning_device i18n_growisofs_mkisofs_output i18n_close burn_speed option_overburn cd_burning_command
	#if output window not already created, we create it
	if { ! [winfo exists .output_window] } {
		toplevel .output_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
		wm title .output_window "$i18n_growisofs_mkisofs_output"
		frame .output_window.f_main
		text .output_window.f_main.log -heigh 10 -bg #f5f5f5 -relief ridge -setgrid true -yscrollcommand { .output_window.f_main.scroll_bar set }
		scrollbar .output_window.f_main.scroll_bar -command { .output_window.f_main.log yview }
		button .output_window.b_close -highlightbackground blue -width 7 -text "$i18n_close" -command { destroy .output_window; refresh_cmd_line }
		
		pack .output_window.f_main.log -fill both -side left -expand 1
		pack .output_window.f_main.scroll_bar -fill y -side right
		pack .output_window.f_main -fill both -expand 1
		pack .output_window.b_close
	}
	.f_burn.go_button configure -state disabled
	if { $burn_type == "burn" } {
		if {[catch {open "|$command_line |& cat"} input]} {
			#one blank line to increase readability
			.output_window.f_main.log insert end "$command_line\n\n"
		} else {
			fileevent $input readable log_proc
			#one blank line to increase readability
			.output_window.f_main.log insert end "$command_line\n\n"
		}
	} elseif { $burn_type == "dvd_copy" } {
		#burn_opt contains source device from which we copy
		if {[catch {open "|growisofs -Z $burning_device=$burn_opt |& cat"} input]} {
			#one blank line to increase readability
			.output_window.f_main.log insert end "growisofs -Z $burning_device=$burn_opt\n\n"
		} else {
			fileevent $input readable log_proc
			#one blank line to increase readability
			.output_window.f_main.log insert end "growisofs -Z $burning_device=$burn_opt\n\n"
		}
	} elseif { $burn_type == "cd_copy" } {
		#burn_opt contains source device from which we copy
		if {[catch {open "|cdrecord dev=$burning_device $burn_speed $option_overburn -isosize $burn_opt |& cat"} input]} {
			#one blank line to increase readability
			.output_window.f_main.log insert end "cdrecord dev=$burning_device $burn_speed $option_overburn -isosize $burn_opt\n\n"
		} else {
			fileevent $input readable log_proc
			#one blank line to increase readability
			.output_window.f_main.log insert end "cdrecord dev=$burning_device $burn_speed $option_overburn -isosize $burn_opt\n\n"
		}
	} elseif { $burn_type == "create_iso" } {
		# burn_opt contains destination file for ISO image
		if {[catch {open "|dd if=$burning_device of=$burn_opt |& cat"} input]} {
			#one blank line to increase readability
			.output_window.f_main.log insert end "dd if=$burning_device of=$burn_opt\n\n"
		} else {
			fileevent $input readable log_proc
			#one blank line to increase readability
			.output_window.f_main.log insert end "dd if=$burning_device of=$burn_opt\n\n"
		}
	} elseif { $burn_type == "erase_dvd" } {
		# $burn_opt= "" or "force" or "blank"
		if {[catch {open "|dvd+rw-format $burn_opt $burning_device |& cat"} input]} {
			#one blank line to increase readability
			.output_window.f_main.log insert end "dvd+rw-format $burn_type $burning_device\n\n"
		} else {
			fileevent $input readable log_proc
			#one blank line to increase readability
			.output_window.f_main.log insert end "dvd+rw-format $burn_type $burning_device\n\n"
		}
	} elseif { $burn_type == "erase_cd" } {
		# $burn_opt= "blank=fast" or "blank=full"
		if {[catch {open "|$cd_burning_command $burn_opt dev=$burning_device |& cat"} input]} {
			#one blank line to increase readability
			.output_window.f_main.log insert end "cdrecord $burn_opt dev=$burning_device\n\n"
		} else {
			fileevent $input readable log_proc
			#one blank line to increase readability
			.output_window.f_main.log insert end "$cd_burning_command $burn_opt dev=$burning_device\n\n"
		}
	}
	catch {fconfigure $input -blocking 0}
	after 4000 refresh_cmd_line
}

proc dvd_choose_format {} {
#i18n
global i18n_erase i18n_close i18n_full_format i18n_normal_format i18n_quick_format i18n_erase_dvdrw tristatecompatibility
	if { ! [winfo exists .format_window] } {
		
		toplevel .format_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
		wm title .format_window "$i18n_erase_dvdrw"
		
		frame .format_window.f_format_type -background #f5f5f5
		
		radiobutton .format_window.f_format_type.options_full_f -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_full_format" -variable format_type -value "-blank"
		radiobutton .format_window.f_format_type.options_normal_f -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_normal_format" -variable format_type -value "-force"
		radiobutton .format_window.f_format_type.options_quick_f -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_quick_format" -variable format_type -value ""

		#see TkDVD.sh comments about Tk 8.4/8.5 compatibility and tristate option
		if { $tristatecompatibility == yes } {
	  	#checkbuttons
	  		.format_window.f_format_type.options_full_f configure -tristatevalue "tristate"
			.format_window.f_format_type.options_normal_f configure -tristatevalue "tristate"
			.format_window.f_format_type.options_quick_f configure -tristatevalue "tristate"
		}
		
		button .format_window.b_erase -highlightbackground red -text "$i18n_erase" -command { launch "erase_dvd" $format_type; destroy .format_window}
		button .format_window.b_close -highlightbackground red -text "$i18n_close" -command { destroy .format_window}

		pack .format_window.f_format_type.options_quick_f -side left
		pack .format_window.f_format_type.options_normal_f -side left
		pack .format_window.f_format_type.options_full_f -side left
		pack .format_window.f_format_type -fill x -padx {0 12}
		pack .format_window.b_close .format_window.b_erase -fill x -side right -padx {0 12} -pady {6 6}
		
		.format_window.f_format_type.options_quick_f select
	}
}

proc cd_choose_format {} {
#i18n
global i18n_erase i18n_close i18n_full_format_cd i18n_quick_format_cd i18n_erase_cdrw
	if { ! [winfo exists .format_window] } {
		
		toplevel .format_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
		wm title .format_window "$i18n_erase_cdrw"
		
		frame .format_window.f_format_type -background #f5f5f5
		
		radiobutton .format_window.f_format_type.options_full_f -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_full_format_cd" -variable format_type -value "blank=all"
		radiobutton .format_window.f_format_type.options_quick_f -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_quick_format_cd" -variable format_type -value "blank=fast"
		
		button .format_window.b_erase -highlightbackground red -text "$i18n_erase" -command { launch "erase_cd" $format_type; destroy .format_window}
		button .format_window.b_close -highlightbackground red -text "$i18n_close" -command { destroy .format_window}
		
		pack .format_window.f_format_type.options_quick_f -side left
		pack .format_window.f_format_type.options_full_f -side left
		pack .format_window.f_format_type -fill x -padx {0 12}
		pack .format_window.b_close .format_window.b_erase -fill x -side right -padx {0 12} -pady {6 6}
		
		.format_window.f_format_type.options_quick_f select
	}
}

proc log_proc {} {
	global input i18n_writing_finished
	if { [gets $input line] > 0 } {
		if { [winfo exists .output_window] } {
			.output_window.f_main.log insert end $line\n
			.output_window.f_main.log see end
		}
	} elseif { [eof $input] } {
		catch { close $input }
		if { [winfo exists .output_window] } {
			.output_window.f_main.log insert end "$i18n_writing_finished"
			.output_window.f_main.log see end
		}
	}
}

proc set_visible_options {} {
	global burn_type v_create_iso dvd_size
	if { $burn_type == "burn_dvd" &&  $v_create_iso == "no" } {
		.f_first_step_iso.b_open_iso configure -state disabled
		.f_only_create_iso.only_create_iso configure -state normal
		.f_vol_name.label_vname configure -state normal
		.f_vol_name.volume_name configure -state normal
		.f_first_step_b.add configure -state normal
		.f_first_step_b.add_d configure -state normal
		.f_first_step_b.delete configure -state normal
		.f_first_step_b.clear configure -state normal
		.f_first_step_b.excluded_files configure -state normal
		.file_list.file_list configure -state normal
		.f_upper_file_list.l_file_size configure -state normal
		.f_upper_file_list.l_space_left configure -state normal
		.f_burn_dev.l_burn_device configure -state normal
		.f_burn_dev.burn_device configure -state normal
		if { [winfo exists .advanced_options_window] } {
			.advanced_options_window.options_oth.pad configure -state normal
			.advanced_options_window.udf_radiobuttons.udf_ext configure -state normal
			.advanced_options_window.udf_radiobuttons.dvd_video_ext configure -state normal
			.advanced_options_window.udf_radiobuttons.udf_ext_off configure -state normal
			.advanced_options_window.rr_radiobuttons.rr_ext_off configure -state normal
			.advanced_options_window.rr_radiobuttons.rra_ext configure -state normal
			.advanced_options_window.rr_radiobuttons.rr_ext configure -state normal
			.advanced_options_window.options_fs.joliet_ext configure -state normal
			.advanced_options_window.options_oth.label_burn_speed configure -state normal
			.advanced_options_window.options_oth.entry_burn_speed configure -state normal
			.advanced_options_window.options_oth.overburn configure -state normal
			if { $dvd_size <= 716800 } {
				.advanced_options_window.f_opts_dvd.multisession configure -state disabled
				.advanced_options_window.f_opts_dvd.monosession configure -state disabled
				.advanced_options_window.f_opts_cd.eject_cd configure -state normal
				.advanced_options_window.f_opts_cd.monosession configure -state normal
				.advanced_options_window.f_opts_cd.multisession configure -state normal
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao configure -state normal
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao configure -state normal
			} else {
				.advanced_options_window.f_opts_dvd.multisession configure -state normal
				.advanced_options_window.f_opts_dvd.monosession configure -state normal
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao configure -state disabled
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao configure -state disabled
				.advanced_options_window.f_opts_cd.eject_cd configure -state disabled
				.advanced_options_window.f_opts_cd.monosession configure -state disabled
				.advanced_options_window.f_opts_cd.multisession configure -state disabled
			}
			.advanced_options_window.options_oth.auto_refresh_space configure -state normal
		}
	} elseif { $burn_type == "burn_dvd" && $v_create_iso == "yes" } {
		.f_first_step_iso.b_open_iso configure -state normal
		.f_burn_dev.l_burn_device configure -state disabled
		.f_burn_dev.burn_device configure -state disabled
		if { [winfo exists .advanced_options_window] } {
			.advanced_options_window.options_oth.pad configure -state normal
			.advanced_options_window.options_fs.joliet_ext configure -state normal
			.advanced_options_window.udf_radiobuttons.udf_ext configure -state normal
			.advanced_options_window.udf_radiobuttons.udf_ext_off configure -state normal
			.advanced_options_window.udf_radiobuttons.dvd_video_ext configure -state normal
			.advanced_options_window.rr_radiobuttons.rr_ext_off configure -state normal
			.advanced_options_window.rr_radiobuttons.rr_ext configure -state normal
			.advanced_options_window.rr_radiobuttons.rra_ext configure -state normal
			.advanced_options_window.options_oth.label_burn_speed configure -state disabled
			.advanced_options_window.options_oth.entry_burn_speed configure -state disabled
			.advanced_options_window.options_oth.overburn configure -state disabled
			.advanced_options_window.f_opts_dvd.multisession configure -state disabled
			.advanced_options_window.f_opts_dvd.monosession configure -state disabled
			.advanced_options_window.f_opts_cd.eject_cd configure -state disabled
			.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao configure -state disabled
			.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao configure -state disabled
			.advanced_options_window.f_opts_cd.monosession configure -state disabled
			.advanced_options_window.f_opts_cd.multisession configure -state disabled
			.advanced_options_window.options_oth.auto_refresh_space configure -state normal
		}
	} elseif { $burn_type == "burn_iso" } {
		.f_first_step_iso.b_open_iso configure -state normal
		.f_only_create_iso.only_create_iso configure -state disabled
		.f_vol_name.label_vname configure -state disabled
		.f_vol_name.volume_name configure -state disabled
		.f_first_step_b.add configure -state disabled
		.f_first_step_b.add_d configure -state disabled
		.f_first_step_b.delete configure -state disabled
		.f_first_step_b.clear configure -state disabled
		.f_first_step_b.excluded_files configure -state disabled
		.file_list.file_list configure -state disabled
		.f_upper_file_list.l_file_size configure -state disabled
		.f_upper_file_list.l_space_left configure -state disabled
		.f_burn_dev.l_burn_device configure -state normal
		.f_burn_dev.burn_device configure -state normal
		if { [winfo exists .advanced_options_window] } {
			.advanced_options_window.options_oth.pad configure -state disabled
			.advanced_options_window.udf_radiobuttons.udf_ext configure -state disabled
			.advanced_options_window.udf_radiobuttons.udf_ext_off configure -state disabled
			.advanced_options_window.udf_radiobuttons.dvd_video_ext configure -state disabled
			.advanced_options_window.rr_radiobuttons.rr_ext_off configure -state disabled
			.advanced_options_window.rr_radiobuttons.rra_ext configure -state disabled
			.advanced_options_window.rr_radiobuttons.rr_ext configure -state disabled
			.advanced_options_window.options_fs.joliet_ext configure -state disabled
			.advanced_options_window.options_oth.label_burn_speed configure -state normal
			.advanced_options_window.options_oth.entry_burn_speed configure -state normal
			.advanced_options_window.options_oth.overburn configure -state normal
			.advanced_options_window.f_opts_dvd.multisession configure -state disabled
			.advanced_options_window.f_opts_dvd.monosession configure -state disabled
			.advanced_options_window.f_opts_cd.monosession configure -state disabled
			.advanced_options_window.f_opts_cd.multisession configure -state disabled
			.advanced_options_window.options_oth.auto_refresh_space configure -state disabled
			if { $dvd_size <= 716800 } {
				.advanced_options_window.f_opts_cd.eject_cd configure -state normal
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao configure -state normal
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao configure -state normal
			} else {
				.advanced_options_window.f_opts_cd.eject_cd configure -state disabled
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao configure -state disabled
				.advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao configure -state disabled
			}
		}
	}
}


proc disc_copy { disc_type } {
	#disc_type == "dvd" or "cd"
	global i18n_dvd_copy i18n_cd_copy i18n_copy i18n_close i18n_choose_source_device
	#seems necessary to declare a second variable for -command launch and not with "set", only variable works...
	variable disc_type_g "$disc_type"
	if { ! [winfo exists .dvd_copy_window] } {
		toplevel .dvd_copy_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
		if { $disc_type == "dvd" } {
			wm title .dvd_copy_window "$i18n_dvd_copy"
		} else {
			wm title .dvd_copy_window "$i18n_cd_copy"
		}

		frame .dvd_copy_window.f_source_device -background #f5f5f5
		label .dvd_copy_window.f_source_device.l_mess -bg #f5f5f5 -text "$i18n_choose_source_device"
		entry .dvd_copy_window.f_source_device.e_bd -relief flat -bg white -highlightbackground blue -highlightcolor blue -disabledbackground #f5f5f5 -state normal -textvariable source_device
		
		button .dvd_copy_window.b_copy -highlightbackground red -text "$i18n_copy" -command { launch "${disc_type_g}_copy" "$source_device"; destroy .dvd_copy_window}
		button .dvd_copy_window.b_close -highlightbackground red -text "$i18n_close" -command { destroy .dvd_copy_window}
	
		pack .dvd_copy_window.f_source_device.l_mess -side left
		pack .dvd_copy_window.f_source_device.e_bd -side left
		pack  .dvd_copy_window.f_source_device -fill x -padx {0 12} -pady {12 12}
		pack .dvd_copy_window.b_close .dvd_copy_window.b_copy -fill x -side right -padx {0 12} -pady {6 6}
	}	
}

proc disc_to_iso { disc_type } {
	#disc_type == "dvd" or "cd"
	global i18n_close i18n_create_iso_from_dvd i18n_create_iso_from_cd i18n_create i18n_choose_target_file i18n_error i18n_error_target_file_ns
	set dest_file ""
	if { ! [winfo exists .create_iso_window] } {
	
		toplevel .create_iso_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
		if { $disc_type == "dvd" } {
			wm title .create_iso_window "$i18n_create_iso_from_dvd"
		} else {
			wm title .create_iso_window "$i18n_create_iso_from_cd"
		}

		frame .create_iso_window.f_dest_file -background #f5f5f5
		button .create_iso_window.f_dest_file.b_mess -highlightbackground blue -text "$i18n_choose_target_file" -command { set dest_file [tk_getSaveFile -filetypes {{ {ISO Image} { .iso } } {{All Files}  * } } -defaultextension .iso] }
		entry .create_iso_window.f_dest_file.e_fp  -relief flat -highlightbackground blue -highlightcolor blue -readonlybackground #f5f5f5 -state readonly -textvariable dest_file -width 57
	
		button .create_iso_window.b_create -highlightbackground red -text "$i18n_create" -command { if { $dest_file == "" } { tk_messageBox -icon error -message $i18n_error_target_file_ns -type ok -title $i18n_error } else {launch "create_iso" "[exec echo $dest_file | sed s/\ /\\\\\ /g -]"; destroy .create_iso_window} }
		button .create_iso_window.b_close -highlightbackground red -text "$i18n_close" -command { destroy .create_iso_window}
	
		pack .create_iso_window.f_dest_file.b_mess -side left -padx {12 12}
		pack .create_iso_window.f_dest_file.e_fp -side left
		pack  .create_iso_window.f_dest_file -fill x -padx {0 12} -pady {12 12}
		pack .create_iso_window.b_close .create_iso_window.b_create -fill x -side right -padx {0 12} -pady {6 6}
	}	
}

proc save_file_list {} {
	global file_list excluded_file_list i18n_error_filelist_empty i18n_error
	#we first check that file list is not empty
	if { $file_list == "" } {
		tk_messageBox -icon error -message $i18n_error_filelist_empty -type ok -title $i18n_error
		return
	}
	set output_file_s [tk_getSaveFile -filetypes {{ {TkDVD file list} { .tkdvd } } {{All Files}  * } } -defaultextension .tkdvd]
	if { $output_file_s != "" } {
		set output_file [open $output_file_s w]
		puts $output_file $file_list
		puts $output_file $excluded_file_list
		close $output_file
	}
}

proc load_file_list {} {
	global file_list excluded_file_list option_auto_refresh_space
	set temp_fl ""
	set temp_efl ""
	set input_file_s [tk_getOpenFile -filetypes {{ {TkDVD file list} { .tkdvd } } {{All Files}  * } } -defaultextension .tkdvd]
	if { $input_file_s != "" } {
		set input_file [open $input_file_s r]
		gets $input_file temp_fl
		gets $input_file temp_efl
		#check if each file/dir loaded is not already in file list
		foreach i $temp_fl {
			if { [file_is_present_or_conatained "$i"] == "no"} {
				lappend file_list $i
			}
		}
		#same check for excluded file
		foreach i $temp_efl {
			if { ([file_is_present_or_conatained "$i"] != "no") && ([file_is_present_or_conatained_in_efl "$i"] == "no")} {
				lappend excluded_file_list $i
			}
		}
		close $input_file
		if { $option_auto_refresh_space == "1" } {
			refresh_total_file_size
		}
		refresh_cmd_line
	}
}

proc file_is_present_or_conatained { this_file } {
	#return "yes" if $this_file is already in file list or "yes_c" if it is contained, returns "will_contains" if this_file will contains other files already present, else return "no"
	global file_list
	if { [file isfile "$this_file"] } {
		#in this case we check that file given in parameter is not equal to another file already in FL or contains in a directory in FL
		foreach i $file_list {
			if { [file isfile "$i"] } {
				#same file
				if { "$i" == "$this_file" } { return "yes" }
			} elseif { [file isdirectory "$i"] } {
				#file contained in already present directory
				if { [string compare [file normalize $i] [file dirname "$this_file"]] == 0 } { return "yes_c" }
			}
		}
	} elseif { [file isdirectory "$this_file"] } {
		foreach i $file_list {
			if { [file isdirectory "$i"] } {
				#same directory
				if { "$i" == "$this_file" } { return "yes" }
				#new directory will contains another already present in FL
				if { [string compare -length [string length $this_file] "$this_file" "$i"] == 0} { return "will_contains" }
				#new directory is contained by another directory in FL
				if { [string compare -length [string length $i] "$i" "$this_file"]==0 } { return "yes_c" }
			} elseif { [file isfile "$i"] } {
				#check that new directory doesnt contains files already present
				if { [string compare -length [string length $this_file] "$this_file" "$i"] == 0} { return "will_contains" }
			}
		}
	}
	return "no"
}

proc file_is_present_or_conatained_in_efl { this_file } {
	#return "yes" if $this_file is already in excluded file list or "yes_c" if it is contained, returns "will_contains" if this_file will contains other files already present, else return "no"
	global excluded_file_list
	if { [file isfile "$this_file"] } {
		#in this case we check that file given in parameter is not equal to another file already in FL or contains in a directory in FL
		foreach i $excluded_file_list {
			if { [file isfile "$i"] } {
				#same file
				if { "$i" == "$this_file" } { return "yes" }
			} elseif { [file isdirectory "$i"] } {
				#file contained in already present directory
				if { [string compare -length [string length $i] "$i" "$this_file"] == 0 } { return "yes_c" }
			}
		}
	} elseif { [file isdirectory "$this_file"] } {
		foreach i $excluded_file_list {
			if { [file isdirectory "$i"] } {
				#same directory
				if { "$i" == "$this_file" } { return "yes" }
				#new directory will contains another already rpesent in FL
				if { [string compare -length [string length $this_file] "$this_file" "$i"] == 0} { return "will_contains" }
				#new directory is contained by another directory in FL
				if { [string compare -length [string length $i] "$i" "$this_file"]==0 } { return "yes_c" }
			} elseif { [file isfile "$i"] } {
				#check that new directory doesnt contains files already present
				if { [string compare -length [string length $this_file] "$this_file" "$i"] == 0} { return "will_contains" }
			}
		}
	}
	return "no"
}