﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/cognito-idp/model/FeedbackValueType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CognitoIdentityProvider
{
namespace Model
{

  /**
   * <p>Specifies the event feedback type.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/EventFeedbackType">AWS
   * API Reference</a></p>
   */
  class EventFeedbackType
  {
  public:
    AWS_COGNITOIDENTITYPROVIDER_API EventFeedbackType();
    AWS_COGNITOIDENTITYPROVIDER_API EventFeedbackType(Aws::Utils::Json::JsonView jsonValue);
    AWS_COGNITOIDENTITYPROVIDER_API EventFeedbackType& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_COGNITOIDENTITYPROVIDER_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The event feedback value.</p>
     */
    inline const FeedbackValueType& GetFeedbackValue() const{ return m_feedbackValue; }

    /**
     * <p>The event feedback value.</p>
     */
    inline bool FeedbackValueHasBeenSet() const { return m_feedbackValueHasBeenSet; }

    /**
     * <p>The event feedback value.</p>
     */
    inline void SetFeedbackValue(const FeedbackValueType& value) { m_feedbackValueHasBeenSet = true; m_feedbackValue = value; }

    /**
     * <p>The event feedback value.</p>
     */
    inline void SetFeedbackValue(FeedbackValueType&& value) { m_feedbackValueHasBeenSet = true; m_feedbackValue = std::move(value); }

    /**
     * <p>The event feedback value.</p>
     */
    inline EventFeedbackType& WithFeedbackValue(const FeedbackValueType& value) { SetFeedbackValue(value); return *this;}

    /**
     * <p>The event feedback value.</p>
     */
    inline EventFeedbackType& WithFeedbackValue(FeedbackValueType&& value) { SetFeedbackValue(std::move(value)); return *this;}


    /**
     * <p>The provider.</p>
     */
    inline const Aws::String& GetProvider() const{ return m_provider; }

    /**
     * <p>The provider.</p>
     */
    inline bool ProviderHasBeenSet() const { return m_providerHasBeenSet; }

    /**
     * <p>The provider.</p>
     */
    inline void SetProvider(const Aws::String& value) { m_providerHasBeenSet = true; m_provider = value; }

    /**
     * <p>The provider.</p>
     */
    inline void SetProvider(Aws::String&& value) { m_providerHasBeenSet = true; m_provider = std::move(value); }

    /**
     * <p>The provider.</p>
     */
    inline void SetProvider(const char* value) { m_providerHasBeenSet = true; m_provider.assign(value); }

    /**
     * <p>The provider.</p>
     */
    inline EventFeedbackType& WithProvider(const Aws::String& value) { SetProvider(value); return *this;}

    /**
     * <p>The provider.</p>
     */
    inline EventFeedbackType& WithProvider(Aws::String&& value) { SetProvider(std::move(value)); return *this;}

    /**
     * <p>The provider.</p>
     */
    inline EventFeedbackType& WithProvider(const char* value) { SetProvider(value); return *this;}


    /**
     * <p>The event feedback date.</p>
     */
    inline const Aws::Utils::DateTime& GetFeedbackDate() const{ return m_feedbackDate; }

    /**
     * <p>The event feedback date.</p>
     */
    inline bool FeedbackDateHasBeenSet() const { return m_feedbackDateHasBeenSet; }

    /**
     * <p>The event feedback date.</p>
     */
    inline void SetFeedbackDate(const Aws::Utils::DateTime& value) { m_feedbackDateHasBeenSet = true; m_feedbackDate = value; }

    /**
     * <p>The event feedback date.</p>
     */
    inline void SetFeedbackDate(Aws::Utils::DateTime&& value) { m_feedbackDateHasBeenSet = true; m_feedbackDate = std::move(value); }

    /**
     * <p>The event feedback date.</p>
     */
    inline EventFeedbackType& WithFeedbackDate(const Aws::Utils::DateTime& value) { SetFeedbackDate(value); return *this;}

    /**
     * <p>The event feedback date.</p>
     */
    inline EventFeedbackType& WithFeedbackDate(Aws::Utils::DateTime&& value) { SetFeedbackDate(std::move(value)); return *this;}

  private:

    FeedbackValueType m_feedbackValue;
    bool m_feedbackValueHasBeenSet = false;

    Aws::String m_provider;
    bool m_providerHasBeenSet = false;

    Aws::Utils::DateTime m_feedbackDate;
    bool m_feedbackDateHasBeenSet = false;
  };

} // namespace Model
} // namespace CognitoIdentityProvider
} // namespace Aws
