﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/sso-admin/model/PermissionSetProvisioningStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSOAdmin
{
namespace Model
{
  class DescribePermissionSetProvisioningStatusResult
  {
  public:
    AWS_SSOADMIN_API DescribePermissionSetProvisioningStatusResult();
    AWS_SSOADMIN_API DescribePermissionSetProvisioningStatusResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SSOADMIN_API DescribePermissionSetProvisioningStatusResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The status object for the permission set provisioning operation.</p>
     */
    inline const PermissionSetProvisioningStatus& GetPermissionSetProvisioningStatus() const{ return m_permissionSetProvisioningStatus; }

    /**
     * <p>The status object for the permission set provisioning operation.</p>
     */
    inline void SetPermissionSetProvisioningStatus(const PermissionSetProvisioningStatus& value) { m_permissionSetProvisioningStatus = value; }

    /**
     * <p>The status object for the permission set provisioning operation.</p>
     */
    inline void SetPermissionSetProvisioningStatus(PermissionSetProvisioningStatus&& value) { m_permissionSetProvisioningStatus = std::move(value); }

    /**
     * <p>The status object for the permission set provisioning operation.</p>
     */
    inline DescribePermissionSetProvisioningStatusResult& WithPermissionSetProvisioningStatus(const PermissionSetProvisioningStatus& value) { SetPermissionSetProvisioningStatus(value); return *this;}

    /**
     * <p>The status object for the permission set provisioning operation.</p>
     */
    inline DescribePermissionSetProvisioningStatusResult& WithPermissionSetProvisioningStatus(PermissionSetProvisioningStatus&& value) { SetPermissionSetProvisioningStatus(std::move(value)); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline DescribePermissionSetProvisioningStatusResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline DescribePermissionSetProvisioningStatusResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline DescribePermissionSetProvisioningStatusResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    PermissionSetProvisioningStatus m_permissionSetProvisioningStatus;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
