
#ifndef BALOO_CORE_EXPORT_H
#define BALOO_CORE_EXPORT_H

#ifdef BALOO_CORE_STATIC_DEFINE
#  define BALOO_CORE_EXPORT
#  define BALOO_CORE_NO_EXPORT
#else
#  ifndef BALOO_CORE_EXPORT
#    ifdef KF5Baloo_EXPORTS
        /* We are building this library */
#      define BALOO_CORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define BALOO_CORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef BALOO_CORE_NO_EXPORT
#    define BALOO_CORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef BALOO_CORE_DECL_DEPRECATED
#  define BALOO_CORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef BALOO_CORE_DECL_DEPRECATED_EXPORT
#  define BALOO_CORE_DECL_DEPRECATED_EXPORT BALOO_CORE_EXPORT BALOO_CORE_DECL_DEPRECATED
#endif

#ifndef BALOO_CORE_DECL_DEPRECATED_NO_EXPORT
#  define BALOO_CORE_DECL_DEPRECATED_NO_EXPORT BALOO_CORE_NO_EXPORT BALOO_CORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef BALOO_CORE_NO_DEPRECATED
#    define BALOO_CORE_NO_DEPRECATED
#  endif
#endif

#define BALOO_CORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(BALOO_CORE_NO_DEPRECATED) && !defined(BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define BALOO_CORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(BALOO_CORE_NO_DEPRECATED_WARNINGS) && !defined(BALOO_CORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define BALOO_CORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define BALOO_CORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(BALOO_CORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define BALOO_CORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(BALOO_CORE_NO_DEPRECATED)
#  undef BALOO_CORE_DEPRECATED
#  define BALOO_CORE_DEPRECATED_EXPORT BALOO_CORE_EXPORT
#  define BALOO_CORE_DEPRECATED_NO_EXPORT BALOO_CORE_NO_EXPORT
#elif defined(BALOO_CORE_NO_DEPRECATED_WARNINGS)
#  define BALOO_CORE_DEPRECATED
#  define BALOO_CORE_DEPRECATED_EXPORT BALOO_CORE_EXPORT
#  define BALOO_CORE_DEPRECATED_NO_EXPORT BALOO_CORE_NO_EXPORT
#else
#  define BALOO_CORE_DEPRECATED BALOO_CORE_DECL_DEPRECATED
#  define BALOO_CORE_DEPRECATED_EXPORT BALOO_CORE_DECL_DEPRECATED_EXPORT
#  define BALOO_CORE_DEPRECATED_NO_EXPORT BALOO_CORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define BALOO_CORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define BALOO_CORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef BALOO_CORE_NO_DEPRECATED
#  define BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56900
#endif
#ifdef BALOO_CORE_NO_DEPRECATED_WARNINGS
#  define BALOO_CORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef BALOO_CORE_DEPRECATED_WARNINGS_SINCE
#  ifdef BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define BALOO_CORE_DEPRECATED_WARNINGS_SINCE BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define BALOO_CORE_DEPRECATED_WARNINGS_SINCE 0x56900
#  endif
#endif

#ifndef BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef BALOO_CORE_DEPRECATED
#  define BALOO_CORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > BALOO_CORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define BALOO_CORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if BALOO_CORE_DEPRECATED_WARNINGS_SINCE >= 0x53700
#  define BALOO_CORE_DEPRECATED_VERSION_5_55(text) BALOO_CORE_DECL_DEPRECATED_TEXT(text)
#else
#  define BALOO_CORE_DEPRECATED_VERSION_5_55(text)
#endif

#if BALOO_CORE_DEPRECATED_WARNINGS_SINCE >= 0x54500
#  define BALOO_CORE_DEPRECATED_VERSION_5_69(text) BALOO_CORE_DECL_DEPRECATED_TEXT(text)
#else
#  define BALOO_CORE_DEPRECATED_VERSION_5_69(text)
#endif
#define BALOO_CORE_DEPRECATED_VERSION_5(minor, text)      BALOO_CORE_DEPRECATED_VERSION_5_##minor(text)
#define BALOO_CORE_DEPRECATED_VERSION(major, minor, text) BALOO_CORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define BALOO_CORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) BALOO_CORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define BALOO_CORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) BALOO_CORE_DEPRECATED_VERSION(major, minor, text)
#  define BALOO_CORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) BALOO_CORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define BALOO_CORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define BALOO_CORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* BALOO_CORE_EXPORT_H */
