import { Scanner } from "./scanner.js";
import { SyntaxKind, SourceFile, Identifier, SyntaxNode, DiagnosticMessage } from "./types";
export declare enum ParsingContext {
    None = 0,
    StatementList = 1,
    AttributeContainerList = 2,
    AssignmentList = 3,
    EdgeRhsList = 4,
    QuotedTextIdentifierConcatenation = 5,
    Count = 6
}
export declare class Parser {
    currentToken: SyntaxKind;
    nodeCount: number;
    identifiers: Set<string>;
    identifierCount: number;
    sourceText: string;
    scanner: Scanner;
    currentNodeHasError: boolean;
    currentContext: ParsingContext;
    diagnostics: DiagnosticMessage[];
    constructor();
    private resetState;
    private nextToken;
    private token;
    private getLinesFromFile;
    parse(sourceText: string): SourceFile;
    private parseGraph;
    private parseIdentifier;
    private registerIdentifier;
    private parseTextIdentifier;
    private parseQuotedTextIdentifierConcatenation;
    private parseQuotedTextIdentifier;
    private isQuotedStringFollowing;
    private parseHtmlIdentifier;
    private parseNumericIdentifier;
    private parseStatement;
    private parseAttributeStatement;
    private parseAttributeContainer;
    private isAssignmentStart;
    private parseIdEqualsIdStatement;
    private isIdEqualsIdStatement;
    private parseNodeStatement;
    private parseEdgeStatement;
    private parseEdgeRhs;
    private createMissingNode;
    private parseAssignment;
    private parseSubGraph;
    private parseNodeId;
    private parseCompassPortDeclaration;
    private parseNormalPortDeclaration;
    private parsePortDeclaration;
    private isCompassPort;
    private parseList;
    private getContextParseError;
    private isInSomeParsingContext;
    private abortListParsing;
    private isListElement;
    private isListTerminator;
    private createEmptyArray;
    private finishNode;
    private createNode;
    private createNodeArray;
    private parseTokenNode;
    private getLastError;
    private parseErrorAtPosition;
    private parseErrorAtCurrentToken;
    private scanError;
    private reportExpectedError;
    private parseExpectedOneOf;
    private parseExpectedTokenOneOf;
    private parseExpectedToken;
    private parseExpected;
    private parseOptionalToken;
    private parseOptional;
    private isEdgeOp;
    private isIdentifier;
    private isCompassPortKind;
    private speculationHelper;
    private lookAhead;
    private tryParse;
}
export declare function isIdentifier(kind: SyntaxKind): boolean;
export declare function isIdentifierNode(node: SyntaxNode): node is Identifier;
