/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapTransform;
import net.sf.freecol.client.control.SoundController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.client.gui.TilePopup;
import net.sf.freecol.client.gui.Widgets;
import net.sf.freecol.client.gui.animation.Animation;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.dialog.ClientOptionsDialog;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.dialog.Parameters;
import net.sf.freecol.client.gui.mapviewer.GUIMessage;
import net.sf.freecol.client.gui.mapviewer.MapViewer;
import net.sf.freecol.client.gui.mapviewer.MapViewerState;
import net.sf.freecol.client.gui.mapviewer.TileViewer;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.InformationPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.PurchasePanel;
import net.sf.freecol.client.gui.panel.RecruitPanel;
import net.sf.freecol.client.gui.panel.StartGamePanel;
import net.sf.freecol.client.gui.panel.StatusPanel;
import net.sf.freecol.client.gui.panel.TradeRouteInputPanel;
import net.sf.freecol.client.gui.panel.TrainPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.LabourData;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.gui.plaf.FreeColToolTipUI;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ImageCache;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class SwingGUI
extends GUI {
    private static final List<Class<? extends FreeColPanel>> EUROPE_CLASSES = CollectionUtils.makeUnmodifiableList(RecruitPanel.class, PurchasePanel.class, TrainPanel.class);
    private static final int DRAG_THRESHOLD = 16;
    private final GraphicsDevice graphicsDevice = Utils.getGoodGraphicsDevice();
    private final ImageCache imageCache;
    private ImageLibrary fixedImageLibrary;
    private ImageLibrary scaledImageLibrary;
    private TileViewer tileViewer;
    private MapViewer mapViewer;
    private MapControls mapControls;
    private Canvas canvas;
    private Widgets widgets;
    private Point dragPoint;
    private boolean gotoStarted = false;

    public SwingGUI(FreeColClient freeColClient) {
        super(freeColClient);
        if (this.graphicsDevice == null) {
            FreeCol.fatal(logger, "Could not find a GraphicsDevice!");
        }
        float scaleFactor = this.determineScaleFactorUsingClientOptions(Utils.determineDpi(this.graphicsDevice));
        this.imageCache = new ImageCache();
        this.scaledImageLibrary = new ImageLibrary(scaleFactor, this.imageCache);
        this.fixedImageLibrary = new ImageLibrary(scaleFactor, this.imageCache);
        this.tileViewer = new TileViewer(freeColClient, this.fixedImageLibrary);
        this.mapViewer = null;
        this.mapControls = null;
        this.canvas = null;
        this.widgets = null;
        this.dragPoint = null;
        logger.info("GUI constructed using scale factor " + scaleFactor);
    }

    private void animate(Animation a, JLabel unitLabel) {
        List<Tile> tiles = a.getTiles();
        Rectangle bounds = null;
        for (Tile t : tiles) {
            Rectangle r = this.mapViewer.getMapViewerBounds().calculateDrawnTileBounds(t);
            bounds = bounds == null ? r : bounds.union(r);
        }
        final Canvas can = this.canvas;
        final Rectangle aBounds = bounds;
        Animations.Procedure painter = new Animations.Procedure(){

            @Override
            public void execute() {
                can.paintImmediately(aBounds);
            }
        };
        a.executeWithLabel(unitLabel, painter);
    }

    private void animations(List<Animation> animations) {
        if (animations.isEmpty()) {
            return;
        }
        boolean center = this.getClientOptions().getBoolean("model.option.alwaysCenter");
        Tile first = animations.get(0).getTiles().get(0);
        if (center && first != this.getFocus()) {
            this.mapViewer.getMapViewerBounds().setFocus(first);
        }
        this.invokeNowOrWait(() -> {
            int i;
            Tile originalFocus = this.mapViewer.getMapViewerState().getActiveUnit() != null ? this.mapViewer.getMapViewerBounds().getFocus() : null;
            List allTiles = animations.stream().map(a -> a.getTiles()).flatMap(Collection::stream).collect(Collectors.toList());
            for (Tile t : allTiles) {
                if (this.mapViewer.getMapViewerBounds().onScreen(t)) continue;
                this.mapViewer.getMapViewerBounds().setFocus(t);
                break;
            }
            ArrayList<JLabel> animatedUnitLabels = new ArrayList<JLabel>();
            try {
                animatedUnitLabels.addAll(this.prepareUnitLabelsForAnimation(animations));
                this.mapViewer.getMapViewerRepaintManager().markAsDirty();
                this.paintImmediately();
                for (i = 0; i < animations.size(); ++i) {
                    this.animate((Animation)animations.get(i), (JLabel)animatedUnitLabels.get(i));
                }
            }
            finally {
                if (originalFocus != null && this.mapViewer.getMapViewerBounds().setFocus(originalFocus)) {
                    this.repaint();
                }
                for (i = 0; i < animations.size(); ++i) {
                    Unit unit = ((Animation)animations.get(i)).getUnit();
                    JLabel unitLabel = (JLabel)animatedUnitLabels.get(i);
                    this.releaseUnitOutForAnimation(unit, unitLabel);
                }
            }
        });
    }

    private void releaseUnitOutForAnimation(Unit unit, JLabel unitLabel) {
        this.mapViewer.getMapViewerState().getUnitAnimator().releaseUnitOutForAnimation(unit);
        if (!this.mapViewer.getMapViewerState().getUnitAnimator().isOutForAnimation(unit)) {
            this.canvas.animationLabel(unitLabel, false);
            this.mapViewer.getMapViewerRepaintManager().markAsDirty();
            this.repaint();
        }
    }

    private List<JLabel> prepareUnitLabelsForAnimation(List<Animation> animations) {
        ArrayList<JLabel> animatedUnitLabels = new ArrayList<JLabel>();
        for (Animation a : animations) {
            Unit unit = a.getUnit();
            boolean newLabel = !this.mapViewer.getMapViewerState().getUnitAnimator().isOutForAnimation(unit);
            JLabel unitLabel = this.mapViewer.getMapViewerState().getUnitAnimator().enterUnitOutForAnimation(unit);
            animatedUnitLabels.add(unitLabel);
            List<Point> points = CollectionUtils.transform(a.getTiles(), CollectionUtils.alwaysTrue(), t -> this.mapViewer.getMapViewerState().getUnitAnimator().getAnimationPosition(unitLabel, (Tile)t));
            a.setPoints(points);
            unitLabel.setLocation(points.get(0));
            if (!newLabel) continue;
            this.canvas.animationLabel(unitLabel, true);
        }
        return animatedUnitLabels;
    }

    private Point getDragPoint() {
        return this.dragPoint;
    }

    private void setDragPoint(int x, int y) {
        this.dragPoint = new Point(x, y);
    }

    public boolean isDrag(int x, int y) {
        Point drag = this.getDragPoint();
        if (drag == null) {
            return false;
        }
        int deltaX = Math.abs(x - drag.x);
        int deltaY = Math.abs(y - drag.y);
        return deltaX >= 16 || deltaY >= 16;
    }

    private boolean changeViewMode(GUI.ViewMode newViewMode) {
        GUI.ViewMode oldViewMode = this.getViewMode();
        if (newViewMode == oldViewMode) {
            return false;
        }
        this.mapViewer.getMapViewerState().setViewMode(newViewMode);
        return true;
    }

    private boolean changeActiveUnit(Unit newUnit) {
        Unit oldUnit = this.getActiveUnit();
        if (newUnit != null && newUnit.hasTile() && !this.mapViewer.getMapViewerBounds().onScreen(newUnit.getTile())) {
            this.mapViewer.getMapViewerBounds().setFocus(newUnit.getTile());
            this.mapViewer.getMapViewerRepaintManager().markAsDirty(newUnit.getTile());
            this.repaint();
        }
        if (newUnit == oldUnit) {
            return false;
        }
        this.mapViewer.getMapViewerState().setActiveUnit(newUnit);
        this.clearGotoPath();
        return true;
    }

    @Override
    public void setRangedAttackMode(boolean rangedAttackMode) {
        MapViewerState mvs = this.mapViewer.getMapViewerState();
        if (mvs.isRangedAttackMode() == rangedAttackMode) {
            return;
        }
        mvs.setRangedAttackMode(rangedAttackMode);
        this.refresh();
    }

    @Override
    public void toggleRangedAttackMode() {
        this.setRangedAttackMode(!this.mapViewer.getMapViewerState().isRangedAttackMode());
    }

    private boolean changeSelectedTile(Tile newTile, boolean refocus) {
        Tile oldTile = this.getSelectedTile();
        Tile oldFocus = this.getFocus();
        boolean bl = refocus = newTile != null && newTile != oldFocus && (oldFocus == null || refocus || !this.mapViewer.getMapViewerBounds().onScreen(newTile));
        if (refocus) {
            this.setFocus(newTile);
        }
        if (newTile == oldTile) {
            return false;
        }
        this.mapViewer.getMapViewerState().setSelectedTile(newTile);
        if (oldTile != null) {
            this.refreshTile(oldTile);
        }
        if (newTile != null) {
            this.refreshTile(newTile);
        }
        return true;
    }

    private void changeDone(boolean update) {
        boolean cursorShouldBlink = this.getViewMode() == GUI.ViewMode.MOVE_UNITS && this.getActiveUnit() != null;
        this.mapViewer.getMapViewerState().setCursorBlinking(cursorShouldBlink);
        if (update) {
            this.updateMapControls();
            Unit activeUnit = this.getActiveUnit();
            if (activeUnit != null) {
                this.refreshTile(activeUnit.getTile());
            }
        }
        this.updateMenuBar();
    }

    private final float getMapScale() {
        ImageLibrary lib = this.scaledImageLibrary;
        return lib == null ? 1.0f : lib.getScaleFactor();
    }

    private PopupPosition getPopupPosition(Tile tile) {
        if (tile == null) {
            return PopupPosition.CENTERED;
        }
        int where = this.mapViewer.getMapViewerBounds().setOffsetFocus(tile);
        this.repaint();
        return where > 0 ? PopupPosition.CENTERED_LEFT : (where < 0 ? PopupPosition.CENTERED_RIGHT : PopupPosition.CENTERED);
    }

    private void updateUnitPath() {
        Unit active = this.getActiveUnit();
        if (active == null) {
            return;
        }
        Location destination = active.getDestination();
        PathNode path = null;
        if (destination != null && !((FreeColGameObject)((Object)destination)).isDisposed() && !active.isAtLocation(destination)) {
            try {
                path = active.findPath(destination);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Path fail", e);
                active.setDestination(null);
            }
        }
        this.setUnitPath(path);
    }

    private void startGoto() {
        this.gotoStarted = true;
        this.canvas.setCursor(Canvas.GO_CURSOR);
        if (this.mapViewer.getMapViewerState().changeGotoPath(null)) {
            this.repaint();
        }
    }

    private PathNode stopGoto() {
        PathNode ret = this.gotoStarted ? this.mapViewer.getMapViewerState().getGotoPath() : null;
        this.gotoStarted = false;
        this.canvas.setCursor(null);
        if (this.mapViewer.getMapViewerState().changeGotoPath(null)) {
            this.repaint();
        }
        return ret;
    }

    private void updateGotoTile(Tile tile) {
        Unit unit = this.getActiveUnit();
        if (tile == null || unit == null) {
            this.clearGotoPath();
        } else if (this.isGotoStarted()) {
            PathNode newPath;
            Tile lastTile;
            PathNode oldPath = this.mapViewer.getMapViewerState().getGotoPath();
            Tile tile2 = lastTile = oldPath == null ? null : oldPath.getLastNode().getTile();
            if (lastTile == tile) {
                return;
            }
            PathNode pathNode = newPath = unit.getTile() == tile || !tile.isExplored() || !unit.getSimpleMoveType(tile).isLegal() ? null : unit.findPath(tile);
            if (this.mapViewer.getMapViewerState().changeGotoPath(newPath)) {
                this.repaint();
            }
        }
    }

    public void paintImmediately() {
        this.canvas.paintImmediately(this.canvas.getBounds());
    }

    @Override
    public void refreshTile(Tile tile) {
        if (tile != null) {
            this.mapViewer.getMapViewerRepaintManager().markAsDirty(tile);
            if (tile.hasSettlement()) {
                this.mapViewer.getMapViewerRepaintManager().markAsDirty(tile.getSurroundingTiles(1, 1));
            }
            this.canvas.repaint();
        }
    }

    private void resetMapZoom() {
        if (this.scaledImageLibrary.getScaleFactor() != this.fixedImageLibrary.getScaleFactor()) {
            this.changeMapScale(this.fixedImageLibrary.getScaleFactor());
        }
    }

    @Override
    public ImageLibrary getFixedImageLibrary() {
        return this.fixedImageLibrary;
    }

    @Override
    public ImageLibrary getScaledImageLibrary() {
        return this.scaledImageLibrary;
    }

    @Override
    public boolean isWindowed() {
        return this.canvas.isWindowed();
    }

    @Override
    public void invokeNowOrLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void invokeNowOrWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Client GUI interaction", ex);
            }
        }
    }

    @Override
    public void changeWindowedMode() {
        this.canvas.toggleFrame();
    }

    @Override
    public void installLookAndFeel(String fontName) throws FreeColException {
        int dpi = Utils.determineDpi(this.graphicsDevice);
        int fontSize = this.determineMainFontSizeUsingClientOptions(dpi);
        FontLibrary.setMainFontSize(fontSize);
        FreeColImageBorder.setScaleFactor(this.fixedImageLibrary.getScaleFactor());
        FreeColToolTipUI.setFontScaling(FontLibrary.getFontScaling());
        FreeColLookAndFeel fclaf = new FreeColLookAndFeel();
        FreeColLookAndFeel.install(fclaf);
        Font font = FontLibrary.createMainFont(fontName);
        if (font == null) {
            throw new FreeColException("Unable to create main font: " + fontName);
        }
        FreeColLookAndFeel.installFont(font);
        Utility.initStyleContext(font);
    }

    @Override
    public void quitGUI() {
        if (this.canvas != null) {
            this.canvas.quit();
        }
    }

    @Override
    public void reconnectGUI(Unit active, Tile tile) {
        this.canvas.requestFocusInWindow();
        this.canvas.initializeInGame();
        this.closeMenus();
        this.clearGotoPath();
        this.canvas.resetMenuBar();
        this.resetMapZoom();
        if (active != null) {
            this.changeView(active, false);
            if (active.hasTile()) {
                tile = active.getTile();
            } else if (active.getOwner().getFallbackTile() != null) {
                tile = active.getOwner().getFallbackTile();
                this.changeView(tile);
            }
        } else if (tile != null) {
            this.changeView(tile);
        } else {
            this.changeView(null, false);
        }
        this.mapViewer.getMapViewerBounds().setFocus(tile);
        this.enableMapControls(false);
        this.enableMapControls(this.getClientOptions().getBoolean("model.option.displayMapControls"));
        this.refresh();
    }

    @Override
    public void removeInGameComponents() {
        this.changeActiveUnit(null);
        this.changeSelectedTile(null, false);
        this.canvas.removeInGameComponents();
    }

    @Override
    public void showOpeningVideo(String userMsg, Runnable callback) {
        boolean play = this.getFreeColClient().getSoundController().canPlaySound();
        this.canvas.playVideo("video.opening", !play, callback);
    }

    @Override
    public void startGUI(Dimension desiredWindowSize) {
        FreeColClient fcc = this.getFreeColClient();
        ClientOptions opts = this.getClientOptions();
        this.mapControls = MapControls.newInstance(fcc);
        ActionListener al = ae -> {
            Tile tile = this.mapViewer.getMapViewerState().getCursorTile();
            if (tile != null) {
                // empty if block
            }
        };
        this.mapViewer = new MapViewer(fcc, this.scaledImageLibrary, al);
        this.canvas = new Canvas(this.getFreeColClient(), this.graphicsDevice, desiredWindowSize, this.mapViewer, this.mapControls);
        this.widgets = new Widgets(fcc, this.canvas);
        opts.getOption("model.option.languageOption", LanguageOption.class).addPropertyChangeListener(e -> {
            LanguageOption.Language language = (LanguageOption.Language)e.getNewValue();
            logger.info("Set language to: " + language);
            if ("automatic".equalsIgnoreCase(language.getKey())) {
                this.showInformationPanel("info.autodetectLanguageSelected");
            } else {
                Locale l = language.getLocale();
                Messages.loadMessageBundle(l);
                Messages.loadModMessageBundle(l);
                this.showInformationPanel((StringTemplate)StringTemplate.template("info.newLanguageSelected").addName("%language%", l.getDisplayName()));
            }
        });
        this.mapViewer.getMapViewerState().setCursorBlinking(true);
        logger.info("GUI started.");
    }

    @Override
    public Dimension getMapViewDimension() {
        return this.canvas.getSize();
    }

    @Override
    public void startMapEditorGUI() {
        this.resetMapZoom();
        this.canvas.startMapEditorGUI();
        this.canvas.showMapEditorTransformPanel();
    }

    @Override
    public void animateUnitAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        this.animations(Animations.unitAttack(this.getFreeColClient(), attacker, defender, attackerTile, defenderTile, success, this.getMapScale()));
        this.refreshTilesForUnit(attacker, attackerTile, defenderTile);
    }

    @Override
    public void animateUnitMove(Unit unit, Tile srcTile, Tile dstTile) {
        this.animations(Animations.unitMove(this.getFreeColClient(), unit, srcTile, dstTile, this.getMapScale()));
        this.refreshTilesForUnit(unit, srcTile, dstTile);
    }

    private void refreshTilesForUnit(Unit unit, Tile srcTile, Tile dstTile) {
        List<Tile> possibleDirtyTiles;
        if (unit != null && srcTile != null) {
            possibleDirtyTiles = srcTile.getSurroundingTiles(0, unit.getLineOfSight());
            this.mapViewer.getMapViewerRepaintManager().markAsDirty(possibleDirtyTiles);
        }
        if (unit != null && dstTile != null) {
            possibleDirtyTiles = dstTile.getSurroundingTiles(0, unit.getLineOfSight());
            this.mapViewer.getMapViewerRepaintManager().markAsDirty(possibleDirtyTiles);
        }
        this.repaint();
    }

    @Override
    public boolean confirm(Tile tile, StringTemplate tmpl, ImageIcon icon, String okKey, String cancelKey) {
        return this.widgets.confirm(tmpl, icon, okKey, cancelKey, this.getPopupPosition(tile));
    }

    @Override
    protected <T> T getChoice(Tile tile, StringTemplate tmpl, ImageIcon icon, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.widgets.getChoice(tmpl, icon, cancelKey, choices, this.getPopupPosition(tile));
    }

    @Override
    public String getInput(Tile tile, StringTemplate tmpl, String defaultValue, String okKey, String cancelKey) {
        return this.widgets.getInput(tmpl, defaultValue, okKey, cancelKey, this.getPopupPosition(tile));
    }

    @Override
    public Tile getFocus() {
        return this.mapViewer.getMapViewerBounds().getFocus();
    }

    @Override
    public void setFocus(Tile tileToFocus) {
        this.mapViewer.getMapViewerBounds().setFocus(tileToFocus);
        this.repaint();
    }

    @Override
    public boolean canZoomInMapControls() {
        if (this.mapControls == null) {
            return false;
        }
        return this.mapControls.canZoomInMapControls();
    }

    @Override
    public boolean canZoomOutMapControls() {
        if (this.mapControls == null) {
            return false;
        }
        return this.mapControls.canZoomOutMapControls();
    }

    @Override
    public void enableMapControls(boolean enable) {
        if (this.mapControls == null) {
            return;
        }
        if (enable) {
            this.updateMapControls();
            this.canvas.addMapControls();
        } else {
            this.canvas.removeMapControls();
        }
    }

    @Override
    public void miniMapToggleViewControls() {
        if (this.mapControls == null) {
            return;
        }
        this.getFreeColClient().toggleClientOption("model.option.miniMapToggleBorders");
        this.mapControls.repaint();
    }

    @Override
    public void miniMapToggleFogOfWarControls() {
        if (this.mapControls == null) {
            return;
        }
        this.getFreeColClient().toggleClientOption("model.option.miniMapToggleFogOfWar");
        this.mapControls.repaint();
    }

    @Override
    public void updateMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.update(this.getViewMode(), this.getActiveUnit(), this.getSelectedTile());
    }

    @Override
    public void zoomInMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.zoomIn();
    }

    @Override
    public void zoomOutMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.zoomOut();
    }

    @Override
    public void closeMenus() {
        this.canvas.closeMenus();
    }

    @Override
    public void resetMenuBar() {
        this.canvas.resetMenuBar();
    }

    @Override
    public void updateMenuBar() {
        this.canvas.updateMenuBar();
    }

    @Override
    public void showPopupMenu(JPopupMenu menu, int x, int y) {
        menu.show(this.canvas, x, y);
    }

    @Override
    public void setUnitPath(PathNode path) {
        this.mapViewer.getMapViewerState().setUnitPath(path);
    }

    @Override
    public void activateGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (this.isGotoStarted()) {
            this.clearGotoPath();
        } else {
            this.startGoto();
            Point pt = this.canvas.getMousePosition();
            this.updateGotoTile(pt == null ? null : this.tileAt(pt.x, pt.y));
        }
    }

    @Override
    public void clearGotoPath() {
        this.stopGoto();
        this.updateUnitPath();
        this.repaint();
    }

    @Override
    public boolean isGotoStarted() {
        return this.gotoStarted;
    }

    @Override
    public void performGoto(Tile tile) {
        Unit active;
        if (this.isGotoStarted()) {
            this.stopGoto();
        }
        if ((active = this.getActiveUnit()) != null) {
            if (tile != null && active.getTile() != tile) {
                this.startGoto();
                this.updateGotoTile(tile);
                this.traverseGotoPath();
            }
            this.updateUnitPath();
        }
        this.repaint();
    }

    @Override
    public void performGoto(int x, int y) {
        this.performGoto(this.tileAt(x, y));
    }

    @Override
    public void traverseGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null || !this.isGotoStarted()) {
            return;
        }
        PathNode path = this.stopGoto();
        if (path == null) {
            this.igc().clearGotoOrders(unit);
        } else {
            this.igc().goToTile(unit, path);
            this.refresh();
        }
        if (unit == this.getActiveUnit()) {
            this.updateUnitPath();
        }
        this.repaint();
    }

    @Override
    public void updateGoto(int x, int y, boolean start) {
        if (!this.isGotoStarted() && start && this.isDrag(x, y)) {
            this.startGoto();
        }
        if (this.isGotoStarted()) {
            this.updateGotoTile(this.tileAt(x, y));
        }
    }

    @Override
    public void prepareDrag(int x, int y) {
        if (this.isGotoStarted()) {
            this.stopGoto();
            this.repaint();
        }
        this.setDragPoint(x, y);
        this.canvas.requestFocus();
    }

    @Override
    public boolean scrollMap(Direction direction) {
        boolean scrolled = false;
        if (Direction.longSides.contains(direction)) {
            List<Direction> directions = SwingGUI.toNonDiagonalDirections(direction);
            if (scrolled |= this.mapViewer.getMapViewerBounds().scrollMap(directions.get(0))) {
                this.mapViewer.paintImmediatelyToBuffersOnly();
            }
            scrolled |= this.mapViewer.getMapViewerBounds().scrollMap(directions.get(1));
        } else {
            scrolled |= this.mapViewer.getMapViewerBounds().scrollMap(direction);
        }
        if (scrolled) {
            this.paintImmediately();
        }
        return scrolled;
    }

    private static List<Direction> toNonDiagonalDirections(Direction d) {
        switch (d) {
            case NE: {
                return List.of(Direction.N, Direction.E);
            }
            case SE: {
                return List.of(Direction.S, Direction.E);
            }
            case NW: {
                return List.of(Direction.N, Direction.W);
            }
            case SW: {
                return List.of(Direction.S, Direction.W);
            }
        }
        return List.of(d);
    }

    @Override
    public BufferedImage createTileImageWithBeachBorderAndItems(Tile tile) {
        return this.tileViewer.createTileImageWithBeachBorderAndItems(tile);
    }

    @Override
    public BufferedImage createTileImage(Tile tile, Player player) {
        return this.tileViewer.createTileImage(tile, player);
    }

    @Override
    public BufferedImage createColonyTileImage(Tile tile, Colony colony) {
        return this.tileViewer.createColonyTileImage(tile, colony);
    }

    @Override
    public void displayColonyTiles(Graphics2D g2d, Tile[][] tiles, Colony colony) {
        this.tileViewer.displayColonyTiles(g2d, tiles, colony);
    }

    @Override
    public GUI.ViewMode getViewMode() {
        return this.mapViewer.getMapViewerState().getViewMode();
    }

    @Override
    public Unit getActiveUnit() {
        return this.mapViewer.getMapViewerState().getActiveUnit();
    }

    @Override
    public Tile getSelectedTile() {
        return this.mapViewer.getMapViewerState().getSelectedTile();
    }

    @Override
    public void changeView(Tile tile) {
        boolean change = this.changeViewMode(GUI.ViewMode.TERRAIN);
        this.changeDone(change |= this.changeSelectedTile(tile, this.getClientOptions().getBoolean("model.option.alwaysCenter")));
    }

    @Override
    public void changeView(Unit unit, boolean force) {
        boolean change = this.changeViewMode(GUI.ViewMode.MOVE_UNITS);
        change |= this.changeActiveUnit(unit);
        if (unit != null && unit.hasTile() && !force) {
            change |= this.changeSelectedTile(unit.getTile(), true);
        }
        this.changeDone(change || force);
    }

    @Override
    public void changeView(MapTransform mt) {
        boolean change = this.changeViewMode(GUI.ViewMode.MAP_TRANSFORM);
        this.changeDone(change);
    }

    @Override
    public void changeView() {
        boolean change = this.changeViewMode(GUI.ViewMode.END_TURN);
        change |= this.changeActiveUnit(null);
        this.changeDone(change |= this.changeSelectedTile(null, false));
    }

    @Override
    public boolean canZoomInMap() {
        return this.scaledImageLibrary.getScaleFactor() < 4.0f;
    }

    @Override
    public boolean canZoomOutMap() {
        return this.scaledImageLibrary.getScaleFactor() > 0.25f;
    }

    @Override
    public void zoomInMap() {
        float newScale;
        float scale = this.scaledImageLibrary.getScaleFactor();
        if (scale < (newScale = scale + 0.25f) && newScale <= 4.0f) {
            this.changeMapScale(newScale);
        }
    }

    @Override
    public void zoomOutMap() {
        float scale = this.scaledImageLibrary.getScaleFactor();
        float newScale = scale - 0.25f;
        if (0.25f <= newScale && newScale < scale) {
            this.changeMapScale(newScale);
        }
    }

    private void changeMapScale(float newScale) {
        this.imageCache.clear();
        if (this.mapViewer != null) {
            this.mapViewer.changeScale(newScale);
        }
        if (this.canvas != null) {
            this.refresh();
        }
    }

    @Override
    public void reloadResources() {
        ResourceManager.reload();
        this.imageCache.clear();
        this.refresh();
    }

    public void prepareResources() {
        ResourceManager.prepare();
        this.imageCache.clear();
        this.refresh();
    }

    @Override
    public void emergencyPurge() {
        this.imageCache.clear();
        SoundController sc = this.getFreeColClient().getSoundController();
        sc.setDefaultPlaylist(List.of());
        sc.playMusic(null);
    }

    @Override
    public void clickAt(int count, int x, int y) {
        if (this.mapViewer.getMapViewerState().isRangedAttackMode()) {
            Tile tile = this.tileAt(x, y);
            Unit activeUnit = this.mapViewer.getMapViewerState().getActiveUnit();
            if (!(activeUnit != null && activeUnit.isOffensiveUnit() && activeUnit.canAttackRanged(tile) && activeUnit.getMovesLeft() > 0 && this.getFreeColClient().currentPlayerIsMyPlayer())) {
                return;
            }
            this.igc().attackRanged(activeUnit, tile);
            return;
        }
        if (count == 1 && this.isDrag(x, y)) {
            return;
        }
        Tile tile = this.tileAt(x, y);
        if (tile == null) {
            return;
        }
        Unit other = null;
        if (!tile.isExplored()) {
            this.changeView(tile);
        } else if (tile.hasSettlement()) {
            Settlement settlement = tile.getSettlement();
            if (settlement instanceof Colony) {
                if (this.getMyPlayer().owns(settlement)) {
                    this.showColonyPanel((Colony)settlement, null);
                } else {
                    DebugUtils.showForeignColony(this.getFreeColClient(), (Colony)settlement);
                }
            } else if (settlement instanceof IndianSettlement) {
                this.showIndianSettlementPanel((IndianSettlement)settlement);
            }
            this.changeView(tile);
        } else {
            other = this.mapViewer.getMapViewerState().findUnitInFront(tile);
            if (other != null) {
                if (this.getMyPlayer().owns(other)) {
                    Unit active = this.getActiveUnit();
                    if (active != null && active.getTile() == tile) {
                        if (this.getViewMode() != GUI.ViewMode.MOVE_UNITS) {
                            other = active;
                        } else {
                            List<Unit> units = tile.getUnitList();
                            while (!units.isEmpty()) {
                                Unit u = units.remove(0);
                                if (u != active) continue;
                                if (units.isEmpty()) break;
                                other = units.remove(0);
                                break;
                            }
                        }
                    }
                    this.changeView(other, false);
                } else {
                    this.changeView(tile);
                }
            } else if (count > 1) {
                this.changeView(tile);
            }
        }
    }

    @Override
    public void closePanel(String panel) {
        this.canvas.closePanel(panel);
    }

    @Override
    public void closeMainPanel() {
        this.canvas.closeMainPanel();
    }

    @Override
    public void closeStatusPanel() {
        StatusPanel panel = this.canvas.getExistingFreeColPanel(StatusPanel.class);
        if (panel != null) {
            this.canvas.removeFromCanvas(panel);
            this.canvas.requestFocusInWindow();
        }
    }

    @Override
    public void displayChat(String sender, String message, Color color, boolean privateChat) {
        this.mapViewer.getMapViewerState().displayChat(new GUIMessage(sender + ": " + message, color));
        this.repaint();
    }

    @Override
    public void displayObject(FreeColObject fco) {
        if (fco instanceof Colony) {
            this.showColonyPanel((Colony)fco, null);
        } else if (fco instanceof Europe) {
            this.showEuropePanel();
        } else if (fco instanceof IndianSettlement) {
            this.showIndianSettlementPanel((IndianSettlement)fco);
        } else if (fco instanceof Tile) {
            this.setFocus((Tile)fco);
        } else if (fco instanceof Unit) {
            Location loc = ((Unit)fco).up();
            if (loc instanceof Colony) {
                this.showColonyPanel((Colony)loc, (Unit)fco);
            } else {
                this.displayObject((FreeColObject)((Object)loc));
            }
        } else if (fco instanceof WorkLocation) {
            this.showColonyPanel(((WorkLocation)fco).getColony(), null);
        }
    }

    @Override
    public void displayStartChat(String sender, String message, boolean privateChat) {
        StartGamePanel panel = this.canvas.getExistingFreeColPanel(StartGamePanel.class);
        if (panel != null) {
            panel.displayChat(sender, message, privateChat);
        }
    }

    @Override
    public boolean isClientOptionsDialogShowing() {
        return this.canvas.getExistingFreeColDialog(ClientOptionsDialog.class) != null;
    }

    @Override
    public boolean isPanelShowing() {
        return this.canvas != null && this.canvas.getShowingPanel() != null;
    }

    @Override
    public void refresh() {
        if (this.mapViewer != null) {
            this.mapViewer.getMapViewerRepaintManager().markAsDirty();
        }
        if (this.canvas != null) {
            this.canvas.repaint(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        }
    }

    @Override
    public void repaint() {
        this.canvas.repaint(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
    }

    @Override
    public void refreshPlayersTable() {
        StartGamePanel panel = this.canvas.getExistingFreeColPanel(StartGamePanel.class);
        if (panel != null) {
            panel.refreshPlayersTable();
        }
    }

    @Override
    public void removeComponent(Component component) {
        this.canvas.remove(component);
        if (!this.isPanelShowing()) {
            this.canvas.requestFocusInWindow();
        }
    }

    @Override
    public void removeDialog(FreeColDialog<?> fcd) {
        this.canvas.dialogRemove(fcd);
    }

    @Override
    public void removeTradeRoutePanel(FreeColPanel panel) {
        this.canvas.remove(panel);
        TradeRouteInputPanel tripPanel = this.canvas.getExistingFreeColPanel(TradeRouteInputPanel.class);
        if (tripPanel != null) {
            tripPanel.cancelTradeRoute();
        }
    }

    @Override
    public void restoreSavedSize(Component comp, Dimension size) {
        this.canvas.restoreSavedSize(comp, size);
    }

    @Override
    public void showTilePopup(Tile tile) {
        if (tile == null || !tile.isExplored()) {
            return;
        }
        TilePopup tp = new TilePopup(this.getFreeColClient(), tile);
        if (tp.hasItem()) {
            Point point = this.mapViewer.getMapViewerBounds().calculateTilePosition(tile, true);
            tp.show(this.canvas, point.x, point.y);
            tp.repaint();
        }
    }

    @Override
    public Tile tileAt(int x, int y) {
        return this.mapViewer.convertToMapTile(x, y);
    }

    @Override
    public void updateEuropeanSubpanels() {
        for (Class<? extends FreeColPanel> c : EUROPE_CLASSES) {
            FreeColPanel p = this.canvas.getExistingFreeColPanel(c);
            if (p == null) continue;
            try {
                Introspector.invokeVoidMethod(p, "update");
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public FreeColPanel showAboutPanel() {
        return this.widgets.showAboutPanel();
    }

    @Override
    public FreeColPanel showBuildQueuePanel(Colony colony) {
        return this.widgets.showBuildQueuePanel(colony);
    }

    @Override
    public void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
        this.widgets.showCaptureGoodsDialog(unit, gl, handler);
    }

    @Override
    public FreeColPanel showChatPanel() {
        return this.getFreeColClient().getSinglePlayer() ? null : this.widgets.showChatPanel();
    }

    @Override
    public void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
        this.widgets.showChooseFoundingFatherDialog(ffs, handler);
    }

    @Override
    public void showClientOptionsDialog() {
        FreeColClient fcc = this.getFreeColClient();
        ClientOptionsDialog dialog = new ClientOptionsDialog(fcc, this.canvas.getParentFrame(), true);
        dialog.setDialogHandler(group -> {
            if (group != null) {
                this.refreshGuiUsingClientOptions();
                this.canvas.mainTitleIfMainPanelIsAlreadyShowing();
            }
        });
        this.canvas.showFreeColPanel(dialog, PopupPosition.CENTERED, true);
    }

    @Override
    public void refreshGuiUsingClientOptions() {
        int dpi = Utils.determineDpi(this.graphicsDevice);
        float scaleFactor = this.determineScaleFactorUsingClientOptions(dpi);
        this.fixedImageLibrary.changeScaleFactor(scaleFactor);
        this.resetMapZoom();
        if (this.tileViewer != null) {
            this.tileViewer.updateScaledVariables();
        }
        FreeColImageBorder.setScaleFactor(scaleFactor);
        ResourceManager.setMods(this.getClientOptions().getActiveMods());
        this.prepareResources();
        int fontSize = this.determineMainFontSizeUsingClientOptions(dpi);
        FontLibrary.setMainFontSize(fontSize);
        Font font = FontLibrary.getMainFont();
        FreeColLookAndFeel.installFont(font);
        FreeColToolTipUI.setFontScaling(FontLibrary.getFontScaling());
        Utility.initStyleContext(font);
        if (this.getFreeColClient().getActionManager() != null) {
            this.getFreeColClient().getActionManager().refreshResources();
        }
        if (this.mapControls != null) {
            this.mapControls.updateLayoutIfNeeded();
        }
        if (this.canvas != null) {
            this.canvas.resetMenuBar();
            this.resetMapControls();
        }
        this.refresh();
    }

    @Override
    public void resetMapControls() {
        if (this.canvas.removeMapControls()) {
            this.updateMapControls();
            this.canvas.addMapControls();
        }
    }

    private int determineMainFontSizeUsingClientOptions(int dpi) {
        int DEFAULT_DPI = 72;
        if (this.getClientOptions().getBoolean("model.option.manualMainFontSize")) {
            int fontSize = this.getClientOptions().getInteger("model.option.mainFontSize");
            logger.info("Manual font size: " + fontSize + " (reported DPI: " + dpi + ")");
            return fontSize;
        }
        int displayScaling = this.getClientOptions().getInteger("model.option.displayScaling");
        if (displayScaling == 0) {
            int fontSize = (int)(12.0f * (float)dpi / 72.0f);
            int screenHeight = this.graphicsDevice.getDisplayMode().getHeight();
            if (screenHeight < 900) {
                fontSize = Math.min(14, fontSize);
            } else if (screenHeight < 1050) {
                fontSize = Math.min(18, fontSize);
            }
            logger.info("Automatic font size: " + fontSize + " (reported DPI: " + dpi + ", screen height: " + screenHeight + ")");
            return fontSize;
        }
        int fontSize = (int)(12.0f * ((float)displayScaling / 100.0f));
        logger.info("Font size based on manual display scaling: " + fontSize + " (reported DPI: " + dpi + ")");
        return fontSize;
    }

    private float determineScaleFactorUsingClientOptions(int dpi) {
        float scaleFactor;
        int DEFAULT_DPI = 72;
        int displayScaling = this.getClientOptions().getInteger("model.option.displayScaling");
        if (displayScaling == 0) {
            int screenHeight;
            scaleFactor = (float)Math.round((float)dpi * 4.0f / 72.0f) / 4.0f;
            if (scaleFactor < 1.0f) {
                scaleFactor = 1.0f;
            }
            if (scaleFactor > 2.0f) {
                scaleFactor = 2.0f;
            }
            if ((screenHeight = this.graphicsDevice.getDisplayMode().getHeight()) < 900) {
                scaleFactor = 1.0f;
            } else if (screenHeight < 1050) {
                scaleFactor = Math.min(1.25f, scaleFactor);
            } else if (screenHeight < 1200) {
                scaleFactor = Math.min(1.5f, scaleFactor);
            } else if (screenHeight < 1400) {
                scaleFactor = Math.min(1.75f, scaleFactor);
            }
            logger.info("Automatic scale factor: " + scaleFactor + " (reported DPI: " + dpi + ", screen height: " + screenHeight + ")");
        } else {
            scaleFactor = (float)displayScaling / 100.0f;
            logger.info("Manual scale factor: " + scaleFactor + " (reported DPI: " + dpi + ")");
        }
        return scaleFactor;
    }

    @Override
    public FreeColPanel showColonyPanel(Colony colony, Unit unit) {
        if (colony == null) {
            return null;
        }
        Predicate<Component> pred = c -> c instanceof ColonyPanel && ((ColonyPanel)c).getColony() == colony;
        ColonyPanel panel = (ColonyPanel)this.canvas.getMatchingComponent(pred);
        if (panel == null) {
            try {
                panel = new ColonyPanel(this.getFreeColClient(), colony);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception in ColonyPanel for " + colony.getId(), e);
                return null;
            }
            this.canvas.showFreeColPanel(panel, this.getPopupPosition(colony.getTile()), true);
        } else {
            panel.requestFocus();
        }
        if (unit != null) {
            panel.setSelectedUnit(unit);
        }
        return panel;
    }

    @Override
    public FreeColPanel showColopediaPanel(String nodeId) {
        return this.widgets.showColopediaPanel(nodeId);
    }

    @Override
    public FreeColPanel showColorChooserPanel(ActionListener al) {
        return this.widgets.showColorChooserPanel(al);
    }

    @Override
    public FreeColPanel showCompactLabourReport() {
        return this.widgets.showCompactLabourReport();
    }

    @Override
    public FreeColPanel showCompactLabourReport(LabourData.UnitData unitData) {
        return this.widgets.showCompactLabourReport(unitData);
    }

    @Override
    public List<String> showConfirmDeclarationDialog() {
        return this.widgets.showConfirmDeclarationDialog();
    }

    @Override
    public void showDeclarationPanel(Runnable afterClosing) {
        this.widgets.showDeclarationPanel(afterClosing);
    }

    @Override
    public void showDifficultyDialog(Specification spec, OptionGroup group, boolean editable, DialogHandler<OptionGroup> dialogHandler) {
        this.widgets.showDifficultyDialog(spec, group, editable, dialogHandler);
    }

    @Override
    public void showDumpCargoDialog(Unit unit, DialogHandler<List<Goods>> handler) {
        this.widgets.showDumpCargoDialog(unit, this.getPopupPosition(unit.getTile()), handler);
    }

    @Override
    public boolean showEditOptionDialog(Option option) {
        return this.widgets.showEditOptionDialog(option);
    }

    @Override
    public IndianSettlement showEditSettlementDialog(IndianSettlement is) {
        return this.widgets.showEditSettlementDialog(is);
    }

    @Override
    public void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
        this.widgets.showEmigrationDialog(player, fountainOfYouth, handler);
    }

    @Override
    public void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
        this.widgets.showEndTurnDialog(units, handler);
    }

    @Override
    public FreeColPanel showErrorPanel(String message, Runnable callback) {
        return this.widgets.showErrorPanel(message).addClosingCallback(callback);
    }

    @Override
    public FreeColPanel showEuropePanel() {
        return this.widgets.showEuropePanel(() -> {
            for (Class<? extends FreeColPanel> c : EUROPE_CLASSES) {
                FreeColPanel p = this.canvas.getExistingFreeColPanel(c);
                if (p == null) continue;
                this.canvas.remove(p);
            }
        });
    }

    @Override
    public FreeColPanel showEventPanel(String header, String image, String footer) {
        return this.widgets.showEventPanel(header, image, footer);
    }

    @Override
    public FreeColPanel showFindSettlementPanel() {
        return this.widgets.showFindSettlementPanel();
    }

    @Override
    public void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, DialogHandler<Boolean> handler) {
        this.widgets.showFirstContactDialog(player, other, tile, settlementCount, this.getPopupPosition(tile), handler);
    }

    @Override
    public void showGameOptionsDialog(boolean editable, DialogHandler<OptionGroup> dialogHandler) {
        this.widgets.showGameOptionsDialog(editable, dialogHandler);
    }

    @Override
    public FreeColPanel showHighScoresPanel(String messageId, List<HighScore> scores) {
        return this.widgets.showHighScoresPanel(messageId, scores);
    }

    @Override
    public FreeColPanel showIndianSettlementPanel(IndianSettlement is) {
        return this.widgets.showIndianSettlementPanel(is, this.getPopupPosition(is.getTile()));
    }

    @Override
    public FreeColPanel showInformationPanel(FreeColObject displayObject, StringTemplate template) {
        ImageIcon icon = null;
        Tile tile = null;
        if (displayObject != null) {
            icon = this.fixedImageLibrary.getObjectImageIcon(displayObject);
            Tile tile2 = tile = displayObject instanceof Location ? ((Location)((Object)displayObject)).getTile() : null;
        }
        if (this.getClientOptions().getBoolean("model.option.audioAlerts")) {
            this.playSound("sound.event.alertSound");
        }
        return this.widgets.showInformationPanel(displayObject, this.getPopupPosition(tile), icon, template);
    }

    @Override
    public File showLoadDialog(File directory, String ... extension) {
        FileFilter[] filters = new FileFilter[extension.length];
        for (int i = 0; i < extension.length; ++i) {
            filters[i] = FreeColDataFile.getFileFilter(extension[i]);
        }
        File file = null;
        while ((file = this.widgets.showLoadDialog(directory, filters)) != null && !file.isFile()) {
            String err = Messages.message(FreeCol.badFile("error.noSuchFile", file));
            this.showErrorPanel(err, null);
        }
        return file;
    }

    @Override
    public LoadingSavegameInfo showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        return this.widgets.showLoadingSavegameDialog(publicServer, singlePlayer);
    }

    @Override
    public FreeColPanel showLogFilePanel() {
        return this.widgets.showLogFilePanel();
    }

    @Override
    public FreeColPanel showMainPanel(String userMsg) {
        FreeColPanel panel = this.canvas.showMainPanel();
        if (userMsg != null) {
            this.showInformationPanel(userMsg);
        }
        return panel;
    }

    @Override
    public void showMainTitle() {
        this.canvas.mainTitle();
        this.playSound("sound.intro.general");
    }

    @Override
    public void showMapGeneratorOptionsDialog(boolean editable, DialogHandler<OptionGroup> dialogHandler) {
        this.widgets.showMapGeneratorOptionsDialog(editable, dialogHandler);
    }

    @Override
    public Dimension showMapSizeDialog() {
        return this.widgets.showMapSizeDialog();
    }

    @Override
    public FreeColPanel showModelMessages(List<ModelMessage> modelMessages) {
        if (modelMessages.isEmpty()) {
            return null;
        }
        Game game = this.getGame();
        int n = modelMessages.size();
        String[] texts = new String[n];
        FreeColObject[] fcos = new FreeColObject[n];
        ImageIcon[] icons = new ImageIcon[n];
        Tile tile = null;
        for (int i = 0; i < n; ++i) {
            ModelMessage m = modelMessages.get(i);
            texts[i] = Messages.message(m);
            fcos[i] = game.getMessageSource(m);
            icons[i] = this.fixedImageLibrary.getObjectImageIcon(game.getMessageDisplay(m));
            if (tile != null || !(fcos[i] instanceof Location)) continue;
            tile = ((Location)((Object)fcos[i])).getTile();
        }
        InformationPanel panel = new InformationPanel(this.getFreeColClient(), texts, fcos, icons);
        return this.canvas.showFreeColPanel(panel, this.getPopupPosition(tile), false);
    }

    @Override
    public void showMonarchDialog(Monarch.MonarchAction action, StringTemplate template, String monarchKey, DialogHandler<Boolean> handler) {
        this.widgets.showMonarchDialog(action, template, monarchKey, handler);
    }

    @Override
    public void showNamingDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
        this.widgets.showNamingDialog(template, defaultName, this.getPopupPosition(unit.getTile()), handler);
    }

    @Override
    public void showNativeDemandDialog(Unit unit, Colony colony, GoodsType type, int amount, DialogHandler<Boolean> handler) {
        this.widgets.showNativeDemandDialog(unit, colony, type, amount, this.getPopupPosition(unit.getTile()), handler);
    }

    @Override
    public DiplomaticTrade showNegotiationDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        if (!(our instanceof Unit) && !(our instanceof Colony) || !(other instanceof Unit) && !(other instanceof Colony) || our instanceof Colony && other instanceof Colony) {
            throw new RuntimeException("Bad DTD args: " + our + ", " + other);
        }
        return this.widgets.showNegotiationDialog(our, other, agreement, comment, this.getPopupPosition(((Location)((Object)our)).getTile()));
    }

    @Override
    public FreeColPanel showNewPanel(Specification spec) {
        return this.widgets.showNewPanel(spec);
    }

    @Override
    public Parameters showParametersDialog() {
        return this.widgets.showParametersDialog();
    }

    @Override
    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        return this.widgets.showPreCombatDialog(attacker, defender, this.getPopupPosition(tile));
    }

    @Override
    public FreeColPanel showPurchasePanel() {
        return this.widgets.showPurchasePanel();
    }

    @Override
    public FreeColPanel showRecruitPanel() {
        return this.widgets.showRecruitPanel();
    }

    @Override
    public FreeColPanel showReportCargoPanel() {
        return this.widgets.showReportCargoPanel();
    }

    @Override
    public FreeColPanel showReportColonyPanel() {
        boolean compact;
        try {
            compact = this.getFreeColClient().getClientOptions().getInteger("model.option.colonyReport") == 1;
        }
        catch (Exception e) {
            compact = false;
        }
        return this.widgets.showReportColonyPanel(compact);
    }

    @Override
    public FreeColPanel showReportContinentalCongressPanel() {
        return this.widgets.showReportContinentalCongressPanel();
    }

    @Override
    public FreeColPanel showReportEducationPanel() {
        return this.widgets.showReportEducationPanel();
    }

    @Override
    public FreeColPanel showReportExplorationPanel() {
        return this.widgets.showReportExplorationPanel();
    }

    @Override
    public FreeColPanel showReportForeignAffairPanel() {
        return this.widgets.showReportForeignAffairPanel();
    }

    @Override
    public FreeColPanel showReportHistoryPanel() {
        return this.widgets.showReportHistoryPanel();
    }

    @Override
    public FreeColPanel showReportIndianPanel() {
        return this.widgets.showReportIndianPanel();
    }

    @Override
    public FreeColPanel showReportLabourPanel() {
        return this.widgets.showReportLabourPanel();
    }

    @Override
    public FreeColPanel showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        return this.widgets.showReportLabourDetailPanel(unitType, data, unitCount, colonies);
    }

    @Override
    public FreeColPanel showReportMilitaryPanel() {
        return this.widgets.showReportMilitaryPanel();
    }

    @Override
    public FreeColPanel showReportNavalPanel() {
        return this.widgets.showReportNavalPanel();
    }

    @Override
    public FreeColPanel showReportProductionPanel() {
        return this.widgets.showReportProductionPanel();
    }

    @Override
    public FreeColPanel showReportReligiousPanel() {
        return this.widgets.showReportReligiousPanel();
    }

    @Override
    public FreeColPanel showReportRequirementsPanel() {
        return this.widgets.showReportRequirementsPanel();
    }

    @Override
    public FreeColPanel showReportTradePanel() {
        return this.widgets.showReportTradePanel();
    }

    @Override
    public FreeColPanel showReportTurnPanel(List<ModelMessage> messages) {
        return this.widgets.showReportTurnPanel(messages);
    }

    @Override
    public String showRiverStyleDialog(List<String> styles) {
        return this.widgets.showRiverStyleDialog(styles);
    }

    @Override
    public File showSaveDialog(File directory, String defaultName) {
        String extension = StringUtils.lastPart(defaultName, ".");
        FileFilter[] filters = new FileFilter[]{FreeColDataFile.getFileFilter(extension), FreeColDataFile.getFileFilter("*")};
        return this.widgets.showSaveDialog(directory, filters, defaultName);
    }

    @Override
    public Dimension showScaleMapSizeDialog() {
        return this.widgets.showScaleMapSizeDialog();
    }

    @Override
    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.widgets.showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    @Override
    public Location showSelectDestinationDialog(Unit unit) {
        return this.widgets.showSelectDestinationDialog(unit, this.getPopupPosition(unit.getTile()));
    }

    @Override
    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        return this.widgets.showSelectTributeAmountDialog(question, maximum);
    }

    @Override
    public FreeColPanel showServerListPanel(List<ServerInfo> serverList) {
        this.canvas.closeMenus();
        return this.widgets.showServerListPanel(serverList);
    }

    @Override
    public FreeColPanel showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        if (game == null) {
            logger.warning("StartGamePanel requires game != null.");
        } else if (player == null) {
            logger.warning("StartGamePanel requires player != null.");
        } else {
            this.canvas.closeMenus();
            StartGamePanel panel = this.canvas.getExistingFreeColPanel(StartGamePanel.class);
            if (panel == null) {
                panel = new StartGamePanel(this.getFreeColClient());
            }
            panel.initialize(singlePlayerMode);
            return this.canvas.showFreeColPanel(panel, PopupPosition.CENTERED, true);
        }
        return null;
    }

    @Override
    public FreeColPanel showStatisticsPanel(Map<String, String> serverStats, Map<String, String> clientStats) {
        return this.widgets.showStatisticsPanel(serverStats, clientStats);
    }

    @Override
    public FreeColPanel showStatusPanel(String message) {
        StatusPanel panel = this.canvas.getExistingFreeColPanel(StatusPanel.class);
        if (panel == null) {
            panel = new StatusPanel(this.getFreeColClient());
        } else {
            this.canvas.removeFromCanvas(panel);
        }
        panel.setStatusMessage(message);
        return this.canvas.showFreeColPanel(panel, PopupPosition.CENTERED, true);
    }

    @Override
    public FreeColPanel showTilePanel(Tile tile) {
        return this.widgets.showTilePanel(tile);
    }

    @Override
    public FreeColPanel showTradeRouteInputPanel(TradeRoute newRoute) {
        return this.widgets.showTradeRouteInputPanel(newRoute);
    }

    @Override
    public FreeColPanel showTradeRoutePanel(Unit unit) {
        return this.widgets.showTradeRoutePanel(unit, this.getPopupPosition(unit == null ? null : unit.getTile()));
    }

    @Override
    public FreeColPanel showTrainPanel() {
        return this.widgets.showTrainPanel();
    }

    @Override
    public void showVictoryDialog(DialogHandler<Boolean> handler) {
        this.widgets.showVictoryDialog(handler);
    }

    @Override
    public boolean showWarehouseDialog(Colony colony) {
        return this.widgets.showWarehouseDialog(colony);
    }

    @Override
    public FreeColPanel showWorkProductionPanel(Unit unit) {
        return this.widgets.showWorkProductionPanel(unit);
    }

    @Override
    public void prepareShowingMainMenu() {
        this.canvas.prepareShowingMainMenu();
    }

    @Override
    public boolean canGameChangingModsBeAdded() {
        return this.getFreeColClient().getGame() == null;
    }

    public static enum PopupPosition {
        ORIGIN,
        CENTERED,
        CENTERED_LEFT,
        CENTERED_RIGHT,
        CENTERED_FORCED;

    }
}

