from math import *
from kandinsky import *
# Mandelbrot fractal
# Nmax: precision, s: scale
def mandelbrot(Nmax=10,s=2,X=160,Y=111):
  w=2.7/X
  h=-1.87/Y
  Y=Y-1
  for y in range(ceil(Y/2)+1):
    c = complex(-2.1,h*y+0.935)
    for x in range(X):
      z = 0
      for j in range(Nmax):
        z=z**2+c
        if abs(z)>2:
          break
      fill_rect(s*x,s*y,s,s,126*j+2079)
      fill_rect(s*x,s*(Y-y),s,s,126*j+2079)
      c = c+w
    set_pixel()