/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Collection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.logging.text.TreeFormatter;

public class NoMatchingVariantSelectionException
extends VariantSelectionException {
    public NoMatchingVariantSelectionException(String producerDisplayName, AttributeContainerInternal consumer, Collection<? extends ResolvedVariant> candidates, AttributeMatcher matcher) {
        super(NoMatchingVariantSelectionException.format(producerDisplayName, consumer, candidates, matcher));
    }

    private static String format(String producerDisplayName, AttributeContainerInternal consumer, Collection<? extends ResolvedVariant> candidates, AttributeMatcher matcher) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No variants of " + producerDisplayName + " match the consumer attributes");
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : candidates) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            AmbiguousConfigurationSelectionException.formatAttributeMatches(formatter, consumer, matcher, resolvedVariant.getAttributes());
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

