/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.reflect.Methods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.Types;

public class PropertyExtractor {
    private final Set<Class<? extends Annotation>> primaryAnnotationTypes;
    private final Set<Class<? extends Annotation>> relevantAnnotationTypes;
    private final Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides;
    private final ImmutableSet<Class<?>> ignoredSuperclasses;
    private final ImmutableSet<Equivalence.Wrapper<Method>> ignoredMethods;

    public PropertyExtractor(Set<Class<? extends Annotation>> primaryAnnotationTypes, Set<Class<? extends Annotation>> relevantAnnotationTypes, Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides, ImmutableSet<Class<?>> ignoredSuperclasses, ImmutableSet<Class<?>> ignoreMethodsFromClasses) {
        this.primaryAnnotationTypes = primaryAnnotationTypes;
        this.relevantAnnotationTypes = relevantAnnotationTypes;
        this.annotationOverrides = annotationOverrides;
        this.ignoredSuperclasses = ignoredSuperclasses;
        this.ignoredMethods = PropertyExtractor.allMethodsOf(ignoreMethodsFromClasses);
    }

    private static ImmutableSet<Equivalence.Wrapper<Method>> allMethodsOf(Iterable<Class<?>> classes) {
        ArrayList methods = Lists.newArrayList();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                methods.add(Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method));
            }
        }
        return ImmutableSet.copyOf((Collection)methods);
    }

    public <T> ImmutableSet<PropertyMetadata> extractPropertyMetadata(Class<T> type) {
        final Set<Class<? extends Annotation>> propertyTypeAnnotations = this.primaryAnnotationTypes;
        final LinkedHashMap properties = Maps.newLinkedHashMap();
        Types.walkTypeHierarchy(type, this.ignoredSuperclasses, new Types.TypeVisitor<T>(){

            @Override
            public void visitType(Class<? super T> type) {
                if (type.isSynthetic()) {
                    return;
                }
                Map fields = PropertyExtractor.getFields(type);
                List getters = PropertyExtractor.this.getGetters(type);
                for (Getter getter : getters) {
                    String fieldName;
                    Field field;
                    Method method = getter.getMethod();
                    if (method.isSynthetic() || (field = (Field)fields.get(fieldName = getter.getName())) != null && field.isSynthetic()) continue;
                    PropertyMetadataBuilder propertyMetadata = (PropertyMetadataBuilder)properties.get(fieldName);
                    if (propertyMetadata == null) {
                        propertyMetadata = new PropertyMetadataBuilder(propertyTypeAnnotations, fieldName, method);
                        properties.put(fieldName, propertyMetadata);
                    }
                    Iterable declaredAnnotations = PropertyExtractor.this.mergeDeclaredAnnotations(method, field, propertyMetadata);
                    Iterable overriddenAnnotations = PropertyExtractor.this.filterOverridingAnnotations(declaredAnnotations, propertyTypeAnnotations);
                    PropertyExtractor.this.recordAnnotations(propertyMetadata, overriddenAnnotations, propertyTypeAnnotations);
                }
            }
        });
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PropertyMetadataBuilder property : properties.values()) {
            builder.add((Object)property.toMetadata());
        }
        return builder.build();
    }

    private Iterable<Annotation> mergeDeclaredAnnotations(Method method, @Nullable Field field, PropertyMetadataBuilder property) {
        Collection<Annotation> methodAnnotations = this.collectRelevantAnnotations(method.getDeclaredAnnotations());
        if (Modifier.isPrivate(method.getModifiers()) && !methodAnnotations.isEmpty()) {
            property.validationMessage("is private and annotated with an input or output annotation");
        }
        if (field == null) {
            return methodAnnotations;
        }
        Collection<Annotation> fieldAnnotations = this.collectRelevantAnnotations(field.getDeclaredAnnotations());
        if (fieldAnnotations.isEmpty()) {
            return methodAnnotations;
        }
        if (methodAnnotations.isEmpty()) {
            return fieldAnnotations;
        }
        for (Annotation methodAnnotation : methodAnnotations) {
            Iterator<Annotation> iFieldAnnotation = fieldAnnotations.iterator();
            while (iFieldAnnotation.hasNext()) {
                Annotation fieldAnnotation = iFieldAnnotation.next();
                if (!methodAnnotation.annotationType().equals(fieldAnnotation.annotationType())) continue;
                property.validationMessage("has both a getter and field declared with annotation @" + methodAnnotation.annotationType().getSimpleName());
                iFieldAnnotation.remove();
            }
        }
        return Iterables.concat(methodAnnotations, fieldAnnotations);
    }

    private Iterable<Annotation> filterOverridingAnnotations(final Iterable<Annotation> declaredAnnotations, final Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return Iterables.filter(declaredAnnotations, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                Class<? extends Annotation> annotationType = input.annotationType();
                if (!propertyTypeAnnotations.contains(annotationType)) {
                    return true;
                }
                for (Class overridingAnnotation : PropertyExtractor.this.annotationOverrides.get(annotationType)) {
                    for (Annotation declaredAnnotation : declaredAnnotations) {
                        if (!declaredAnnotation.annotationType().equals(overridingAnnotation)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private void recordAnnotations(PropertyMetadataBuilder property, Iterable<Annotation> annotations, Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        LinkedHashSet declaredPropertyTypes = Sets.newLinkedHashSet();
        for (Annotation annotation : annotations) {
            if (propertyTypeAnnotations.contains(annotation.annotationType())) {
                declaredPropertyTypes.add(annotation.annotationType());
            }
            property.addAnnotation(annotation);
        }
        if (declaredPropertyTypes.size() > 1) {
            property.validationMessage("has conflicting property types declared: " + Joiner.on((String)", ").join(Iterables.transform((Iterable)declaredPropertyTypes, (Function)new Function<Class<? extends Annotation>, String>(){

                public String apply(Class<? extends Annotation> annotationType) {
                    return "@" + annotationType.getSimpleName();
                }
            })));
        }
    }

    private Collection<Annotation> collectRelevantAnnotations(Annotation[] annotations) {
        ArrayList relevantAnnotations = Lists.newArrayListWithCapacity((int)annotations.length);
        for (Annotation annotation : annotations) {
            if (!this.relevantAnnotationTypes.contains(annotation.annotationType())) continue;
            relevantAnnotations.add(annotation);
        }
        return relevantAnnotations;
    }

    private static Map<String, Field> getFields(Class<?> type) {
        HashMap fields = Maps.newHashMap();
        for (Field field : type.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private List<Getter> getGetters(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        ArrayList getters = Lists.newArrayListWithCapacity((int)methods.length);
        for (Method method : methods) {
            PropertyAccessorType accessorType = PropertyAccessorType.of(method);
            if (accessorType == null || accessorType == PropertyAccessorType.SETTER || method.isBridge() || this.ignoredMethods.contains((Object)Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method))) continue;
            getters.add(new Getter(method, accessorType.propertyNameFor(method)));
        }
        Collections.sort(getters);
        return getters;
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final String fieldName;
        private final Method method;
        private final Class<? extends Annotation> propertyType;
        private final ImmutableMap<Class<? extends Annotation>, Annotation> annotations;
        private final ImmutableList<String> validationMessages;

        DefaultPropertyMetadata(String fieldName, Method method, Class<? extends Annotation> propertyType, ImmutableMap<Class<? extends Annotation>, Annotation> annotations, ImmutableList<String> validationMessages) {
            this.fieldName = fieldName;
            this.method = method;
            this.propertyType = propertyType;
            this.annotations = annotations;
            this.validationMessages = validationMessages;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)annotationType.cast(this.annotations.get(annotationType)));
        }

        public ImmutableList<String> getValidationMessages() {
            return this.validationMessages;
        }

        @Override
        @Nullable
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Class<?> getDeclaredType() {
            return this.method.getReturnType();
        }

        @Override
        public Method getGetterMethod() {
            return this.method;
        }
    }

    private static class PropertyMetadataBuilder {
        private final Set<Class<? extends Annotation>> propertyTypeAnnotations;
        private final String fieldName;
        private final Method method;
        private Class<? extends Annotation> propertyType;
        private final Map<Class<? extends Annotation>, Annotation> annotations = Maps.newHashMap();
        private final List<String> validationMessages = Lists.newArrayList();

        PropertyMetadataBuilder(Set<Class<? extends Annotation>> propertyTypeAnnotations, String fieldName, Method method) {
            this.propertyTypeAnnotations = propertyTypeAnnotations;
            this.fieldName = fieldName;
            this.method = method;
        }

        public void validationMessage(String message) {
            this.validationMessages.add(message);
        }

        public void addAnnotation(Annotation annotation) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (this.propertyType == null && this.isPropertyTypeAnnotation(annotationType)) {
                this.propertyType = annotationType;
            }
            if (!this.isAnnotationPresent(annotation.annotationType())) {
                this.annotations.put(annotationType, annotation);
            }
        }

        boolean isPropertyTypeAnnotation(Class<? extends Annotation> annotationType) {
            return this.propertyTypeAnnotations.contains(annotationType);
        }

        boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Nullable
        <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)annotationType.cast(this.annotations.get(annotationType)));
        }

        PropertyMetadata toMetadata() {
            return new DefaultPropertyMetadata(this.fieldName, this.method, this.propertyType, (ImmutableMap<Class<? extends Annotation>, Annotation>)ImmutableMap.copyOf(this.annotations), (ImmutableList<String>)ImmutableList.copyOf(this.validationMessages));
        }
    }

    private static class Getter
    implements Comparable<Getter> {
        private final Method method;
        private final String name;

        Getter(Method method, String name) {
            this.method = method;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public int compareTo(@Nonnull Getter o) {
            return this.method.getName().compareTo(o.method.getName());
        }
    }
}

