/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.event.PostDeleteEvent;
import org.grails.datastore.mapping.engine.event.PostInsertEvent;
import org.grails.datastore.mapping.engine.event.PostLoadEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.datastore.mapping.engine.event.PreDeleteEvent;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreLoadEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class EntityPersister
implements Persister {
    private final PersistentEntity persistentEntity;
    private final MappingContext mappingContext;
    protected final Session session;
    protected final ApplicationEventPublisher publisher;
    protected final EntityReflector reflector;
    protected ProxyFactory proxyFactory;

    public EntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        this.persistentEntity = entity;
        this.mappingContext = mappingContext;
        this.session = session;
        this.publisher = publisher;
        this.reflector = mappingContext.getEntityReflector(entity);
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public Object proxy(Serializable key) {
        PersistentEntity entity = this.getPersistentEntity();
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            key = (Serializable)this.mappingContext.getConversionService().convert((Object)key, identity.getType());
        }
        return this.getProxyFactory().createProxy(this.session, entity.getJavaClass(), key);
    }

    public ProxyFactory getProxyFactory() {
        if (this.proxyFactory == null) {
            this.proxyFactory = this.mappingContext.getProxyFactory();
        }
        return this.proxyFactory;
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public Class getType() {
        return this.persistentEntity.getJavaClass();
    }

    @Override
    public Serializable getObjectIdentifier(Object obj) {
        if (obj == null) {
            return null;
        }
        ProxyFactory pf = this.getProxyFactory();
        if (pf.isProxy(obj)) {
            return pf.getIdentifier(obj);
        }
        if (this.persistentEntity.getJavaClass().equals(obj.getClass())) {
            return this.reflector.getIdentifier(obj);
        }
        EntityPersister persister = (EntityPersister)this.getSession().getPersister(obj);
        if (persister != null) {
            return persister.getObjectIdentifier(obj);
        }
        return null;
    }

    @Override
    public Serializable insert(Object obj) {
        if (!this.persistentEntity.isInstance(obj)) {
            Persister persister = this.getSession().getPersister(obj);
            if (persister == null) {
                throw new IllegalArgumentException("Object [" + obj + "] is not an instance supported by the persister for class [" + this.getType().getName() + "]");
            }
            return persister.persist(obj);
        }
        return this.persistEntity(this.getPersistentEntity(), obj, true);
    }

    protected Serializable persistEntity(PersistentEntity entity, Object obj, boolean isInsert) {
        return this.persistEntity(entity, obj);
    }

    public void setObjectIdentifier(Object obj, Serializable id) {
        this.createEntityAccess(this.getPersistentEntity(), obj).setIdentifier(id);
    }

    @Override
    public final Serializable persist(Object obj) {
        if (!this.persistentEntity.isInstance(obj)) {
            Persister persister = this.getSession().getPersister(obj);
            if (persister == null) {
                throw new IllegalArgumentException("Object [" + obj + "] is not an instance supported by the persister for class [" + this.getType().getName() + "]");
            }
            return persister.persist(obj);
        }
        return this.persistEntity(this.getPersistentEntity(), obj);
    }

    @Override
    public List<Serializable> persist(Iterable objs) {
        return this.persistEntities(this.getPersistentEntity(), objs);
    }

    @Override
    public List<Object> retrieveAll(Iterable<Serializable> keys) {
        return this.retrieveAllEntities(this.getPersistentEntity(), keys);
    }

    @Override
    public List<Object> retrieveAll(Serializable[] keys) {
        return this.retrieveAllEntities(this.getPersistentEntity(), keys);
    }

    protected abstract List<Object> retrieveAllEntities(PersistentEntity var1, Serializable[] var2);

    public Object getCurrentVersion(EntityAccess ea) {
        Object currentVersion = ea.getProperty("version");
        if (Number.class.isAssignableFrom(ea.getPropertyType("version"))) {
            currentVersion = currentVersion != null ? Long.valueOf(((Number)currentVersion).longValue()) : currentVersion;
        }
        return currentVersion;
    }

    protected abstract List<Object> retrieveAllEntities(PersistentEntity var1, Iterable<Serializable> var2);

    protected abstract List<Serializable> persistEntities(PersistentEntity var1, Iterable var2);

    @Override
    public final Object retrieve(Serializable key) {
        if (key == null) {
            return null;
        }
        PersistentEntity entity = this.getPersistentEntity();
        Object o = this.retrieveEntity(entity, key);
        if (o == null) {
            return null;
        }
        return o;
    }

    protected abstract Object retrieveEntity(PersistentEntity var1, Serializable var2);

    protected boolean isAssignedId(PersistentEntity persistentEntity) {
        PropertyMapping mapping;
        boolean assignedId = false;
        PersistentProperty identity = persistentEntity.getIdentity();
        if (identity != null && (mapping = identity.getMapping()) != null) {
            Object p = mapping.getMappedForm();
            assignedId = p != null && "assigned".equals(((Property)p).getGenerator());
        }
        return assignedId;
    }

    protected abstract Serializable persistEntity(PersistentEntity var1, Object var2);

    @Override
    public final void delete(Iterable objects) {
        if (objects == null) {
            return;
        }
        this.deleteEntities(this.getPersistentEntity(), objects);
    }

    @Override
    public void delete(Object obj) {
        if (obj == null) {
            return;
        }
        this.deleteEntity(this.getPersistentEntity(), obj);
    }

    protected abstract void deleteEntity(PersistentEntity var1, Object var2);

    protected abstract void deleteEntities(PersistentEntity var1, Iterable var2);

    protected EntityAccess createEntityAccess(PersistentEntity pe, Object obj) {
        SessionImplementor si = (SessionImplementor)((Object)this.getSession());
        return si.createEntityAccess(pe, obj);
    }

    protected Object newEntityInstance(PersistentEntity persistentEntity) {
        Object o = persistentEntity.newInstance();
        this.publisher.publishEvent((ApplicationEvent)new PreLoadEvent(this.session.getDatastore(), this.getPersistentEntity(), this.createEntityAccess(persistentEntity, o)));
        return o;
    }

    public boolean cancelInsert(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreInsertEvent event = new PreInsertEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public void firePostInsertEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostInsertEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public boolean cancelUpdate(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreUpdateEvent event = new PreUpdateEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public boolean cancelDelete(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreDeleteEvent event = new PreDeleteEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public boolean cancelLoad(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        PreLoadEvent event = new PreLoadEvent(this.session.getDatastore(), persistentEntity, entityAccess);
        this.publisher.publishEvent((ApplicationEvent)event);
        return event.isCancelled();
    }

    public void firePostUpdateEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostUpdateEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public void firePostDeleteEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostDeleteEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public void firePreLoadEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PreLoadEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public void firePostLoadEvent(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        this.publisher.publishEvent((ApplicationEvent)new PostLoadEvent(this.session.getDatastore(), persistentEntity, entityAccess));
    }

    public boolean isVersioned(EntityAccess ea) {
        if (ea != null && !ea.getPersistentEntity().isVersioned()) {
            return false;
        }
        Class type = ea.getPropertyType("version");
        return Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type);
    }

    public void incrementVersion(EntityAccess ea) {
        EntityPersister.incrementEntityVersion(ea);
    }

    public static void incrementEntityVersion(EntityAccess ea) {
        String versionName = ea.getPersistentEntity().getVersion().getName();
        if (Number.class.isAssignableFrom(ea.getPropertyType(versionName))) {
            Number currentVersion = (Number)ea.getProperty(versionName);
            if (currentVersion == null) {
                currentVersion = 0L;
            }
            ea.setProperty(versionName, currentVersion.longValue() + 1L);
        } else {
            EntityPersister.setDateVersionInternal(versionName, ea);
        }
    }

    protected void setVersion(EntityAccess ea) {
        String versionName = ea.getPersistentEntity().getVersion().getName();
        if (Number.class.isAssignableFrom(ea.getPropertyType(versionName))) {
            ea.setProperty(versionName, 0);
        } else {
            this.setDateVersion(ea);
        }
    }

    protected void setDateVersion(EntityAccess ea) {
        EntityPersister.setDateVersionInternal(ea.getPersistentEntity().getVersion().getName(), ea);
    }

    private static void setDateVersionInternal(String versionName, EntityAccess ea) {
        if (Timestamp.class.isAssignableFrom(ea.getPropertyType(versionName))) {
            ea.setProperty(versionName, new Timestamp(System.currentTimeMillis()));
        } else {
            ea.setProperty(versionName, new Date());
        }
    }
}

